/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.opnd;

import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.gen.opnd.ConstSimpleOpnd;
import ghidra.pcode.emu.jit.gen.opnd.FloatLocalOpnd;
import ghidra.pcode.emu.jit.gen.opnd.SimpleOpnd;
import ghidra.pcode.emu.jit.gen.util.Emitter;
import ghidra.pcode.emu.jit.gen.util.Op;
import ghidra.pcode.emu.jit.gen.util.Scope;
import ghidra.pcode.emu.jit.gen.util.Types;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;

final class FloatConstOpnd
extends Record
implements ConstSimpleOpnd<Types.TFloat, JitType.FloatJitType> {
    private final float value;
    private final JitType.FloatJitType type;

    FloatConstOpnd(float value, JitType.FloatJitType type) {
        this.value = value;
        this.type = type;
    }

    @Override
    public String name() {
        return "const_float_%f".formatted(Float.valueOf(this.value)).replace(".", "dot");
    }

    @Override
    public <N extends Emitter.Next> Emitter<Emitter.Ent<N, Types.TFloat>> read(Emitter<N> em) {
        return em.emit(Op::ldc__f, Float.valueOf(this.value));
    }

    @Override
    public <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TFloat>> SimpleOpnd.SimpleOpndEm<Types.TFloat, JitType.FloatJitType, N1> write(Emitter<N0> em, Scope scope) {
        return FloatLocalOpnd.temp(this.type(), this.tempName(), scope).write(em, scope);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{FloatConstOpnd.class, "value;type", "value", "type"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{FloatConstOpnd.class, "value;type", "value", "type"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{FloatConstOpnd.class, "value;type", "value", "type"}, this, o);
    }

    public float value() {
        return this.value;
    }

    @Override
    public JitType.FloatJitType type() {
        return this.type;
    }
}

