/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.opnd;

import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.gen.opnd.ConstSimpleOpnd;
import ghidra.pcode.emu.jit.gen.opnd.IntLocalOpnd;
import ghidra.pcode.emu.jit.gen.opnd.SimpleOpnd;
import ghidra.pcode.emu.jit.gen.util.Emitter;
import ghidra.pcode.emu.jit.gen.util.Op;
import ghidra.pcode.emu.jit.gen.util.Scope;
import ghidra.pcode.emu.jit.gen.util.Types;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;

public final class IntConstOpnd
extends Record
implements ConstSimpleOpnd<Types.TInt, JitType.IntJitType> {
    private final int value;
    private final JitType.IntJitType type;
    public static final IntConstOpnd ZERO_I1 = new IntConstOpnd(0, JitType.IntJitType.I1);
    public static final IntConstOpnd ZERO_I2 = new IntConstOpnd(0, JitType.IntJitType.I2);
    public static final IntConstOpnd ZERO_I3 = new IntConstOpnd(0, JitType.IntJitType.I3);
    public static final IntConstOpnd ZERO_I4 = new IntConstOpnd(0, JitType.IntJitType.I4);

    public IntConstOpnd(int value, JitType.IntJitType type) {
        this.value = value;
        this.type = type;
    }

    public static IntConstOpnd zero(JitType.IntJitType type) {
        return switch (type.size()) {
            case 1 -> ZERO_I1;
            case 2 -> ZERO_I2;
            case 3 -> ZERO_I3;
            case 4 -> ZERO_I4;
            default -> throw new AssertionError();
        };
    }

    @Override
    public String name() {
        return "const_int_0x%x".formatted(this.value);
    }

    @Override
    public <N extends Emitter.Next> Emitter<Emitter.Ent<N, Types.TInt>> read(Emitter<N> em) {
        return em.emit(Op::ldc__i, this.value);
    }

    @Override
    public <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TInt>> SimpleOpnd.SimpleOpndEm<Types.TInt, JitType.IntJitType, N1> write(Emitter<N0> em, Scope scope) {
        return IntLocalOpnd.temp(this.type(), this.tempName(), scope).write(em, scope);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{IntConstOpnd.class, "value;type", "value", "type"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{IntConstOpnd.class, "value;type", "value", "type"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{IntConstOpnd.class, "value;type", "value", "type"}, this, o);
    }

    public int value() {
        return this.value;
    }

    @Override
    public JitType.IntJitType type() {
        return this.type;
    }
}

