/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.opnd;

import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.gen.opnd.IntLocalOpnd;
import ghidra.pcode.emu.jit.gen.opnd.LocalOpnd;
import ghidra.pcode.emu.jit.gen.opnd.SimpleOpnd;
import ghidra.pcode.emu.jit.gen.util.Emitter;
import ghidra.pcode.emu.jit.gen.util.Local;
import ghidra.pcode.emu.jit.gen.util.Op;
import ghidra.pcode.emu.jit.gen.util.Scope;
import ghidra.pcode.emu.jit.gen.util.Types;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;

final class IntReadOnlyLocalOpnd
extends Record
implements LocalOpnd<Types.TInt, JitType.IntJitType> {
    private final JitType.IntJitType type;
    private final Local<Types.TInt> local;

    IntReadOnlyLocalOpnd(JitType.IntJitType type, Local<Types.TInt> local) {
        this.type = type;
        this.local = local;
    }

    static IntReadOnlyLocalOpnd of(JitType.IntJitType type, Local<Types.TInt> local) {
        return new IntReadOnlyLocalOpnd(type, local);
    }

    static IntReadOnlyLocalOpnd temp(JitType.IntJitType type, String name, Scope scope) {
        return IntReadOnlyLocalOpnd.of(type, scope.decl(type.bType(), name));
    }

    static <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TInt>> SimpleOpnd.SimpleOpndEm<Types.TInt, JitType.IntJitType, N1> create(Emitter<N0> em, JitType.IntJitType type, String name, Scope scope) {
        IntReadOnlyLocalOpnd ro = IntReadOnlyLocalOpnd.temp(type, name, scope);
        return new SimpleOpnd.SimpleOpndEm(ro, em.emit(Op::istore, ro.local));
    }

    @Override
    public <N extends Emitter.Next> Emitter<Emitter.Ent<N, Types.TInt>> read(Emitter<N> em) {
        return em.emit(Op::iload, this.local);
    }

    @Override
    public <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TInt>> SimpleOpnd.SimpleOpndEm<Types.TInt, JitType.IntJitType, N1> write(Emitter<N0> em, Scope scope) {
        String name = "%s_tempFromRo".formatted(this.name());
        return IntLocalOpnd.temp(this.type(), name, scope).write(em, scope);
    }

    @Override
    public <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TInt>> Emitter<N1> writeDirect(Emitter<N0> em) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{IntReadOnlyLocalOpnd.class, "type;local", "type", "local"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{IntReadOnlyLocalOpnd.class, "type;local", "type", "local"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{IntReadOnlyLocalOpnd.class, "type;local", "type", "local"}, this, o);
    }

    @Override
    public JitType.IntJitType type() {
        return this.type;
    }

    @Override
    public Local<Types.TInt> local() {
        return this.local;
    }
}

