/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.opnd;

import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.gen.opnd.ConstSimpleOpnd;
import ghidra.pcode.emu.jit.gen.opnd.LongLocalOpnd;
import ghidra.pcode.emu.jit.gen.opnd.SimpleOpnd;
import ghidra.pcode.emu.jit.gen.util.Emitter;
import ghidra.pcode.emu.jit.gen.util.Op;
import ghidra.pcode.emu.jit.gen.util.Scope;
import ghidra.pcode.emu.jit.gen.util.Types;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;

final class LongConstOpnd
extends Record
implements ConstSimpleOpnd<Types.TLong, JitType.LongJitType> {
    private final long value;
    private final JitType.LongJitType type;

    LongConstOpnd(long value, JitType.LongJitType type) {
        this.value = value;
        this.type = type;
    }

    @Override
    public String name() {
        return "const_long_0x%x".formatted(this.value);
    }

    @Override
    public <N extends Emitter.Next> Emitter<Emitter.Ent<N, Types.TLong>> read(Emitter<N> em) {
        return em.emit(Op::ldc__l, this.value);
    }

    @Override
    public <N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TLong>> SimpleOpnd.SimpleOpndEm<Types.TLong, JitType.LongJitType, N1> write(Emitter<N0> em, Scope scope) {
        return LongLocalOpnd.temp(this.type(), this.tempName(), scope).write(em, scope);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{LongConstOpnd.class, "value;type", "value", "type"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{LongConstOpnd.class, "value;type", "value", "type"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{LongConstOpnd.class, "value;type", "value", "type"}, this, o);
    }

    public long value() {
        return this.value;
    }

    @Override
    public JitType.LongJitType type() {
        return this.type;
    }
}

