/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.opnd;

import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.gen.opnd.IntConstOpnd;
import ghidra.pcode.emu.jit.gen.opnd.Opnd;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

final class MpIntConstOpnd
extends Record
implements Opnd<JitType.MpIntJitType> {
    private final JitType.MpIntJitType type;
    private final String name;
    private final List<IntConstOpnd> legsLE;

    public MpIntConstOpnd(BigInteger value, JitType.MpIntJitType type) {
        this(type, "const_mpint_0x%s".formatted(value.toString(16)), MpIntConstOpnd.computeLegs(value, type));
    }

    MpIntConstOpnd(JitType.MpIntJitType type, String name, List<IntConstOpnd> legsLE) {
        this.type = type;
        this.name = name;
        this.legsLE = legsLE;
    }

    static List<IntConstOpnd> computeLegs(BigInteger value, JitType.MpIntJitType type) {
        ArrayList<IntConstOpnd> legs = new ArrayList<IntConstOpnd>();
        int count = type.legsAlloc();
        for (int i = 0; i < count; ++i) {
            JitType.IntJitType t = type.legTypesLE().get(i);
            legs.add(new IntConstOpnd(value.intValue(), t));
            value = value.shiftRight(32);
        }
        return List.copyOf(legs);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{MpIntConstOpnd.class, "type;name;legsLE", "type", "name", "legsLE"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{MpIntConstOpnd.class, "type;name;legsLE", "type", "name", "legsLE"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{MpIntConstOpnd.class, "type;name;legsLE", "type", "name", "legsLE"}, this, o);
    }

    @Override
    public JitType.MpIntJitType type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public List<IntConstOpnd> legsLE() {
        return this.legsLE;
    }
}

