/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.util;

import ghidra.pcode.emu.jit.gen.util.ChildScope;
import ghidra.pcode.emu.jit.gen.util.Emitter;
import ghidra.pcode.emu.jit.gen.util.Lbl;
import ghidra.pcode.emu.jit.gen.util.Local;
import ghidra.pcode.emu.jit.gen.util.Scope;
import ghidra.pcode.emu.jit.gen.util.SubScope;
import ghidra.pcode.emu.jit.gen.util.Types;
import java.util.ArrayList;
import java.util.List;

class RootScope<N extends Emitter.Next>
implements Scope {
    protected final Emitter<N> em;
    protected final Lbl<N> start;
    protected int nextLocal;
    protected Scope childScope;
    protected boolean closed = false;
    protected final List<Local<?>> vars = new ArrayList();

    RootScope(Emitter<?> em, int nextLocal) {
        this.em = em;
        this.nextLocal = nextLocal;
        this.start = Lbl.place(this.em).lbl();
    }

    @Override
    public SubScope sub() {
        return new ChildScope(this.em, this);
    }

    protected void declVars() {
        Lbl end = this.em.emit(Lbl::place).lbl();
        for (Local<?> v : this.vars) {
            this.em.emit(Local::decl, v, this.start, end);
        }
    }

    @Override
    public <T extends Types.BNonVoid> Local<T> decl(T type, String name) {
        if (this.childScope != null) {
            throw new IllegalStateException("There is a child scope active.");
        }
        int next = this.next(type);
        Local<T> local = Local.of(type, name, next);
        this.vars.add(local);
        return local;
    }

    protected int next(Types.BNonVoid type) {
        int next = this.nextLocal;
        this.nextLocal += type.slots();
        return next;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.declVars();
        this.closed = true;
    }
}

