/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.util;

import org.objectweb.asm.Type;

public interface Types {
    public static final TVoid T_VOID = TVoid.INSTANCE;
    public static final TBool T_BOOL = TBool.INSTANCE;
    public static final TByte T_BYTE = TByte.INSTANCE;
    public static final TChar T_CHAR = TChar.INSTANCE;
    public static final TShort T_SHORT = TShort.INSTANCE;
    public static final TInt T_INT = TInt.INSTANCE;
    public static final TLong T_LONG = TLong.INSTANCE;
    public static final TFloat T_FLOAT = TFloat.INSTANCE;
    public static final TDouble T_DOUBLE = TDouble.INSTANCE;
    public static final TRef<boolean[]> T_BOOL_ARR = Types.refOf(boolean[].class);
    public static final TRef<byte[]> T_BYTE_ARR = Types.refOf(byte[].class);
    public static final TRef<char[]> T_CHAR_ARR = Types.refOf(char[].class);
    public static final TRef<short[]> T_SHORT_ARR = Types.refOf(short[].class);
    public static final TRef<int[]> T_INT_ARR = Types.refOf(int[].class);
    public static final TRef<long[]> T_LONG_ARR = Types.refOf(long[].class);
    public static final TRef<float[]> T_FLOAT_ARR = Types.refOf(float[].class);
    public static final TRef<double[]> T_DOUBLE_ARR = Types.refOf(double[].class);

    public static <T> TRef<T> refOf(Class<T> cls) {
        return TRef.of(cls);
    }

    public static <ST, T extends ST> TRef<T> refExtends(Class<ST> cls, String desc) {
        return TRef.ofExtends(cls, desc);
    }

    public static <ST, T extends ST> TRef<T> refExtends(TRef<ST> st, String desc) {
        return TRef.ofExtends(st.cls, desc);
    }

    public static <ST, T extends ST> TRef<T> refExtends(TRef<ST> st, Class<?> reflected) {
        return TRef.ofExtends(st.cls, Type.getDescriptor(reflected));
    }

    public record TRef<T>(Class<? super T> cls, Type type) implements TCat1
    {
        static <T> TRef<T> of(Class<T> cls) {
            return new TRef<T>(cls, Type.getType(cls));
        }

        static <ST, T extends ST> TRef<T> ofExtends(Class<ST> cls, String desc) {
            return new TRef<ST>(cls, Type.getType((String)desc));
        }
    }

    public static enum TVoid implements BType
    {
        INSTANCE;


        @Override
        public Type type() {
            return Type.VOID_TYPE;
        }

        @Override
        public Class<?> cls() {
            return Void.TYPE;
        }
    }

    public static enum TBool implements SPrim<boolean[]>
    {
        INSTANCE;


        @Override
        public int t() {
            return 4;
        }

        @Override
        public Type type() {
            return Type.BOOLEAN_TYPE;
        }

        @Override
        public Class<?> cls() {
            return Boolean.TYPE;
        }
    }

    public static enum TByte implements SPrim<byte[]>
    {
        INSTANCE;


        @Override
        public int t() {
            return 8;
        }

        @Override
        public Type type() {
            return Type.BYTE_TYPE;
        }

        @Override
        public Class<?> cls() {
            return Byte.TYPE;
        }
    }

    public static enum TChar implements SPrim<char[]>
    {
        INSTANCE;


        @Override
        public int t() {
            return 5;
        }

        @Override
        public Type type() {
            return Type.CHAR_TYPE;
        }

        @Override
        public Class<?> cls() {
            return Character.TYPE;
        }
    }

    public static enum TShort implements SPrim<short[]>
    {
        INSTANCE;


        @Override
        public int t() {
            return 9;
        }

        @Override
        public Type type() {
            return Type.SHORT_TYPE;
        }

        @Override
        public Class<?> cls() {
            return Short.TYPE;
        }
    }

    public static enum TInt implements TCat1,
    BPrim<int[]>
    {
        INSTANCE;


        @Override
        public int t() {
            return 10;
        }

        @Override
        public Type type() {
            return Type.INT_TYPE;
        }

        @Override
        public Class<?> cls() {
            return Integer.TYPE;
        }
    }

    public static enum TLong implements TCat2,
    BPrim<long[]>
    {
        INSTANCE;


        @Override
        public int t() {
            return 11;
        }

        @Override
        public Type type() {
            return Type.LONG_TYPE;
        }

        @Override
        public Class<?> cls() {
            return Long.TYPE;
        }
    }

    public static enum TFloat implements TCat1,
    BPrim<float[]>
    {
        INSTANCE;


        @Override
        public int t() {
            return 6;
        }

        @Override
        public Type type() {
            return Type.FLOAT_TYPE;
        }

        @Override
        public Class<?> cls() {
            return Float.TYPE;
        }
    }

    public static enum TDouble implements TCat2,
    BPrim<double[]>
    {
        INSTANCE;


        @Override
        public int t() {
            return 7;
        }

        @Override
        public Type type() {
            return Type.DOUBLE_TYPE;
        }

        @Override
        public Class<?> cls() {
            return Double.TYPE;
        }
    }

    public static interface TCat2
    extends BNonVoid {
        @Override
        default public int slots() {
            return 2;
        }
    }

    public static interface TCat1
    extends BNonVoid {
        @Override
        default public int slots() {
            return 1;
        }
    }

    public static interface BPrim<A>
    extends BNonVoid,
    SPrim<A> {
        @Override
        public int t();
    }

    public static interface BNonVoid
    extends BType,
    SNonVoid {
        public int slots();
    }

    public static interface BType
    extends SType {
        @Override
        public Type type();

        default public String internalName() {
            return this.type().getInternalName();
        }
    }

    public static interface SPrim<A>
    extends SNonVoid {
        public int t();
    }

    public static interface SNonVoid
    extends SType {
    }

    public static interface SType {
        public Type type();

        public Class<?> cls();
    }
}

