/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.var;

import ghidra.pcode.emu.jit.alloc.JvmLocal;
import ghidra.pcode.emu.jit.analysis.JitControlFlowModel;
import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.analysis.JitVarScopeModel;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.access.AccessGen;
import ghidra.pcode.emu.jit.gen.opnd.Opnd;
import ghidra.pcode.emu.jit.gen.tgt.JitCompiledPassage;
import ghidra.pcode.emu.jit.gen.util.Emitter;
import ghidra.pcode.emu.jit.gen.util.Local;
import ghidra.pcode.emu.jit.gen.util.Scope;
import ghidra.pcode.emu.jit.gen.util.Types;
import ghidra.pcode.emu.jit.gen.var.MissingVarGen;
import ghidra.pcode.emu.jit.gen.var.ValGen;
import ghidra.pcode.emu.jit.gen.var.WholeDirectMemoryVarGen;
import ghidra.pcode.emu.jit.gen.var.WholeInputVarGen;
import ghidra.pcode.emu.jit.gen.var.WholeLocalOutVarGen;
import ghidra.pcode.emu.jit.gen.var.WholeMemoryOutVarGen;
import ghidra.pcode.emu.jit.var.JitDirectMemoryVar;
import ghidra.pcode.emu.jit.var.JitIndirectMemoryVar;
import ghidra.pcode.emu.jit.var.JitInputVar;
import ghidra.pcode.emu.jit.var.JitLocalOutVar;
import ghidra.pcode.emu.jit.var.JitMemoryOutVar;
import ghidra.pcode.emu.jit.var.JitMissingVar;
import ghidra.pcode.emu.jit.var.JitVar;
import ghidra.pcode.emu.jit.var.JitVarnodeVar;
import ghidra.program.model.pcode.Varnode;
import java.lang.runtime.SwitchBootstraps;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

public interface VarGen<V extends JitVar>
extends ValGen<V> {
    public static <V extends JitVar> VarGen<V> lookup(V v) {
        V v2 = v;
        Objects.requireNonNull(v2);
        V v3 = v2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitIndirectMemoryVar.class, JitDirectMemoryVar.class, JitInputVar.class, JitMissingVar.class, JitMemoryOutVar.class, JitLocalOutVar.class}, v3, n)) {
            case 0 -> {
                JitIndirectMemoryVar imv = (JitIndirectMemoryVar)v3;
                throw new AssertionError();
            }
            case 1 -> {
                JitDirectMemoryVar dmv = (JitDirectMemoryVar)v3;
                yield WholeDirectMemoryVarGen.GEN;
            }
            case 2 -> {
                JitInputVar iv = (JitInputVar)v3;
                yield WholeInputVarGen.GEN;
            }
            case 3 -> {
                JitMissingVar mv = (JitMissingVar)v3;
                yield MissingVarGen.GEN;
            }
            case 4 -> {
                JitMemoryOutVar mov = (JitMemoryOutVar)v3;
                yield WholeMemoryOutVarGen.GEN;
            }
            case 5 -> {
                JitLocalOutVar lov = (JitLocalOutVar)v3;
                yield WholeLocalOutVarGen.GEN;
            }
            default -> throw new AssertionError();
        };
    }

    public static <N extends Emitter.Next> Emitter<N> genVarnodeInit(Emitter<N> em, JitCodeGenerator<?> gen, Varnode vn) {
        long start = vn.getOffset();
        long endIncl = start + (long)vn.getSize() - 1L;
        long startBlock = start / 4096L * 4096L;
        long endBlockIncl = endIncl / 4096L * 4096L;
        for (long block = startBlock; block != endBlockIncl + 4096L; block += 4096L) {
            gen.requestFieldForArrDirect(vn.getAddress().getNewAddress(block));
        }
        return em;
    }

    public static <THIS extends JitCompiledPassage, T extends Types.BPrim<?>, JT extends JitType.SimpleJitType<T, JT>, N extends Emitter.Next> Emitter<Emitter.Ent<N, T>> genReadValDirectToStack(Emitter<N> em, Local<Types.TRef<THIS>> localThis, JitCodeGenerator<THIS> gen, JT type, Varnode vn) {
        return AccessGen.lookupSimple(gen.getAnalysisContext().getEndian(), type).genReadToStack(em, localThis, gen, vn);
    }

    public static <THIS extends JitCompiledPassage, T extends Types.BPrim<?>, JT extends JitType.SimpleJitType<T, JT>, N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, T>> Emitter<N1> genWriteValDirectFromStack(Emitter<N0> em, Local<Types.TRef<THIS>> localThis, JitCodeGenerator<THIS> gen, JT type, Varnode vn) {
        return AccessGen.lookupSimple(gen.getAnalysisContext().getEndian(), type).genWriteFromStack(em, localThis, gen, vn);
    }

    public static <THIS extends JitCompiledPassage, T extends Types.BPrim<?>, JT extends JitType.SimpleJitType<T, JT>, N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, T>> Emitter<N1> genWriteValDirectFromStack(Emitter<N0> em, Local<Types.TRef<THIS>> localThis, JitCodeGenerator<THIS> gen, JT type, JitVarnodeVar v) {
        return VarGen.genWriteValDirectFromStack(em, localThis, gen, type, v.varnode());
    }

    public static <THIS extends JitCompiledPassage, N extends Emitter.Next> Emitter<N> genBirth(Emitter<N> em, Local<Types.TRef<THIS>> localThis, JitCodeGenerator<THIS> gen, Set<Varnode> toBirth) {
        for (Varnode vn : toBirth) {
            for (JvmLocal<?, ?> local : gen.getAllocationModel().localsForVn(vn)) {
                em = local.genBirthCode(em, localThis, gen);
            }
        }
        return em;
    }

    public static <THIS extends JitCompiledPassage, N extends Emitter.Next> Emitter<N> genRetire(Emitter<N> em, Local<Types.TRef<THIS>> localThis, JitCodeGenerator<THIS> gen, Set<Varnode> toRetire) {
        for (Varnode vn : toRetire) {
            for (JvmLocal<?, ?> local : gen.getAllocationModel().localsForVn(vn)) {
                em = local.genRetireCode(em, localThis, gen);
            }
        }
        return em;
    }

    public static <THIS extends JitCompiledPassage> BlockTransition<THIS> computeBlockTransition(Local<Types.TRef<THIS>> localThis, JitCodeGenerator<THIS> gen, JitControlFlowModel.JitBlock from, JitControlFlowModel.JitBlock to) {
        JitVarScopeModel scopeModel = gen.getVariableScopeModel();
        Set liveFrom = from == null ? Set.of() : scopeModel.getLiveVars(from);
        Set liveTo = to == null ? Set.of() : scopeModel.getLiveVars(to);
        BlockTransition<THIS> result = new BlockTransition<THIS>(localThis, gen);
        result.toRetire.addAll(liveFrom);
        result.toRetire.removeAll(liveTo);
        result.toBirth.addAll(liveTo);
        result.toBirth.removeAll(liveFrom);
        return result;
    }

    public <THIS extends JitCompiledPassage, T extends Types.BPrim<?>, JT extends JitType.SimpleJitType<T, JT>, N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, T>> Emitter<N1> genWriteFromStack(Emitter<N0> var1, Local<Types.TRef<THIS>> var2, JitCodeGenerator<THIS> var3, V var4, JT var5, Opnd.Ext var6, Scope var7);

    public <THIS extends JitCompiledPassage, N extends Emitter.Next> Emitter<N> genWriteFromOpnd(Emitter<N> var1, Local<Types.TRef<THIS>> var2, JitCodeGenerator<THIS> var3, V var4, Opnd<JitType.MpIntJitType> var5, Opnd.Ext var6, Scope var7);

    public <THIS extends JitCompiledPassage, N1 extends Emitter.Next, N0 extends Emitter.Ent<N1, Types.TRef<int[]>>> Emitter<N1> genWriteFromArray(Emitter<N0> var1, Local<Types.TRef<THIS>> var2, JitCodeGenerator<THIS> var3, V var4, JitType.MpIntJitType var5, Opnd.Ext var6, Scope var7);

    public record BlockTransition<THIS extends JitCompiledPassage>(Local<Types.TRef<THIS>> localThis, JitCodeGenerator<THIS> gen, Set<Varnode> toRetire, Set<Varnode> toBirth) {
        public BlockTransition(Local<Types.TRef<THIS>> localThis, JitCodeGenerator<THIS> gen) {
            this(localThis, gen, new LinkedHashSet<Varnode>(), new LinkedHashSet<Varnode>());
        }

        public boolean needed() {
            return !this.toRetire.isEmpty() || !this.toBirth().isEmpty();
        }

        public <N extends Emitter.Next> Emitter<N> genFwd(Emitter<N> em) {
            return em.emit(VarGen::genRetire, this.localThis, this.gen, this.toRetire).emit(VarGen::genBirth, this.localThis, this.gen, this.toBirth);
        }

        public <N extends Emitter.Next> Emitter<N> genInv(Emitter<N> em) {
            return em.emit(VarGen::genRetire, this.localThis, this.gen, this.toBirth).emit(VarGen::genBirth, this.localThis, this.gen, this.toRetire);
        }
    }
}

