/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emulate;

import ghidra.program.model.address.Address;
import ghidra.program.model.lang.DisassemblerContext;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.DefaultProgramContext;
import ghidra.program.util.ProgramContextImpl;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Deprecated(since="12.1", forRemoval=true)
public class EmulateDisassemblerContext
implements DisassemblerContext {
    private final Language language;
    private final Map<Address, RegisterValue> futureContextMap;
    private final Register contextReg;
    private RegisterValue contextRegValue;
    private byte[] flowingContextRegisterMask;
    private boolean hasNonFlowingContext;

    EmulateDisassemblerContext(Language language) {
        this.language = language;
        this.contextReg = language.getContextBaseRegister();
        this.futureContextMap = new HashMap<Address, RegisterValue>();
        this.initContext();
    }

    public EmulateDisassemblerContext(Language language, RegisterValue initialContextValue) {
        this(language);
        this.contextRegValue = initialContextValue;
    }

    public Register getBaseContextRegister() {
        return this.contextReg;
    }

    public RegisterValue getCurrentContextRegisterValue() {
        if (this.contextRegValue == null) {
            return null;
        }
        return new RegisterValue(this.contextRegValue.getRegister(), this.contextRegValue.toBytes());
    }

    public void setCurrentAddress(Address addr) {
        RegisterValue newContext;
        if (this.contextReg == Register.NO_CONTEXT) {
            return;
        }
        RegisterValue partialValue = null;
        if (this.contextRegValue != null && this.contextRegValue.getRegister() != this.contextReg) {
            if (this.contextRegValue.getRegister().getBaseRegister() == this.contextReg) {
                partialValue = this.contextRegValue;
            }
            this.contextRegValue = null;
        }
        if (this.contextRegValue == null) {
            ProgramContextImpl defaultContext = new ProgramContextImpl(this.language);
            this.language.applyContextSettings((DefaultProgramContext)defaultContext);
            this.contextRegValue = defaultContext.getDefaultValue(this.contextReg, addr);
            if (this.contextRegValue == null) {
                this.contextRegValue = new RegisterValue(this.contextReg);
            }
            if (partialValue != null) {
                this.contextRegValue = this.contextRegValue.combineValues(partialValue);
            }
        }
        if (this.hasNonFlowingContext) {
            byte[] contextBytes = this.contextRegValue.toBytes();
            int valMaskLen = contextBytes.length >> 1;
            for (int i = 0; i < valMaskLen; ++i) {
                int n = i;
                contextBytes[n] = (byte)(contextBytes[n] & this.flowingContextRegisterMask[i]);
                int n2 = valMaskLen + i;
                contextBytes[n2] = (byte)(contextBytes[n2] & this.flowingContextRegisterMask[i]);
            }
            this.contextRegValue = new RegisterValue(this.contextReg, contextBytes);
        }
        if ((newContext = this.futureContextMap.get(addr)) != null) {
            this.contextRegValue = this.contextRegValue.combineValues(newContext);
        }
    }

    private void initContext() {
        if (this.contextReg == Register.NO_CONTEXT) {
            return;
        }
        this.flowingContextRegisterMask = (byte[])this.contextReg.getBaseMask().clone();
        Arrays.fill(this.flowingContextRegisterMask, (byte)0);
        this.initContextBitMasks(this.contextReg);
    }

    private void initContextBitMasks(Register reg) {
        block4: {
            byte[] subMask;
            block3: {
                subMask = reg.getBaseMask();
                if (reg.followsFlow()) break block3;
                this.hasNonFlowingContext = true;
                for (int i = 0; i < this.flowingContextRegisterMask.length; ++i) {
                    int n = i;
                    this.flowingContextRegisterMask[n] = (byte)(this.flowingContextRegisterMask[n] & ~subMask[i]);
                }
                break block4;
            }
            for (int i = 0; i < this.flowingContextRegisterMask.length; ++i) {
                int n = i;
                this.flowingContextRegisterMask[n] = (byte)(this.flowingContextRegisterMask[n] | subMask[i]);
            }
            if (!reg.hasChildren()) break block4;
            for (Register childReg : reg.getChildRegisters()) {
                this.initContextBitMasks(childReg);
            }
        }
    }

    public void clearRegister(Register register) {
        throw new UnsupportedOperationException();
    }

    public Register getRegister(String name) {
        throw new UnsupportedOperationException();
    }

    public RegisterValue getRegisterValue(Register register) {
        if (!register.isProcessorContext()) {
            throw new UnsupportedOperationException();
        }
        if (register.equals((Object)this.contextReg)) {
            return this.contextRegValue;
        }
        return new RegisterValue(register, this.contextRegValue.toBytes());
    }

    public List<Register> getRegisters() {
        throw new UnsupportedOperationException();
    }

    public BigInteger getValue(Register register, boolean signed) {
        throw new UnsupportedOperationException();
    }

    public boolean hasValue(Register register) {
        return true;
    }

    public void setRegisterValue(RegisterValue value) {
        Register reg = value.getRegister();
        if (!reg.isProcessorContext()) {
            throw new UnsupportedOperationException();
        }
        this.contextRegValue = this.contextRegValue == null ? value.getBaseRegisterValue() : this.contextRegValue.combineValues(value);
    }

    public void setValue(Register register, BigInteger value) {
        throw new UnsupportedOperationException();
    }

    public void setFutureRegisterValue(Address address, RegisterValue value) {
        Register reg = value.getRegister();
        if (!reg.isProcessorContext()) {
            throw new UnsupportedOperationException();
        }
        RegisterValue registerValue = this.futureContextMap.get(address);
        if (registerValue != null) {
            value = registerValue.combineValues(value);
        }
        this.futureContextMap.put(address, value);
    }

    public void setFutureRegisterValue(Address fromAddr, Address toAddr, RegisterValue value) {
        throw new UnsupportedOperationException();
    }
}

