/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec;

import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.plugin.processors.sleigh.template.OpTpl;
import ghidra.app.util.pcode.AbstractAppender;
import ghidra.app.util.pcode.AbstractPcodeFormatter;
import ghidra.app.util.pcode.Appender;
import ghidra.pcode.exec.PcodeExecutor;
import ghidra.pcode.exec.PcodeUseropLibrary;
import ghidra.pcodeCPort.slghsymbol.UserOpSymbol;
import ghidra.program.model.lang.InjectContext;
import ghidra.program.model.lang.InjectPayload;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.PcodeInjectLibrary;
import ghidra.program.model.lang.UnknownInstructionException;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.util.exception.NotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PcodeProgram {
    protected final SleighLanguage language;
    protected final List<PcodeOp> code;
    protected final Map<Integer, String> useropNames;

    public static PcodeProgram fromInstruction(Instruction instruction) {
        return PcodeProgram.fromInstruction(instruction, false);
    }

    public static PcodeProgram fromInstruction(Instruction instruction, boolean includeOverrides) {
        Language language = instruction.getPrototype().getLanguage();
        if (!(language instanceof SleighLanguage)) {
            throw new IllegalArgumentException("Instruction must be parsed using Sleigh");
        }
        SleighLanguage slang = (SleighLanguage)language;
        PcodeOp[] pcode = instruction.getPcode(includeOverrides);
        return new PcodeProgram(slang, List.of(pcode), Map.of());
    }

    public static PcodeProgram fromInject(Program program, String name, int type) throws MemoryAccessException, UnknownInstructionException, NotFoundException, IOException {
        PcodeInjectLibrary library = program.getCompilerSpec().getPcodeInjectLibrary();
        InjectContext ctx = library.buildInjectContext();
        InjectPayload payload = library.getPayload(type, name);
        PcodeOp[] pcode = payload.getPcode(program, ctx);
        return new PcodeProgram((SleighLanguage)program.getLanguage(), List.of(pcode), Map.of());
    }

    protected PcodeProgram(SleighLanguage language, List<PcodeOp> code, Map<Integer, UserOpSymbol> useropSymbols) {
        this.language = language;
        this.code = code;
        this.useropNames = new HashMap<Integer, String>();
        int langOpCount = language.getNumberOfUserDefinedOpNames();
        for (Map.Entry<Integer, UserOpSymbol> ent : useropSymbols.entrySet()) {
            int index = ent.getKey();
            if (index < langOpCount) {
                this.useropNames.put(index, language.getUserDefinedOpName(index));
                continue;
            }
            this.useropNames.put(index, ent.getValue().getName());
        }
    }

    public PcodeProgram(PcodeProgram program, List<PcodeOp> code) {
        assert (!code.isEmpty());
        this.language = program.language;
        this.code = code;
        this.useropNames = program.useropNames;
    }

    public SleighLanguage getLanguage() {
        return this.language;
    }

    public List<PcodeOp> getCode() {
        return this.code;
    }

    public <T> void execute(PcodeExecutor<T> executor, PcodeUseropLibrary<T> library) {
        executor.execute(this, library);
    }

    protected String getHead() {
        return this.getClass().getSimpleName();
    }

    public String toString() {
        return this.format();
    }

    public String format(boolean numberOps) {
        return (String)new MyFormatter(this, numberOps).formatOps((Language)this.language, this.code);
    }

    public String format() {
        return this.format(false);
    }

    public String getUseropName(int opNo) {
        if (opNo < this.language.getNumberOfUserDefinedOpNames()) {
            return this.language.getUserDefinedOpName(opNo);
        }
        return this.useropNames.get(opNo);
    }

    public int getUseropNumber(String name) {
        for (int i = 0; i < this.language.getNumberOfUserDefinedOpNames(); ++i) {
            if (!name.equals(this.language.getUserDefinedOpName(i))) continue;
            return i;
        }
        for (Map.Entry<Integer, String> ent : this.useropNames.entrySet()) {
            if (!name.equals(ent.getValue())) continue;
            return ent.getKey();
        }
        return -1;
    }

    protected static class MyFormatter
    extends AbstractPcodeFormatter<String, MyAppender> {
        protected final PcodeProgram program;
        protected final boolean numberOps;

        public MyFormatter(PcodeProgram program, boolean numberOps) {
            this.program = program;
            this.numberOps = numberOps;
        }

        protected MyAppender createAppender(Language language, boolean indent) {
            return new MyAppender(this.program, language, this.numberOps);
        }

        protected AbstractPcodeFormatter.FormatResult formatOpTemplate(MyAppender appender, OpTpl op) {
            AbstractPcodeFormatter.FormatResult result = super.formatOpTemplate((Appender)appender, op);
            appender.endLine();
            return result;
        }
    }

    protected static class MyAppender
    extends AbstractAppender<String> {
        protected int opIdx = 0;
        protected final PcodeProgram program;
        protected final boolean numberOps;
        protected final StringBuffer buf = new StringBuffer();

        public MyAppender(PcodeProgram program, Language language, boolean numberOps) {
            super(language, true);
            this.program = program;
            this.numberOps = numberOps;
            this.buf.append("<" + program.getHead() + ":\n");
        }

        protected void appendString(String string) {
            this.buf.append(string);
        }

        protected void endLine() {
            this.buf.append("\n");
        }

        protected String stringifyUseropUnchecked(Language language, int id) {
            String name = super.stringifyUseropUnchecked(language, id);
            if (name != null) {
                return name;
            }
            return this.program.useropNames.get(id);
        }

        public String finish() {
            this.buf.append(">");
            return this.buf.toString();
        }

        public void appendIndent() {
            super.appendIndent();
            if (this.numberOps) {
                PcodeOp op = this.program.getCode().get(this.opIdx);
                this.buf.append(this.opIdx++);
                this.buf.append(",");
                this.buf.append(op.getSeqnum().getTarget());
                this.buf.append(".");
                this.buf.append(op.getSeqnum().getTime());
                this.buf.append(": ");
            }
        }
    }
}

