/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.options;

import ghidra.framework.options.AbstractOptions;
import ghidra.framework.options.ActionTrigger;
import ghidra.framework.options.AttributedSaveState;
import ghidra.framework.options.CustomOption;
import ghidra.framework.options.Option;
import ghidra.framework.options.OptionType;
import ghidra.framework.options.Options;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.SaveState;
import ghidra.framework.options.ThemeColorOption;
import ghidra.framework.options.ThemeFontOption;
import ghidra.framework.options.WrappedActionTrigger;
import ghidra.framework.options.WrappedColor;
import ghidra.framework.options.WrappedCustomOption;
import ghidra.framework.options.WrappedDate;
import ghidra.framework.options.WrappedFile;
import ghidra.framework.options.WrappedFont;
import ghidra.framework.options.WrappedKeyStroke;
import ghidra.framework.options.WrappedOption;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.SystemUtilities;
import ghidra.util.bean.opteditor.OptionsVetoException;
import ghidra.util.exception.AssertException;
import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyEditor;
import java.io.File;
import java.lang.reflect.Constructor;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.KeyStroke;
import org.jdom.Content;
import org.jdom.Element;

public class ToolOptions
extends AbstractOptions {
    private static final String CLASS_ATTRIBUTE = "CLASS";
    private static final String NAME_ATTRIBUTE = "NAME";
    private static final String WRAPPED_OPTION_NAME = "WRAPPED_OPTION";
    private static final String CLEARED_VALUE_ELEMENT_NAME = "CLEARED_VALUE";
    public static final String LAST_REGISTERED_DATE_ATTIBUTE = "LAST_REGISTERED";
    public static final DateTimeFormatter LAST_REGISTERED_DATE_FORMATTER = DateTimeFormatter.ISO_LOCAL_DATE;
    public static final Set<Class<?>> PRIMITIVE_CLASSES = ToolOptions.buildPrimitiveClassSet();
    public static final Set<Class<?>> WRAPPABLE_CLASSES = ToolOptions.buildWrappableClassSet();
    public static final String XML_ELEMENT_NAME = "CATEGORY";

    private static Set<Class<?>> buildPrimitiveClassSet() {
        HashSet set = new HashSet();
        set.add(Byte.class);
        set.add(Short.class);
        set.add(Integer.class);
        set.add(Long.class);
        set.add(Float.class);
        set.add(Double.class);
        set.add(Boolean.class);
        set.add(String.class);
        return set;
    }

    private static Set<Class<?>> buildWrappableClassSet() {
        HashSet set = new HashSet();
        set.add(Color.class);
        set.add(Font.class);
        set.add(KeyStroke.class);
        set.add(File.class);
        return set;
    }

    public ToolOptions(String name) {
        super(name);
    }

    public ToolOptions copy() {
        return new ToolOptions(this.getXmlRoot(true));
    }

    public ToolOptions(Element root) {
        this(root.getAttributeValue(NAME_ATTRIBUTE));
        AttributedSaveState saveState = new AttributedSaveState(root);
        this.readNonWrappedOptions(saveState);
        try {
            this.readWrappedOptions(root);
        }
        catch (ReflectiveOperationException exc) {
            Msg.error((Object)this, (Object)("Unexpected Exception: " + exc.getMessage()), (Throwable)exc);
        }
    }

    private void readNonWrappedOptions(AttributedSaveState saveState) {
        for (String optionName : saveState.getNames()) {
            Object object = saveState.getObject(optionName);
            OptionType type = OptionType.getOptionType(object);
            Option option = this.createUnregisteredOption(optionName, type, null);
            option.doSetCurrentValue(object);
            LocalDate date = this.getLastRegisteredDateString(saveState, optionName);
            option.setLastRegisteredDate(date);
            this.valueMap.put(optionName, option);
        }
    }

    private LocalDate getLastRegisteredDateString(AttributedSaveState saveState, String optionName) {
        String dateString;
        Map attrs = saveState.getAttributes(optionName);
        if (attrs != null && (dateString = (String)attrs.get(LAST_REGISTERED_DATE_ATTIBUTE)) != null) {
            return LocalDate.parse(dateString, LAST_REGISTERED_DATE_FORMATTER);
        }
        return LocalDate.now();
    }

    private void readWrappedOptions(Element root) throws ReflectiveOperationException {
        for (Element element : root.getChildren(WRAPPED_OPTION_NAME)) {
            WrappedCustomOption wrappedCustom;
            List children = element.getChildren();
            if (children.isEmpty()) continue;
            Class<?> c = Class.forName(element.getAttributeValue(CLASS_ATTRIBUTE));
            Constructor<?> constructor = c.getDeclaredConstructor(new Class[0]);
            WrappedOption wo = (WrappedOption)constructor.newInstance(new Object[0]);
            wo.readState(new SaveState(element));
            if (wo instanceof WrappedCustomOption && !(wrappedCustom = (WrappedCustomOption)wo).isValid()) continue;
            if (wo instanceof WrappedKeyStroke) {
                WrappedKeyStroke wrappedKs = (WrappedKeyStroke)wo;
                wo = wrappedKs.toWrappedActionTrigger();
            }
            String optionName = element.getAttributeValue(NAME_ATTRIBUTE);
            Option option = this.createUnregisteredOption(optionName, wo.getOptionType(), null);
            this.valueMap.put(optionName, option);
            Element child = (Element)children.get(0);
            String elementName = child.getName();
            if (CLEARED_VALUE_ELEMENT_NAME.equals(elementName)) {
                option.doSetCurrentValue(null);
            } else {
                option.doSetCurrentValue(wo.getObject());
            }
            LocalDate date = LocalDate.now();
            String dateString = element.getAttributeValue(LAST_REGISTERED_DATE_ATTIBUTE);
            if (dateString != null) {
                date = LocalDate.parse(dateString, LAST_REGISTERED_DATE_FORMATTER);
            }
            option.setLastRegisteredDate(date);
        }
    }

    public Element getXmlRoot(boolean includeDefaultBindings) {
        AttributedSaveState saveState = new AttributedSaveState(XML_ELEMENT_NAME);
        this.writeNonWrappedOptions(includeDefaultBindings, saveState);
        Element root = saveState.saveToXml();
        root.setAttribute(NAME_ATTRIBUTE, this.name);
        this.writeWrappedOptions(includeDefaultBindings, root);
        return root;
    }

    private void writeNonWrappedOptions(boolean includeDefaultBindings, AttributedSaveState saveState) {
        for (String optionName : this.valueMap.keySet()) {
            Option option = (Option)this.valueMap.get(optionName);
            if (!includeDefaultBindings && option.isDefault()) continue;
            this.writeNonWrappedOption(saveState, optionName, option);
        }
    }

    private void writeNonWrappedOption(AttributedSaveState saveState, String optionName, Option option) {
        Object value = option.getValue(null);
        if (!this.isSupportedBySaveState(value)) {
            return;
        }
        saveState.putObject(optionName, value);
        LocalDate date = option.getLastRegisteredDate();
        String dateString = date.format(LAST_REGISTERED_DATE_FORMATTER);
        Map<String, String> attrs = Map.of(LAST_REGISTERED_DATE_ATTIBUTE, dateString);
        saveState.addAttributes(optionName, attrs);
    }

    private void writeWrappedOptions(boolean includeDefaultBindings, Element root) {
        for (String optionName : this.valueMap.keySet()) {
            Option option = (Option)this.valueMap.get(optionName);
            if (option instanceof ThemeColorOption || option instanceof ThemeFontOption || !includeDefaultBindings && option.isDefault()) continue;
            this.writeWrappedOption(root, optionName, option);
        }
    }

    private void writeWrappedOption(Element root, String optionName, Option option) {
        Object value = option.getCurrentValue();
        if (this.isSupportedBySaveState(value)) {
            return;
        }
        WrappedOption wrappedOption = this.wrapOption(option);
        if (wrappedOption == null) {
            return;
        }
        SaveState ss = new SaveState(WRAPPED_OPTION_NAME);
        Element element = null;
        if (value == null) {
            element = ss.saveToXml();
            element.addContent((Content)new Element(CLEARED_VALUE_ELEMENT_NAME));
        } else {
            wrappedOption.writeState(ss);
            element = ss.saveToXml();
        }
        element.setAttribute(NAME_ATTRIBUTE, optionName);
        String className = wrappedOption.getClass().getName();
        element.setAttribute(CLASS_ATTRIBUTE, className);
        LocalDate date = option.getLastRegisteredDate();
        String dateString = date.format(LAST_REGISTERED_DATE_FORMATTER);
        element.setAttribute(LAST_REGISTERED_DATE_ATTIBUTE, dateString);
        root.addContent((Content)element);
    }

    private boolean isSupportedBySaveState(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Enum) {
            return true;
        }
        if (obj instanceof byte[]) {
            return true;
        }
        return PRIMITIVE_CLASSES.contains(obj.getClass());
    }

    private WrappedOption wrapOption(Option option) {
        Object value = null;
        value = option.getCurrentValue();
        if (value == null) {
            value = option.getDefaultValue();
        }
        if (value == null) {
            return null;
        }
        if (value instanceof CustomOption) {
            return new WrappedCustomOption((CustomOption)value);
        }
        if (value instanceof Color) {
            return new WrappedColor((Color)value);
        }
        if (value instanceof Font) {
            return new WrappedFont((Font)value);
        }
        if (value instanceof KeyStroke) {
            return new WrappedKeyStroke((KeyStroke)value);
        }
        if (value instanceof ActionTrigger) {
            return new WrappedActionTrigger((ActionTrigger)value);
        }
        if (value instanceof File) {
            return new WrappedFile((File)value);
        }
        if (value instanceof Date) {
            return new WrappedDate((Date)value);
        }
        throw new AssertException("Attempted to wrap object of unexpected class type: " + String.valueOf(value.getClass()));
    }

    public void addOptionsChangeListener(OptionsChangeListener l) {
        this.listeners.add((Object)l);
    }

    public void takeListeners(ToolOptions oldOptions) {
        this.listeners = oldOptions.listeners;
        oldOptions.listeners = null;
    }

    public void removeOptionsChangeListener(OptionsChangeListener l) {
        this.listeners.remove((Object)l);
    }

    public void removeUnusedOptions() {
        ArrayList optionNames = new ArrayList(this.valueMap.keySet());
        for (String optionName : optionNames) {
            Option optionState = (Option)this.valueMap.get(optionName);
            if (!optionState.hasExpired()) continue;
            this.removeOption(optionName);
        }
    }

    public void copyOptions(Options newOptions) {
        List<String> optionNames = newOptions.getOptionNames();
        for (String optionName : optionNames) {
            Object value = newOptions.getObject(optionName, null);
            if (value == null) continue;
            this.putObject(optionName, value);
        }
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ToolOptions other = (ToolOptions)obj;
        if (!SystemUtilities.isEqual((Object)this.name, (Object)other.name)) {
            return false;
        }
        List<String> optionNames = this.getOptionNames();
        List<String> otherOptionNames = other.getOptionNames();
        if (optionNames.size() != otherOptionNames.size()) {
            return false;
        }
        Object dummy = new Object();
        for (String string : optionNames) {
            Object otherValue;
            Object myValue = this.getObject(string, dummy);
            if (SystemUtilities.isEqual((Object)myValue, (Object)(otherValue = other.getObject(string, dummy)))) continue;
            return false;
        }
        return true;
    }

    public void validateOptions() {
        if (!SystemUtilities.isInDevelopmentMode()) {
            return;
        }
        Set keySet = this.valueMap.keySet();
        for (String propertyName : keySet) {
            Option optionState = (Option)this.valueMap.get(propertyName);
            if (optionState.isRegistered() || optionState.wasRegisteredInPreviousSession()) continue;
            Msg.warn((Object)this, (Object)("Unregistered property \"" + propertyName + "\" in Options \"" + this.name + "\"\n     " + optionState.getInceptionInformation()));
        }
    }

    public void registerOptions(ToolOptions oldOptions) {
        Set optionNameSet = oldOptions.valueMap.keySet();
        for (String optionName : optionNameSet) {
            Option option = (Option)oldOptions.valueMap.get(optionName);
            if (!option.isRegistered()) continue;
            this.registerOption(optionName, option.getOptionType(), option.getDefaultValue(), option.getHelpLocation(), option.getDescription());
        }
    }

    @Override
    protected Option createRegisteredOption(String optionName, OptionType type, String description, HelpLocation help, Object defaultValue, PropertyEditor editor) {
        return new ToolOption(optionName, type, description, help, defaultValue, true, editor);
    }

    @Override
    protected Option createUnregisteredOption(String optionName, OptionType type, Object defaultValue) {
        if (type == OptionType.KEYSTROKE_TYPE) {
            type = OptionType.ACTION_TRIGGER;
            if (defaultValue instanceof KeyStroke) {
                KeyStroke keyStroke = (KeyStroke)defaultValue;
                defaultValue = new ActionTrigger(keyStroke);
            }
        }
        return new ToolOption(optionName, type, null, null, defaultValue, false, null);
    }

    @Override
    protected boolean notifyOptionChanged(String optionName, Object oldValue, Object newValue) {
        NotifyListenersRunnable runnable = new NotifyListenersRunnable(optionName, oldValue, newValue);
        Swing.runNow((Runnable)runnable);
        OptionsVetoException veto = runnable.getVetoException();
        if (veto != null) {
            throw veto;
        }
        return true;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.listeners.clear();
    }

    private static class ToolOption
    extends Option {
        private Object currentValue;

        ToolOption(String name, OptionType type, String description, HelpLocation helpLocation, Object defaultValue, boolean isRegistered, PropertyEditor editor) {
            super(name, type, description, helpLocation, defaultValue, isRegistered, editor);
            this.currentValue = defaultValue;
        }

        @Override
        public Object getCurrentValue() {
            return this.currentValue;
        }

        @Override
        public void doSetCurrentValue(Object value) {
            this.currentValue = value;
        }
    }

    private class NotifyListenersRunnable
    implements Runnable {
        private String optionName;
        private Object oldValue;
        private Object newValue;
        private OptionsVetoException veto;

        NotifyListenersRunnable(String optionName, Object oldValue, Object newValue) {
            this.optionName = optionName;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        @Override
        public void run() {
            ArrayList<OptionsChangeListener> notifiedListeners = new ArrayList<OptionsChangeListener>();
            try {
                for (OptionsChangeListener listener : ToolOptions.this.listeners) {
                    listener.optionsChanged(ToolOptions.this, this.optionName, this.oldValue, this.newValue);
                    notifiedListeners.add(listener);
                }
            }
            catch (OptionsVetoException e) {
                this.veto = e;
                for (OptionsChangeListener notifiedListener : notifiedListeners) {
                    notifiedListener.optionsChanged(ToolOptions.this, this.optionName, this.newValue, this.oldValue);
                }
            }
        }

        OptionsVetoException getVetoException() {
            return this.veto;
        }
    }
}

