/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph;

import docking.ActionContext;
import docking.DockingUtils;
import docking.action.DockingAction;
import docking.action.KeyBindingData;
import docking.action.KeyBindingType;
import docking.action.MenuData;
import docking.action.ToggleDockingAction;
import docking.action.ToolBarData;
import docking.menu.ActionState;
import docking.menu.MultiStateDockingAction;
import docking.widgets.EventTrigger;
import docking.widgets.OptionDialog;
import generic.theme.GIcon;
import ghidra.app.events.ProgramSelectionPluginEvent;
import ghidra.app.plugin.core.functiongraph.EdgeDisplayType;
import ghidra.app.plugin.core.functiongraph.action.FunctionGraphSatelliteViewerActionContext;
import ghidra.app.plugin.core.functiongraph.action.FunctionGraphUneditableVertexLocationActionContext;
import ghidra.app.plugin.core.functiongraph.action.FunctionGraphValidGraphActionContextIf;
import ghidra.app.plugin.core.functiongraph.action.FunctionGraphVertexLocationContextIf;
import ghidra.app.plugin.core.functiongraph.action.FunctionGraphVertexLocationInFullViewModeActionContext;
import ghidra.app.plugin.core.functiongraph.action.VertexActionContextInfo;
import ghidra.app.plugin.core.functiongraph.graph.FunctionGraph;
import ghidra.app.plugin.core.functiongraph.graph.layout.FGLayoutProvider;
import ghidra.app.plugin.core.functiongraph.graph.vertex.FGVertex;
import ghidra.app.plugin.core.functiongraph.graph.vertex.GroupedFunctionGraphVertex;
import ghidra.app.plugin.core.functiongraph.mvc.FGController;
import ghidra.app.plugin.core.functiongraph.mvc.FGData;
import ghidra.app.plugin.core.functiongraph.mvc.FgEnv;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

public class FGActionManager {
    private static final String EDGE_HOVER_HIGHLIGHT = "EDGE_HOVER_HIGHLIGHT";
    private static final String EDGE_SELECTION_HIGHLIGHT = "EDGE_SELECTION_HIGHLIGHT";
    private static final String LAYOUT_NAME = "LAYOUT_NAME";
    private static final String COMPLEX_LAYOUT_NAME = "COMPLEX_LAYOUT_NAME";
    private static final String LAYOUT_CLASS_NAME = "LAYOUT_CLASS_NAME";
    private static final Icon GROUP_ICON = new GIcon("icon.plugin.functiongraph.action.vertex.group");
    private static final Icon GROUP_ADD_ICON = new GIcon("icon.plugin.functiongraph.action.vertex.group.add");
    private static final Icon UNGROUP_ICON = new GIcon("icon.plugin.functiongraph.action.vertex.ungroup");
    private static final Icon EDIT_ICON = new GIcon("icon.plugin.functiongraph.action.vertex.edit.label");
    private static final Icon FULL_SCREEN_ICON = new GIcon("icon.plugin.functiongraph.action.vertex.full.screen");
    private static final Icon XREFS_ICON = new GIcon("icon.plugin.functiongraph.action.vertex.full.screen");
    private PluginTool tool;
    private String owner;
    private FGController controller;
    private ToggleDockingAction togglePopups;
    private MultiStateDockingAction<EdgeDisplayType> vertexHoverModeAction;
    private MultiStateDockingAction<EdgeDisplayType> vertexFocusModeAction;
    private MultiStateDockingAction<FGLayoutProvider> layoutAction;

    public FGActionManager(FGController controller, String owner) {
        this.controller = controller;
        this.owner = owner;
        FgEnv env = controller.getEnv();
        this.tool = env.getTool();
        this.createActions();
    }

    private JComponent getCenterOverComponent() {
        return this.controller.getViewComponent();
    }

    private void addLocalAction(DockingAction action) {
        FgEnv env = this.controller.getEnv();
        env.addLocalAction(action);
    }

    private void createActions() {
        String toolBarGroup1 = "groupA";
        String layoutGroup = "groupB";
        String toolbarEdgeGroup = "groupC";
        String popupSelectionGroup = "Highlight";
        String popupSelectionGroup2 = popupSelectionGroup + "2";
        String popupSelectionGroup3 = popupSelectionGroup + "3";
        String popupMutateGroup1 = "zamutate.1";
        String popupMutateGroup2 = "zamutate.2";
        String popupDisplayGroup = "zdisplay";
        String popuEndPopupGroup = "zzzoom";
        int vertexGroupingSubgroupOffset = 1;
        int groupingSubgroupOffset = 1;
        DockingAction chooseFormatsAction = new DockingAction("Edit Code Block Fields", this.owner){

            public void actionPerformed(ActionContext context) {
                FGActionManager.this.showFormatChooser();
            }

            public boolean isEnabledForContext(ActionContext context) {
                return FGActionManager.this.controller.hasResults();
            }
        };
        chooseFormatsAction.setToolBarData(new ToolBarData((Icon)new GIcon("icon.plugin.functiongraph.action.vertex.edit.format"), layoutGroup, "3"));
        chooseFormatsAction.setHelpLocation(new HelpLocation("FunctionGraphPlugin", "Function_Graph_Action_Format"));
        DockingAction homeAction = new DockingAction("Go To Function Entry Point", this.owner){

            public void actionPerformed(ActionContext context) {
                FGActionManager.this.goHome();
            }

            public boolean isEnabledForContext(ActionContext context) {
                return FGActionManager.this.controller.getGraphedFunction() != null;
            }
        };
        homeAction.setToolBarData(new ToolBarData((Icon)new GIcon("icon.plugin.functiongraph.action.viewer.home"), toolBarGroup1));
        homeAction.setHelpLocation(new HelpLocation("FunctionGraphPlugin", "Function_Graph_Action_Home"));
        DockingAction resetGraphAction = new DockingAction("Reset Graph", this.owner){

            public void actionPerformed(ActionContext context) {
                int choice = OptionDialog.showYesNoDialog((Component)FGActionManager.this.getCenterOverComponent(), (String)"Reset Graph?", (String)"<html>Erase all vertex position and grouping information?");
                if (choice != 1) {
                    return;
                }
                FGActionManager.this.controller.resetGraph();
            }

            public boolean isEnabledForContext(ActionContext context) {
                return FGActionManager.this.controller.hasResults();
            }
        };
        resetGraphAction.setToolBarData(new ToolBarData((Icon)new GIcon("icon.plugin.functiongraph.action.viewer.reset"), layoutGroup, "1"));
        resetGraphAction.setDescription("<html>Reloads the graph--All positioning and grouping information is <b>lost</b>");
        resetGraphAction.setHelpLocation(new HelpLocation("FunctionGraphPlugin", "Function_Graph_Reload_Graph"));
        this.addLocalAction(resetGraphAction);
        this.addLayoutAction(layoutGroup);
        this.addVertexHoverModeAction(toolbarEdgeGroup);
        this.addVertexSelectedModeAction(toolbarEdgeGroup);
        DockingAction zoomOutAction = new DockingAction("Zoom Out", this.owner){

            public void actionPerformed(ActionContext context) {
                FGActionManager.this.controller.zoomOutGraph();
            }

            public boolean isAddToPopup(ActionContext context) {
                if (!(context instanceof FunctionGraphValidGraphActionContextIf)) {
                    return false;
                }
                return !(context instanceof FunctionGraphVertexLocationInFullViewModeActionContext);
            }
        };
        zoomOutAction.setPopupMenuData(new MenuData(new String[]{"Zoom Out"}, popuEndPopupGroup));
        zoomOutAction.setKeyBindingData(new KeyBindingData(KeyStroke.getKeyStroke(45, DockingUtils.CONTROL_KEY_MODIFIER_MASK)));
        zoomOutAction.setHelpLocation(new HelpLocation("FunctionGraphPlugin", "Zoom"));
        DockingAction zoomInAction = new DockingAction("Zoom In", this.owner){

            public void actionPerformed(ActionContext context) {
                FGActionManager.this.controller.zoomInGraph();
            }

            public boolean isAddToPopup(ActionContext context) {
                if (!(context instanceof FunctionGraphValidGraphActionContextIf)) {
                    return false;
                }
                return !(context instanceof FunctionGraphVertexLocationInFullViewModeActionContext);
            }
        };
        zoomInAction.setPopupMenuData(new MenuData(new String[]{"Zoom In"}, popuEndPopupGroup));
        zoomInAction.setKeyBindingData(new KeyBindingData(KeyStroke.getKeyStroke(61, DockingUtils.CONTROL_KEY_MODIFIER_MASK)));
        zoomInAction.setHelpLocation(new HelpLocation("FunctionGraphPlugin", "Zoom"));
        DockingAction zoomToWindowAction = new DockingAction("Zoom to Window", this.owner){

            public void actionPerformed(ActionContext context) {
                FGActionManager.this.controller.zoomToWindow();
            }

            public boolean isAddToPopup(ActionContext context) {
                if (!(context instanceof FunctionGraphValidGraphActionContextIf)) {
                    return false;
                }
                return !(context instanceof FunctionGraphVertexLocationInFullViewModeActionContext);
            }
        };
        zoomToWindowAction.setPopupMenuData(new MenuData(new String[]{"Zoom to Window"}, popuEndPopupGroup));
        zoomToWindowAction.setHelpLocation(new HelpLocation("FunctionGraphPlugin", "Zoom"));
        DockingAction zoomToVertexAction = new DockingAction("Zoom to Vertex", this.owner){

            public void actionPerformed(ActionContext context) {
                FunctionGraphVertexLocationContextIf vertexContext = (FunctionGraphVertexLocationContextIf)context;
                FGVertex vertex = vertexContext.getVertex();
                FGActionManager.this.controller.zoomToVertex(vertex);
            }

            public boolean isAddToPopup(ActionContext context) {
                if (!(context instanceof FunctionGraphVertexLocationContextIf)) {
                    return false;
                }
                FunctionGraphVertexLocationContextIf vertexContext = (FunctionGraphVertexLocationContextIf)context;
                FGVertex vertex = vertexContext.getVertex();
                return vertex != null;
            }
        };
        zoomToVertexAction.setPopupMenuData(new MenuData(new String[]{"Zoom to Vertex"}, popuEndPopupGroup));
        zoomToVertexAction.setHelpLocation(new HelpLocation("FunctionGraphPlugin", "Zoom"));
        this.togglePopups = new ToggleDockingAction("Display Popup Windows", this.owner){

            public void actionPerformed(ActionContext context) {
                FGActionManager.this.controller.setPopupsVisible(this.isSelected());
            }

            public boolean isAddToPopup(ActionContext context) {
                if (context instanceof FunctionGraphSatelliteViewerActionContext) {
                    return true;
                }
                if (!(context instanceof FunctionGraphValidGraphActionContextIf)) {
                    return false;
                }
                return !(context instanceof FunctionGraphVertexLocationInFullViewModeActionContext) && !(context instanceof FunctionGraphUneditableVertexLocationActionContext);
            }
        };
        this.togglePopups.setSelected(true);
        this.togglePopups.setPopupMenuData(new MenuData(new String[]{"Display Popup Windows"}, popupDisplayGroup));
        this.togglePopups.setHelpLocation(new HelpLocation("FunctionGraphPlugin", "Popups"));
        DockingAction editLabelAction = new DockingAction("Edit Vertex Label", this.owner){

            public void actionPerformed(ActionContext context) {
                FunctionGraphValidGraphActionContextIf graphContext = (FunctionGraphValidGraphActionContextIf)context;
                FGVertex vertex = graphContext.getSelectedVertices().iterator().next();
                vertex.editLabel(FGActionManager.this.getCenterOverComponent());
            }

            public boolean isEnabledForContext(ActionContext context) {
                if (!(context instanceof FunctionGraphValidGraphActionContextIf)) {
                    return false;
                }
                if (context instanceof FunctionGraphVertexLocationInFullViewModeActionContext) {
                    return false;
                }
                FunctionGraphValidGraphActionContextIf graphContext = (FunctionGraphValidGraphActionContextIf)context;
                return graphContext.getSelectedVertices().size() == 1;
            }

            public boolean isAddToPopup(ActionContext context) {
                if (!(context instanceof FunctionGraphValidGraphActionContextIf)) {
                    return false;
                }
                return !(context instanceof FunctionGraphVertexLocationInFullViewModeActionContext);
            }
        };
        MenuData menuData = new MenuData(new String[]{"Edit Label"}, popupMutateGroup1);
        menuData.setIcon(EDIT_ICON);
        menuData.setMenuSubGroup(Integer.toString(vertexGroupingSubgroupOffset++));
        editLabelAction.setDescription("Change the label for the code block");
        editLabelAction.setPopupMenuData(menuData);
        editLabelAction.setHelpLocation(new HelpLocation("FunctionGraphPlugin", "Vertex_Action_Label"));
        DockingAction fullViewAction = new DockingAction(this, "Vertex View Mode", this.owner){

            public void actionPerformed(ActionContext context) {
                FunctionGraphValidGraphActionContextIf graphContext = (FunctionGraphValidGraphActionContextIf)context;
                FGVertex vertex = graphContext.getSelectedVertices().iterator().next();
                vertex.setFullScreenMode(true);
            }

            public boolean isEnabledForContext(ActionContext context) {
                if (!(context instanceof FunctionGraphValidGraphActionContextIf)) {
                    return false;
                }
                if (context instanceof FunctionGraphVertexLocationInFullViewModeActionContext) {
                    return false;
                }
                FunctionGraphValidGraphActionContextIf graphContext = (FunctionGraphValidGraphActionContextIf)context;
                Set<FGVertex> vertices = graphContext.getSelectedVertices();
                if (vertices.size() != 1) {
                    return false;
                }
                FGVertex vertex = vertices.iterator().next();
                return !(vertex instanceof GroupedFunctionGraphVertex);
            }

            public boolean isAddToPopup(ActionContext context) {
                if (!(context instanceof FunctionGraphValidGraphActionContextIf)) {
                    return false;
                }
                return !(context instanceof FunctionGraphVertexLocationInFullViewModeActionContext);
            }
        };
        menuData = new MenuData(new String[]{"View Full Screen"}, popupMutateGroup1);
        menuData.setIcon(FULL_SCREEN_ICON);
        menuData.setMenuSubGroup(Integer.toString(vertexGroupingSubgroupOffset++));
        fullViewAction.setDescription("Displays this vertex in use the full Listing format");
        fullViewAction.setPopupMenuData(menuData);
        fullViewAction.setHelpLocation(new HelpLocation("FunctionGraphPlugin", "Vertex_Action_Full_View"));
        DockingAction xrefsAction = new DockingAction("Jump to XRef", this.owner){

            public void actionPerformed(ActionContext context) {
                FGActionManager.this.controller.showXRefsDialog();
            }

            public boolean isEnabledForContext(ActionContext context) {
                return context instanceof FunctionGraphValidGraphActionContextIf;
            }

            public boolean isAddToPopup(ActionContext context) {
                return context instanceof FunctionGraphValidGraphActionContextIf;
            }
        };
        menuData = new MenuData(new String[]{"Jump to XRef"}, popupMutateGroup1);
        menuData.setIcon(XREFS_ICON);
        menuData.setMenuSubGroup(Integer.toString(vertexGroupingSubgroupOffset++));
        xrefsAction.setPopupMenuData(menuData);
        xrefsAction.setHelpLocation(new HelpLocation("FunctionGraphPlugin", "Vertex_Action_XRefs"));
        DockingAction groupSelectedVertices = new DockingAction("Group Selected Vertices", this.owner){

            public void actionPerformed(ActionContext context) {
                FGActionManager.this.controller.groupSelectedVertices();
            }

            public boolean isEnabledForContext(ActionContext context) {
                if (!(context instanceof FunctionGraphValidGraphActionContextIf)) {
                    return false;
                }
                if (context instanceof FunctionGraphVertexLocationInFullViewModeActionContext) {
                    return false;
                }
                FunctionGraphValidGraphActionContextIf graphContext = (FunctionGraphValidGraphActionContextIf)context;
                return graphContext.getSelectedVertices().size() > 1;
            }

            public boolean isAddToPopup(ActionContext context) {
                if (!(context instanceof FunctionGraphValidGraphActionContextIf)) {
                    return false;
                }
                return !(context instanceof FunctionGraphVertexLocationInFullViewModeActionContext);
            }
        };
        menuData = new MenuData(new String[]{"Group Selected Vertices"}, popupMutateGroup2);
        menuData.setIcon(GROUP_ICON);
        menuData.setMenuSubGroup(Integer.toString(groupingSubgroupOffset++));
        groupSelectedVertices.setPopupMenuData(menuData);
        groupSelectedVertices.setHelpLocation(new HelpLocation("FunctionGraphPlugin", "Vertex_Grouping_Group_Selected_Popup"));
        DockingAction addSelectedVerticesToGroup = new DockingAction("Group Selected Vertices", this.owner){

            public void actionPerformed(ActionContext context) {
                FGActionManager.this.addToGroup(context);
            }

            public boolean isEnabledForContext(ActionContext context) {
                if (!(context instanceof FunctionGraphValidGraphActionContextIf)) {
                    return false;
                }
                if (context instanceof FunctionGraphVertexLocationInFullViewModeActionContext) {
                    return false;
                }
                FunctionGraphValidGraphActionContextIf graphContext = (FunctionGraphValidGraphActionContextIf)context;
                Set<FGVertex> vertices = graphContext.getSelectedVertices();
                if (vertices.size() <= 1) {
                    return false;
                }
                GroupedFunctionGraphVertex groupVertex = null;
                for (FGVertex vertex : vertices) {
                    if (!(vertex instanceof GroupedFunctionGraphVertex)) continue;
                    if (groupVertex != null) {
                        return false;
                    }
                    groupVertex = (GroupedFunctionGraphVertex)vertex;
                }
                return groupVertex != null;
            }

            public boolean isAddToPopup(ActionContext context) {
                if (!(context instanceof FunctionGraphValidGraphActionContextIf)) {
                    return false;
                }
                return !(context instanceof FunctionGraphVertexLocationInFullViewModeActionContext);
            }
        };
        menuData = new MenuData(new String[]{"Group Selected Vertices - Add to Group"}, popupMutateGroup2);
        menuData.setIcon(GROUP_ADD_ICON);
        menuData.setMenuSubGroup(Integer.toString(groupingSubgroupOffset++));
        addSelectedVerticesToGroup.setPopupMenuData(menuData);
        addSelectedVerticesToGroup.setHelpLocation(new HelpLocation("FunctionGraphPlugin", "Vertex_Grouping_Add_Selected_Vertices_To_Group"));
        DockingAction ungroupSelectedVertices = new DockingAction("Ungroup Selected Vertices", this.owner){

            public void actionPerformed(ActionContext context) {
                FunctionGraphValidGraphActionContextIf graphContext = (FunctionGraphValidGraphActionContextIf)context;
                Set<FGVertex> selectedVertices = graphContext.getSelectedVertices();
                FGActionManager.this.ungroupVertices(FGActionManager.this.getGroupVertices(selectedVertices));
            }

            public boolean isEnabledForContext(ActionContext context) {
                if (!(context instanceof FunctionGraphValidGraphActionContextIf)) {
                    return false;
                }
                if (context instanceof FunctionGraphVertexLocationInFullViewModeActionContext) {
                    return false;
                }
                FunctionGraphValidGraphActionContextIf graphContext = (FunctionGraphValidGraphActionContextIf)context;
                return FGActionManager.this.getGroupVertices(graphContext.getSelectedVertices()).size() > 0;
            }

            public boolean isAddToPopup(ActionContext context) {
                if (!(context instanceof FunctionGraphValidGraphActionContextIf)) {
                    return false;
                }
                return !(context instanceof FunctionGraphVertexLocationInFullViewModeActionContext);
            }
        };
        menuData = new MenuData(new String[]{"Ungroup Selected Vertices"}, popupMutateGroup2);
        menuData.setIcon(UNGROUP_ICON);
        menuData.setMenuSubGroup(Integer.toString(groupingSubgroupOffset++));
        ungroupSelectedVertices.setPopupMenuData(menuData);
        ungroupSelectedVertices.setHelpLocation(new HelpLocation("FunctionGraphPlugin", "Vertex_Grouping_Ungroup_Selected_Popup"));
        DockingAction removeFromGroup = new DockingAction("Remove From Group", this.owner){

            public void actionPerformed(ActionContext context) {
                FunctionGraphValidGraphActionContextIf graphContext = (FunctionGraphValidGraphActionContextIf)context;
                Set<FGVertex> selectedVertices = graphContext.getSelectedVertices();
                FGActionManager.this.removeFromHistory(selectedVertices);
            }

            public boolean isEnabledForContext(ActionContext context) {
                if (!(context instanceof FunctionGraphValidGraphActionContextIf)) {
                    return false;
                }
                if (context instanceof FunctionGraphVertexLocationInFullViewModeActionContext) {
                    return false;
                }
                FunctionGraphValidGraphActionContextIf graphContext = (FunctionGraphValidGraphActionContextIf)context;
                Set<FGVertex> selectedVertices = graphContext.getSelectedVertices();
                if (selectedVertices.isEmpty()) {
                    return false;
                }
                return FGActionManager.this.containsUncollapsedVertices(selectedVertices);
            }

            public boolean isAddToPopup(ActionContext context) {
                if (!(context instanceof FunctionGraphValidGraphActionContextIf)) {
                    return false;
                }
                return !(context instanceof FunctionGraphVertexLocationInFullViewModeActionContext);
            }
        };
        menuData = new MenuData(new String[]{"Remove From Group"}, popupMutateGroup2);
        menuData.setMenuSubGroup(Integer.toString(groupingSubgroupOffset++));
        removeFromGroup.setPopupMenuData(menuData);
        removeFromGroup.setHelpLocation(new HelpLocation("FunctionGraphPlugin", "Vertex_Grouping_Remove_From_Group"));
        DockingAction ungroupAllVertices = new DockingAction("Ungroup All Vertices", this.owner){

            public void actionPerformed(ActionContext context) {
                int choice = OptionDialog.showYesNoDialog((Component)FGActionManager.this.getCenterOverComponent(), (String)"Ungroup All Vertices?", (String)"Ungroup all grouped vertices?");
                if (choice != 1) {
                    return;
                }
                FGActionManager.this.controller.ungroupAllVertices();
            }

            public boolean isEnabledForContext(ActionContext context) {
                if (!(context instanceof FunctionGraphValidGraphActionContextIf)) {
                    return false;
                }
                if (context instanceof FunctionGraphVertexLocationInFullViewModeActionContext) {
                    return false;
                }
                return FGActionManager.this.getGroupVertices(FGActionManager.this.getAllVertices()).size() > 0;
            }

            public boolean isAddToPopup(ActionContext context) {
                if (!(context instanceof FunctionGraphValidGraphActionContextIf)) {
                    return false;
                }
                return !(context instanceof FunctionGraphVertexLocationInFullViewModeActionContext);
            }
        };
        menuData = new MenuData(new String[]{"Ungroup All Vertices"}, popupMutateGroup2);
        menuData.setMenuSubGroup(Integer.toString(groupingSubgroupOffset++));
        ungroupAllVertices.setPopupMenuData(menuData);
        ungroupAllVertices.setHelpLocation(new HelpLocation("FunctionGraphPlugin", "Vertex_Grouping_Ungroup_All_Popup"));
        String selectionMenuName = "Program Selection";
        DockingAction selectHoveredEdgesAction = new DockingAction("Make Selection From Hovered Edges", this.owner){

            public void actionPerformed(ActionContext context) {
                FunctionGraphVertexLocationContextIf fgContext = (FunctionGraphVertexLocationContextIf)context;
                VertexActionContextInfo vertexInfo = fgContext.getVertexInfo();
                AddressSet addresses = vertexInfo.getHoveredVertexAddresses();
                FGActionManager.this.makeSelectionFromAddresses(addresses);
            }

            public boolean isAddToPopup(ActionContext context) {
                return !(context instanceof FunctionGraphSatelliteViewerActionContext);
            }

            public boolean isEnabledForContext(ActionContext context) {
                if (!(context instanceof FunctionGraphVertexLocationContextIf)) {
                    return false;
                }
                FunctionGraphVertexLocationContextIf fgContext = (FunctionGraphVertexLocationContextIf)context;
                VertexActionContextInfo vertexInfo = fgContext.getVertexInfo();
                AddressSet addresses = vertexInfo.getHoveredVertexAddresses();
                return !addresses.isEmpty();
            }
        };
        selectHoveredEdgesAction.setPopupMenuData(new MenuData(new String[]{selectionMenuName, "From Hovered Edges"}, popupSelectionGroup2));
        selectHoveredEdgesAction.setHelpLocation(new HelpLocation("FunctionGraphPlugin", "Path_Selection"));
        DockingAction selectFocusedEdgesAction = new DockingAction("Make Selection From Focused Edges", this.owner){

            public void actionPerformed(ActionContext context) {
                FunctionGraphVertexLocationContextIf fgContext = (FunctionGraphVertexLocationContextIf)context;
                VertexActionContextInfo vertexInfo = fgContext.getVertexInfo();
                AddressSet addresses = vertexInfo.getSelectedVertexAddresses();
                FGActionManager.this.makeSelectionFromAddresses(addresses);
            }

            public boolean isAddToPopup(ActionContext context) {
                return !(context instanceof FunctionGraphSatelliteViewerActionContext);
            }

            public boolean isEnabledForContext(ActionContext context) {
                if (!(context instanceof FunctionGraphVertexLocationContextIf)) {
                    return false;
                }
                FunctionGraphVertexLocationContextIf fgContext = (FunctionGraphVertexLocationContextIf)context;
                VertexActionContextInfo vertexInfo = fgContext.getVertexInfo();
                AddressSet addresses = vertexInfo.getSelectedVertexAddresses();
                return !addresses.isEmpty();
            }
        };
        selectFocusedEdgesAction.setPopupMenuData(new MenuData(new String[]{selectionMenuName, "From Focused Edges"}, popupSelectionGroup2));
        selectFocusedEdgesAction.setHelpLocation(new HelpLocation("FunctionGraphPlugin", "Path_Selection"));
        DockingAction clearCurrentSelectionAction = new DockingAction("Clear Current Selection", this.owner){

            public void actionPerformed(ActionContext context) {
                FGActionManager.this.clearGraphSelection();
            }

            public boolean isAddToPopup(ActionContext context) {
                return context instanceof FunctionGraphValidGraphActionContextIf;
            }

            public boolean isEnabledForContext(ActionContext context) {
                ProgramSelection selection = FGActionManager.this.controller.getSelection();
                return selection != null && !selection.isEmpty();
            }
        };
        clearCurrentSelectionAction.setPopupMenuData(new MenuData(new String[]{selectionMenuName, "Clear Graph Selection"}, popupSelectionGroup3));
        clearCurrentSelectionAction.setHelpLocation(new HelpLocation("FunctionGraphPlugin", "Path_Selection"));
        DockingAction selectAllAction = new DockingAction("Select All Code Units", this.owner){

            public void actionPerformed(ActionContext context) {
                AddressSet addresses = null;
                Set<FGVertex> selectedVertices = FGActionManager.this.controller.getSelectedVertices();
                if (selectedVertices.size() > 0) {
                    addresses = FGActionManager.this.getAddressesForVertices(selectedVertices);
                } else {
                    FunctionGraph functionGraph;
                    FGData functionGraphData = FGActionManager.this.controller.getFunctionGraphData();
                    FunctionGraph graph = functionGraph = functionGraphData.getFunctionGraph();
                    addresses = FGActionManager.this.getAddressesForVertices(graph.getVertices());
                }
                FGActionManager.this.makeSelectionFromAddresses(addresses);
            }

            public boolean isValidContext(ActionContext context) {
                return context instanceof FunctionGraphValidGraphActionContextIf;
            }

            public boolean isEnabledForContext(ActionContext context) {
                return this.isValidContext(context);
            }

            public boolean isAddToPopup(ActionContext context) {
                return this.isValidContext(context);
            }
        };
        selectAllAction.setKeyBindingData(new KeyBindingData(65, DockingUtils.CONTROL_KEY_MODIFIER_MASK));
        selectAllAction.setPopupMenuData(new MenuData(new String[]{selectionMenuName, "Select All Code Units"}, popupSelectionGroup3));
        selectAllAction.setHelpLocation(new HelpLocation("FunctionGraphPlugin", "Code_Unit_Selection"));
        this.addLocalAction(chooseFormatsAction);
        this.addLocalAction(homeAction);
        this.addLocalAction(zoomInAction);
        this.addLocalAction(zoomOutAction);
        this.addLocalAction(zoomToVertexAction);
        this.addLocalAction(zoomToWindowAction);
        this.addLocalAction(editLabelAction);
        this.addLocalAction(fullViewAction);
        this.addLocalAction(xrefsAction);
        this.addLocalAction(groupSelectedVertices);
        this.addLocalAction(addSelectedVerticesToGroup);
        this.addLocalAction(removeFromGroup);
        this.addLocalAction(ungroupSelectedVertices);
        this.addLocalAction(ungroupAllVertices);
        this.addLocalAction((DockingAction)this.togglePopups);
        this.addLocalAction(selectAllAction);
        this.addLocalAction(selectHoveredEdgesAction);
        this.addLocalAction(selectFocusedEdgesAction);
        this.addLocalAction(clearCurrentSelectionAction);
        this.tool.setMenuGroup(new String[]{selectionMenuName}, popupSelectionGroup);
    }

    private void addLayoutAction(String group) {
        HelpLocation layoutHelpLocation = new HelpLocation("FunctionGraphPlugin", "Function_Graph_Action_Layout");
        this.layoutAction = new MultiStateDockingAction<FGLayoutProvider>("Relayout Graph", this.owner, KeyBindingType.SHARED){

            public void actionPerformed(ActionContext context) {
                FGLayoutProvider currentUserData = (FGLayoutProvider)this.getCurrentUserData();
                FGActionManager.this.changeLayout(currentUserData);
            }

            public void actionStateChanged(ActionState<FGLayoutProvider> newActionState, EventTrigger trigger) {
                FGActionManager.this.changeLayout((FGLayoutProvider)newActionState.getUserData());
                if (trigger != EventTrigger.API_CALL) {
                    FGActionManager.this.tool.setConfigChanged(true);
                }
            }
        };
        this.layoutAction.setGroup(group);
        this.layoutAction.setSubGroup("2");
        this.layoutAction.setHelpLocation(layoutHelpLocation);
        this.layoutAction.setDefaultIcon((Icon)new GIcon("icon.plugin.functiongraph.action.viewer.layout"));
        List<ActionState<FGLayoutProvider>> actionStates = this.loadActionStatesForLayoutProviders();
        for (ActionState<FGLayoutProvider> actionState : actionStates) {
            this.layoutAction.addActionState(actionState);
        }
        this.addLocalAction((DockingAction)this.layoutAction);
    }

    private void changeLayout(FGLayoutProvider layout) {
        this.controller.changeLayout(layout);
    }

    private List<ActionState<FGLayoutProvider>> loadActionStatesForLayoutProviders() {
        FgEnv env = this.controller.getEnv();
        List<FGLayoutProvider> layoutInstances = env.getLayoutProviders();
        return this.createActionStates(layoutInstances);
    }

    private List<ActionState<FGLayoutProvider>> createActionStates(List<FGLayoutProvider> layoutProviders) {
        ArrayList<ActionState<FGLayoutProvider>> list = new ArrayList<ActionState<FGLayoutProvider>>();
        for (FGLayoutProvider layout : layoutProviders) {
            ActionState layoutState = new ActionState(layout.getLayoutName(), layout.getActionIcon(), (Object)layout);
            layoutState.setHelpLocation(layout.getHelpLocation());
            list.add((ActionState<FGLayoutProvider>)layoutState);
        }
        return list;
    }

    private void setLayoutActionStateByClassName(String layoutClassName, String layoutName) {
        if (layoutName == null) {
            return;
        }
        List states = this.layoutAction.getAllActionStates();
        for (ActionState state : states) {
            FGLayoutProvider layoutProvider = (FGLayoutProvider)state.getUserData();
            String stateLayoutName = layoutProvider.getLayoutName();
            if (!stateLayoutName.equals(layoutName)) continue;
            this.layoutAction.setCurrentActionState(state);
            return;
        }
    }

    private void addVertexHoverModeAction(String group) {
        GIcon pathsToVertexIcon = new GIcon("icon.plugin.functiongraph.action.viewer.vertex.hover.paths.to.vertex");
        GIcon pathsFromVertexIcon = new GIcon("icon.plugin.functiongraph.action.viewer.vertex.hover.paths.from.vertex");
        GIcon pathsFromToVertexIcon = new GIcon("icon.plugin.functiongraph.action.viewer.vertex.hover.paths.from.to.vertex");
        GIcon pathsIcon = new GIcon("icon.plugin.functiongraph.action.viewer.vertex.hover.paths.all");
        GIcon cyclesIcon = new GIcon("icon.plugin.functiongraph.action.viewer.vertex.hover.cycles");
        GIcon forwardScopedIcon = new GIcon("icon.plugin.functiongraph.action.viewer.vertex.hover.scoped.flow.forward");
        GIcon reverseScopedIcon = new GIcon("icon.plugin.functiongraph.action.viewer.vertex.hover.scoped.flow.reverse");
        GIcon nothingIcon = new GIcon("icon.plugin.functiongraph.action.viewer.vertex.hover.off");
        HelpLocation pathHelpLocation = new HelpLocation("FunctionGraphPlugin", "Path_Highlight_Actions");
        ActionState pathsToVertexState = new ActionState("Show Paths To Block", (Icon)pathsToVertexIcon, (Object)EdgeDisplayType.PathsToVertex);
        pathsToVertexState.setHelpLocation(pathHelpLocation);
        ActionState pathsFromVertexState = new ActionState("Show Paths From Block", (Icon)pathsFromVertexIcon, (Object)EdgeDisplayType.PathsFromVertex);
        pathsFromVertexState.setHelpLocation(pathHelpLocation);
        ActionState pathsFromToVertexState = new ActionState("Show Paths To/From Block", (Icon)pathsFromToVertexIcon, (Object)EdgeDisplayType.PathsFromToVertex);
        pathsFromToVertexState.setHelpLocation(pathHelpLocation);
        ActionState cyclesState = new ActionState("Show Loops Containing Block", (Icon)cyclesIcon, (Object)EdgeDisplayType.Cycles);
        cyclesState.setHelpLocation(pathHelpLocation);
        ActionState pathsState = new ActionState("Show Paths From Focus to Hover", (Icon)pathsIcon, (Object)EdgeDisplayType.PathsFromVertexToVertex);
        pathsState.setHelpLocation(pathHelpLocation);
        ActionState pathsForwardScopedFlow = new ActionState("Show Scoped Flow From Block", (Icon)forwardScopedIcon, (Object)EdgeDisplayType.ScopedFlowsFromVertex);
        pathsForwardScopedFlow.setHelpLocation(pathHelpLocation);
        ActionState pathsReverseScopedFlow = new ActionState("Show Scoped Flow To Block", (Icon)reverseScopedIcon, (Object)EdgeDisplayType.ScopedFlowsToVertex);
        pathsReverseScopedFlow.setHelpLocation(pathHelpLocation);
        ActionState offState = new ActionState("Off", (Icon)nothingIcon, (Object)EdgeDisplayType.Off);
        offState.setHelpLocation(pathHelpLocation);
        this.vertexHoverModeAction = new MultiStateDockingAction<EdgeDisplayType>("Block Hover Mode", this.owner){

            public void actionStateChanged(ActionState<EdgeDisplayType> newActionState, EventTrigger trigger) {
                EdgeDisplayType displayType = (EdgeDisplayType)((Object)newActionState.getUserData());
                FGActionManager.this.controller.setVertexHoverPathHighlightMode(displayType.getAsPathHighlightHoverMode());
                FGActionManager.this.tool.setConfigChanged(true);
            }
        };
        this.vertexHoverModeAction.setGroup(group);
        this.vertexHoverModeAction.setHelpLocation(pathHelpLocation);
        this.vertexHoverModeAction.addActionState(offState);
        this.vertexHoverModeAction.addActionState(pathsForwardScopedFlow);
        this.vertexHoverModeAction.addActionState(pathsReverseScopedFlow);
        this.vertexHoverModeAction.addActionState(pathsFromToVertexState);
        this.vertexHoverModeAction.addActionState(pathsFromVertexState);
        this.vertexHoverModeAction.addActionState(pathsToVertexState);
        this.vertexHoverModeAction.addActionState(cyclesState);
        this.vertexHoverModeAction.addActionState(pathsState);
        this.vertexHoverModeAction.setCurrentActionState(pathsForwardScopedFlow);
        this.addLocalAction((DockingAction)this.vertexHoverModeAction);
    }

    private void addVertexSelectedModeAction(String group) {
        GIcon pathsToVertexIcon = new GIcon("icon.plugin.functiongraph.action.viewer.vertex.hover.paths.to.vertex");
        GIcon pathsFromVertexIcon = new GIcon("icon.plugin.functiongraph.action.viewer.vertex.hover.paths.from.vertex");
        GIcon pathsFromToVertexIcon = new GIcon("icon.plugin.functiongraph.action.viewer.vertex.hover.paths.from.to.vertex");
        GIcon cyclesIcon = new GIcon("icon.plugin.functiongraph.action.viewer.vertex.hover.cycles");
        GIcon allCyclesIcon = new GIcon("icon.plugin.functiongraph.action.viewer.vertex.hover.cycles.all");
        GIcon forwardScopedIcon = new GIcon("icon.plugin.functiongraph.action.viewer.vertex.hover.scoped.flow.forward");
        GIcon reverseScopedIcon = new GIcon("icon.plugin.functiongraph.action.viewer.vertex.hover.scoped.flow.reverse");
        GIcon nothingIcon = new GIcon("icon.plugin.functiongraph.action.viewer.vertex.hover.off");
        HelpLocation pathHelpLocation = new HelpLocation("FunctionGraphPlugin", "Path_Highlight_Actions");
        ActionState pathsToVertexState = new ActionState("Show Paths To Block", (Icon)pathsToVertexIcon, (Object)EdgeDisplayType.PathsToVertex);
        pathsToVertexState.setHelpLocation(pathHelpLocation);
        ActionState pathsFromVertexState = new ActionState("Show Paths From Block", (Icon)pathsFromVertexIcon, (Object)EdgeDisplayType.PathsFromVertex);
        pathsFromVertexState.setHelpLocation(pathHelpLocation);
        ActionState pathsFromToVertexState = new ActionState("Show Paths To/From Block", (Icon)pathsFromToVertexIcon, (Object)EdgeDisplayType.PathsFromToVertex);
        pathsFromToVertexState.setHelpLocation(pathHelpLocation);
        ActionState cyclesState = new ActionState("Show Loops Containing Block", (Icon)cyclesIcon, (Object)EdgeDisplayType.Cycles);
        cyclesState.setHelpLocation(pathHelpLocation);
        ActionState allCyclesState = new ActionState("Show All Loops In Function", (Icon)allCyclesIcon, (Object)EdgeDisplayType.AllCycles);
        allCyclesState.setHelpLocation(pathHelpLocation);
        ActionState pathsForwardScopedFlow = new ActionState("Show Scoped Flow From Block", (Icon)forwardScopedIcon, (Object)EdgeDisplayType.ScopedFlowsFromVertex);
        pathsForwardScopedFlow.setHelpLocation(pathHelpLocation);
        ActionState pathsReverseScopedFlow = new ActionState("Show Scoped Flow To Block", (Icon)reverseScopedIcon, (Object)EdgeDisplayType.ScopedFlowsToVertex);
        pathsReverseScopedFlow.setHelpLocation(pathHelpLocation);
        ActionState offState = new ActionState("Off", (Icon)nothingIcon, (Object)EdgeDisplayType.Off);
        offState.setHelpLocation(pathHelpLocation);
        this.vertexFocusModeAction = new MultiStateDockingAction<EdgeDisplayType>("Block Focus Mode", this.owner){

            public void actionStateChanged(ActionState<EdgeDisplayType> newActionState, EventTrigger trigger) {
                EdgeDisplayType displayType = (EdgeDisplayType)((Object)newActionState.getUserData());
                FGActionManager.this.controller.setVertexFocusPathHighlightMode(displayType.getAsPathHighlightHoverMode());
                FGActionManager.this.tool.setConfigChanged(true);
            }
        };
        this.vertexFocusModeAction.setGroup(group);
        this.vertexFocusModeAction.setHelpLocation(pathHelpLocation);
        this.vertexFocusModeAction.addActionState(offState);
        this.vertexFocusModeAction.addActionState(pathsForwardScopedFlow);
        this.vertexFocusModeAction.addActionState(pathsReverseScopedFlow);
        this.vertexFocusModeAction.addActionState(pathsFromToVertexState);
        this.vertexFocusModeAction.addActionState(pathsFromVertexState);
        this.vertexFocusModeAction.addActionState(pathsToVertexState);
        this.vertexFocusModeAction.addActionState(cyclesState);
        this.vertexFocusModeAction.addActionState(allCyclesState);
        this.vertexFocusModeAction.setCurrentActionState(allCyclesState);
        this.addLocalAction((DockingAction)this.vertexFocusModeAction);
    }

    private void clearGraphSelection() {
        FGData functionGraphData = this.controller.getFunctionGraphData();
        Function function = functionGraphData.getFunction();
        AddressSetView functionBody = function.getBody();
        ProgramSelection selection = this.controller.getSelection();
        AddressSet subtraction = selection.subtract(functionBody);
        ProgramSelection programSelectionWithoutGraphBody = new ProgramSelection((AddressSetView)subtraction);
        FgEnv env = this.controller.getEnv();
        Program program = env.getProgram();
        this.tool.firePluginEvent((PluginEvent)new ProgramSelectionPluginEvent("Spoof!", programSelectionWithoutGraphBody, program));
    }

    private Set<FGVertex> getAllVertices() {
        FunctionGraph functionGraph;
        FGData functionGraphData = this.controller.getFunctionGraphData();
        FunctionGraph graph = functionGraph = functionGraphData.getFunctionGraph();
        return new HashSet<FGVertex>(graph.getVertices());
    }

    private Set<GroupedFunctionGraphVertex> getGroupVertices(Set<FGVertex> vertices) {
        HashSet<GroupedFunctionGraphVertex> groupVertices = new HashSet<GroupedFunctionGraphVertex>();
        for (FGVertex vertex : vertices) {
            if (!(vertex instanceof GroupedFunctionGraphVertex)) continue;
            groupVertices.add((GroupedFunctionGraphVertex)vertex);
        }
        return groupVertices;
    }

    private boolean containsUncollapsedVertices(Set<FGVertex> selectedVertices) {
        for (FGVertex vertex : selectedVertices) {
            if (!vertex.isUncollapsedGroupMember()) continue;
            return true;
        }
        return false;
    }

    private void addToGroup(ActionContext context) {
        FunctionGraphValidGraphActionContextIf graphContext = (FunctionGraphValidGraphActionContextIf)context;
        GroupedFunctionGraphVertex groupVertex = null;
        HashSet<FGVertex> vertices = new HashSet<FGVertex>(graphContext.getSelectedVertices());
        for (FGVertex vertex : vertices) {
            if (!(vertex instanceof GroupedFunctionGraphVertex)) continue;
            groupVertex = (GroupedFunctionGraphVertex)vertex;
        }
        this.controller.addToGroup(groupVertex, vertices);
    }

    private void showFormatChooser() {
        this.controller.showFormatChooser();
    }

    private void goHome() {
        Function function = this.controller.getGraphedFunction();
        FgEnv env = this.controller.getEnv();
        Program program = env.getProgram();
        ProgramLocation homeLocation = new ProgramLocation(program, function.getEntryPoint());
        this.controller.display(program, homeLocation);
    }

    private AddressSet getAddressesForVertices(Collection<FGVertex> vertices) {
        AddressSet addresses = new AddressSet();
        for (FGVertex vertex : vertices) {
            addresses.add(vertex.getAddresses());
        }
        return addresses;
    }

    private void makeSelectionFromAddresses(AddressSet addresses) {
        ProgramSelection selection = new ProgramSelection((AddressSetView)addresses);
        FgEnv env = this.controller.getEnv();
        Program program = env.getProgram();
        this.tool.firePluginEvent((PluginEvent)new ProgramSelectionPluginEvent("Spoof!", selection, program));
    }

    private void ungroupVertices(Set<GroupedFunctionGraphVertex> groupVertices) {
        int size = groupVertices.size();
        if (size == 0) {
            return;
        }
        Object vertexString = size == 1 ? "1 group vertex" : size + " group vertices";
        int choice = OptionDialog.showYesNoDialog((Component)this.getCenterOverComponent(), (String)"Ungroup Vertices?", (String)("Ungroup " + (String)vertexString + "?"));
        if (choice != 1) {
            return;
        }
        for (GroupedFunctionGraphVertex groupVertex : groupVertices) {
            this.controller.ungroupVertex(groupVertex);
        }
    }

    private void removeFromHistory(Set<FGVertex> vertices) {
        FGData functionGraphData = this.controller.getFunctionGraphData();
        FunctionGraph functionGraph = functionGraphData.getFunctionGraph();
        for (FGVertex vertex : vertices) {
            functionGraph.removeFromGroupHistory(vertex);
        }
    }

    void setEdgeFocusMode(EdgeDisplayType edgeDisplayType) {
        this.vertexFocusModeAction.setCurrentActionStateByUserData((Object)edgeDisplayType);
    }

    void setEdgeHoverMode(EdgeDisplayType edgeDisplayType) {
        this.vertexHoverModeAction.setCurrentActionStateByUserData((Object)edgeDisplayType);
    }

    EdgeDisplayType getCurrentFocusMode() {
        return (EdgeDisplayType)((Object)this.vertexFocusModeAction.getCurrentUserData());
    }

    EdgeDisplayType getCurrentHoverMode() {
        return (EdgeDisplayType)((Object)this.vertexHoverModeAction.getCurrentUserData());
    }

    void popupVisibilityChanged(boolean visible) {
        this.togglePopups.setSelected(visible);
    }

    void setCurrentActionState(ActionState<FGLayoutProvider> state) {
        this.layoutAction.setCurrentActionState(state);
    }

    void setLayouts(List<FGLayoutProvider> layouts) {
        List<ActionState<FGLayoutProvider>> states = this.createActionStates(layouts);
        this.layoutAction.setActionStates(states);
    }

    ActionState<FGLayoutProvider> getCurrentLayoutState() {
        return this.layoutAction.getCurrentState();
    }

    void readConfigState(SaveState saveState) {
        EdgeDisplayType hoverState = (EdgeDisplayType)saveState.getEnum(EDGE_HOVER_HIGHLIGHT, (Enum)((EdgeDisplayType)((Object)this.vertexHoverModeAction.getCurrentState().getUserData())));
        this.vertexHoverModeAction.setCurrentActionStateByUserData((Object)hoverState);
        EdgeDisplayType selectedState = (EdgeDisplayType)saveState.getEnum(EDGE_SELECTION_HIGHLIGHT, (Enum)((EdgeDisplayType)((Object)this.vertexFocusModeAction.getCurrentState().getUserData())));
        this.vertexFocusModeAction.setCurrentActionStateByUserData((Object)selectedState);
        FGLayoutProvider layoutProvider = (FGLayoutProvider)this.layoutAction.getCurrentUserData();
        SaveState layoutState = saveState.getSaveState(COMPLEX_LAYOUT_NAME);
        if (layoutState != null) {
            String layoutName = layoutState.getString(LAYOUT_NAME, layoutProvider.getLayoutName());
            String layoutClassName = layoutState.getString(LAYOUT_CLASS_NAME, layoutProvider.getClass().getName());
            this.setLayoutActionStateByClassName(layoutClassName, layoutName);
        }
    }

    void writeConfigState(SaveState saveState) {
        saveState.putEnum(EDGE_HOVER_HIGHLIGHT, (Enum)this.vertexHoverModeAction.getCurrentUserData());
        saveState.putEnum(EDGE_SELECTION_HIGHLIGHT, (Enum)this.vertexFocusModeAction.getCurrentUserData());
        FGLayoutProvider layoutProvider = (FGLayoutProvider)this.layoutAction.getCurrentUserData();
        SaveState layoutState = new SaveState(COMPLEX_LAYOUT_NAME);
        String layoutName = layoutProvider.getLayoutName();
        layoutState.putString(LAYOUT_NAME, layoutName);
        layoutState.putString(LAYOUT_CLASS_NAME, layoutProvider.getClass().getName());
        saveState.putSaveState(COMPLEX_LAYOUT_NAME, layoutState);
    }
}

