/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.byteviewer;

import docking.widgets.fieldpanel.support.BackgroundColorModel;
import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.app.plugin.core.byteviewer.ByteViewerComponent;
import ghidra.app.plugin.core.byteviewer.ByteViewerComponentProvider;
import ghidra.app.plugin.core.byteviewer.ByteViewerPanel;
import java.awt.Color;
import java.math.BigInteger;

public class ByteViewerBGColorModel
implements BackgroundColorModel {
    private Color bgColor = ByteViewerComponentProvider.BG_COLOR;
    private ByteViewerPanel panel;

    public ByteViewerBGColorModel(ByteViewerPanel panel) {
        this.panel = panel;
    }

    public Color getBackgroundColor(BigInteger index) {
        if (!this.panel.isHighlightCurrentLine()) {
            return this.bgColor;
        }
        ByteViewerComponent c = this.panel.getCurrentComponent();
        FieldLocation loc = c.getCursorLocation();
        BigInteger cursorIndex = loc.getIndex();
        if (index.equals(cursorIndex)) {
            return ByteViewerComponentProvider.CURRENT_LINE_COLOR;
        }
        return this.bgColor;
    }

    public Color getDefaultBackgroundColor() {
        return this.bgColor;
    }

    public void setDefaultBackgroundColor(Color c) {
        this.bgColor = c;
    }
}

