/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.byteviewer;

import docking.ActionContext;
import docking.DockingUtils;
import docking.Tool;
import docking.action.DockingActionIf;
import docking.actions.PopupActionProvider;
import docking.widgets.EventTrigger;
import docking.widgets.fieldpanel.FieldPanel;
import docking.widgets.fieldpanel.Layout;
import docking.widgets.fieldpanel.LayoutModel;
import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.listener.FieldInputListener;
import docking.widgets.fieldpanel.listener.FieldLocationListener;
import docking.widgets.fieldpanel.listener.FieldMouseListener;
import docking.widgets.fieldpanel.listener.FieldSelectionListener;
import docking.widgets.fieldpanel.support.FieldLocation;
import docking.widgets.fieldpanel.support.FieldRange;
import docking.widgets.fieldpanel.support.FieldSelection;
import docking.widgets.fieldpanel.support.FieldSelectionHelper;
import docking.widgets.fieldpanel.support.HoverProvider;
import docking.widgets.fieldpanel.support.ViewerPosition;
import generic.theme.Gui;
import ghidra.app.plugin.core.byteviewer.ByteField;
import ghidra.app.plugin.core.byteviewer.ByteViewerBGColorModel;
import ghidra.app.plugin.core.byteviewer.ByteViewerComponentNamer;
import ghidra.app.plugin.core.byteviewer.ByteViewerComponentProvider;
import ghidra.app.plugin.core.byteviewer.ByteViewerHighlighter;
import ghidra.app.plugin.core.byteviewer.ByteViewerLayoutModel;
import ghidra.app.plugin.core.byteviewer.ByteViewerPanel;
import ghidra.app.plugin.core.byteviewer.FieldFactory;
import ghidra.app.plugin.core.byteviewer.IndexMap;
import ghidra.app.plugin.core.byteviewer.MemoryByteBlock;
import ghidra.app.plugin.core.byteviewer.ProgramByteBlockSet;
import ghidra.app.plugin.core.format.ByteBlock;
import ghidra.app.plugin.core.format.ByteBlockAccessException;
import ghidra.app.plugin.core.format.ByteBlockInfo;
import ghidra.app.plugin.core.format.ByteBlockRange;
import ghidra.app.plugin.core.format.ByteBlockSelection;
import ghidra.app.plugin.core.format.ByteBlockSet;
import ghidra.app.plugin.core.format.CursorWidthDataFormatModel;
import ghidra.app.plugin.core.format.DataFormatModel;
import ghidra.app.plugin.core.format.IndexedByteBlockInfo;
import ghidra.app.plugin.core.format.MutableDataFormatModel;
import ghidra.app.plugin.core.format.TooltipDataFormatModel;
import ghidra.app.plugin.core.hover.AbstractHoverProvider;
import ghidra.app.services.HoverService;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.util.Msg;
import ghidra.util.Swing;
import help.Help;
import help.HelpService;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigInteger;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JToolTip;

public class ByteViewerComponent
extends FieldPanel
implements FieldMouseListener,
FieldLocationListener,
FieldSelectionListener,
FieldInputListener,
PopupActionProvider,
ByteViewerComponentNamer {
    private ByteViewerPanel panel;
    private DataFormatModel model;
    private int bytesPerLine;
    private FieldFactory[] fieldFactories;
    private FontMetrics fm;
    private int charWidth;
    private IndexMap indexMap;
    private ProgramByteBlockSet blockSet;
    private ByteViewerLayoutModel layoutModel;
    private boolean doingRefresh;
    private boolean doingEdit;
    private boolean updatingIndexMap;
    private boolean indexUpdate = true;
    private FieldLocation lastFieldLoc;
    private ByteViewerHighlighter highlightProvider = new ByteViewerHighlighter();
    private FieldSelectionListener liveSelectionListener = (selection, trigger) -> {
        ByteBlockSelection sel = this.processFieldSelection(selection);
        this.panel.updateLiveSelection(this, sel);
    };
    private ByteViewerHoverProvider byteViewerHoverProvider;

    protected ByteViewerComponent(ByteViewerPanel panel, ByteViewerLayoutModel layoutModel, DataFormatModel model, int bytesPerLine) {
        super((LayoutModel)layoutModel, "Byte Viewer");
        this.setFieldDescriptionProvider((l, f) -> this.getFieldDescription(l, f));
        this.panel = panel;
        this.model = model;
        this.bytesPerLine = bytesPerLine;
        this.layoutModel = layoutModel;
        this.setName(model.getName());
        this.getAccessibleContext().setAccessibleName("Byte Viewer " + model.getName());
        this.initialize();
    }

    private boolean isEditMode() {
        return this.panel.getEditMode();
    }

    private boolean isActiveComponent() {
        return this.panel.getCurrentComponent() == this;
    }

    private String getFieldDescription(FieldLocation fieldLoc, Field field) {
        if (field == null) {
            return null;
        }
        IndexedByteBlockInfo info = this.indexMap.getBlockInfo(fieldLoc.getIndex(), fieldLoc.getFieldNum());
        if (info != null) {
            String modelName = this.model.getName();
            String location = this.getAccessibleLocationInfo(info.getBlock(), info.getOffset());
            return modelName + " format at " + location;
        }
        return null;
    }

    private String getAccessibleLocationInfo(ByteBlock block, BigInteger offset) {
        if (block instanceof MemoryByteBlock) {
            MemoryByteBlock memBlock = (MemoryByteBlock)block;
            Address address = memBlock.getAddress(offset);
            return address.toString(address.getAddressSpace().showSpaceName(), 1);
        }
        return block.getLocationRepresentation(offset);
    }

    @Override
    public String getByteViewerComponentName() {
        return this.model.getDescriptiveName();
    }

    public List<DockingActionIf> getPopupActions(Tool tool, ActionContext context) {
        DataFormatModel dataFormatModel = this.model;
        if (dataFormatModel instanceof PopupActionProvider) {
            PopupActionProvider popupProvider = (PopupActionProvider)dataFormatModel;
            return popupProvider.getPopupActions(tool, context);
        }
        return null;
    }

    public void buttonPressed(FieldLocation fieldLocation, Field field, MouseEvent mouseEvent) {
        if (fieldLocation == null || field == null) {
            return;
        }
        if (!(field instanceof ByteField)) {
            return;
        }
        if (mouseEvent.getButton() == this.panel.getHighlightButton()) {
            String text = field.getText();
            if (text.equals(this.highlightProvider.getText())) {
                this.highlightProvider.setText(null);
            } else {
                this.highlightProvider.setText(text);
            }
            this.repaint();
        }
        if (DockingUtils.isControlModifier((MouseEvent)mouseEvent) && mouseEvent.isShiftDown() && mouseEvent.getButton() == 1) {
            this.fieldLocationChanged(fieldLocation, field, true, false);
        } else if (!this.isActiveComponent()) {
            this.fieldLocationChanged(fieldLocation, field, false, true);
        }
    }

    public void fieldLocationChanged(FieldLocation loc, Field field, EventTrigger trigger) {
        this.fieldLocationChanged(loc, field, false, trigger == EventTrigger.GUI_ACTION);
    }

    private void fieldLocationChanged(FieldLocation loc, Field field, boolean isAltDown, boolean setCurrentView) {
        IndexedByteBlockInfo info;
        if (this.doingRefresh || this.doingEdit || loc == null || this.indexMap == null || field == null || this.updatingIndexMap) {
            return;
        }
        if (this.indexMap.isBlockSeparatorIndex(loc.getIndex())) {
            this.panel.setCurrentNonMappedIndex(loc.getIndex(), this);
        }
        if (this.lastFieldLoc == null || !loc.getIndex().equals(this.lastFieldLoc.getIndex())) {
            this.panel.updateIndexColumnCurrentLine();
        }
        if (setCurrentView) {
            this.panel.setCurrentView(this);
        }
        if (!(field instanceof ByteField) || !isAltDown && loc.equals((Object)this.lastFieldLoc)) {
            return;
        }
        Swing.runLater(() -> this.updateColors());
        this.lastFieldLoc = loc;
        ByteField bf = (ByteField)field;
        int fieldOffset = bf.getFieldOffset();
        BigInteger index = loc.getIndex();
        int pos = loc.getCol();
        if (pos >= this.model.getDataUnitSymbolSize()) {
            pos = this.model.getDataUnitSymbolSize() - 1;
        }
        if ((info = this.indexMap.getBlockInfo(index, fieldOffset)) == null) {
            return;
        }
        ByteBlock block = info.getBlock();
        BigInteger offset = info.getOffset();
        int byteOffset = this.model.getByteOffset(info.getBlock(), pos);
        offset = offset.add(BigInteger.valueOf(byteOffset));
        this.panel.setInsertionField(this, block, offset, index, loc.getCol(), isAltDown);
    }

    public void selectionChanged(FieldSelection selection, EventTrigger trigger) {
        if (this.blockSet == null || this.doingRefresh) {
            return;
        }
        ByteBlockSelection sel = this.processFieldSelection(selection);
        this.panel.updateSelection(this, sel);
        this.setViewerSelection(sel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keyPressed(KeyEvent ev, BigInteger index, int fieldNum, int row, int col, Field field) {
        ByteBlock block;
        this.panel.setStatusMessage("");
        if (!this.isEditMode()) {
            return;
        }
        if (DockingUtils.isControlModifier((KeyEvent)ev)) {
            return;
        }
        if (ev.getKeyCode() == 8) {
            this.cursorLeft();
            ev.consume();
            return;
        }
        DataFormatModel dataFormatModel = this.model;
        if (!(dataFormatModel instanceof MutableDataFormatModel)) {
            this.panel.setStatusMessage(this.model.getName() + " view is not editable");
            ev.consume();
            return;
        }
        MutableDataFormatModel mutableModel = (MutableDataFormatModel)dataFormatModel;
        char c = ev.getKeyChar();
        if (c < ' ' || c > '\u007f') {
            ev.consume();
            this.getToolkit().beep();
            return;
        }
        if (field == null || !(field instanceof ByteField)) {
            ev.consume();
            this.getToolkit().beep();
            return;
        }
        int fieldOffset = ((ByteField)field).getFieldOffset();
        IndexedByteBlockInfo info = this.indexMap.getBlockInfo(index, fieldOffset);
        if (info == null) {
            ev.consume();
            this.getToolkit().beep();
            return;
        }
        if (col >= this.model.getDataUnitSymbolSize()) {
            col = this.model.getDataUnitSymbolSize() - 1;
        }
        if (!(block = info.getBlock()).isEditable()) {
            this.panel.setStatusMessage("Block is not writable!");
            this.getToolkit().beep();
            ev.consume();
            return;
        }
        BigInteger offset = info.getOffset();
        int transactionID = this.blockSet.startTransaction();
        if (transactionID < 0) {
            ev.consume();
            this.getToolkit().beep();
            return;
        }
        try {
            byte[] oldValue = this.getByteValue(block, offset);
            boolean success = mutableModel.replaceValue(block, offset, col, c);
            if (success) {
                byte[] newValue = this.getByteValue(block, offset);
                this.blockSet.notifyByteEditing(block, offset, oldValue, newValue);
                this.cursorRight();
                this.doingEdit = true;
                this.layoutModel.dataChanged(index, index);
            } else {
                this.panel.setStatusMessage("Invalid char '" + c + "' in the " + this.model.getName() + " view");
                this.getToolkit().beep();
            }
        }
        catch (ByteBlockAccessException | NumberFormatException exc) {
            this.panel.setStatusMessage("Editing not allowed: " + ((Throwable)exc).getMessage());
            this.getToolkit().beep();
        }
        catch (AddressOutOfBoundsException | IndexOutOfBoundsException e) {
            this.getToolkit().beep();
        }
        catch (Throwable t) {
            Msg.showError((Object)this, null, (String)"Error", (Object)"Error editing memory", (Throwable)t);
        }
        finally {
            ev.consume();
            this.doingEdit = false;
            this.blockSet.endTransaction(transactionID, true);
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.fm = this.getFontMetrics(this.getFont());
        if (this.model != null && this.layoutModel != null) {
            this.invalidateModelFields();
        }
    }

    void invalidateModelFields() {
        int n;
        DataFormatModel dataFormatModel = this.model;
        if (dataFormatModel instanceof CursorWidthDataFormatModel) {
            CursorWidthDataFormatModel cwdfm = (CursorWidthDataFormatModel)dataFormatModel;
            n = cwdfm.getCursorWidth(this.fm);
        } else {
            n = this.fm.charWidth('W');
        }
        this.charWidth = n;
        this.createFields();
        this.layoutModel.setIndexMap(this.indexMap);
    }

    private byte[] getByteValue(ByteBlock block, BigInteger offset) {
        byte[] b = new byte[this.model.getUnitByteSize()];
        try {
            for (int i = 0; i < b.length; ++i) {
                b[i] = block.getByte(offset.add(BigInteger.valueOf(i)));
            }
            return b;
        }
        catch (ByteBlockAccessException byteBlockAccessException) {
            return null;
        }
    }

    void addListeners() {
        this.addFieldLocationListener(this);
        this.addFieldSelectionListener(this);
        this.addLiveFieldSelectionListener(this.liveSelectionListener);
        this.addFieldInputListener(this);
        this.addFieldMouseListener(this);
    }

    void setIndexMap(IndexMap map) {
        ProgramByteBlockSet pbbs;
        ByteBlockSet byteBlockSet;
        this.updatingIndexMap = true;
        this.indexMap = map;
        if (map != null) {
            this.bytesPerLine = map.getBytesPerLine();
            this.createFields();
        }
        this.blockSet = (byteBlockSet = this.indexMap.getByteBlockSet()) instanceof ProgramByteBlockSet ? (pbbs = (ProgramByteBlockSet)byteBlockSet) : null;
        this.byteViewerHoverProvider.setProgram(this.blockSet != null && this.blockSet.isValid() ? this.blockSet.program : null);
        if (this.indexUpdate) {
            this.layoutModel.setIndexMap(this.indexMap);
        }
        this.updatingIndexMap = false;
    }

    protected IndexMap getIndexMap() {
        return this.indexMap;
    }

    protected ProgramByteBlockSet getBlockSet() {
        return this.blockSet;
    }

    void setViewerSelection(ByteBlockSelection selection) {
        this.removeFieldSelectionListener(this);
        try {
            this.setSelection(this.getFieldSelection(selection));
        }
        catch (Exception e) {
            Msg.showError((Object)this, null, (String)"Error", (Object)"Error setting selection", (Throwable)e);
        }
        finally {
            this.addFieldSelectionListener(this);
        }
    }

    protected FieldSelection getFieldSelection(ByteBlockSelection selection) {
        FieldSelection fsel = new FieldSelection();
        for (int i = 0; i < selection.getNumberOfRanges(); ++i) {
            ByteBlockRange r = selection.getRange(i);
            ByteBlock block = r.getByteBlock();
            BigInteger start = r.getStartIndex();
            BigInteger end = r.getEndIndex();
            FieldLocation startLoc = this.indexMap.getFieldLocation(block, start, this.fieldFactories);
            FieldLocation endLoc = this.indexMap.getFieldLocation(block, end, this.fieldFactories);
            int endFieldOffset = endLoc.getFieldNum();
            BigInteger endIndex = endLoc.getIndex();
            if (endFieldOffset == this.fieldFactories.length - 1) {
                endFieldOffset = 0;
                endIndex = endIndex.add(BigInteger.ONE);
            } else {
                ++endFieldOffset;
            }
            fsel.addRange(new FieldLocation(startLoc.getIndex(), startLoc.getFieldNum(), 0, 0), new FieldLocation(endIndex, endFieldOffset, 0, 0));
        }
        return fsel;
    }

    void setViewerHighlight(ByteBlockSelection highlight) {
        try {
            this.setHighlight(this.getFieldSelection(highlight));
        }
        catch (Exception e) {
            Msg.showError((Object)this, null, (String)"Error", (Object)"Error setting highlight", (Throwable)e);
        }
    }

    int setViewerCursorLocation(ByteBlock block, BigInteger index, int characterOffset) {
        if (this.indexMap == null) {
            return -1;
        }
        try {
            FieldLocation location = this.indexMap.getFieldLocation(block, index, this.fieldFactories);
            if (location == null) {
                return -1;
            }
            int column = this.adjustCharacterOffsetForBytesField(location, characterOffset);
            BigInteger fieldIndex = location.getIndex();
            int fieldNum = location.getFieldNum();
            int row = location.getRow();
            this.setCursorPosition(fieldIndex, fieldNum, row, column, EventTrigger.INTERNAL_ONLY);
            if (this.isActiveComponent()) {
                this.goTo(fieldIndex, fieldNum, row, column, false, EventTrigger.INTERNAL_ONLY);
            }
            return fieldIndex.intValue();
        }
        catch (AddressOutOfBoundsException location) {
        }
        catch (Exception e) {
            Msg.showError((Object)this, null, (String)"Error", (Object)"Error setting cursor location.", (Throwable)e);
        }
        return -1;
    }

    private int adjustCharacterOffsetForBytesField(FieldLocation fieldLoc, int characterOffset) {
        BigInteger index = fieldLoc.getIndex();
        if (index.compareTo(BigInteger.ZERO) < 0 || index.compareTo(this.layoutModel.getNumIndexes()) >= 0) {
            return characterOffset;
        }
        Layout layout = this.layoutModel.getLayout(index);
        if (layout == null) {
            return characterOffset;
        }
        int fieldNum = fieldLoc.getFieldNum();
        Field field = layout.getField(fieldNum);
        if (!(field instanceof ByteField)) {
            return characterOffset;
        }
        ByteField field2 = (ByteField)field;
        int column = Math.clamp((long)(fieldLoc.getCol() + characterOffset), 0, field2.getNumCols(fieldLoc.getRow()) - 1);
        return column;
    }

    void clearViewerSelection() {
        this.removeFieldSelectionListener(this);
        this.clearSelection();
        this.addFieldSelectionListener(this);
    }

    ByteBlockSelection getViewerSelection() {
        FieldSelection sel = this.getSelection();
        if (sel == null) {
            return null;
        }
        return this.processFieldSelection(sel);
    }

    void clearViewerHighlight() {
        this.clearHighlight();
    }

    ByteBlockSelection getViewerHighlight() {
        FieldSelection hl = this.getHighlight();
        if (hl == null) {
            return null;
        }
        return this.processFieldSelection(hl);
    }

    void returnToView(ByteBlock block, BigInteger index, ViewerPosition vpos) {
        FieldLocation fieldLoc = this.indexMap.getFieldLocation(block, index, this.fieldFactories);
        this.setViewerPosition(vpos.getIndex(), vpos.getXOffset(), vpos.getYOffset());
        this.setCursorPosition(fieldLoc.getIndex(), fieldLoc.getFieldNum(), fieldLoc.getRow(), fieldLoc.getCol());
    }

    public ByteBlockInfo getViewerCursorLocation() {
        BigInteger index;
        IndexedByteBlockInfo info;
        FieldLocation loc = this.getCursorLocation();
        if (loc == null) {
            ViewerPosition vp = this.getViewerPosition();
            if (vp == null) {
                return null;
            }
            return this.indexMap.getBlockInfo(vp.getIndex(), 0);
        }
        if (this.indexMap == null) {
            return null;
        }
        Field field = super.getCurrentField();
        if (!(field instanceof ByteField)) {
            return null;
        }
        ByteField currentField = (ByteField)field;
        int fieldOffset = currentField.getFieldOffset();
        int pos = loc.getCol();
        if (pos >= this.model.getDataUnitSymbolSize()) {
            pos = this.model.getDataUnitSymbolSize() - 1;
        }
        if ((info = this.indexMap.getBlockInfo(index = loc.getIndex(), fieldOffset)) == null) {
            return null;
        }
        BigInteger offset = info.getOffset();
        int byteOffset = this.model.getByteOffset(info.getBlock(), pos);
        offset = offset.add(BigInteger.valueOf(byteOffset));
        return new ByteBlockInfo(info.getBlock(), offset, loc.getCol());
    }

    DataFormatModel getDataModel() {
        return this.model;
    }

    private Color getActiveColor() {
        return this.isEditMode() ? ByteViewerComponentProvider.CURSOR_COLOR_FOCUSED_EDIT : ByteViewerComponentProvider.CURSOR_COLOR_FOCUSED_NON_EDIT;
    }

    void updateColors() {
        this.setFocusedCursorColor(this.isActiveComponent() ? this.getActiveColor() : ByteViewerComponentProvider.CURSOR_COLOR_UNFOCUSED_NON_EDIT);
    }

    void refreshView() {
        try {
            this.doingRefresh = true;
            FieldLocation loc = this.getCursorLocation();
            if (loc != null) {
                ByteBlockSelection sel = this.getViewerSelection();
                this.layoutModel.dataChanged(loc.getIndex(), loc.getIndex());
                if (sel != null && sel.getNumberOfRanges() > 0) {
                    this.setViewerSelection(sel);
                }
            }
        }
        finally {
            this.doingRefresh = false;
        }
    }

    public void dispose() {
        super.dispose();
        this.model.dispose();
        this.layoutModel.dispose();
        this.fieldFactories = null;
    }

    private void initialize() {
        this.setFont(ByteViewerComponentProvider.DEFAULT_FONT);
        this.createFields();
        this.setCursorOn(true);
        this.setNonFocusCursorColor((Color)ByteViewerComponentProvider.CURSOR_COLOR_UNFOCUSED_NON_EDIT);
        this.setFocusedCursorColor((Color)ByteViewerComponentProvider.CURSOR_COLOR_FOCUSED_NON_EDIT);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 3 && !ByteViewerComponent.this.isActiveComponent()) {
                    ByteViewerComponent.this.panel.setCurrentView(ByteViewerComponent.this);
                }
            }
        });
        this.setBackgroundColor((Color)ByteViewerComponentProvider.BG_COLOR);
        this.setBackgroundColorModel(new ByteViewerBGColorModel(this.panel));
        Gui.registerFont((Component)((Object)this), (String)"font.byteviewer");
        this.invalidateModelFields();
        this.enableHelp();
        this.byteViewerHoverProvider = new ByteViewerHoverProvider("ByteViewer" + this.model.getName() + "Hover");
        this.setHoverProvider((HoverProvider)this.byteViewerHoverProvider);
    }

    public boolean isDragging() {
        return super.isDragging();
    }

    private void enableHelp() {
        HelpService helpService = Help.getHelpService();
        if (helpService != null) {
            helpService.registerHelp((Object)this, this.model.getHelpLocation());
        }
    }

    private void createFields() {
        int fieldCount = Math.max(this.bytesPerLine / this.model.getUnitByteSize(), 1);
        this.fieldFactories = new FieldFactory[fieldCount];
        int fieldOffset = 0;
        for (int i = 0; i < fieldCount; ++i) {
            this.fieldFactories[i] = new FieldFactory(this.model, this.bytesPerLine, fieldOffset, this.charWidth, this.fm, this.highlightProvider);
            fieldOffset += this.model.getUnitByteSize();
            this.fieldFactories[i].setIndexMap(this.indexMap);
        }
        this.layoutModel.setFactorys(this.fieldFactories, this.model, this.charWidth);
    }

    private IndexedByteBlockInfo getBlockInfoForSelectionStart(FieldLocation loc) {
        BigInteger index = loc.getIndex();
        int fieldNum = loc.getFieldNum();
        if (this.indexMap.isBlockSeparatorIndex(index)) {
            index = index.add(BigInteger.ONE);
            fieldNum = 0;
        }
        int offset = this.indexMap.getFieldOffset(index, fieldNum, this.fieldFactories);
        return this.indexMap.getBlockInfo(index, offset);
    }

    private IndexedByteBlockInfo getBlockInfoForSelectionEnd(FieldLocation loc) {
        BigInteger lineIndex = loc.getIndex();
        int fieldNum = loc.getFieldNum();
        if (this.indexMap.isBlockSeparatorIndex(lineIndex)) {
            lineIndex = lineIndex.subtract(BigInteger.ONE);
            fieldNum = this.fieldFactories.length - 1;
        }
        if (loc.getCol() == 0 && --fieldNum < 0) {
            if (this.indexMap.isBlockSeparatorIndex(lineIndex = lineIndex.subtract(BigInteger.ONE))) {
                lineIndex = lineIndex.subtract(BigInteger.ONE);
            }
            fieldNum = this.fieldFactories.length - 1;
        }
        int bytesFromLineStart = this.indexMap.getFieldOffset(lineIndex, fieldNum, this.fieldFactories);
        int bytesInField = this.model.getUnitByteSize();
        int lastByteInSelectionOnLine = bytesFromLineStart + bytesInField - 1;
        return this.indexMap.getBlockInfo(lineIndex, lastByteInSelectionOnLine);
    }

    private void addByteBlockRange(ByteBlockSelection sel, IndexedByteBlockInfo start, IndexedByteBlockInfo end) {
        ByteBlock endBlock;
        if (start == null || end == null) {
            return;
        }
        if (start.compareTo(end) > 0) {
            return;
        }
        ByteBlock startBlock = start.getBlock();
        if (startBlock == (endBlock = end.getBlock())) {
            ByteBlockRange r = new ByteBlockRange(startBlock, start.getOffset(), end.getOffset());
            sel.add(r);
        } else {
            BigInteger last = startBlock.getLength().subtract(BigInteger.ONE);
            sel.add(new ByteBlockRange(startBlock, start.getOffset(), last));
            sel.add(new ByteBlockRange(endBlock, BigInteger.ZERO, end.getOffset()));
            for (ByteBlock byteBlock : this.indexMap.getBlocksBetween(start, end)) {
                BigInteger maxIndex = byteBlock.getLength().subtract(BigInteger.ONE);
                sel.add(new ByteBlockRange(byteBlock, BigInteger.ZERO, maxIndex));
            }
        }
    }

    protected ByteBlockSelection processFieldSelection(FieldSelection fieldSelection) {
        ByteBlockSelection blockSelection = new ByteBlockSelection();
        int count = fieldSelection.getNumRanges();
        for (int i = 0; i < count; ++i) {
            FieldRange range = fieldSelection.getFieldRange(i);
            IndexedByteBlockInfo start = this.getBlockInfoForSelectionStart(range.getStart());
            IndexedByteBlockInfo end = this.getBlockInfoForSelectionEnd(range.getEnd());
            this.addByteBlockRange(blockSelection, start, end);
        }
        return blockSelection;
    }

    String getTextForSelection() {
        FieldSelection selection = this.getSelection();
        if (selection == null) {
            return null;
        }
        return FieldSelectionHelper.getAllSelectedText((FieldSelection)selection, (FieldPanel)this);
    }

    FieldLocation getFieldLocation(ByteBlock block, BigInteger offset) {
        return this.indexMap.getFieldLocation(block, offset, this.fieldFactories);
    }

    void enableIndexUpdate(boolean b) {
        this.indexUpdate = b;
    }

    int getNumberOfFields() {
        return this.fieldFactories.length;
    }

    ByteField getField(BigInteger index, int fieldNum) {
        if (this.indexMap != null && fieldNum < this.fieldFactories.length) {
            return (ByteField)this.fieldFactories[fieldNum].getField(index);
        }
        return null;
    }

    public AddressSetView getView() {
        AddressSet result = new AddressSet();
        if (this.blockSet != null) {
            for (ByteBlock block : this.blockSet.getBlocks()) {
                Address start = this.blockSet.getBlockStart(block);
                result.add(start, start.add(block.getLength().longValue() - 1L));
            }
        }
        return result;
    }

    private class ByteViewerHoverProvider
    extends AbstractHoverProvider
    implements HoverService {
        public ByteViewerHoverProvider(String windowName) {
            super(windowName);
            this.addHoverService(this);
        }

        protected ProgramLocation getHoverLocation(FieldLocation fieldLocation, Field field, Rectangle fieldBounds, MouseEvent event) {
            return ByteViewerComponent.this.model instanceof TooltipDataFormatModel && field instanceof ByteField ? new ProgramLocation() : null;
        }

        public int getPriority() {
            return 0;
        }

        public boolean hoverModeSelected() {
            return true;
        }

        public JComponent getHoverComponent(Program unusedProgram, ProgramLocation unusedProgLoc, FieldLocation fieldLocation, Field field) {
            DataFormatModel dataFormatModel;
            ByteField bf;
            block6: {
                block5: {
                    if (!(field instanceof ByteField)) break block5;
                    bf = (ByteField)field;
                    dataFormatModel = ByteViewerComponent.this.model;
                    if (dataFormatModel instanceof TooltipDataFormatModel) break block6;
                }
                return null;
            }
            TooltipDataFormatModel ttdfm = (TooltipDataFormatModel)dataFormatModel;
            BigInteger index = fieldLocation.getIndex();
            IndexedByteBlockInfo info = ByteViewerComponent.this.indexMap.getBlockInfo(index, bf.getFieldOffset());
            if (info == null) {
                return null;
            }
            String ttStr = ttdfm.getTooltip(info.getBlock(), info.getOffset(), ByteViewerComponent.this);
            if (ttStr != null && !ttStr.isBlank()) {
                JToolTip tt = new JToolTip();
                tt.setTipText(ttStr);
                return tt;
            }
            return null;
        }

        public void componentHidden() {
        }

        public void componentShown() {
        }

        public void scroll(int amount) {
        }
    }
}

