/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.byteviewer;

import ghidra.framework.options.SaveState;
import ghidra.util.charset.CharsetInfo;
import ghidra.util.charset.CharsetInfoManager;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class ByteViewerConfigOptions {
    static final int DEFAULT_BYTES_PER_LINE = 16;
    private static final String HEX_VIEW_GROUPSIZE_OPTION_NAME = "Hex View Groupsize";
    private static final String CHARSET_OPTION_NAME = "Charset Name";
    private static final String COMPACTCHARS_OPTION_NAME = "Compact Chars";
    private static final String USE_CHAR_ALIGNMENT_OPTION_NAME = "Use Char Alignment";
    private static final String BYTES_PER_LINE_OPTION_NAME = "Bytes Per Line";
    private static final String OFFSET_NAME = "Offset";
    private int bytesPerLine = 16;
    private int offset;
    private boolean compactChars = true;
    private boolean useCharAlignment = true;
    private CharsetInfo csi = CharsetInfoManager.getInstance().get(StandardCharsets.US_ASCII);
    private int hexGroupSize = 1;

    public ByteViewerConfigOptions clone() {
        ByteViewerConfigOptions clone = new ByteViewerConfigOptions();
        clone.bytesPerLine = this.bytesPerLine;
        clone.compactChars = this.compactChars;
        clone.useCharAlignment = this.useCharAlignment;
        clone.csi = this.csi;
        clone.hexGroupSize = this.hexGroupSize;
        clone.offset = this.offset;
        return clone;
    }

    public void read(SaveState saveState) {
        this.hexGroupSize = saveState.getInt(HEX_VIEW_GROUPSIZE_OPTION_NAME, 1);
        String charsetName = saveState.getString(CHARSET_OPTION_NAME, "US-ASCII");
        this.csi = CharsetInfoManager.getInstance().get(charsetName, StandardCharsets.US_ASCII);
        this.compactChars = saveState.getBoolean(COMPACTCHARS_OPTION_NAME, true);
        this.useCharAlignment = saveState.getBoolean(USE_CHAR_ALIGNMENT_OPTION_NAME, true);
        this.bytesPerLine = saveState.getInt(BYTES_PER_LINE_OPTION_NAME, 16);
        this.offset = saveState.getInt(OFFSET_NAME, 0);
    }

    public void write(SaveState saveState) {
        saveState.putInt(HEX_VIEW_GROUPSIZE_OPTION_NAME, this.hexGroupSize);
        saveState.putString(CHARSET_OPTION_NAME, this.csi.getName());
        saveState.putBoolean(COMPACTCHARS_OPTION_NAME, this.compactChars);
        saveState.putBoolean(USE_CHAR_ALIGNMENT_OPTION_NAME, this.useCharAlignment);
        saveState.putInt(BYTES_PER_LINE_OPTION_NAME, this.bytesPerLine);
        saveState.putInt(OFFSET_NAME, this.offset);
    }

    public boolean areOptionsEqual(ByteViewerConfigOptions other) {
        return this.bytesPerLine == other.bytesPerLine && this.compactChars == other.compactChars && Objects.equals(this.csi, other.csi) && this.hexGroupSize == other.hexGroupSize && this.offset == other.offset && this.useCharAlignment == other.useCharAlignment;
    }

    public boolean areLayoutParamsChanged(ByteViewerConfigOptions other) {
        return this.offset != other.getOffset() || this.hexGroupSize != other.getHexGroupSize() || this.bytesPerLine != other.getBytesPerLine() || this.useCharAlignment != other.isUseCharAlignment();
    }

    public boolean areDislayWidthsChanged(ByteViewerConfigOptions other) {
        return this.getHexGroupSize() != other.getHexGroupSize() || this.isCompactChars() != other.isCompactChars() || this.useCharAlignment && this.csi.getAlignment() != other.csi.getAlignment();
    }

    public int getBytesPerLine() {
        return this.bytesPerLine;
    }

    public void setBytesPerLine(int newBytesPerLine) {
        this.bytesPerLine = newBytesPerLine;
        this.offset = Math.clamp((long)this.offset, 0, this.bytesPerLine - 1);
        this.hexGroupSize = Math.clamp((long)this.hexGroupSize, 1, this.bytesPerLine);
    }

    public int getOffset() {
        return this.offset;
    }

    public int calcNormalizedOffset(int newOffset) {
        if (newOffset < 0) {
            newOffset = this.bytesPerLine - 1;
        } else if (newOffset >= this.bytesPerLine) {
            newOffset %= this.bytesPerLine;
        }
        return newOffset;
    }

    public void setOffset(int newOffset) {
        this.offset = this.calcNormalizedOffset(newOffset);
    }

    public int getHexGroupSize() {
        return this.hexGroupSize;
    }

    public void setHexGroupSize(int newHexGroupSize) {
        this.hexGroupSize = newHexGroupSize;
    }

    public CharsetInfo getCharsetInfo() {
        return this.csi;
    }

    public void setCharsetInfo(CharsetInfo newCSI) {
        this.csi = newCSI;
    }

    public void setCompactChars(boolean newCompactChars) {
        this.compactChars = newCompactChars;
    }

    public boolean isCompactChars() {
        return this.compactChars;
    }

    public boolean isUseCharAlignment() {
        return this.useCharAlignment;
    }

    public void setUseCharAlignment(boolean newUseCharAlignment) {
        this.useCharAlignment = newUseCharAlignment;
    }
}

