/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.byteviewer;

import docking.widgets.fieldpanel.FieldPanel;
import docking.widgets.fieldpanel.Layout;
import docking.widgets.indexedscrollpane.IndexScrollListener;
import docking.widgets.indexedscrollpane.IndexedScrollable;
import ghidra.app.plugin.core.byteviewer.ByteViewerComponent;
import ghidra.app.plugin.core.byteviewer.InteractivePanelManager;
import ghidra.app.plugin.core.format.DataFormatModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;

class ByteViewerIndexedView
extends JPanel
implements IndexedScrollable,
IndexScrollListener {
    private FieldPanel indexPanel;
    private List<FieldPanel> allPanels = new ArrayList<FieldPanel>();
    private boolean processingIndexRangeChanged;
    private InteractivePanelManager panelManager;

    ByteViewerIndexedView(FieldPanel indexPanel) {
        super(new BorderLayout());
        this.indexPanel = indexPanel;
        this.allPanels.add(indexPanel);
        this.panelManager = new InteractivePanelManager();
        indexPanel.addIndexScrollListener((IndexScrollListener)this);
        this.panelManager.addComponent("Addresses", (JComponent)indexPanel);
        JComponent mainPanel = this.panelManager.getMainPanel();
        this.add((Component)mainPanel, "Center");
        this.addMouseWheelListener(e -> {
            Layout firstLayout = indexPanel.getLayoutModel().getLayout(BigInteger.ZERO);
            int layoutScrollHt = firstLayout != null ? firstLayout.getScrollableUnitIncrement(0, 1) : 0;
            double wheelRotation = e.getPreciseWheelRotation();
            int scrollAmount = (int)(wheelRotation * (double)layoutScrollHt * 3.0);
            indexPanel.scrollView(scrollAmount);
            e.consume();
        });
    }

    void addView(String viewName, ByteViewerComponent c) {
        this.panelManager.addComponent(viewName, (JComponent)((Object)c));
        this.allPanels.add(c);
        c.addIndexScrollListener(this);
    }

    void removeView(ByteViewerComponent c) {
        this.panelManager.removeComponent((JComponent)((Object)c));
        this.allPanels.remove(c);
        c.removeIndexScrollListener(this);
    }

    JComponent getColumnHeader() {
        return this.panelManager.getColumnHeader();
    }

    public List<String> getViewNamesInDisplayOrder() {
        ArrayList<String> viewNames = new ArrayList<String>();
        List<JComponent> components = this.panelManager.getComponents();
        for (JComponent component : components) {
            if (component == this.indexPanel || !(component instanceof ByteViewerComponent)) continue;
            ByteViewerComponent byteViewerComponent = (ByteViewerComponent)((Object)component);
            DataFormatModel model = byteViewerComponent.getDataModel();
            viewNames.add(model.getName());
        }
        return viewNames;
    }

    void resetViewWidthToDefaults() {
        List<String> viewNames = this.getViewNamesInDisplayOrder();
        for (String viewName : viewNames) {
            this.panelManager.resetColumnWidthToPreferredWidth(viewName);
        }
    }

    void setIndexName(String indexName) {
        this.panelManager.setName((JComponent)this.indexPanel, indexName);
    }

    int getViewWidth(String viewName) {
        return this.panelManager.getColumnWidth(viewName);
    }

    void setColumnWidth(String viewName, int width) {
        this.panelManager.setColumnWidth(viewName, width);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indexRangeChanged(BigInteger startIndex, BigInteger endIndex, int yStart, int yEnd) {
        if (this.processingIndexRangeChanged) {
            return;
        }
        this.processingIndexRangeChanged = true;
        try {
            for (FieldPanel fieldPanel : this.allPanels) {
                fieldPanel.showIndex(startIndex, yStart);
            }
        }
        finally {
            this.processingIndexRangeChanged = false;
        }
    }

    public void addIndexScrollListener(IndexScrollListener listener) {
        this.indexPanel.addIndexScrollListener(listener);
    }

    public int getHeight(BigInteger index) {
        return this.indexPanel.getHeight(index);
    }

    public BigInteger getIndexAfter(BigInteger index) {
        return this.indexPanel.getIndexAfter(index);
    }

    public BigInteger getIndexBefore(BigInteger index) {
        return this.indexPanel.getIndexBefore(index);
    }

    public BigInteger getIndexCount() {
        return this.indexPanel.getIndexCount();
    }

    public boolean isUniformIndex() {
        return true;
    }

    public void removeIndexScrollListener(IndexScrollListener listener) {
        this.indexPanel.removeIndexScrollListener(listener);
    }

    public void scrollLineDown() {
        this.indexPanel.scrollLineDown();
    }

    public void scrollLineUp() {
        this.indexPanel.scrollLineUp();
    }

    public void scrollPageDown() {
        this.indexPanel.scrollPageDown();
    }

    public void scrollPageUp() {
        this.indexPanel.scrollPageUp();
    }

    public void showIndex(BigInteger index, int verticalOffset) {
        this.indexPanel.showIndex(index, verticalOffset);
    }

    public void indexModelChanged() {
    }

    public void indexModelDataChanged(BigInteger start, BigInteger end) {
    }

    public void mouseWheelMoved(double preciseWheelRotation, boolean isHorizontal) {
        this.indexPanel.mouseWheelMoved(preciseWheelRotation, isHorizontal);
    }
}

