/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.byteviewer;

import docking.DialogComponentProvider;
import docking.widgets.button.BrowseButton;
import docking.widgets.checkbox.GCheckBox;
import docking.widgets.fieldpanel.support.ViewerPosition;
import docking.widgets.label.GLabel;
import docking.widgets.spinner.IntegerSpinner;
import generic.theme.GThemeDefaults;
import ghidra.app.plugin.core.byteviewer.ByteViewerComponentProvider;
import ghidra.app.plugin.core.byteviewer.ByteViewerConfigOptions;
import ghidra.app.plugin.core.format.DataFormatModel;
import ghidra.util.HelpLocation;
import ghidra.util.charset.CharsetInfo;
import ghidra.util.charset.picker.CharsetPickerDialog;
import ghidra.util.layout.PairLayout;
import ghidra.util.layout.VerticalLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class ByteViewerOptionsDialog
extends DialogComponentProvider {
    private JTextField charsetField;
    private BrowseButton charsetPickerButton;
    private ByteViewerComponentProvider provider;
    private ByteViewerConfigOptions configOptions;
    private Map<String, JCheckBox> checkboxMap = new HashMap<String, JCheckBox>();
    private MySpinnerNumberModel bytesPerLineSpinnerModel;
    private MySpinnerNumberModel offsetSpinnerModel;
    private MySpinnerNumberModel hexGroupSizeSpinnerModel;
    private IntegerSpinner bytesPerLineSpinner;
    private IntegerSpinner offsetSpinner;
    private IntegerSpinner hexGroupSizeSpinner;
    private LinkedHashMap<String, DataFormatModel> models = new LinkedHashMap();

    public ByteViewerOptionsDialog(ByteViewerComponentProvider provider) {
        super("Byte Viewer Options");
        this.provider = provider;
        this.configOptions = provider.getConfigOptions().clone();
        for (String modelName : provider.getDataFormatNames()) {
            this.models.put(modelName, provider.getDataFormatModel(modelName));
        }
        this.addWorkPanel(this.buildPanel());
        this.addOKButton();
        this.addCancelButton();
        this.setResizable(false);
        this.setHelpLocation(new HelpLocation("ByteViewerPlugin", "Byte_Viewer_Options"));
        this.setRememberLocation(false);
        this.setRememberSize(false);
    }

    private void disposeModels() {
        for (DataFormatModel model : this.models.values()) {
            model.dispose();
        }
        this.models.clear();
    }

    private JComponent buildPanel() {
        JPanel mainPanel = new JPanel((LayoutManager)new VerticalLayout(10));
        mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        mainPanel.add(this.buildSettingsPanel());
        mainPanel.add(this.buildModelPickerPanel());
        this.updateButtonEnablement();
        return mainPanel;
    }

    private void setTooltip(IntegerSpinner spinner, String text) {
        spinner.getTextField().getComponent().setToolTipText(text);
        spinner.getSpinner().setToolTipText(text);
    }

    private void updateModelStatus(DataFormatModel model, String errorMsg) {
        JCheckBox cb = this.checkboxMap.get(model.getName());
        if (cb != null) {
            cb.setForeground((Color)(errorMsg == null ? GThemeDefaults.Colors.FOREGROUND : GThemeDefaults.Colors.Messages.ERROR));
            cb.setToolTipText(errorMsg);
        }
    }

    private boolean isModelEnabled(DataFormatModel model) {
        JCheckBox cb = this.checkboxMap.get(model.getName());
        return cb != null && cb.isSelected();
    }

    private void updateButtonEnablement() {
        int enabledModelCount = 0;
        String firstErrorMsg = null;
        for (DataFormatModel model : this.models.values()) {
            String errorMsg = model.validateByteViewerConfigOptions(this.configOptions);
            if (errorMsg == null && this.configOptions.getBytesPerLine() % model.getUnitByteSize() != 0) {
                errorMsg = "%s (%d bytes) is not a multiple of %d".formatted(model.getName(), model.getUnitByteSize(), this.configOptions.getBytesPerLine());
            }
            this.updateModelStatus(model, errorMsg);
            if (!this.isModelEnabled(model)) continue;
            ++enabledModelCount;
            if (errorMsg == null) continue;
            firstErrorMsg = firstErrorMsg == null ? errorMsg : firstErrorMsg;
        }
        if (enabledModelCount == 0) {
            firstErrorMsg = "You must have at least one view selected";
        }
        this.setStatusText(firstErrorMsg);
        this.setOkEnabled(firstErrorMsg == null);
    }

    private Component buildSettingsPanel() {
        JPanel panel = new JPanel((LayoutManager)new PairLayout(5, 5));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.bytesPerLineSpinnerModel = new MySpinnerNumberModel(this.configOptions.getBytesPerLine(), 1, 256, 1);
        this.offsetSpinnerModel = new MySpinnerNumberModel(this.configOptions.getOffset(), 0, this.configOptions.getBytesPerLine() - 1, 1){

            @Override
            public Object getNextValue() {
                Long val = (Long)this.getNumber();
                Long maximum = (Long)this.getMaximum();
                if (maximum != null && maximum.compareTo(val) <= 0) {
                    return this.getMinimum();
                }
                return super.getNextValue();
            }

            @Override
            public Object getPreviousValue() {
                Long val = (Long)this.getNumber();
                Long min = (Long)this.getMinimum();
                if (min != null && min.compareTo(val) >= 0) {
                    return this.getMaximum();
                }
                return super.getPreviousValue();
            }
        };
        this.hexGroupSizeSpinnerModel = new MySpinnerNumberModel(this.configOptions.getHexGroupSize(), 1, this.configOptions.getBytesPerLine(), 1);
        this.bytesPerLineSpinner = new MyIntegerSpinner(this.bytesPerLineSpinnerModel, 3);
        this.bytesPerLineSpinner.getTextField().setShowNumberMode(false);
        this.bytesPerLineSpinner.getTextField().setAccessibleName("Bytes Per Line");
        this.setTooltip(this.bytesPerLineSpinner, "Number of bytes to display in each row of the viewer.");
        this.offsetSpinner = new MyIntegerSpinner(this.offsetSpinnerModel, 3);
        this.offsetSpinner.getTextField().setShowNumberMode(false);
        this.offsetSpinner.getTextField().setAccessibleName("Offset");
        this.setTooltip(this.offsetSpinner, "Adjusts the starting byte of the row left or right.\nRanges from 0 to bytes per line (exclusive).");
        this.hexGroupSizeSpinner = new MyIntegerSpinner(this.hexGroupSizeSpinnerModel, 3);
        this.hexGroupSizeSpinner.getTextField().setShowNumberMode(false);
        this.hexGroupSizeSpinner.getTextField().setAccessibleName("Hex Group Size");
        this.setTooltip(this.hexGroupSizeSpinner, "How many bytes will be grouped together in the hex view.\nRanges from 1 to bytes per line (inclusive).");
        this.bytesPerLineSpinnerModel.addChangeListener(e -> {
            Long bpl = (Long)this.bytesPerLineSpinnerModel.getNumber();
            if (bpl != null) {
                this.setBytesPerLine(bpl.intValue());
            }
        });
        this.offsetSpinnerModel.addChangeListener(e -> {
            Long val = (Long)this.offsetSpinnerModel.getNumber();
            if (val != null) {
                this.setOffset(val.intValue());
            }
        });
        this.hexGroupSizeSpinnerModel.addChangeListener(e -> {
            Long val = (Long)this.hexGroupSizeSpinnerModel.getNumber();
            if (val != null) {
                this.setHexGroupSize(val.intValue());
            }
        });
        panel.add((Component)new GLabel("Bytes Per Line:"));
        panel.add(this.bytesPerLineSpinner.getSpinner());
        panel.add((Component)new GLabel("Alignment Offset:"));
        panel.add(this.offsetSpinner.getSpinner());
        panel.add((Component)new GLabel("Hex Group Size:"));
        panel.add(this.hexGroupSizeSpinner.getSpinner());
        panel.add((Component)new GLabel("Charset:"));
        this.charsetField = new JTextField();
        this.charsetField.setEditable(false);
        this.charsetField.setText(this.configOptions.getCharsetInfo().getName());
        this.charsetField.getAccessibleContext().setAccessibleName("Character Set Name");
        this.charsetPickerButton = new BrowseButton();
        this.charsetPickerButton.addActionListener(e -> this.pickCharset());
        this.charsetPickerButton.getAccessibleContext().setAccessibleName("Character Set Picker");
        JPanel charsetPanel = new JPanel(new BorderLayout());
        charsetPanel.add((Component)this.charsetField, "Center");
        charsetPanel.add((Component)this.charsetPickerButton, "East");
        panel.add(charsetPanel);
        panel.add((Component)new GLabel("Compact Char Width:"));
        GCheckBox compactChars = new GCheckBox();
        compactChars.setSelected(this.configOptions.isCompactChars());
        compactChars.addChangeListener(e -> this.configOptions.setCompactChars(compactChars.isSelected()));
        compactChars.getAccessibleContext().setAccessibleName("Compact Characters");
        compactChars.setToolTipText("Display characters tightly packed together or more widely spaced apart");
        panel.add((Component)compactChars);
        panel.add((Component)new GLabel("Use Char Alignment:"));
        GCheckBox useCharAlignment = new GCheckBox();
        useCharAlignment.setSelected(this.configOptions.isUseCharAlignment());
        useCharAlignment.addChangeListener(e -> this.configOptions.setUseCharAlignment(useCharAlignment.isSelected()));
        useCharAlignment.getAccessibleContext().setAccessibleName("Character Alignment");
        useCharAlignment.setToolTipText("Align start-of-character location with charset's byte width.\nOnly some charsets (like UTF-16/UTF-32) are marked as alignable.");
        panel.add((Component)useCharAlignment);
        return panel;
    }

    void setBytesPerLine(int bpl) {
        this.configOptions.setBytesPerLine(bpl);
        if (this.configOptions.getOffset() != this.offsetSpinnerModel.getNumber().intValue()) {
            this.offsetSpinnerModel.setValue(this.configOptions.getOffset());
        }
        if (this.configOptions.getHexGroupSize() != this.hexGroupSizeSpinnerModel.getIntValue()) {
            this.hexGroupSizeSpinnerModel.setValue(this.configOptions.getHexGroupSize());
        }
        this.offsetSpinnerModel.setMaximum(Long.valueOf(bpl - 1));
        this.hexGroupSizeSpinnerModel.setMaximum(Long.valueOf(bpl));
        this.updateButtonEnablement();
    }

    public void setOffset(int val) {
        this.configOptions.setOffset(val);
        this.updateButtonEnablement();
    }

    void setHexGroupSize(int val) {
        this.configOptions.setHexGroupSize(val);
        this.updateButtonEnablement();
    }

    private void pickCharset() {
        CharsetInfo newCSI = CharsetPickerDialog.pickCharset((CharsetInfo)this.configOptions.getCharsetInfo());
        if (newCSI != null) {
            this.setCharsetInfo(newCSI);
        }
    }

    private void setCharsetInfo(CharsetInfo newCSI) {
        this.configOptions.setCharsetInfo(newCSI);
        this.charsetField.setText(newCSI.getName());
    }

    private JPanel buildModelPickerPanel() {
        JPanel panel = new JPanel(new GridLayout(0, 2, 40, 0));
        TitledBorder outer = BorderFactory.createTitledBorder("Views");
        Border inner = BorderFactory.createEmptyBorder(5, 15, 5, 15);
        panel.setBorder(BorderFactory.createCompoundBorder(outer, inner));
        Set<String> currentViews = this.provider.getCurrentViews();
        for (DataFormatModel model : this.models.values()) {
            String modelName = model.getName();
            GCheckBox cb = new GCheckBox(modelName);
            cb.addChangeListener(e -> this.updateButtonEnablement());
            this.checkboxMap.put(modelName, (JCheckBox)cb);
            if (currentViews.contains(modelName)) {
                cb.setSelected(true);
            }
            panel.add((Component)cb);
        }
        return panel;
    }

    void setModelSelected(String modelName, boolean selected) {
        JCheckBox cb = this.checkboxMap.get(modelName);
        cb.setSelected(selected);
    }

    protected void okCallback() {
        ViewerPosition vp = this.provider.getByteViewerPanel().getViewerPosition();
        this.provider.updateConfigOptions(this.configOptions, this.getSelectedViewNames());
        this.provider.getByteViewerPanel().setViewerPosition(vp);
        this.disposeModels();
        this.close();
    }

    protected void cancelCallback() {
        this.disposeModels();
        super.cancelCallback();
    }

    private Set<String> getSelectedViewNames() {
        return this.checkboxMap.entrySet().stream().filter(entry -> ((JCheckBox)entry.getValue()).isSelected()).map(entry -> (String)entry.getKey()).collect(Collectors.toSet());
    }

    private static class MySpinnerNumberModel
    extends SpinnerNumberModel {
        public MySpinnerNumberModel(int value, int minimum, int maximum, int stepSize) {
            super((Number)value, Long.valueOf(minimum), Long.valueOf(maximum), (Number)stepSize);
        }

        public int getIntValue() {
            return ((Long)this.getValue()).intValue();
        }

        public boolean isValid(Object value) {
            if (value == null || !(value instanceof Long)) {
                return false;
            }
            Long val = (Long)value;
            Long minimum = (Long)this.getMinimum();
            Long maximum = (Long)this.getMaximum();
            return minimum.compareTo(val) <= 0 && maximum.compareTo(val) >= 0;
        }

        @Override
        public void setValue(Object value) {
            if (this.isValid(value)) {
                super.setValue(value);
            }
        }
    }

    private static class MyIntegerSpinner
    extends IntegerSpinner {
        MyIntegerSpinner(final MySpinnerNumberModel spinnerModel, int columns) {
            super((SpinnerNumberModel)spinnerModel, columns);
            this.integerTextField.addChangeListener(e -> {
                BigInteger valObj = this.integerTextField.getValue();
                Long value = valObj != null ? Long.valueOf(valObj.longValue()) : null;
                this.integerTextField.getComponent().setForeground((Color)(spinnerModel.isValid(value) ? GThemeDefaults.Colors.FOREGROUND : GThemeDefaults.Colors.Messages.ERROR));
            });
            this.integerTextField.getComponent().addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                    Long value;
                    BigInteger valObj = integerTextField.getValue();
                    Long l = value = valObj != null ? Long.valueOf(valObj.longValue()) : null;
                    if (!spinnerModel.isValid(value)) {
                        integerTextField.setValue(spinnerModel.getIntValue());
                    }
                }

                @Override
                public void focusGained(FocusEvent e) {
                }
            });
        }
    }
}

