/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.byteviewer;

import docking.widgets.EventTrigger;
import docking.widgets.fieldpanel.FieldPanel;
import docking.widgets.fieldpanel.Layout;
import docking.widgets.fieldpanel.LayoutModel;
import docking.widgets.fieldpanel.field.EmptyTextField;
import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.listener.IndexMapper;
import docking.widgets.fieldpanel.listener.LayoutListener;
import docking.widgets.fieldpanel.listener.LayoutModelListener;
import docking.widgets.fieldpanel.support.AnchoredLayout;
import docking.widgets.fieldpanel.support.BackgroundColorModel;
import docking.widgets.fieldpanel.support.FieldSelection;
import docking.widgets.fieldpanel.support.SingleRowLayout;
import docking.widgets.fieldpanel.support.ViewerPosition;
import docking.widgets.indexedscrollpane.IndexedScrollPane;
import docking.widgets.label.GDLabel;
import docking.widgets.label.GLabel;
import generic.theme.Gui;
import ghidra.app.plugin.core.byteviewer.ByteViewerBGColorModel;
import ghidra.app.plugin.core.byteviewer.ByteViewerComponent;
import ghidra.app.plugin.core.byteviewer.ByteViewerComponentProvider;
import ghidra.app.plugin.core.byteviewer.ByteViewerConfigOptions;
import ghidra.app.plugin.core.byteviewer.ByteViewerIndexedView;
import ghidra.app.plugin.core.byteviewer.ByteViewerLayoutModel;
import ghidra.app.plugin.core.byteviewer.ByteViewerState;
import ghidra.app.plugin.core.byteviewer.IndexFieldFactory;
import ghidra.app.plugin.core.byteviewer.IndexMap;
import ghidra.app.plugin.core.format.ByteBlock;
import ghidra.app.plugin.core.format.ByteBlockInfo;
import ghidra.app.plugin.core.format.ByteBlockSelection;
import ghidra.app.plugin.core.format.ByteBlockSet;
import ghidra.app.plugin.core.format.DataFormatModel;
import ghidra.app.util.viewer.listingpanel.AddressSetDisplayListener;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.datastruct.ListenerSet;
import ghidra.util.layout.PairLayout;
import help.Help;
import help.HelpService;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.LayoutManager;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ByteViewerPanel
extends JPanel
implements LayoutModel,
LayoutListener {
    private static final String FONT_STATUS_ID = "font.byteviewer.status";
    private List<ByteViewerComponent> viewList;
    private FieldPanel indexPanel;
    private IndexFieldFactory indexFactory;
    private JLabel startField;
    private JLabel endField;
    private JLabel offsetField;
    private JLabel insertionField;
    private JPanel statusPanel;
    private int fontHeight;
    private FontMetrics fontMetrics;
    private int bytesPerLine;
    private ByteBlockSet blockSet;
    private ByteBlock[] blocks;
    private IndexMap indexMap;
    private int blockOffset;
    private ByteViewerComponent currentView;
    private boolean highlightCurrentLine;
    private int highlightButton;
    private ListenerSet<LayoutModelListener> layoutListeners = new ListenerSet(LayoutModelListener.class, false);
    private boolean addingView;
    private final ByteViewerComponentProvider provider;
    private List<AddressSetDisplayListener> displayListeners = new ArrayList<AddressSetDisplayListener>();
    private ByteViewerIndexedView indexedView;
    private boolean editMode;

    protected ByteViewerPanel(ByteViewerComponentProvider provider) {
        this.provider = provider;
        this.bytesPerLine = provider.getConfigOptions().getBytesPerLine();
        this.viewList = new ArrayList<ByteViewerComponent>();
        this.indexMap = new IndexMap();
        this.create();
    }

    @Override
    public Dimension getPreferredSize() {
        int rowCount = 20;
        int rowsHeight = rowCount * this.fontHeight;
        int defaultHeight = rowsHeight + this.statusPanel.getHeight();
        if (this.viewList.isEmpty()) {
            int width = this.statusPanel.getPreferredSize().width + 20;
            return new Dimension(width, defaultHeight);
        }
        int width = this.indexPanel.getPreferredSize().width;
        int height = defaultHeight;
        for (ByteViewerComponent c : this.viewList) {
            Dimension d = c.getPreferredSize();
            width += d.width + 2;
            height = Math.max(d.height, defaultHeight);
        }
        return new Dimension(width, height);
    }

    void updateColors() {
        for (ByteViewerComponent comp : this.viewList) {
            comp.updateColors();
        }
    }

    int getHighlightButton() {
        return this.highlightButton;
    }

    void setHighlightCurrentLineEnabled(boolean b) {
        this.highlightCurrentLine = b;
        this.repaint();
    }

    boolean isHighlightCurrentLine() {
        return this.highlightCurrentLine;
    }

    void setHighlightButton(int highlightButton) {
        this.highlightButton = highlightButton;
    }

    void setByteBlocks(ByteBlockSet blockSet) {
        this.blockSet = blockSet;
        this.blocks = null;
        this.indexMap = null;
        if (blockSet != null) {
            this.blocks = blockSet.getBlocks();
            if (this.blocks.length > 0) {
                this.indexMap = new IndexMap(blockSet, this.bytesPerLine, this.blockOffset);
                String start = this.blocks[0].getLocationRepresentation(BigInteger.ZERO);
                this.startField.setText(start);
                ByteBlock lastBlock = this.blocks[this.blocks.length - 1];
                this.endField.setText(lastBlock.getLocationRepresentation(lastBlock.getLength().subtract(BigInteger.ONE)));
                this.offsetField.setText(Integer.toString(this.blockOffset));
                this.clearSelection();
            }
        }
        if (this.indexMap == null) {
            this.indexMap = new IndexMap();
            this.startField.setText("00000000");
            this.endField.setText("00000000");
            this.offsetField.setText("00000000");
            this.insertionField.setText("00000000");
        }
        this.indexFactory.setIndexMap(this.indexMap);
        this.indexFactory.setSize(this.getIndexSizeInChars());
        for (ByteViewerComponent c : this.viewList) {
            c.enableIndexUpdate(false);
            c.setIndexMap(this.indexMap);
        }
        for (ByteViewerComponent c : this.viewList) {
            c.enableIndexUpdate(true);
            c.setIndexMap(this.indexMap);
        }
        if (this.blocks != null && this.blocks.length > 0) {
            this.indexedView.setIndexName(this.blocks[0].getIndexName());
        }
        this.indexPanel.dataChanged(BigInteger.ZERO, this.indexMap.getNumIndexes());
        this.indexSetChanged();
    }

    void setViewerSelection(ByteBlockSelection selection) {
        for (ByteViewerComponent c : this.viewList) {
            c.setViewerSelection(selection);
        }
    }

    ByteBlockSelection getViewerSelection() {
        if (this.currentView == null) {
            return null;
        }
        return this.currentView.getViewerSelection();
    }

    void setViewerHighlight(ByteBlockSelection highlight) {
        for (ByteViewerComponent c : this.viewList) {
            c.setViewerHighlight(highlight);
        }
    }

    ByteBlockSelection getViewerHighlight() {
        if (this.currentView == null) {
            return null;
        }
        return this.currentView.getViewerHighlight();
    }

    void setCursorLocation(ByteBlock block, BigInteger index, int column) {
        int modelIndex = -1;
        for (ByteViewerComponent c : this.viewList) {
            modelIndex = c.setViewerCursorLocation(block, index, column);
        }
        if (modelIndex >= 0) {
            this.insertionField.setText(block.getLocationRepresentation(index));
        }
        this.updateIndexColumnCurrentLine();
    }

    void updateIndexColumnCurrentLine() {
        this.indexPanel.repaint();
    }

    ByteBlockInfo getCursorLocation() {
        if (this.currentView == null) {
            return null;
        }
        return this.currentView.getViewerCursorLocation();
    }

    DataFormatModel getCurrentModel() {
        if (this.currentView == null) {
            return null;
        }
        return this.currentView.getDataModel();
    }

    public ByteViewerComponent getCurrentComponent() {
        return this.currentView;
    }

    public ByteViewerComponent getComponentByName(String name) {
        for (ByteViewerComponent bvc : this.viewList) {
            if (!name.equals(bvc.getDataModel().getName())) continue;
            return bvc;
        }
        return null;
    }

    protected ByteViewerComponent newByteViewerComponent(DataFormatModel model) {
        return new ByteViewerComponent(this, new ByteViewerLayoutModel(), model, this.bytesPerLine);
    }

    ByteViewerComponent addView(String viewName, DataFormatModel model, boolean updateViewPosition) {
        if (this.viewList.size() != 0) {
            this.addingView = true;
        }
        ViewerPosition vp = this.getViewerPosition();
        ByteViewerComponent c = this.newByteViewerComponent(model);
        c.setIndexMap(this.indexMap);
        this.viewList.add(c);
        c.setSize(c.getPreferredSize());
        this.indexedView.addView(viewName, c);
        c.addListeners();
        if (this.viewList.size() == 1) {
            this.currentView = c;
            if (this.blocks != null) {
                this.setCursorLocation(this.blocks[0], BigInteger.ZERO, 0);
            }
        } else {
            ByteBlockInfo info;
            ByteBlockSelection hl;
            ByteBlockSelection sel = this.currentView.getViewerSelection();
            if (sel != null) {
                c.setViewerSelection(sel);
            }
            if ((hl = this.currentView.getViewerHighlight()) != null) {
                c.setViewerHighlight(hl);
            }
            if ((info = this.currentView.getViewerCursorLocation()) != null) {
                c.setViewerCursorLocation(info.getBlock(), info.getOffset(), info.getColumn());
            }
            if (updateViewPosition) {
                Swing.runLater(() -> this.indexPanel.setViewerPosition(vp.getIndex(), vp.getXOffset(), vp.getYOffset()));
            }
            this.addingView = false;
        }
        c.updateColors();
        this.validate();
        this.repaint();
        return c;
    }

    void removeView(ByteViewerComponent comp) {
        this.viewList.remove(comp);
        this.indexedView.removeView(comp);
        if (this.currentView == comp) {
            this.currentView = !this.viewList.isEmpty() ? this.viewList.get(0) : null;
        }
        comp.dispose();
        this.validate();
        this.repaint();
    }

    void setCurrentView(ByteViewerComponent c) {
        this.currentView = c;
        this.updateColors();
    }

    void setEditMode(boolean editMode) {
        this.editMode = editMode;
        this.updateColors();
    }

    boolean getEditMode() {
        return this.editMode;
    }

    void refreshView() {
        for (ByteViewerComponent c : this.viewList) {
            c.refreshView();
        }
    }

    void updateLayoutConfigOptions(ByteViewerConfigOptions options) {
        boolean offsetChanged;
        boolean bplChanged = this.bytesPerLine != options.getBytesPerLine();
        boolean bl = offsetChanged = this.blockOffset != options.getOffset();
        if (bplChanged || offsetChanged) {
            this.bytesPerLine = options.getBytesPerLine();
            this.blockOffset = options.getOffset();
            this.updateIndexMap();
            this.offsetField.setText(Integer.toString(this.blockOffset));
        }
        if (bplChanged) {
            this.resetColumnsToDefaultWidths();
        }
    }

    void resetColumnsToDefaultWidths() {
        this.indexedView.resetViewWidthToDefaults();
        this.invalidate();
        this.validate();
        this.repaint();
    }

    void setInsertionField(ByteViewerComponent source, ByteBlock block, BigInteger offset, BigInteger modelIndex, int column, boolean isAltDown) {
        this.provider.updateLocation(block, offset, column, isAltDown);
        if (this.addingView) {
            return;
        }
        this.indexPanel.setCursorPosition(modelIndex, 0, 0, 0);
        if (block != null) {
            String locRep = block.getLocationRepresentation(offset);
            if (locRep == null) {
                return;
            }
            this.insertionField.setText(locRep);
        }
        for (ByteViewerComponent c : this.viewList) {
            if (source == c) continue;
            c.setViewerCursorLocation(block, offset, column);
        }
        this.updateIndexColumnCurrentLine();
    }

    void setCurrentNonMappedIndex(BigInteger index, ByteViewerComponent source) {
        for (ByteViewerComponent c : this.viewList) {
            if (c == source) continue;
            c.setCursorPosition(index, 0, 0, 0, EventTrigger.INTERNAL_ONLY);
        }
    }

    void updateSelection(ByteViewerComponent source, ByteBlockSelection selection) {
        this.provider.updateSelection(selection);
        for (ByteViewerComponent c : this.viewList) {
            if (source == c) continue;
            c.setViewerSelection(selection);
        }
    }

    void updateLiveSelection(ByteViewerComponent bvc, ByteBlockSelection selection) {
        this.provider.updateLiveSelection(bvc, selection);
        for (ByteViewerComponent c : this.viewList) {
            if (c == bvc) continue;
            c.setViewerSelection(selection);
        }
        this.updateIndexColumnCurrentLine();
    }

    List<String> getViewNamesInDisplayOrder() {
        return this.indexedView.getViewNamesInDisplayOrder();
    }

    public ViewerPosition getViewerPosition() {
        return this.indexPanel.getViewerPosition();
    }

    public void setViewerPosition(ViewerPosition pos) {
        this.indexPanel.setViewerPosition(pos.getIndex(), pos.getXOffset(), pos.getYOffset());
    }

    void restoreView(ByteViewerState vp) {
        if (this.currentView == null) {
            return;
        }
        ByteBlock block = vp.getBlock();
        BigInteger offset = vp.getOffset();
        ViewerPosition vpos = vp.getViewerPosition();
        for (ByteViewerComponent c : this.viewList) {
            c.returnToView(block, offset, vpos);
        }
        this.indexPanel.setViewerPosition(vpos.getIndex(), vpos.getXOffset(), vpos.getYOffset());
    }

    void restoreConfigState(ByteViewerConfigOptions options) {
        this.updateLayoutConfigOptions(options);
    }

    void programWasRestored() {
        this.updateIndexMap();
        this.refreshView();
    }

    protected int getBytesPerLine() {
        return this.bytesPerLine;
    }

    void dispose() {
        for (ByteViewerComponent comp : this.viewList) {
            comp.dispose();
        }
        this.viewList.clear();
        this.indexMap = new IndexMap();
        this.blockSet = null;
        this.layoutListeners.clear();
    }

    private void create() {
        this.setLayout(new BorderLayout(10, 0));
        this.setBorder(BorderFactory.createBevelBorder(1));
        this.setFont(ByteViewerComponentProvider.DEFAULT_FONT);
        this.indexFactory = new IndexFieldFactory(this.fontMetrics);
        this.indexPanel = new FieldPanel((LayoutModel)this, "Byte Viewer");
        this.indexPanel.enableSelection(false);
        this.indexPanel.setCursorOn(false);
        this.indexPanel.setFocusable(false);
        this.indexPanel.addLayoutListener((LayoutListener)this);
        this.indexPanel.setBackgroundColor((Color)ByteViewerComponentProvider.BG_COLOR);
        this.indexPanel.setBackgroundColorModel((BackgroundColorModel)new ByteViewerBGColorModel(this));
        this.indexedView = new ByteViewerIndexedView(this.indexPanel);
        IndexedScrollPane indexedScrollPane = new IndexedScrollPane((JComponent)this.indexedView);
        indexedScrollPane.setWheelScrollingEnabled(false);
        indexedScrollPane.setColumnHeaderComp(this.indexedView.getColumnHeader());
        indexedScrollPane.setBackground((Color)ByteViewerComponentProvider.BG_COLOR);
        this.statusPanel = this.createStatusPanel();
        this.add((Component)indexedScrollPane, "Center");
        this.add((Component)this.statusPanel, "South");
        Gui.registerFont((Component)this, (String)"font.byteviewer");
        HelpService help = Help.getHelpService();
        help.registerHelp((Object)this, new HelpLocation("ByteViewerPlugin", "ByteViewerPlugin"));
    }

    private JPanel createStatusPanel() {
        GLabel startLabel = new GLabel("Start:", 4);
        GLabel endLabel = new GLabel("End:", 4);
        GLabel offsetLabel = new GLabel("Offset:", 4);
        GLabel insertionLabel = new GLabel("Insertion:", 4);
        this.startField = new GDLabel("00000000");
        this.startField.setName("Start");
        this.endField = new GDLabel("00000000");
        this.endField.setName("End");
        this.offsetField = new GDLabel("00000000");
        this.offsetField.setName("Offset");
        this.insertionField = new GDLabel("00000000");
        this.insertionField.setName("Insertion");
        Gui.registerFont((Component)startLabel, (String)FONT_STATUS_ID);
        Gui.registerFont((Component)endLabel, (String)FONT_STATUS_ID);
        Gui.registerFont((Component)offsetLabel, (String)FONT_STATUS_ID);
        Gui.registerFont((Component)insertionLabel, (String)FONT_STATUS_ID);
        Gui.registerFont((Component)this.startField, (String)FONT_STATUS_ID);
        Gui.registerFont((Component)this.endField, (String)FONT_STATUS_ID);
        Gui.registerFont((Component)this.offsetField, (String)FONT_STATUS_ID);
        Gui.registerFont((Component)this.insertionField, (String)FONT_STATUS_ID);
        JPanel p1 = new JPanel((LayoutManager)new PairLayout(0, 5));
        p1.add((Component)startLabel);
        p1.add(this.startField);
        JPanel p2 = new JPanel((LayoutManager)new PairLayout(0, 5));
        p2.add((Component)endLabel);
        p2.add(this.endField);
        JPanel p3 = new JPanel((LayoutManager)new PairLayout(0, 5));
        p3.add((Component)offsetLabel);
        p3.add(this.offsetField);
        JPanel p4 = new JPanel((LayoutManager)new PairLayout(0, 5));
        p4.add((Component)insertionLabel);
        p4.add(this.insertionField);
        JPanel[] panels = new JPanel[]{p1, p2, p3, p4};
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(Box.createHorizontalStrut(10));
        for (JPanel element : panels) {
            panel.add(element);
        }
        panel.add(Box.createHorizontalStrut(10));
        panel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        return panel;
    }

    private void updateIndexMap() {
        if (this.blockSet == null) {
            return;
        }
        ByteBlockInfo info = null;
        if (this.currentView != null) {
            info = this.currentView.getViewerCursorLocation();
        }
        this.indexMap = new IndexMap(this.blockSet, this.bytesPerLine, this.blockOffset);
        this.indexFactory.setIndexMap(this.indexMap);
        ByteBlock block = null;
        BigInteger offset = BigInteger.ZERO;
        if (info != null) {
            block = info.getBlock();
            offset = info.getOffset();
        }
        for (ByteViewerComponent c : this.viewList) {
            c.setIndexMap(this.indexMap);
            if (info == null) continue;
            c.setViewerCursorLocation(block, offset, info.getColumn());
        }
        this.indexSetChanged();
    }

    private void clearSelection() {
        for (ByteViewerComponent c : this.viewList) {
            c.clearViewerSelection();
        }
    }

    public boolean isUniform() {
        return true;
    }

    public Dimension getPreferredViewSize() {
        return new Dimension(100, 500);
    }

    public BigInteger getNumIndexes() {
        if (this.indexMap == null) {
            return BigInteger.ZERO;
        }
        return this.indexMap.getNumIndexes();
    }

    public Layout getLayout(BigInteger index) {
        BigInteger numIndexes = this.getNumIndexes();
        if (numIndexes.compareTo(BigInteger.ZERO) > 0 && index.compareTo(numIndexes) >= 0) {
            return null;
        }
        Field field = this.indexFactory.getField(index);
        if (field == null) {
            int height = this.fontMetrics.getMaxAscent() + this.fontMetrics.getMaxDescent();
            field = new EmptyTextField(height, this.indexFactory.getStartX(), 0, this.indexFactory.getWidth());
        }
        return new SingleRowLayout(field);
    }

    public void addLayoutModelListener(LayoutModelListener listener) {
        this.layoutListeners.add((Object)listener);
    }

    public void removeLayoutModelListener(LayoutModelListener listener) {
        this.layoutListeners.remove((Object)listener);
    }

    void indexSetChanged() {
        ((LayoutModelListener)this.layoutListeners.invoke()).modelSizeChanged(IndexMapper.IDENTITY_MAPPER);
    }

    private int getIndexSizeInChars() {
        int minChars = "Addresses".length();
        if (this.blocks != null) {
            for (ByteBlock element : this.blocks) {
                int charCount = element.getMaxLocationRepresentationSize();
                minChars = Math.max(minChars, charCount);
            }
        }
        return minChars;
    }

    public BigInteger getIndexAfter(BigInteger index) {
        BigInteger nextIndex = index.add(BigInteger.ONE);
        if (nextIndex.compareTo(this.indexMap.getNumIndexes()) >= 0) {
            return null;
        }
        return nextIndex;
    }

    public BigInteger getIndexBefore(BigInteger index) {
        if (index.equals(BigInteger.ZERO)) {
            return null;
        }
        return index.subtract(BigInteger.ONE);
    }

    public List<ByteViewerComponent> getViewList() {
        return this.viewList;
    }

    void setStatusMessage(String message) {
        this.provider.setStatusMessage(message);
    }

    public void flushChanges() {
    }

    protected AddressSetView computeVisibleAddresses(List<AnchoredLayout> layouts) {
        ByteViewerComponent component = this.getCurrentComponent();
        if (component == null || this.blockSet == null || layouts.isEmpty()) {
            return new AddressSet();
        }
        BigInteger startIndex = layouts.get(0).getIndex();
        BigInteger endIndex = layouts.get(layouts.size() - 1).getIndex();
        FieldSelection fieldSel = new FieldSelection();
        fieldSel.addRange(startIndex, endIndex.add(BigInteger.ONE));
        ByteBlockSelection blockSel = component.processFieldSelection(fieldSel);
        return this.blockSet.getAddressSet(blockSel);
    }

    public void layoutsChanged(List<AnchoredLayout> layouts) {
        AddressSetView visible = this.computeVisibleAddresses(layouts);
        for (AddressSetDisplayListener listener : this.displayListeners) {
            try {
                listener.visibleAddressesChanged(visible);
            }
            catch (Throwable t) {
                Msg.showError((Object)this, (Component)this.indexPanel, (String)"Error in Display Listener", (Object)"Exception encountered when notifying listeners of change in display", (Throwable)t);
            }
        }
    }

    public void addDisplayListener(AddressSetDisplayListener listener) {
        this.displayListeners.add(listener);
    }

    public void removeDisplayListener(AddressSetDisplayListener listener) {
        this.displayListeners.add(listener);
    }

    public int getViewWidth(String viewName) {
        return this.indexedView.getViewWidth(viewName);
    }

    public void setViewWidth(String viewName, int width) {
        this.indexedView.setColumnWidth(viewName, width);
    }

    private void updateFontDependantInfo() {
        this.fontMetrics = this.getFontMetrics(this.getFont());
        this.fontHeight = this.fontMetrics.getHeight();
        if (this.indexFactory != null) {
            this.indexFactory.setFontMetrics(this.fontMetrics);
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.updateFontDependantInfo();
    }
}

