/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.byteviewer;

import ghidra.app.plugin.core.format.ByteBlock;
import ghidra.app.plugin.core.format.ByteBlockAccessException;
import ghidra.util.DataConverter;
import ghidra.util.LittleEndianDataConverter;
import java.math.BigInteger;

class FileByteBlock
implements ByteBlock {
    private byte[] buf;
    private boolean bigEndian;
    private DataConverter converter;

    FileByteBlock(byte[] b) {
        this.buf = b;
        this.converter = LittleEndianDataConverter.INSTANCE;
    }

    @Override
    public String getLocationRepresentation(BigInteger bigIndex) {
        int index = bigIndex.intValue();
        return index < this.buf.length ? "%08d".formatted(index) : null;
    }

    @Override
    public int getMaxLocationRepresentationSize() {
        return 8;
    }

    @Override
    public String getIndexName() {
        return "Bytes";
    }

    @Override
    public BigInteger getLength() {
        return BigInteger.valueOf(this.buf.length);
    }

    @Override
    public byte getByte(BigInteger bigIndex) throws ByteBlockAccessException {
        int index = bigIndex.intValue();
        if (index < this.buf.length) {
            return this.buf[index];
        }
        return 0;
    }

    @Override
    public int getBytes(byte[] bytes, BigInteger bigIndex, int count) throws ByteBlockAccessException {
        int index = bigIndex.intValue();
        if (index < this.buf.length) {
            count = Math.min(count, this.buf.length - index);
            System.arraycopy(this.buf, index, bytes, 0, count);
            return count;
        }
        return 0;
    }

    @Override
    public short getShort(BigInteger bigIndex) throws ByteBlockAccessException {
        int index = bigIndex.intValue();
        if (index < this.buf.length) {
            byte[] b = new byte[2];
            System.arraycopy(this.buf, index, b, 0, b.length);
            return this.converter.getShort(b);
        }
        return 0;
    }

    @Override
    public int getInt(BigInteger bigIndex) throws ByteBlockAccessException {
        int index = bigIndex.intValue();
        if (index < this.buf.length) {
            byte[] b = new byte[4];
            System.arraycopy(this.buf, index, b, 0, b.length);
            return this.converter.getInt(b);
        }
        return 0;
    }

    @Override
    public long getLong(BigInteger bigIndex) throws ByteBlockAccessException {
        int index = bigIndex.intValue();
        if (index < this.buf.length) {
            byte[] b = new byte[8];
            System.arraycopy(this.buf, index, b, 0, b.length);
            return this.converter.getLong(b);
        }
        return 0L;
    }

    @Override
    public void setByte(BigInteger bigIndex, byte value) throws ByteBlockAccessException {
        int index = bigIndex.intValue();
        if (index < this.buf.length) {
            this.buf[index] = value;
        }
    }

    @Override
    public void setShort(BigInteger bigIndex, short value) throws ByteBlockAccessException {
        int index = bigIndex.intValue();
        if (index < this.buf.length) {
            byte[] b = new byte[2];
            this.converter.putShort(b, 0, value);
            System.arraycopy(b, 0, this.buf, index, b.length);
        }
    }

    @Override
    public void setInt(BigInteger bigIndex, int value) throws ByteBlockAccessException {
        int index = bigIndex.intValue();
        if (index < this.buf.length) {
            byte[] b = new byte[4];
            this.converter.putInt(b, 0, value);
            System.arraycopy(b, 0, this.buf, index, b.length);
        }
    }

    @Override
    public void setLong(BigInteger bigIndex, long value) throws ByteBlockAccessException {
        int index = bigIndex.intValue();
        if (index < this.buf.length) {
            byte[] b = new byte[8];
            this.converter.putLong(b, 0, value);
            System.arraycopy(b, 0, this.buf, index, b.length);
        }
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    @Override
    public void setBigEndian(boolean bigEndian) {
        if (this.bigEndian != bigEndian) {
            this.bigEndian = bigEndian;
            this.converter = DataConverter.getInstance((boolean)bigEndian);
        }
    }

    @Override
    public boolean isBigEndian() {
        return this.bigEndian;
    }

    @Override
    public int getAlignment(int radix) {
        return 0;
    }

    byte[] getBytes() {
        return this.buf;
    }
}

