/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.byteviewer;

import ghidra.app.plugin.core.format.ByteBlock;
import ghidra.app.plugin.core.format.ByteBlockAccessException;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import java.math.BigInteger;

public class MemoryByteBlock
implements ByteBlock {
    private MemoryBlock block;
    private Memory memory;
    private Address start;
    private boolean bigEndian;
    private Program program;

    protected MemoryByteBlock(Program program, Memory memory, MemoryBlock block) {
        this.program = program;
        this.memory = memory;
        this.block = block;
        this.start = block.getStart();
        this.bigEndian = memory.isBigEndian();
    }

    @Override
    public String getLocationRepresentation(BigInteger index) {
        Address addr = this.getAddress(index);
        if (!this.memory.contains(addr)) {
            return null;
        }
        return addr.toString();
    }

    @Override
    public int getMaxLocationRepresentationSize() {
        if (this.start == null) {
            return 1;
        }
        AddressSpace space = this.start.getAddressSpace();
        Address address = space.getAddress(1L);
        return address.toString(space.showSpaceName(), true).length();
    }

    @Override
    public String getIndexName() {
        return "Addresses";
    }

    @Override
    public BigInteger getLength() {
        return this.block.getSizeAsBigInteger();
    }

    @Override
    public void setByte(BigInteger index, byte value) throws ByteBlockAccessException {
        Address addr = this.getAddress(index);
        this.checkEditsAllowed(addr, 1L);
        try {
            this.memory.setByte(addr, value);
        }
        catch (MemoryAccessException e) {
            throw new ByteBlockAccessException(e.getMessage());
        }
    }

    @Override
    public byte getByte(BigInteger index) throws ByteBlockAccessException {
        Address addr = this.getAddress(index);
        try {
            return this.memory.getByte(addr);
        }
        catch (MemoryAccessException e) {
            throw new ByteBlockAccessException(e.getMessage());
        }
    }

    @Override
    public int getBytes(byte[] bytes, BigInteger index, int count) throws ByteBlockAccessException {
        try {
            Address addr = this.getAddress(index);
            return this.memory.getBytes(addr, bytes, 0, count);
        }
        catch (MemoryAccessException e) {
            throw new ByteBlockAccessException(e.getMessage());
        }
    }

    @Override
    public boolean hasValue(BigInteger index) {
        Address addr = this.getAddress(index);
        return this.memory.getAllInitializedAddressSet().contains(addr);
    }

    @Override
    public void setLong(BigInteger index, long value) throws ByteBlockAccessException {
        Address addr = this.getAddress(index);
        this.checkEditsAllowed(addr, 8L);
        try {
            this.memory.setLong(addr, value, this.bigEndian);
        }
        catch (MemoryAccessException e) {
            throw new ByteBlockAccessException(e.getMessage());
        }
    }

    @Override
    public long getLong(BigInteger index) throws ByteBlockAccessException {
        Address addr = this.getAddress(index);
        try {
            return this.memory.getLong(addr, this.bigEndian);
        }
        catch (MemoryAccessException e) {
            throw new ByteBlockAccessException(e.getMessage());
        }
    }

    @Override
    public void setBigEndian(boolean bigEndian) {
        this.bigEndian = bigEndian;
    }

    @Override
    public int getInt(BigInteger index) throws ByteBlockAccessException {
        Address addr = this.getAddress(index);
        try {
            return this.memory.getInt(addr, this.bigEndian);
        }
        catch (MemoryAccessException e) {
            throw new ByteBlockAccessException(e.getMessage());
        }
    }

    @Override
    public void setInt(BigInteger index, int value) throws ByteBlockAccessException {
        Address addr = this.getAddress(index);
        this.checkEditsAllowed(addr, 4L);
        try {
            this.memory.setInt(addr, value, this.bigEndian);
        }
        catch (MemoryAccessException e) {
            throw new ByteBlockAccessException(e.getMessage());
        }
    }

    @Override
    public short getShort(BigInteger index) throws ByteBlockAccessException {
        Address addr = this.getAddress(index);
        try {
            return this.memory.getShort(addr, this.bigEndian);
        }
        catch (MemoryAccessException e) {
            throw new ByteBlockAccessException(e.getMessage());
        }
    }

    @Override
    public void setShort(BigInteger index, short value) throws ByteBlockAccessException {
        Address addr = this.getAddress(index);
        this.checkEditsAllowed(addr, 2L);
        try {
            this.memory.setShort(addr, value, this.bigEndian);
        }
        catch (MemoryAccessException e) {
            throw new ByteBlockAccessException(e.getMessage());
        }
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    @Override
    public boolean isBigEndian() {
        return this.bigEndian;
    }

    @Override
    public int getAlignment(int radix) {
        return (int)(this.start.getOffset() % (long)radix);
    }

    public Address getAddress(BigInteger index) {
        try {
            return this.start.addNoWrap(index);
        }
        catch (AddressOverflowException e) {
            throw new IndexOutOfBoundsException("Index " + String.valueOf(index) + " is not in this block");
        }
    }

    public BigInteger getIndex(Address addr) {
        return addr.getOffsetAsBigInteger().subtract(this.start.getOffsetAsBigInteger());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MemoryByteBlock mb = (MemoryByteBlock)obj;
        return this.block == mb.block;
    }

    protected void checkEditsAllowed(Address addr, long length) throws ByteBlockAccessException {
        if (!this.editAllowed(addr, length)) {
            String msg = "Instruction exists at address " + String.valueOf(addr);
            if (length > 1L) {
                Address toAddr = null;
                try {
                    toAddr = addr.addNoWrap(length);
                }
                catch (AddressOverflowException addressOverflowException) {
                    // empty catch block
                }
                msg = "Instruction exists in address range " + String.valueOf(addr) + " to " + String.valueOf(toAddr);
            }
            throw new ByteBlockAccessException(msg);
        }
    }

    protected boolean editAllowed(Address addr, long length) {
        Listing listing = this.program.getListing();
        Address a = addr;
        int i = 0;
        while ((long)i < length) {
            try {
                a = a.addNoWrap((long)i);
            }
            catch (AddressOverflowException e) {
                return false;
            }
            CodeUnit cu = listing.getCodeUnitContaining(a);
            if (!(cu instanceof Data)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

