/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.format;

import ghidra.app.plugin.core.format.ByteBlock;
import ghidra.app.plugin.core.format.ByteBlockAccessException;
import ghidra.app.plugin.core.format.DataFormatModel;
import ghidra.app.plugin.core.format.MutableDataFormatModel;
import ghidra.app.plugin.core.format.UniversalDataFormatModel;
import ghidra.util.HelpLocation;
import java.math.BigInteger;

public class BinaryFormatModel
implements UniversalDataFormatModel,
MutableDataFormatModel {
    private int symbolSize = 8;
    private static final String GOOD_CHARS = "01";

    @Override
    public String getName() {
        return "Binary";
    }

    @Override
    public int getUnitByteSize() {
        return 1;
    }

    @Override
    public int getByteOffset(ByteBlock block, int position) {
        return 0;
    }

    @Override
    public int getColumnPosition(ByteBlock block, int byteOffset) {
        return 0;
    }

    @Override
    public int getDataUnitSymbolSize() {
        return this.symbolSize;
    }

    @Override
    public String getDataRepresentation(ByteBlock block, BigInteger index) throws ByteBlockAccessException {
        int b;
        int i = b = block.getByte(index);
        String str = Integer.toBinaryString(i &= 0xFF);
        if (str.length() > this.symbolSize) {
            str = str.substring(str.length() - this.symbolSize);
        }
        return DataFormatModel.pad(str, this.symbolSize);
    }

    @Override
    public boolean replaceValue(ByteBlock block, BigInteger index, int charPosition, char c) throws ByteBlockAccessException {
        if (charPosition < 0 || charPosition > 7) {
            return false;
        }
        if (GOOD_CHARS.indexOf(c) == -1) {
            return false;
        }
        if (charPosition == 0 && GOOD_CHARS.indexOf(c) > 1) {
            return false;
        }
        byte b = block.getByte(index);
        char[] charArray = new char[]{c};
        byte cb = Byte.parseByte(new String(charArray), 2);
        byte mask = (byte)(1 << 7 - charPosition);
        b = (byte)(b & ~mask);
        if (cb == 1) {
            b = (byte)(b | mask);
        }
        block.setByte(index, b);
        return true;
    }

    @Override
    public int getUnitDelimiterSize() {
        return 1;
    }

    @Override
    public HelpLocation getHelpLocation() {
        return new HelpLocation("ByteViewerPlugin", "Binary");
    }
}

