/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.format;

import ghidra.app.plugin.core.format.ByteBlock;
import ghidra.app.plugin.core.format.ByteBlockAccessException;
import ghidra.app.plugin.core.format.HexValueFormatModel;
import ghidra.util.DataConverter;
import java.math.BigInteger;

public class HexLongLongFormatModel
extends HexValueFormatModel {
    public HexLongLongFormatModel() {
        super("Hex Long Long", 16);
    }

    @Override
    public String getDataRepresentation(ByteBlock block, BigInteger index) throws ByteBlockAccessException {
        byte[] bytes = new byte[this.nbytes];
        if (block.getBytes(bytes, index, this.nbytes) != this.nbytes) {
            return this.fullSymbolErrorStr;
        }
        DataConverter dc = DataConverter.getInstance((boolean)block.isBigEndian());
        BigInteger val = dc.getBigInteger(bytes, this.nbytes, false);
        return "%032x".formatted(val);
    }
}

