/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.cliwrapper;

import ghidra.file.cliwrapper.CliToolWrapper;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.framework.OperatingSystem;
import ghidra.util.Msg;
import ghidra.util.task.CancelledListener;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.UnknownProgressWrappingTaskMonitor;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.io.FilenameUtils;

public abstract class AbstractCliToolWrapper
implements CliToolWrapper {
    private static final long DEFAULT_TIMEOUT_MS = 5000L;
    protected long timeoutMS = 5000L;
    protected File nativeExecutable;

    public static File findInOSPathEnv(String name) {
        for (String pathEntry : System.getenv("PATH").split(File.pathSeparator)) {
            try {
                File pathDir = new File(pathEntry);
                File testFile = AbstractCliToolWrapper.normalizeExecutablePath(new File(pathDir, name));
                if (testFile == null) continue;
                return testFile;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static File normalizeExecutablePath(File f) throws IOException {
        if (OperatingSystem.CURRENT_OPERATING_SYSTEM == OperatingSystem.WINDOWS && !FilenameUtils.getExtension((String)f.getName()).equals("exe")) {
            f = new File(f.getParentFile(), f.getName() + ".exe");
        }
        return f.isFile() ? f.getCanonicalFile() : null;
    }

    public static <T extends AbstractCliToolWrapper> T findToolWrapper(List<String> exeNames, TaskMonitor monitor, Function<File, T> toolCreator) {
        for (String exeName : exeNames) {
            AbstractCliToolWrapper tmp;
            File exeFile = AbstractCliToolWrapper.findInOSPathEnv(exeName);
            if (exeFile == null || !(tmp = (AbstractCliToolWrapper)toolCreator.apply(exeFile)).isValid(monitor)) continue;
            return (T)tmp;
        }
        return null;
    }

    protected AbstractCliToolWrapper(File nativeExecutable) {
        this.nativeExecutable = nativeExecutable;
    }

    protected List<String> getCmdLine(List<String> args) {
        ArrayList<String> cmdLine = new ArrayList<String>(args.size() + 1);
        cmdLine.add(this.nativeExecutable.getPath());
        cmdLine.addAll(args);
        return cmdLine;
    }

    protected int execAndReadStdOut(List<String> args, TaskMonitor monitor, Consumer<String> stdoutConsumer) throws IOException {
        List<String> cmd = this.getCmdLine(args);
        Process process = new ProcessBuilder(cmd).redirectError(ProcessBuilder.Redirect.DISCARD).start();
        process.getOutputStream().close();
        CancelledListener l = () -> process.destroyForcibly();
        try {
            String line;
            monitor.addCancelledListener(l);
            BufferedReader inputReader = process.inputReader();
            while (!monitor.isCancelled() && (line = inputReader.readLine()) != null) {
                stdoutConsumer.accept(line);
            }
            if (!monitor.isCancelled() && process.waitFor(this.timeoutMS, TimeUnit.MILLISECONDS)) {
                int n = process.exitValue();
                return n;
            }
            try {
                process.destroyForcibly();
                throw new IOException("Process %s timeout".formatted(cmd));
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }
        finally {
            monitor.removeCancelledListener(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int execAndRedirectStdOut(List<String> args, InputStream is, OutputStream os, TaskMonitor monitor) throws IOException {
        UnknownProgressWrappingTaskMonitor upwtm = new UnknownProgressWrappingTaskMonitor(monitor);
        List<String> cmd = this.getCmdLine(args);
        Process process = new ProcessBuilder(cmd).redirectError(ProcessBuilder.Redirect.DISCARD).start();
        CancelledListener l = () -> process.destroyForcibly();
        try {
            int bytesRead;
            monitor.addCancelledListener(l);
            if (is != null) {
                OutputStream processStdin = process.getOutputStream();
                Thread stdinThread = new Thread(() -> this.lambda$execAndRedirectStdOut$2((TaskMonitor)upwtm, is, processStdin), this.nativeExecutable.getName() + " stdin stream");
                stdinThread.setDaemon(true);
                stdinThread.start();
            }
            InputStream processStdout = process.getInputStream();
            byte[] buffer = new byte[65536];
            long totalBytesRead = 0L;
            while (!monitor.isCancelled() && (bytesRead = processStdout.read(buffer)) > 0) {
                os.write(buffer, 0, bytesRead);
                upwtm.setProgress(totalBytesRead += (long)bytesRead);
            }
        }
        finally {
            monitor.removeCancelledListener(l);
        }
        try {
            if (!monitor.isCancelled() && process.waitFor(this.timeoutMS, TimeUnit.MILLISECONDS)) {
                return process.exitValue();
            }
            process.destroyForcibly();
            throw new IOException("Process %s timeout".formatted(cmd));
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$execAndRedirectStdOut$2(TaskMonitor upwtm, InputStream is, OutputStream processStdin) {
        byte[] buffer = new byte[65536];
        try {
            int bytesRead;
            while (!upwtm.isCancelled() && (bytesRead = is.read(buffer)) > 0) {
                processStdin.write(buffer, 0, bytesRead);
            }
            processStdin.flush();
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)"Error streaming to tool stdin", (Throwable)e);
        }
        finally {
            FSUtilities.uncheckedClose((AutoCloseable)processStdin, null);
        }
    }
}

