/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.util;

import ghidra.app.util.bin.ByteProvider;
import ghidra.file.formats.android.util.OverlayRange;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class OverlayByteProvider
implements ByteProvider {
    private ByteProvider provider;
    private List<OverlayRange> overlayList = new ArrayList<OverlayRange>();

    public OverlayByteProvider(ByteProvider provider) {
        this.provider = provider;
    }

    public void addRange(OverlayRange range) {
        this.overlayList.add(range);
    }

    public File getFile() {
        return this.provider.getFile();
    }

    public String getName() {
        return this.provider.getName();
    }

    public String getAbsolutePath() {
        return this.provider.getAbsolutePath();
    }

    public long length() {
        long currentMax = 0L;
        for (OverlayRange range : this.overlayList) {
            currentMax = Math.max(currentMax, (long)range.getEndIndex());
        }
        return Math.max(currentMax, this.provider.length());
    }

    public boolean isValidIndex(long index) {
        for (OverlayRange range : this.overlayList) {
            if (!range.containsIndex(index)) continue;
            return true;
        }
        return this.provider.isValidIndex(index);
    }

    public void close() throws IOException {
        this.provider.close();
    }

    public byte readByte(long index) throws IOException {
        for (OverlayRange range : this.overlayList) {
            if (!range.containsIndex(index)) continue;
            return range.getByte(index);
        }
        return this.provider.readByte(index);
    }

    public byte[] readBytes(long index, long length) throws IOException {
        for (OverlayRange range : this.overlayList) {
            if (!range.containsIndex(index)) continue;
            return range.getBytes(index, length);
        }
        return this.provider.readBytes(index, length);
    }

    public InputStream getInputStream(long index) throws IOException {
        throw new IOException("get input stream is not supported");
    }
}

