/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.cpio;

import ghidra.app.util.bin.ByteProvider;
import ghidra.file.formats.cpio.CpioFileSystemFactory;
import ghidra.formats.gfilesystem.AbstractFileSystem;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.formats.gfilesystem.fileinfo.FileAttributeType;
import ghidra.formats.gfilesystem.fileinfo.FileAttributes;
import ghidra.formats.gfilesystem.fileinfo.FileType;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.EOFException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.commons.compress.archivers.cpio.CpioArchiveEntry;
import org.apache.commons.compress.archivers.cpio.CpioArchiveInputStream;

@FileSystemInfo(type="cpio", description="CPIO", factory=CpioFileSystemFactory.class)
public class CpioFileSystem
extends AbstractFileSystem<CpioArchiveEntry> {
    private static final int MAX_SANE_SYMLINK = 65536;
    private ByteProvider provider;

    public CpioFileSystem(FSRLRoot fsFSRL, ByteProvider provider, FileSystemService fsService, TaskMonitor monitor) throws IOException {
        super(fsFSRL, fsService);
        monitor.setMessage("Opening CPIO...");
        this.provider = provider;
        try (CpioArchiveInputStream cpioInputStream2 = new CpioArchiveInputStream(provider.getInputStream(0L));){
            CpioArchiveEntry entry;
            int fileNum = 0;
            while ((entry = cpioInputStream2.getNextEntry()) != null) {
                monitor.setMessage(entry.getName());
                if (entry.isSymbolicLink()) {
                    String linkDest = entry.getSize() < 65536L ? new String(cpioInputStream2.readAllBytes(), StandardCharsets.UTF_8) : "???badsymlink???";
                    this.fsIndex.storeSymlink(entry.getName(), (long)fileNum++, linkDest, entry.getSize(), (Object)entry);
                    continue;
                }
                this.fsIndex.storeFile(entry.getName(), (long)fileNum++, entry.isDirectory(), entry.getSize(), (Object)entry);
            }
        }
        catch (EOFException cpioInputStream2) {
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void close() throws IOException {
        this.refManager.onClose();
        this.fsIndex.clear();
        if (this.provider != null) {
            this.provider.close();
            this.provider = null;
        }
    }

    public boolean isClosed() {
        return this.provider == null;
    }

    public FileAttributes getFileAttributes(GFile file, TaskMonitor monitor) {
        FileAttributes result = new FileAttributes();
        CpioArchiveEntry entry = (CpioArchiveEntry)this.fsIndex.getMetadata(file);
        if (entry != null) {
            result.add(FileAttributeType.NAME_ATTR, (Object)entry.getName());
            result.add(FileAttributeType.SIZE_ATTR, (Object)entry.getSize());
            result.add(FileAttributeType.MODIFIED_DATE_ATTR, (Object)entry.getLastModifiedDate());
            result.add(FileAttributeType.USER_ID_ATTR, (Object)entry.getUID());
            result.add(FileAttributeType.GROUP_ID_ATTR, (Object)entry.getGID());
            result.add(FileAttributeType.FILE_TYPE_ATTR, (Object)this.getFileType(entry));
            result.add(FileAttributeType.SYMLINK_DEST_ATTR, (Object)this.fsIndex.getSymlinkPath(file));
            result.add("Mode", (Object)Long.toHexString(entry.getMode()));
            result.add("Inode", (Object)Long.toHexString(entry.getInode()));
            result.add("Format", (Object)Long.toHexString(entry.getFormat()));
            try {
                result.add("Device ID", (Object)Long.toHexString(entry.getDevice()));
                result.add("Remote Device", (Object)Long.toHexString(entry.getRemoteDevice()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                result.add("Checksum", (Object)Long.toHexString(entry.getChksum()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public FileType getFileType(GFile f, TaskMonitor monitor) {
        CpioArchiveEntry entry = (CpioArchiveEntry)this.fsIndex.getMetadata(f);
        return entry != null ? this.getFileType(entry) : FileType.UNKNOWN;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ByteProvider getByteProvider(GFile file, TaskMonitor monitor) throws IOException, CancelledException {
        CpioArchiveEntry targetEntry = (CpioArchiveEntry)this.fsIndex.getMetadata(file = this.fsIndex.resolveSymlinks(file));
        if (targetEntry == null) {
            return null;
        }
        if (!targetEntry.isRegularFile()) {
            throw new IOException("CPIO entry " + file.getName() + " is not a regular file.");
        }
        try (CpioArchiveInputStream cpioInputStream = new CpioArchiveInputStream(this.provider.getInputStream(0L));){
            ByteProvider bp;
            CpioArchiveEntry currentEntry;
            do {
                if ((currentEntry = cpioInputStream.getNextEntry()) == null) throw new IOException("Unable to seek to entry: " + file.getName());
            } while (!currentEntry.equals((Object)targetEntry));
            ByteProvider byteProvider = bp = this.fsService.getDerivedByteProvider(this.provider.getFSRL(), file.getFSRL(), file.getPath(), currentEntry.getSize(), () -> cpioInputStream, monitor);
            return byteProvider;
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e);
        }
    }

    private FileType getFileType(CpioArchiveEntry entry) {
        if (entry.isSymbolicLink()) {
            return FileType.SYMBOLIC_LINK;
        }
        if (entry.isDirectory()) {
            return FileType.DIRECTORY;
        }
        if (entry.isRegularFile()) {
            return FileType.FILE;
        }
        return FileType.OTHER;
    }
}

