/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.lzfse;

import ghidra.app.util.bin.ByteProvider;
import ghidra.file.formats.lzfse.LzfseCliToolWrapper;
import ghidra.file.formats.lzfse.LzfseFileSystem;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.factory.FileSystemFactoryDependencyException;
import ghidra.formats.gfilesystem.factory.GFileSystemFactoryByteProvider;
import ghidra.formats.gfilesystem.factory.GFileSystemProbeBytesOnly;
import ghidra.formats.gfilesystem.fileinfo.FileAttribute;
import ghidra.formats.gfilesystem.fileinfo.FileAttributeType;
import ghidra.formats.gfilesystem.fileinfo.FileAttributes;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class LzfseFileSystemFactory
implements GFileSystemFactoryByteProvider<LzfseFileSystem>,
GFileSystemProbeBytesOnly {
    private static final int START_BYTES_REQUIRED = 4;
    private static final int LZFSE_ENDOFSTREAM_BLOCK_MAGIC = 611874402;
    private static final int LZFSE_UNCOMPRESSED_BLOCK_MAGIC = 762869346;
    private static final int LZFSE_COMPRESSEDV1_BLOCK_MAGIC = 829978210;
    private static final int LZFSE_COMPRESSEDV2_BLOCK_MAGIC = 846755426;
    private static final int LZFSE_COMPRESSEDLZVN_BLOCK_MAGIC = 1853388386;
    private LzfseCliToolWrapper cliTool;

    public int getBytesRequired() {
        return 4;
    }

    public boolean probeStartBytes(FSRL containerFSRL, byte[] startBytes) {
        int startValue = ByteBuffer.wrap(startBytes).order(ByteOrder.LITTLE_ENDIAN).getInt();
        return switch (startValue) {
            case 611874402, 762869346, 829978210, 846755426, 1853388386 -> true;
            default -> false;
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GFileSystem create(FSRLRoot targetFSRL, ByteProvider byteProvider, FileSystemService fsService, TaskMonitor monitor) throws IOException, CancelledException {
        try {
            LzfseFileSystem fs;
            this.ensureTool(monitor);
            ByteProvider payloadProvider = fsService.getDerivedByteProviderPush(byteProvider.getFSRL(), null, "lzfse_decompressed", -1L, os -> {
                try (InputStream is = byteProvider.getInputStream(0L);){
                    this.cliTool.decompressStream(is, os, monitor);
                }
            }, monitor);
            FileAttributes fileAttrs = FileAttributes.of((FileAttribute[])new FileAttribute[]{FileAttribute.create((FileAttributeType)FileAttributeType.COMPRESSED_SIZE_ATTR, (Object)byteProvider.length()), FileAttribute.create((FileAttributeType)FileAttributeType.SIZE_ATTR, (Object)payloadProvider.length())});
            LzfseFileSystem lzfseFileSystem = fs = new LzfseFileSystem(targetFSRL, payloadProvider, "lzfse_decompressed", fileAttrs);
            return lzfseFileSystem;
        }
        finally {
            FSUtilities.uncheckedClose((AutoCloseable)byteProvider, null);
        }
    }

    private void ensureTool(TaskMonitor monitor) throws IOException {
        if (this.cliTool == null) {
            this.cliTool = LzfseCliToolWrapper.findTool(monitor);
        }
        if (this.cliTool == null) {
            throw new FileSystemFactoryDependencyException("lzfse native decompressor not present");
        }
    }
}

