/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.sparseimage;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.file.formats.sparseimage.SparseHeader;
import ghidra.file.formats.sparseimage.SparseImageDecompressor;
import ghidra.file.formats.sparseimage.SparseImageFileSystem;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.factory.GFileSystemFactoryByteProvider;
import ghidra.formats.gfilesystem.factory.GFileSystemProbeByteProvider;
import ghidra.formats.gfilesystem.fileinfo.FileAttribute;
import ghidra.formats.gfilesystem.fileinfo.FileAttributeType;
import ghidra.formats.gfilesystem.fileinfo.FileAttributes;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class SparseImageFileSystemFactory
implements GFileSystemFactoryByteProvider<SparseImageFileSystem>,
GFileSystemProbeByteProvider {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SparseImageFileSystem create(FSRLRoot targetFSRL, ByteProvider byteProvider, FileSystemService fsService, TaskMonitor monitor) throws IOException, CancelledException {
        try {
            ByteProvider payloadProvider = fsService.getDerivedByteProviderPush(byteProvider.getFSRL(), null, "sparse", -1L, os -> {
                SparseImageDecompressor sid = new SparseImageDecompressor(byteProvider, os);
                sid.decompress(monitor);
            }, monitor);
            FileAttributes payloadAttrs = FileAttributes.of((FileAttribute[])new FileAttribute[]{FileAttribute.create((FileAttributeType)FileAttributeType.SIZE_ATTR, (Object)payloadProvider.length()), FileAttribute.create((FileAttributeType)FileAttributeType.COMPRESSED_SIZE_ATTR, (Object)byteProvider.length())});
            String payloadName = targetFSRL.getContainer().getName() + ".raw";
            SparseImageFileSystem sparseImageFileSystem = new SparseImageFileSystem(targetFSRL, payloadProvider, payloadName, payloadAttrs);
            return sparseImageFileSystem;
        }
        finally {
            FSUtilities.uncheckedClose((AutoCloseable)byteProvider, null);
        }
    }

    public boolean probe(ByteProvider byteProvider, FileSystemService fsService, TaskMonitor taskMonitor) throws IOException, CancelledException {
        BinaryReader reader = new BinaryReader(byteProvider, true);
        SparseHeader header = new SparseHeader(reader);
        return header.getMagic() == -316211398;
    }
}

