/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.zstd;

import ghidra.app.util.bin.ByteProvider;
import ghidra.file.cliwrapper.ArchiverCliToolWrapper;
import ghidra.file.cliwrapper.CliToolWrapper;
import ghidra.file.cliwrapper.StreamDecompressorCliToolWrapper;
import ghidra.file.formats.sevenzip.SevenZipCliToolWrapper;
import ghidra.file.formats.zstd.ZstdCliToolWrapper;
import ghidra.file.formats.zstd.ZstdFileSystem;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.factory.FileSystemFactoryDependencyException;
import ghidra.formats.gfilesystem.factory.GFileSystemFactoryByteProvider;
import ghidra.formats.gfilesystem.factory.GFileSystemProbeBytesOnly;
import ghidra.formats.gfilesystem.fileinfo.FileAttribute;
import ghidra.formats.gfilesystem.fileinfo.FileAttributeType;
import ghidra.formats.gfilesystem.fileinfo.FileAttributes;
import ghidra.util.NumericUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;

public class ZstdFileSystemFactory
implements GFileSystemFactoryByteProvider<ZstdFileSystem>,
GFileSystemProbeBytesOnly {
    private static final byte[] MAGIC = NumericUtilities.convertStringToBytes((String)"28b52ffd");
    private CliToolWrapper cliTool;

    public int getBytesRequired() {
        return MAGIC.length;
    }

    public boolean probeStartBytes(FSRL containerFSRL, byte[] startBytes) {
        return Arrays.equals(startBytes, 0, MAGIC.length, MAGIC, 0, MAGIC.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GFileSystem create(FSRLRoot targetFSRL, ByteProvider byteProvider, FileSystemService fsService, TaskMonitor monitor) throws IOException, CancelledException {
        try {
            ZstdFileSystem fs;
            this.ensureTool(monitor);
            String containerName = targetFSRL.getContainer().getName();
            String payloadFilename = containerName.endsWith(".zstd") ? containerName.substring(0, containerName.length() - ".zstd".length()) : containerName + ".uncompressed";
            ByteProvider payloadProvider = this.extract(byteProvider, fsService, monitor);
            FileAttributes fileAttrs = FileAttributes.of((FileAttribute[])new FileAttribute[]{FileAttribute.create((FileAttributeType)FileAttributeType.COMPRESSED_SIZE_ATTR, (Object)byteProvider.length()), FileAttribute.create((FileAttributeType)FileAttributeType.SIZE_ATTR, (Object)payloadProvider.length())});
            ZstdFileSystem zstdFileSystem = fs = new ZstdFileSystem(targetFSRL, payloadProvider, payloadFilename, fileAttrs);
            return zstdFileSystem;
        }
        finally {
            byteProvider.close();
        }
    }

    ByteProvider extract(ByteProvider byteProvider, FileSystemService fsService, TaskMonitor monitor) throws CancelledException, IOException {
        return fsService.getDerivedByteProviderPush(byteProvider.getFSRL(), null, "zstd decompressed", -1L, os -> {
            CliToolWrapper patt0$temp = this.cliTool;
            if (patt0$temp instanceof StreamDecompressorCliToolWrapper) {
                StreamDecompressorCliToolWrapper decompTool = (StreamDecompressorCliToolWrapper)patt0$temp;
                try (InputStream is = byteProvider.getInputStream(0L);){
                    decompTool.decompressStream(is, os, monitor);
                    return;
                }
            }
            CliToolWrapper patt1$temp = this.cliTool;
            if (patt1$temp instanceof ArchiverCliToolWrapper) {
                ArchiverCliToolWrapper archiverTool = (ArchiverCliToolWrapper)patt1$temp;
                File f = fsService.getFileIfAvailable(byteProvider);
                File tmpFile = f == null ? fsService.createPlaintextTempFile(byteProvider, "zstd_tmp_", monitor) : null;
                File archiveFile = f != null ? f : tmpFile;
                try {
                    List<ArchiverCliToolWrapper.Entry> listing = archiverTool.getListing(archiveFile, monitor);
                    if (listing.size() == 1) {
                        archiverTool.extract(archiveFile, listing.get(0), os, monitor);
                        return;
                    }
                }
                finally {
                    if (tmpFile != null) {
                        tmpFile.delete();
                    }
                }
            }
            throw new IOException("Failed to extract " + String.valueOf(byteProvider.getFSRL()));
        }, monitor);
    }

    private void ensureTool(TaskMonitor monitor) throws IOException {
        if (this.cliTool == null) {
            this.cliTool = ZstdCliToolWrapper.findTool(monitor);
        }
        if (this.cliTool == null) {
            this.cliTool = SevenZipCliToolWrapper.findTool(monitor);
        }
        if (this.cliTool == null) {
            throw new FileSystemFactoryDependencyException("No zstd or 7z cli tool found in PATH");
        }
    }
}

