/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.demangler.swift.nodes;

import ghidra.app.util.demangler.Demangled;
import ghidra.app.util.demangler.DemangledException;
import ghidra.app.util.demangler.DemangledUnknown;
import ghidra.app.util.demangler.swift.SwiftDemangledNodeKind;
import ghidra.app.util.demangler.swift.SwiftDemangler;
import ghidra.app.util.demangler.swift.nodes.SwiftAllocatorNode;
import ghidra.app.util.demangler.swift.nodes.SwiftBoundGenericStructureNode;
import ghidra.app.util.demangler.swift.nodes.SwiftBuiltinTypeNameNode;
import ghidra.app.util.demangler.swift.nodes.SwiftClassNode;
import ghidra.app.util.demangler.swift.nodes.SwiftConstructorNode;
import ghidra.app.util.demangler.swift.nodes.SwiftDeallocatorNode;
import ghidra.app.util.demangler.swift.nodes.SwiftDependentGenericParamTypeNode;
import ghidra.app.util.demangler.swift.nodes.SwiftDependentGenericTypeNode;
import ghidra.app.util.demangler.swift.nodes.SwiftDestructorNode;
import ghidra.app.util.demangler.swift.nodes.SwiftEnumNode;
import ghidra.app.util.demangler.swift.nodes.SwiftExtensionNode;
import ghidra.app.util.demangler.swift.nodes.SwiftFunctionNode;
import ghidra.app.util.demangler.swift.nodes.SwiftFunctionTypeNode;
import ghidra.app.util.demangler.swift.nodes.SwiftGetterNode;
import ghidra.app.util.demangler.swift.nodes.SwiftGlobalNode;
import ghidra.app.util.demangler.swift.nodes.SwiftGlobalVariableOnceDeclListNode;
import ghidra.app.util.demangler.swift.nodes.SwiftGlobalVariableOnceFunctionNode;
import ghidra.app.util.demangler.swift.nodes.SwiftInOutNode;
import ghidra.app.util.demangler.swift.nodes.SwiftInitializerNode;
import ghidra.app.util.demangler.swift.nodes.SwiftLabelListNode;
import ghidra.app.util.demangler.swift.nodes.SwiftLazyProtocolWitnessTableAccessorNode;
import ghidra.app.util.demangler.swift.nodes.SwiftLocalDeclNameNode;
import ghidra.app.util.demangler.swift.nodes.SwiftModifyAccessorNode;
import ghidra.app.util.demangler.swift.nodes.SwiftOutlinedConsumeNode;
import ghidra.app.util.demangler.swift.nodes.SwiftOutlinedCopyNode;
import ghidra.app.util.demangler.swift.nodes.SwiftPrivateDeclNameNode;
import ghidra.app.util.demangler.swift.nodes.SwiftProtocolConformanceNode;
import ghidra.app.util.demangler.swift.nodes.SwiftProtocolNode;
import ghidra.app.util.demangler.swift.nodes.SwiftSetterNode;
import ghidra.app.util.demangler.swift.nodes.SwiftStructureNode;
import ghidra.app.util.demangler.swift.nodes.SwiftSubscriptNode;
import ghidra.app.util.demangler.swift.nodes.SwiftTupleElementNode;
import ghidra.app.util.demangler.swift.nodes.SwiftTupleNode;
import ghidra.app.util.demangler.swift.nodes.SwiftTypeAliasNode;
import ghidra.app.util.demangler.swift.nodes.SwiftTypeListNode;
import ghidra.app.util.demangler.swift.nodes.SwiftTypeMetadataAccessFunctionNode;
import ghidra.app.util.demangler.swift.nodes.SwiftUnsafeMutableAddressorNode;
import ghidra.app.util.demangler.swift.nodes.SwiftUnsupportedNode;
import ghidra.app.util.demangler.swift.nodes.SwiftVariableNode;
import ghidra.app.util.demangler.swift.nodes.generic.SwiftGenericDescriptorNode;
import ghidra.app.util.demangler.swift.nodes.generic.SwiftGenericIndexNode;
import ghidra.app.util.demangler.swift.nodes.generic.SwiftGenericPassthroughNode;
import ghidra.app.util.demangler.swift.nodes.generic.SwiftGenericTextNode;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

public abstract class SwiftNode {
    protected NodeProperties properties;
    private SwiftNode parent;
    private List<SwiftNode> children = new ArrayList<SwiftNode>();
    private boolean childSkipped = false;

    public static SwiftNode get(NodeProperties props) {
        SwiftNode node = switch (props.kind()) {
            case SwiftDemangledNodeKind.Allocator -> new SwiftAllocatorNode();
            case SwiftDemangledNodeKind.AnonymousDescriptor -> new SwiftGenericDescriptorNode();
            case SwiftDemangledNodeKind.ArgumentTuple -> new SwiftGenericPassthroughNode();
            case SwiftDemangledNodeKind.BoundGenericStructure -> new SwiftBoundGenericStructureNode();
            case SwiftDemangledNodeKind.BuiltinTypeName -> new SwiftBuiltinTypeNameNode();
            case SwiftDemangledNodeKind.Class -> new SwiftClassNode();
            case SwiftDemangledNodeKind.Constructor -> new SwiftConstructorNode();
            case SwiftDemangledNodeKind.Deallocator -> new SwiftDeallocatorNode();
            case SwiftDemangledNodeKind.DefaultArgumentInitializer -> new SwiftGenericPassthroughNode();
            case SwiftDemangledNodeKind.DependentGenericParamType -> new SwiftDependentGenericParamTypeNode();
            case SwiftDemangledNodeKind.DependentGenericType -> new SwiftDependentGenericTypeNode();
            case SwiftDemangledNodeKind.Destructor -> new SwiftDestructorNode();
            case SwiftDemangledNodeKind.DispatchThunk -> new SwiftGenericPassthroughNode();
            case SwiftDemangledNodeKind.Enum -> new SwiftEnumNode();
            case SwiftDemangledNodeKind.Extension -> new SwiftExtensionNode();
            case SwiftDemangledNodeKind.Function -> new SwiftFunctionNode();
            case SwiftDemangledNodeKind.FunctionType -> new SwiftFunctionTypeNode();
            case SwiftDemangledNodeKind.GenericSpecialization -> new SwiftGenericTextNode();
            case SwiftDemangledNodeKind.Getter -> new SwiftGetterNode();
            case SwiftDemangledNodeKind.Global -> new SwiftGlobalNode();
            case SwiftDemangledNodeKind.GlobalVariableOnceDeclList -> new SwiftGlobalVariableOnceDeclListNode();
            case SwiftDemangledNodeKind.GlobalVariableOnceFunction -> new SwiftGlobalVariableOnceFunctionNode();
            case SwiftDemangledNodeKind.Identifier -> new SwiftGenericTextNode();
            case SwiftDemangledNodeKind.InfixOperator -> new SwiftGenericTextNode();
            case SwiftDemangledNodeKind.Initializer -> new SwiftInitializerNode();
            case SwiftDemangledNodeKind.InOut -> new SwiftInOutNode();
            case SwiftDemangledNodeKind.LabelList -> new SwiftLabelListNode();
            case SwiftDemangledNodeKind.LazyProtocolWitnessTableAccessor -> new SwiftLazyProtocolWitnessTableAccessorNode();
            case SwiftDemangledNodeKind.LocalDeclName -> new SwiftLocalDeclNameNode();
            case SwiftDemangledNodeKind.MergedFunction -> new SwiftGenericPassthroughNode();
            case SwiftDemangledNodeKind.MethodDescriptor -> new SwiftGenericDescriptorNode();
            case SwiftDemangledNodeKind.ModifyAccessor -> new SwiftModifyAccessorNode();
            case SwiftDemangledNodeKind.Module -> new SwiftGenericTextNode();
            case SwiftDemangledNodeKind.ModuleDescriptor -> new SwiftGenericDescriptorNode();
            case SwiftDemangledNodeKind.NominalTypeDescriptor -> new SwiftGenericDescriptorNode();
            case SwiftDemangledNodeKind.Number -> new SwiftGenericIndexNode();
            case SwiftDemangledNodeKind.ObjCAttribute -> new SwiftGenericTextNode();
            case SwiftDemangledNodeKind.OutlinedConsume -> new SwiftOutlinedConsumeNode();
            case SwiftDemangledNodeKind.OutlinedCopy -> new SwiftOutlinedCopyNode();
            case SwiftDemangledNodeKind.Owned -> new SwiftGenericPassthroughNode();
            case SwiftDemangledNodeKind.PrivateDeclName -> new SwiftPrivateDeclNameNode();
            case SwiftDemangledNodeKind.Protocol -> new SwiftProtocolNode();
            case SwiftDemangledNodeKind.ProtocolConformance -> new SwiftProtocolConformanceNode();
            case SwiftDemangledNodeKind.ProtocolConformanceDescriptor -> new SwiftGenericDescriptorNode();
            case SwiftDemangledNodeKind.ProtocolDescriptor -> new SwiftGenericDescriptorNode();
            case SwiftDemangledNodeKind.ProtocolWitness -> new SwiftGenericPassthroughNode();
            case SwiftDemangledNodeKind.ReflectionMetadataBuiltinDescriptor -> new SwiftGenericDescriptorNode();
            case SwiftDemangledNodeKind.ReflectionMetadataFieldDescriptor -> new SwiftGenericDescriptorNode();
            case SwiftDemangledNodeKind.ReturnType -> new SwiftGenericPassthroughNode();
            case SwiftDemangledNodeKind.Setter -> new SwiftSetterNode();
            case SwiftDemangledNodeKind.Static -> new SwiftGenericPassthroughNode();
            case SwiftDemangledNodeKind.Structure -> new SwiftStructureNode();
            case SwiftDemangledNodeKind.Subscript -> new SwiftSubscriptNode();
            case SwiftDemangledNodeKind.Suffix -> new SwiftGenericTextNode();
            case SwiftDemangledNodeKind.Tuple -> new SwiftTupleNode();
            case SwiftDemangledNodeKind.TupleElement -> new SwiftTupleElementNode();
            case SwiftDemangledNodeKind.TupleElementName -> new SwiftGenericTextNode();
            case SwiftDemangledNodeKind.Type -> new SwiftGenericPassthroughNode();
            case SwiftDemangledNodeKind.TypeAlias -> new SwiftTypeAliasNode();
            case SwiftDemangledNodeKind.TypeList -> new SwiftTypeListNode();
            case SwiftDemangledNodeKind.TypeMetadataAccessFunction -> new SwiftTypeMetadataAccessFunctionNode();
            case SwiftDemangledNodeKind.UnsafeMutableAddressor -> new SwiftUnsafeMutableAddressorNode();
            case SwiftDemangledNodeKind.Variable -> new SwiftVariableNode();
            default -> new SwiftUnsupportedNode(props.kind().toString(), props);
        };
        node.properties = props;
        return node;
    }

    public abstract Demangled demangle(SwiftDemangler var1) throws DemangledException;

    public SwiftDemangledNodeKind getKind() {
        return this.properties.kind();
    }

    public String getText() {
        return this.properties.text();
    }

    public String getIndex() {
        return this.properties.index();
    }

    public int getDepth() {
        return this.properties.depth();
    }

    public SwiftNode getParent() {
        return this.parent;
    }

    public void setParent(SwiftNode parent) {
        this.parent = parent;
    }

    public List<SwiftNode> getChildren() {
        return this.children;
    }

    public boolean walkAndTest(Predicate<SwiftNode> predicate) {
        if (predicate.test(this)) {
            return true;
        }
        for (SwiftNode child : this.children) {
            if (!child.walkAndTest(predicate)) continue;
            return true;
        }
        return false;
    }

    public boolean hasChild(SwiftDemangledNodeKind childKind) {
        return this.children.stream().anyMatch(child -> child.getKind().equals((Object)childKind));
    }

    public SwiftNode getChild(SwiftDemangledNodeKind childKind) {
        return this.children.stream().filter(child -> child.getKind().equals((Object)childKind)).findFirst().orElse(null);
    }

    public SwiftNode getFirstAncestor(SwiftDemangledNodeKind ... ancestorKinds) {
        if (ancestorKinds != null && ancestorKinds.length > 0) {
            for (SwiftNode p = this.parent; p != null; p = p.getParent()) {
                for (SwiftDemangledNodeKind ancestorKind : ancestorKinds) {
                    if (!p.getKind().equals((Object)ancestorKind)) continue;
                    return p;
                }
            }
        }
        return null;
    }

    public void skip(SwiftNode child) {
        this.childSkipped = true;
    }

    public boolean childWasSkipped() {
        return this.childSkipped;
    }

    public DemangledUnknown getUnknown() {
        return new DemangledUnknown(this.properties.mangled(), this.properties.originalDemangled(), this.properties.originalDemangled());
    }

    public static Demangled join(Demangled a, Demangled b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        Demangled topNamespace = b;
        while (topNamespace.getNamespace() != null) {
            topNamespace = topNamespace.getNamespace();
        }
        topNamespace.setNamespace(a);
        return b;
    }

    public static String toString(SwiftNode node, boolean recurse) {
        StringBuilder sb = new StringBuilder(node.toString());
        if (recurse) {
            sb.append("\n");
            for (SwiftNode child : node.getChildren()) {
                sb.append(SwiftNode.toString(child, true));
            }
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(" ".repeat(this.properties.depth() * 2));
        sb.append("kind=" + String.valueOf((Object)this.properties.kind()));
        if (this.properties.text() != null) {
            sb.append(", text=\"" + this.properties.text() + "\"");
        }
        if (this.properties.index() != null) {
            sb.append(", index=" + this.properties.index());
        }
        return sb.toString();
    }

    protected Demangled demangleFirstChild(SwiftDemangler demangler) throws DemangledException {
        Demangled first = null;
        for (int i = 0; i < this.children.size(); ++i) {
            SwiftNode child = this.children.get(i);
            if (i == 0) {
                first = child.demangle(demangler);
                continue;
            }
            child.skip(child);
        }
        if (first == null) {
            throw new DemangledException("No children");
        }
        return first;
    }

    public record NodeProperties(SwiftDemangledNodeKind kind, String text, String index, int depth, String mangled, String originalDemangled, boolean is64bit) {
    }
}

