/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.analyzers;

import ghidra.app.analyzers.FunctionStartAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.util.bytesearch.BulkPatternSearcher;
import ghidra.util.bytesearch.Pattern;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public class FunctionStartFuncAnalyzer
extends FunctionStartAnalyzer {
    protected static final String FUNCTION_START_POST_SEARCH = "Function Start Post Search";

    public FunctionStartFuncAnalyzer() {
        super("Function Start Search", AnalyzerType.FUNCTION_ANALYZER);
        this.setSupportsOneTimeAnalysis(false);
        this.setPriority(AnalysisPriority.FUNCTION_ANALYSIS.before().before());
    }

    @Override
    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        AddressSet potentialPreMatches = this.getOrCreatePotentialMatchPropertyMap(program).getAddressSet();
        if ((set = set.intersect((AddressSetView)potentialPreMatches)).isEmpty()) {
            return true;
        }
        return super.added(program, set, monitor, log);
    }

    @Override
    public boolean canAnalyze(Program program) {
        if (!super.canAnalyze(program)) {
            return false;
        }
        BulkPatternSearcher<Pattern> localSearcher = this.initialize(program);
        if (localSearcher == null) {
            return false;
        }
        if (this.hasFunctionStartConstraints) {
            this.patternSearcher = localSearcher;
            return true;
        }
        return false;
    }
}

