/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.function;

import ghidra.framework.cmd.Command;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.SourceType;

public class SetFunctionNameCmd
implements Command<Program> {
    private Address entry;
    private String name;
    private String msg;
    private SourceType source;

    public SetFunctionNameCmd(Address entry, String newName, SourceType source) {
        this.entry = entry;
        this.name = newName;
        this.source = source;
    }

    public boolean applyTo(Program program) {
        Function f;
        if (this.name.length() <= 0) {
            this.name = null;
        }
        if ((f = program.getListing().getFunctionAt(this.entry)) == null) {
            return true;
        }
        try {
            f.setName(this.name, this.source);
        }
        catch (Exception e) {
            this.msg = e.getMessage();
            return false;
        }
        return true;
    }

    public String getName() {
        return "\u91cd\u547d\u540d\u51fd\u6570";
    }

    public String getStatusMsg() {
        return this.msg;
    }
}

