/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.merge.listing;

import docking.DialogComponentProvider;
import docking.widgets.dialogs.ReadTextDialog;
import generic.stl.Pair;
import ghidra.app.merge.MergeManager;
import ghidra.app.merge.ProgramMultiUserMergeManager;
import ghidra.app.merge.listing.ConflictPanel;
import ghidra.app.merge.listing.FunctionVariableStorageConflicts;
import ghidra.app.merge.listing.ListingMergeConstants;
import ghidra.app.merge.listing.ListingMergeManager;
import ghidra.app.merge.listing.ResolveConflictChangeEvent;
import ghidra.app.merge.listing.ScrollingListChoicesPanel;
import ghidra.app.merge.listing.VariousChoicesPanel;
import ghidra.app.merge.listing.VerticalChoicesPanel;
import ghidra.app.merge.tool.ListingMergePanel;
import ghidra.app.merge.util.ConflictUtility;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.CircularDependencyException;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.StackFrame;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableFilter;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.program.util.ProgramMerge;
import ghidra.util.Msg;
import ghidra.util.MultiComparableArrayIterator;
import ghidra.util.NumericUtilities;
import ghidra.util.SystemUtilities;
import ghidra.util.datastruct.ObjectIntHashtable;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.exception.NoValueException;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang3.StringUtils;

abstract class AbstractFunctionMerger
implements ListingMergeConstants {
    protected static final int BODY_CONFLICT_START = 35;
    protected static final int BODY_CONFLICT_SIZE = 25;
    protected static final int FUNCTION_CONFLICT_START = 60;
    protected static final int FUNCTION_CONFLICT_SIZE = 25;
    protected static final int DETAILS_CONFLICT_START = 85;
    protected static final int DETAILS_CONFLICT_SIZE = 15;
    protected static final int FUNC_OVERLAP = 1;
    protected static final int FUNC_BODY = 2;
    protected static final int FUNC_REMOVE = 4;
    protected static final int FUNC_THUNK = 8;
    protected static final int FUNC_RETURN = 1;
    protected static final int FUNC_RETURN_ADDRESS_OFFSET = 2;
    protected static final int FUNC_STACK_PURGE_SIZE = 16;
    protected static final int FUNC_NAME = 32;
    protected static final int FUNC_INLINE = 64;
    protected static final int FUNC_NO_RETURN = 128;
    protected static final int FUNC_CALLING_CONVENTION = 256;
    protected static final int FUNC_VAR_STORAGE = 1024;
    protected static final int FUNC_SIGNATURE = 2048;
    protected static final int FUNC_LOCAL_DETAILS = 4096;
    protected static final int FUNC_PARAM_DETAILS = 8192;
    protected static final int FUNC_SIGNATURE_SOURCE = 32768;
    protected static final int FUNC_DETAIL_MASK = 498;
    protected static final int VAR_NAME = 2;
    protected static final int VAR_DATATYPE = 4;
    protected static final int VAR_COMMENT = 16;
    protected static final int VAR_REMOVED = 512;
    protected static final int HEADER = -1;
    protected static final int RESULT = 0;
    protected static final int LATEST = 1;
    protected static final int MY = 2;
    protected static final int ORIGINAL = 3;
    protected static final int ORIGINAL_VAR = 0;
    protected static final int LATEST_VAR = 1;
    protected static final int MY_VAR = 2;
    protected StringBuffer errorBuf;
    protected StringBuffer infoBuf;
    protected ProgramMultiUserMergeManager mergeManager;
    protected Program[] programs = new Program[4];
    protected FunctionManager[] functionManagers = new FunctionManager[4];
    protected ListingMergeManager listingMergeManager;
    protected AddressFactory resultAddressFactory;
    protected Map<Long, DataType> latestResolvedDts;
    protected Map<Long, DataType> myResolvedDts;
    protected Map<Long, DataType> origResolvedDts;
    protected ListingMergePanel listingMergePanel;
    protected VerticalChoicesPanel verticalConflictPanel;
    protected VariousChoicesPanel variousConflictPanel;
    protected ScrollingListChoicesPanel scrollingListConflictPanel;
    protected ConflictPanel currentConflictPanel;
    protected TaskMonitor currentMonitor;
    protected int overlapChoice = 0;
    protected int bodyChoice = 0;
    protected int functionReturnChoice = 0;
    protected int removeChoice = 0;
    protected int detailsChoice = 0;
    protected int variableStorageChoice = 0;
    protected int parameterSignatureChoice = 0;
    protected int parameterInfoChoice = 0;
    protected int removedLocalVariableChoice = 0;
    protected int localVariableDetailChoice = 0;
    protected int thunkChoice = 0;
    AddressSet removeSet;
    protected ObjectIntHashtable<Address> funcConflicts;
    protected AddressSet funcSet;
    protected static final String[] STORAGE_CONFLICT_CHOICES = new String[]{"Latest", "Checked Out"};
    protected static final String[] STORAGE_CONFLICT_HEADINGS = new String[]{"Parameter/First-Use", "Name", "Storage", "Data-Type"};

    public AbstractFunctionMerger(ProgramMultiUserMergeManager mergeManager, Program[] programs) {
        this.mergeManager = mergeManager;
        this.programs = programs;
        if (programs.length != 4) {
            throw new IllegalArgumentException("Invalid program array passed to constructor.");
        }
        this.init();
    }

    private void init() {
        this.errorBuf = new StringBuffer();
        this.infoBuf = new StringBuffer();
        for (int i = 0; i < this.programs.length; ++i) {
            this.functionManagers[i] = this.programs[i].getFunctionManager();
        }
        this.resultAddressFactory = this.programs[0].getAddressFactory();
        this.removeSet = new AddressSet();
        this.funcConflicts = new ObjectIntHashtable();
        this.funcSet = new AddressSet();
    }

    DataType getResultDataType(long dtID, Program fromProgram) {
        DataType dt = null;
        if (fromProgram == this.programs[2]) {
            dt = this.myResolvedDts.get(dtID);
            if (dt == null) {
                dt = this.programs[0].getDataTypeManager().getDataType(dtID);
            }
        } else if (fromProgram == this.programs[1]) {
            dt = this.latestResolvedDts.get(dtID);
            if (dt == null) {
                dt = this.programs[0].getDataTypeManager().getDataType(dtID);
            }
        } else if (fromProgram == this.programs[3]) {
            dt = this.origResolvedDts.get(dtID);
        } else if (fromProgram == this.programs[0]) {
            dt = this.programs[0].getDataTypeManager().getDataType(dtID);
        }
        if (dt == null) {
            dt = fromProgram.getDataTypeManager().getDataType(dtID);
        }
        return dt;
    }

    protected abstract void saveFunctionDetailConflict(Function[] var1, int var2);

    protected abstract String getInfoTitle();

    protected abstract String getErrorTitle();

    int determineFunctionConflict(Function[] functions, int type, int latestMyChanges, int originalLatestChanges, int originalMyChanges, TaskMonitor monitor) {
        if ((latestMyChanges & type) != 0 && (originalMyChanges & type) != 0) {
            if ((originalLatestChanges & type) != 0) {
                StackFrame latestStack = functions[1].getStackFrame();
                StackFrame myStack = functions[2].getStackFrame();
                switch (type) {
                    case 2: {
                        return latestStack.getReturnAddressOffset() == myStack.getReturnAddressOffset() ? 0 : type;
                    }
                    case 16: {
                        return functions[1].getStackPurgeSize() == functions[2].getStackPurgeSize() ? 0 : type;
                    }
                    case 32: {
                        return this.hasUnresolvedFunctionNameConflict(functions, monitor) ? type : 0;
                    }
                    case 64: {
                        return functions[1].isInline() == functions[2].isInline() ? 0 : type;
                    }
                    case 128: {
                        return functions[1].hasNoReturn() == functions[2].hasNoReturn() ? 0 : type;
                    }
                    case 256: {
                        return functions[1].getCallingConventionName().equals(functions[2].getCallingConventionName()) ? 0 : type;
                    }
                    case 32768: {
                        return functions[1].getSignatureSource() == functions[2].getSignatureSource() ? 0 : type;
                    }
                }
                throw new IllegalArgumentException("type = " + type);
            }
            Address myEntryPoint = functions[2].getEntryPoint();
            this.mergeFunctionDetail(type, myEntryPoint, this.getMergeMy(), monitor);
        }
        return 0;
    }

    private boolean hasUnresolvedFunctionNameConflict(Function[] functions, TaskMonitor monitor) {
        boolean originalAndMyAreSame;
        String originalName = functions[3] != null ? functions[3].getName() : "";
        String latestName = functions[1] != null ? functions[1].getName() : "";
        String myName = functions[2] != null ? functions[2].getName() : "";
        boolean originalIsDefault = this.isDefaultName(functions[3]);
        boolean latestIsDefault = this.isDefaultName(functions[1]);
        boolean myIsDefault = this.isDefaultName(functions[2]);
        boolean latestAndMyAreSame = latestName.equals(myName) || latestIsDefault && myIsDefault;
        boolean originalAndLatestAreSame = originalName.equals(latestName) || originalIsDefault && latestIsDefault;
        boolean bl = originalAndMyAreSame = originalName.equals(myName) || originalIsDefault && myIsDefault;
        if (latestAndMyAreSame) {
            return false;
        }
        if (originalAndMyAreSame) {
            return false;
        }
        if (originalAndLatestAreSame) {
            Address myEntryPoint = functions[2].getEntryPoint();
            this.mergeFunctionDetail(32, myEntryPoint, this.getMergeMy(), monitor);
            return false;
        }
        if (latestIsDefault) {
            Address myEntryPoint = functions[2].getEntryPoint();
            this.mergeFunctionDetail(32, myEntryPoint, this.getMergeMy(), monitor);
            return false;
        }
        return !myIsDefault;
    }

    private boolean isDefaultName(Function function) {
        if (function != null) {
            String name = function.getName();
            Symbol symbol = function.getSymbol();
            SourceType source = symbol.getSource();
            boolean sourceIsDefault = source == SourceType.DEFAULT;
            String defaultFunctionName = SymbolUtilities.getDefaultFunctionName((Address)function.getEntryPoint());
            boolean matchesDefaultName = name.equals(defaultFunctionName);
            return sourceIsDefault || matchesDefaultName;
        }
        return false;
    }

    abstract ProgramMerge getMergeLatest();

    abstract ProgramMerge getMergeMy();

    abstract ProgramMerge getMergeOriginal();

    void determineFunctionConflicts(Function[] functions, boolean ignoreNames, TaskMonitor monitor) throws CancelledException {
        monitor.checkCancelled();
        boolean isExternalFunction = functions[1] != null ? functions[1].isExternal() : (functions[2] != null ? functions[2].isExternal() : functions[3].isExternal());
        int functionConflictFlags = 0;
        int latestMyChanges = AbstractFunctionMerger.getFunctionDiffs(functions[1], functions[2]);
        if (latestMyChanges != 0) {
            int originalLatestChanges = AbstractFunctionMerger.getFunctionDiffs(functions[3], functions[1]);
            int originalMyChanges = AbstractFunctionMerger.getFunctionDiffs(functions[3], functions[2]);
            functionConflictFlags |= this.determineFunctionConflict(functions, 2, latestMyChanges, originalLatestChanges, originalMyChanges, monitor);
            functionConflictFlags |= this.determineFunctionConflict(functions, 16, latestMyChanges, originalLatestChanges, originalMyChanges, monitor);
            if (!ignoreNames) {
                functionConflictFlags |= this.determineFunctionConflict(functions, 32, latestMyChanges, originalLatestChanges, originalMyChanges, monitor);
            }
            functionConflictFlags |= this.determineFunctionConflict(functions, 64, latestMyChanges, originalLatestChanges, originalMyChanges, monitor);
            functionConflictFlags |= this.determineFunctionConflict(functions, 128, latestMyChanges, originalLatestChanges, originalMyChanges, monitor);
            functionConflictFlags |= this.determineFunctionConflict(functions, 256, latestMyChanges, originalLatestChanges, originalMyChanges, monitor);
            functionConflictFlags |= this.determineFunctionConflict(functions, 32768, latestMyChanges, originalLatestChanges, originalMyChanges, monitor);
        }
        if ((functionConflictFlags & 0x100) == 0) {
            FunctionVariableStorageConflicts variableStorageConflicts = null;
            boolean skipParamChecks = false;
            if (!isExternalFunction) {
                variableStorageConflicts = this.determineStorageConflict(functions, monitor);
                boolean bl = skipParamChecks = variableStorageConflicts != null && variableStorageConflicts.hasParameterConflict();
            }
            if (!skipParamChecks && this.determineSignatureConflicts(functions, monitor)) {
                this.determineParameterInfoConflicts(functions, true, monitor);
            }
            this.determineReturnConflict(functions, true, monitor);
            if (!isExternalFunction) {
                this.determineLocalVariableInfoConflicts(functions, true, variableStorageConflicts, monitor);
            }
        }
        if (functionConflictFlags != 0) {
            this.saveFunctionDetailConflict(functions, functionConflictFlags);
        }
    }

    protected FunctionVariableStorageConflicts determineStorageConflict(Function[] functions, TaskMonitor monitor) throws CancelledException {
        if (functions[1] == null || functions[2] == null) {
            return null;
        }
        FunctionVariableStorageConflicts variableStorageConflicts = new FunctionVariableStorageConflicts(functions[1], functions[2], !functions[0].hasCustomVariableStorage(), monitor);
        if (!variableStorageConflicts.hasOverlapConflict()) {
            return null;
        }
        this.saveFunctionDetailConflict(functions, 1024);
        return variableStorageConflicts;
    }

    boolean determineSignatureConflicts(Function[] functions, TaskMonitor monitor) throws CancelledException {
        monitor.checkCancelled();
        Address entry = functions[1] != null ? functions[1].getEntryPoint() : (functions[2] != null ? functions[2].getEntryPoint() : functions[3].getEntryPoint());
        boolean latestChangedParamSig = !this.isSameParamSig(functions[3], functions[1]);
        boolean myChangedParamSig = !this.isSameParamSig(functions[3], functions[2]);
        boolean latestChangedParamInfo = !this.isSameParamInfo(functions[3], functions[1]);
        boolean myChangedParamInfo = !this.isSameParamInfo(functions[3], functions[2]);
        boolean latestChangedReturn = this.functionReturnDiffers(functions[3], functions[1]);
        boolean myChangedReturn = this.functionReturnDiffers(functions[3], functions[2]);
        boolean sameSig = this.isSameParamSig(functions[1], functions[2]);
        if (sameSig) {
            if (myChangedParamInfo || myChangedReturn) {
                if (latestChangedParamInfo || latestChangedReturn) {
                    return true;
                }
                this.getMergeMy().replaceFunctionParameters(entry, monitor);
            }
        } else if (latestChangedParamSig) {
            if (myChangedParamSig || myChangedParamInfo || myChangedReturn) {
                this.saveFunctionDetailConflict(functions, 2048);
            }
        } else if (myChangedParamSig) {
            if (latestChangedParamInfo || latestChangedReturn) {
                this.saveFunctionDetailConflict(functions, 2048);
            } else {
                this.getMergeMy().replaceFunctionParameters(entry, monitor);
            }
        }
        return false;
    }

    private boolean functionReturnDiffers(Function func1, Function func2) {
        if (func1 == null && func2 == null) {
            return false;
        }
        if (func1 == null || func2 == null) {
            return true;
        }
        return !func1.getReturn().equals((Object)func2.getReturn());
    }

    protected boolean determineReturnConflict(Function[] functions, boolean autoMerge, TaskMonitor monitor) {
        Address entry = functions[1] != null ? functions[1].getEntryPoint() : (functions[2] != null ? functions[2].getEntryPoint() : functions[3].getEntryPoint());
        try {
            int conflicts = this.funcConflicts.get((Object)entry);
            if ((conflicts & 0x800) != 0) {
                return false;
            }
        }
        catch (NoValueException conflicts) {
            // empty catch block
        }
        boolean latestMyDiffers = this.functionReturnDiffers(functions[1], functions[2]);
        if (!latestMyDiffers) {
            return false;
        }
        boolean originalLatestDiffers = this.functionReturnDiffers(functions[3], functions[1]);
        boolean originalMyDiffers = this.functionReturnDiffers(functions[3], functions[2]);
        if (latestMyDiffers && originalMyDiffers) {
            if (originalLatestDiffers) {
                Parameter latestReturn = functions[1].getReturn();
                Parameter myReturn = functions[2].getReturn();
                boolean storageDiffers = false;
                if (functions[0].hasCustomVariableStorage()) {
                    boolean bl = storageDiffers = !latestReturn.getVariableStorage().equals((Object)myReturn.getVariableStorage());
                }
                if (!storageDiffers) {
                    DataType myResultDt;
                    long latestID = this.programs[1].getDataTypeManager().getID(latestReturn.getDataType());
                    long myID = this.programs[2].getDataTypeManager().getID(myReturn.getDataType());
                    DataType latestResultDt = this.getResultDataType(latestID, this.programs[1]);
                    if (latestResultDt == (myResultDt = this.getResultDataType(myID, this.programs[2]))) {
                        return false;
                    }
                }
                this.saveFunctionDetailConflict(functions, 1);
                return true;
            }
            if (autoMerge) {
                this.getMergeMy().mergeFunctionReturn(entry);
            }
        }
        return false;
    }

    protected List<ParamInfoConflict> determineParameterInfoConflicts(Function[] functions, boolean autoMerge, TaskMonitor monitor) {
        ArrayList<ParamInfoConflict> paramConflictList = null;
        Address entry = functions[1] != null ? functions[1].getEntryPoint() : (functions[2] != null ? functions[2].getEntryPoint() : functions[3].getEntryPoint());
        Parameter[] origParms = functions[3] != null ? functions[3].getParameters() : new Parameter[]{};
        Parameter[] latestParms = functions[1] != null ? functions[1].getParameters() : new Parameter[]{};
        Parameter[] myParms = functions[2] != null ? functions[2].getParameters() : new Parameter[]{};
        int numParms = myParms.length;
        for (int ordinal = 0; ordinal < numParms; ++ordinal) {
            Parameter myParameter;
            int latestMyChanges;
            Parameter latestParameter;
            Parameter originalParameter = ordinal < origParms.length ? origParms[ordinal] : null;
            Parameter parameter = latestParameter = ordinal < latestParms.length ? latestParms[ordinal] : null;
            if (latestParameter != null && latestParameter.isAutoParameter() || (latestMyChanges = this.getVariableDiffs((Variable)latestParameter, (Variable)(myParameter = ordinal < myParms.length ? myParms[ordinal] : null))) == 0) continue;
            int originalLatestChanges = this.getVariableDiffs((Variable)originalParameter, (Variable)latestParameter);
            int originalMyChanges = this.getVariableDiffs((Variable)originalParameter, (Variable)myParameter);
            int paramConflicts = 0;
            if (paramConflicts == 0) {
                paramConflicts |= this.determineVariableConflict(entry, 2, (Variable)myParameter, latestMyChanges, originalLatestChanges, originalMyChanges, autoMerge, monitor);
                paramConflicts |= this.determineVariableConflict(entry, 4, (Variable)myParameter, latestMyChanges, originalLatestChanges, originalMyChanges, autoMerge, monitor);
                paramConflicts |= this.determineVariableConflict(entry, 16, (Variable)myParameter, latestMyChanges, originalLatestChanges, originalMyChanges, autoMerge, monitor);
            }
            if (paramConflicts == 0) continue;
            if (paramConflictList == null) {
                paramConflictList = new ArrayList<ParamInfoConflict>();
            }
            paramConflictList.add(new ParamInfoConflict(this, entry, ordinal, paramConflicts));
        }
        if (paramConflictList != null) {
            this.saveFunctionDetailConflict(functions, 8192);
        }
        return paramConflictList;
    }

    boolean isSameParamSig(Function f1, Function f2) {
        Parameter[] f2Parms;
        if (f1 == null) {
            return f2 == null;
        }
        if (f2 == null) {
            return false;
        }
        if (f1.hasVarArgs() != f2.hasVarArgs()) {
            return false;
        }
        Parameter[] f1Parms = f1.getParameters();
        if (f1Parms.length != (f2Parms = f2.getParameters()).length) {
            return false;
        }
        for (int i = 0; i < f1Parms.length; ++i) {
            if (f1Parms[i].isAutoParameter() == f2Parms[i].isAutoParameter() && f1Parms[i].isForcedIndirect() == f2Parms[i].isForcedIndirect()) continue;
            return false;
        }
        if (!f1.hasCustomVariableStorage() && !f2.hasCustomVariableStorage()) {
            return true;
        }
        Parameter return1 = f1.getReturn();
        Parameter return2 = f2.getReturn();
        if (return1.getLength() != return2.getLength() || !return1.getVariableStorage().equals((Object)return2.getVariableStorage())) {
            return false;
        }
        for (int i = 0; i < f1Parms.length; ++i) {
            if (f1Parms[i].getVariableStorage().equals((Object)f2Parms[i].getVariableStorage())) continue;
            return false;
        }
        return true;
    }

    private boolean isSameParamInfo(Function f1, Function f2) {
        if (f1 == null) {
            return f2 == null;
        }
        if (f2 == null) {
            return false;
        }
        Parameter[] f1Parms = f1.getParameters();
        Parameter[] f2Parms = f2.getParameters();
        if (f1.hasCustomVariableStorage() || f2.hasCustomVariableStorage()) {
            f1Parms = f1.getParameters();
            f2Parms = f2.getParameters();
        } else {
            f1Parms = f1.getParameters(VariableFilter.NONAUTO_PARAMETER_FILTER);
            f2Parms = f2.getParameters(VariableFilter.NONAUTO_PARAMETER_FILTER);
        }
        if (f1Parms.length != f2Parms.length) {
            return false;
        }
        for (int i = 0; i < f1Parms.length; ++i) {
            if (!f1Parms[i].isEquivalent((Variable)f2Parms[i])) {
                return false;
            }
            if (!StringUtils.equals((CharSequence)f1Parms[i].getName(), (CharSequence)f2Parms[i].getName())) {
                return false;
            }
            if (StringUtils.equals((CharSequence)f1Parms[i].getComment(), (CharSequence)f2Parms[i].getComment())) continue;
            return false;
        }
        return true;
    }

    private int determineVariableConflict(Address entry, int varType, Variable var, int latestMyChanges, int originalLatestChanges, int originalMyChanges, boolean autoMerge, TaskMonitor monitor) {
        if ((latestMyChanges & varType) != 0 && (originalMyChanges & varType) != 0) {
            if ((originalLatestChanges & varType) != 0) {
                return varType;
            }
            if (autoMerge) {
                this.mergeVariable(varType, entry, var, this.getMergeMy(), monitor);
            }
        }
        return 0;
    }

    private void mergeParameter(int type, Address entry, int ordinal, ProgramMerge pgmMerge, TaskMonitor monitor) {
        if (pgmMerge == null) {
            return;
        }
        switch (type) {
            case 2: {
                try {
                    pgmMerge.replaceFunctionParameterName(entry, ordinal, monitor);
                }
                catch (InvalidInputException e) {
                    Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
                }
                catch (DuplicateNameException e) {
                    Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
                }
                break;
            }
            case 4: {
                pgmMerge.replaceFunctionParameterDataType(entry, ordinal, monitor);
                break;
            }
            case 16: {
                pgmMerge.replaceFunctionParameterComment(entry, ordinal, monitor);
            }
        }
    }

    protected void mergeParameter(int type, Address entry, int ordinal, int currentConflictOption, TaskMonitor monitor) {
        this.mergeParameter(type, entry, ordinal, this.getProgramListingMerge(currentConflictOption), monitor);
    }

    protected void mergeParameter(int type, Function[] functions, int ordinal, int currentConflictOption, TaskMonitor monitor) {
        ProgramMerge programMerge = null;
        Address entryPoint = null;
        if ((currentConflictOption & 1) != 0) {
            programMerge = this.getMergeOriginal();
            entryPoint = functions[3] != null ? functions[3].getEntryPoint() : null;
        } else if ((currentConflictOption & 2) != 0) {
            programMerge = this.getMergeLatest();
            entryPoint = functions[1] != null ? functions[1].getEntryPoint() : null;
        } else if ((currentConflictOption & 4) != 0) {
            programMerge = this.getMergeMy();
            entryPoint = functions[2] != null ? functions[2].getEntryPoint() : null;
        } else {
            throw new IllegalArgumentException(currentConflictOption + " is not a valid value for the currentConflictOption.");
        }
        this.mergeParameter(type, entryPoint, ordinal, programMerge, monitor);
    }

    void mergeLocalVariable(int type, Address entry, Variable[] vars, int currentConflictOption, TaskMonitor monitor) {
        Variable var = null;
        for (int i = 0; i < 3; ++i) {
            if (vars[i] == null) continue;
            var = vars[i];
            break;
        }
        this.mergeVariable(type, entry, var, this.getProgramListingMerge(currentConflictOption), monitor);
    }

    void mergeVariable(int type, Address entry, Variable var, ProgramMerge pgmMerge, TaskMonitor monitor) {
        if (pgmMerge == null) {
            return;
        }
        switch (type) {
            case 512: {
                pgmMerge.replaceFunctionVariable(entry, var, monitor);
                break;
            }
            case 2: {
                try {
                    pgmMerge.replaceFunctionVariableName(entry, var, monitor);
                }
                catch (DuplicateNameException e) {
                    Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
                }
                catch (InvalidInputException e) {
                    Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
                }
                break;
            }
            case 4: {
                pgmMerge.replaceFunctionVariableDataType(entry, var, monitor);
                break;
            }
            case 16: {
                pgmMerge.replaceFunctionVariableComment(entry, var, monitor);
                break;
            }
            default: {
                throw new AssertException("Unsupported type: 0x" + Integer.toHexString(type));
            }
        }
        if (!monitor.isCancelled()) {
            this.handleProgramMergeMessages(pgmMerge);
        }
    }

    static int getFunctionDiffs(Function func1, Function func2) {
        int diffs = 0;
        if (func1 == null && func2 == null) {
            return 0;
        }
        if (func1 == null || func2 == null) {
            return 498;
        }
        StackFrame stack1 = func1.getStackFrame();
        StackFrame stack2 = func2.getStackFrame();
        if (!SystemUtilities.isEqual((Object)func1.getName(), (Object)func2.getName())) {
            diffs |= 0x20;
        }
        if (stack1.getReturnAddressOffset() != stack2.getReturnAddressOffset()) {
            diffs |= 2;
        }
        if (func1.getStackPurgeSize() != func2.getStackPurgeSize()) {
            diffs |= 0x10;
        }
        if (func1.isInline() != func2.isInline()) {
            diffs |= 0x40;
        }
        if (func1.hasNoReturn() != func2.hasNoReturn()) {
            diffs |= 0x80;
        }
        if (!func1.getCallingConventionName().equals(func2.getCallingConventionName())) {
            diffs |= 0x100;
        }
        if (func1.getSignatureSource() != func2.getSignatureSource()) {
            diffs |= 0x8000;
        }
        return diffs;
    }

    private int getVariableDiffs(Variable var1, Variable var2) {
        int diffs = 0;
        if (var1 == null && var2 == null) {
            return 0;
        }
        if (var1 == null || var2 == null) {
            return 22;
        }
        if (!var1.getName().equals(var2.getName())) {
            diffs |= 2;
        }
        if (!var1.getDataType().isEquivalent(var2.getDataType())) {
            diffs |= 4;
        }
        if (!SystemUtilities.isEqual((Object)var1.getComment(), (Object)var2.getComment())) {
            diffs |= 0x10;
        }
        return diffs;
    }

    List<LocalVariableConflict> determineLocalVariableInfoConflicts(Function[] functions, boolean autoMerge, FunctionVariableStorageConflicts storageConflicts, TaskMonitor monitor) throws CancelledException {
        monitor.checkCancelled();
        ArrayList<LocalVariableConflict> varConflictList = null;
        Address entry = functions[1] != null ? functions[1].getEntryPoint() : (functions[2] != null ? functions[2].getEntryPoint() : functions[3].getEntryPoint());
        Object[] origLocals = functions[3] != null ? functions[3].getLocalVariables() : new Variable[]{};
        Object[] latestLocals = functions[1] != null ? functions[1].getLocalVariables() : new Variable[]{};
        Object[] myLocals = functions[2] != null ? functions[2].getLocalVariables() : new Variable[]{};
        Arrays.sort(origLocals);
        Arrays.sort(latestLocals);
        Arrays.sort(myLocals);
        MultiComparableArrayIterator varIter = new MultiComparableArrayIterator((Comparable[][])new Variable[][]{origLocals, latestLocals, myLocals});
        while (varIter.hasNext()) {
            int latestMyChanges;
            Variable[] vars = (Variable[])varIter.next();
            Variable origVar = vars[0];
            Variable latestVar = vars[1];
            Variable myVar = vars[2];
            if ((latestVar == null || myVar == null) && storageConflicts != null && storageConflicts.isConflicted(latestVar, myVar) || (latestMyChanges = this.getVariableDiffs(latestVar, myVar)) == 0) continue;
            boolean removedLatest = origVar != null && latestVar == null;
            boolean removedMy = origVar != null && myVar == null;
            int originalLatestChanges = this.getVariableDiffs(origVar, latestVar);
            int originalMyChanges = this.getVariableDiffs(origVar, myVar);
            int varConflicts = 0;
            if (removedLatest && originalMyChanges != 0 || removedMy && originalLatestChanges != 0) {
                varConflicts |= 0x200;
            } else {
                if (removedMy) {
                    if (!autoMerge || removedLatest) continue;
                    this.getMergeMy().replaceFunctionVariable(entry, origVar, monitor);
                    continue;
                }
                if (origVar == null && myVar != null && latestVar == null) {
                    if (!autoMerge) continue;
                    this.getMergeMy().replaceFunctionVariable(entry, myVar, monitor);
                    continue;
                }
                varConflicts |= this.determineVariableConflict(entry, 2, myVar, latestMyChanges, originalLatestChanges, originalMyChanges, autoMerge, monitor);
                varConflicts |= this.determineVariableConflict(entry, 4, myVar, latestMyChanges, originalLatestChanges, originalMyChanges, autoMerge, monitor);
                varConflicts |= this.determineVariableConflict(entry, 16, myVar, latestMyChanges, originalLatestChanges, originalMyChanges, autoMerge, monitor);
            }
            if (varConflicts == 0) continue;
            if (varConflictList == null) {
                varConflictList = new ArrayList<LocalVariableConflict>();
            }
            varConflictList.add(new LocalVariableConflict(this, entry, vars, varConflicts));
        }
        if (varConflictList != null) {
            this.saveFunctionDetailConflict(functions, 4096);
        }
        return varConflictList;
    }

    protected int countSetBits(int bits) {
        int count = 0;
        for (int i = 0; i < 32; ++i) {
            if ((bits & 1) != 0) {
                ++count;
            }
            bits >>>= 1;
        }
        return count;
    }

    protected void mergeFunctionDetail(int type, Address entry, ProgramMerge pgmMerge, TaskMonitor monitor) {
        if (pgmMerge == null) {
            return;
        }
        switch (type) {
            case 32: {
                pgmMerge.mergeFunctionName(entry, monitor);
                break;
            }
            case 2: {
                pgmMerge.mergeFunctionReturnAddressOffset(entry, monitor);
                break;
            }
            case 16: {
                pgmMerge.mergeFunctionStackPurgeSize(entry, monitor);
                break;
            }
            case 64: {
                pgmMerge.replaceFunctionInlineFlag(entry, monitor);
                break;
            }
            case 128: {
                pgmMerge.replaceFunctionNoReturnFlag(entry, monitor);
                break;
            }
            case 256: {
                pgmMerge.replaceFunctionCallingConvention(entry, monitor);
                break;
            }
            case 32768: {
                pgmMerge.replaceFunctionSignatureSource(entry, monitor);
                break;
            }
            default: {
                throw new IllegalArgumentException("type = " + type);
            }
        }
    }

    private void mergeFunctionDetail(int type, Function[] functions, int chosenConflictOption, TaskMonitor monitor) {
        Address entryPoint = this.getEntryPoint(functions, chosenConflictOption);
        ProgramMerge programListingMerge = this.getProgramListingMerge(chosenConflictOption);
        this.mergeFunctionDetail(type, entryPoint, programListingMerge, monitor);
    }

    ProgramMerge getProgramListingMerge(int chosenConflictOption) {
        if ((chosenConflictOption & 1) != 0) {
            return this.getMergeOriginal();
        }
        if ((chosenConflictOption & 2) != 0) {
            return this.getMergeLatest();
        }
        if ((chosenConflictOption & 4) != 0) {
            return this.getMergeMy();
        }
        return null;
    }

    Address getEntryPoint(Function[] functions, int chosenConflictOption) {
        Function function = null;
        if ((chosenConflictOption & 1) != 0) {
            function = functions[3];
        } else if ((chosenConflictOption & 2) != 0) {
            function = functions[1];
        } else if ((chosenConflictOption & 4) != 0) {
            function = functions[2];
        } else if ((chosenConflictOption & 8) != 0) {
            function = functions[0];
        }
        return function != null ? function.getEntryPoint() : null;
    }

    private void handleProgramMergeMessages(ProgramMerge pm) {
        this.errorBuf.append(pm.getErrorMessage());
        pm.clearErrorMessage();
        this.infoBuf.append(pm.getInfoMessage());
        pm.clearInfoMessage();
    }

    protected void mergeParameters(Function[] functions, int chosenConflictOption, TaskMonitor monitor) {
        if (functions[0] == null) {
            return;
        }
        ProgramMerge pgmMerge = null;
        Address currentAddress = null;
        if ((chosenConflictOption & 2) != 0) {
            pgmMerge = this.getMergeLatest();
            currentAddress = functions[1].getEntryPoint();
        } else if ((chosenConflictOption & 4) != 0) {
            pgmMerge = this.getMergeMy();
            currentAddress = functions[2].getEntryPoint();
        } else {
            return;
        }
        if (pgmMerge != null) {
            pgmMerge.replaceFunctionParameters(currentAddress, monitor);
            Function f = pgmMerge.getOriginProgram().getFunctionManager().getFunctionAt(currentAddress);
            if (f == null) {
                return;
            }
        }
    }

    protected void mergeParamInfo(Address entryPt, List<ParamInfoConflict> paramInfoConflicts, int chosenConflictOption, TaskMonitor monitor) throws CancelledException {
        for (ParamInfoConflict pc : paramInfoConflicts) {
            monitor.checkCancelled();
            this.mergeParamInfo(entryPt, pc, chosenConflictOption, monitor);
        }
    }

    protected void mergeParamInfo(Address entryPt, ParamInfoConflict pc, int chosenConflictOption, TaskMonitor monitor) {
        int ordinal = pc.ordinal;
        int conflicts = pc.paramConflicts;
        if ((conflicts & 2) != 0) {
            this.mergeParameter(2, entryPt, ordinal, chosenConflictOption, monitor);
        }
        if ((conflicts & 4) != 0) {
            this.mergeParameter(4, entryPt, ordinal, chosenConflictOption, monitor);
        }
        if ((conflicts & 0x10) != 0) {
            this.mergeParameter(16, entryPt, ordinal, chosenConflictOption, monitor);
        }
    }

    protected void mergeParamInfo(Function[] functions, List<ParamInfoConflict> paramInfoConflicts, int chosenConflictOption, TaskMonitor monitor) throws CancelledException {
        for (ParamInfoConflict pc : paramInfoConflicts) {
            monitor.checkCancelled();
            this.mergeParamInfo(functions, pc, chosenConflictOption, monitor);
        }
    }

    protected void mergeParamInfo(Function[] functions, ParamInfoConflict pc, int chosenConflictOption, TaskMonitor monitor) {
        int ordinal = pc.ordinal;
        int conflicts = pc.paramConflicts;
        if ((conflicts & 2) != 0) {
            this.mergeParameter(2, functions, ordinal, chosenConflictOption, monitor);
        }
        if ((conflicts & 4) != 0) {
            this.mergeParameter(4, functions, ordinal, chosenConflictOption, monitor);
        }
        if ((conflicts & 0x10) != 0) {
            this.mergeParameter(16, functions, ordinal, chosenConflictOption, monitor);
        }
    }

    protected void mergeLocals(Address entryPt, List<LocalVariableConflict> localVarConflicts, int chosenConflictOption, TaskMonitor monitor) throws CancelledException {
        for (LocalVariableConflict lvc : localVarConflicts) {
            monitor.checkCancelled();
            this.mergeLocal(entryPt, lvc, chosenConflictOption, monitor);
        }
    }

    protected void mergeLocal(Address entryPt, LocalVariableConflict localVarConflict, int chosenConflictOption, TaskMonitor monitor) throws CancelledException {
        monitor.checkCancelled();
        Variable[] vars = localVarConflict.vars;
        int conflicts = localVarConflict.varConflicts;
        if ((conflicts & 0x200) != 0) {
            this.mergeLocalVariable(512, entryPt, vars, chosenConflictOption, monitor);
            return;
        }
        if ((conflicts & 2) != 0) {
            this.mergeLocalVariable(2, entryPt, vars, chosenConflictOption, monitor);
        }
        if ((conflicts & 4) != 0) {
            this.mergeLocalVariable(4, entryPt, vars, chosenConflictOption, monitor);
        }
        if ((conflicts & 0x10) != 0) {
            this.mergeLocalVariable(16, entryPt, vars, chosenConflictOption, monitor);
        }
    }

    void mergeFunctionDetails(Function[] functions, int chosenConflictOption, TaskMonitor monitor) {
        Address myEntryPoint = functions[2].getEntryPoint();
        int conflicts = 0;
        try {
            conflicts = this.funcConflicts.get((Object)myEntryPoint);
        }
        catch (NoValueException noValueException) {
            // empty catch block
        }
        if ((conflicts & 0x20) != 0) {
            this.mergeFunctionDetail(32, functions, chosenConflictOption, monitor);
        }
        if ((conflicts & 2) != 0 && (conflicts & 0x800) == 0) {
            this.mergeFunctionDetail(2, functions, chosenConflictOption, monitor);
        }
        if ((conflicts & 0x10) != 0) {
            this.mergeFunctionDetail(16, functions, chosenConflictOption, monitor);
        }
        if ((conflicts & 0x40) != 0) {
            this.mergeFunctionDetail(64, functions, chosenConflictOption, monitor);
        }
        if ((conflicts & 0x80) != 0) {
            this.mergeFunctionDetail(128, functions, chosenConflictOption, monitor);
        }
        if ((conflicts & 0x100) != 0) {
            this.mergeFunctionDetail(256, functions, chosenConflictOption, monitor);
        }
        if ((conflicts & 0x8000) != 0) {
            this.mergeFunctionDetail(32768, functions, chosenConflictOption, monitor);
        }
    }

    void mergeHigherPrioritySignatureSource(Function[] functions, TaskMonitor monitor) {
        int currentConflictOption = 2;
        SourceType latestSignatureSource = functions[1].getSignatureSource();
        SourceType mySignatureSource = functions[2].getSignatureSource();
        if (mySignatureSource.isHigherPriorityThan(latestSignatureSource)) {
            currentConflictOption = 4;
        }
        this.mergeFunctionDetail(32768, functions, currentConflictOption, monitor);
    }

    void mergeFunctionReturn(Function[] functions, int chosenConflictOption, TaskMonitor monitor) {
        Address entryPoint = this.getEntryPoint(functions, chosenConflictOption);
        ProgramMerge programListingMerge = this.getProgramListingMerge(chosenConflictOption);
        programListingMerge.mergeFunctionReturn(entryPoint);
    }

    protected VerticalChoicesPanel getEmptyVerticalPanel() {
        if (this.verticalConflictPanel == null) {
            this.verticalConflictPanel = new VerticalChoicesPanel();
        }
        this.runSwing(() -> this.verticalConflictPanel.clear());
        this.currentConflictPanel = this.verticalConflictPanel;
        return this.verticalConflictPanel;
    }

    protected ScrollingListChoicesPanel getEmptyScrollingListChoicesPanel() {
        if (this.scrollingListConflictPanel == null) {
            this.scrollingListConflictPanel = new ScrollingListChoicesPanel();
        }
        this.runSwing(() -> this.scrollingListConflictPanel.clear());
        this.currentConflictPanel = this.scrollingListConflictPanel;
        return this.scrollingListConflictPanel;
    }

    protected VariousChoicesPanel getEmptyVariousPanel() {
        if (this.variousConflictPanel == null) {
            this.variousConflictPanel = new VariousChoicesPanel();
        }
        this.runSwing(() -> this.variousConflictPanel.clear());
        this.currentConflictPanel = this.variousConflictPanel;
        return this.variousConflictPanel;
    }

    protected String getReturnString(Function func, boolean includeStorage) {
        if (func == null) {
            return "";
        }
        Parameter returnVar = func.getReturn();
        Object returnStr = returnVar.getDataType().getName();
        if (includeStorage) {
            returnStr = (String)returnStr + ", " + String.valueOf(returnVar.getVariableStorage());
        }
        return returnStr;
    }

    protected String[] getReturnInfo(Program pgm, String returnStr, String prefix, String suffix) {
        if (pgm == null) {
            return new String[]{"Option", "Function Return"};
        }
        String[] info = new String[]{"", ""};
        String version = "";
        if (pgm == this.programs[3]) {
            version = "Original";
        } else if (pgm == this.programs[1]) {
            version = "Latest";
        } else if (pgm == this.programs[2]) {
            version = "Checked Out";
        } else if (pgm == this.programs[0]) {
            version = "Result";
        }
        info[0] = prefix + version + suffix;
        if (returnStr != null) {
            info[1] = returnStr;
        }
        return info;
    }

    protected String[] getSignatureInfo(Program pgm, Function f, String prefix, String suffix) {
        if (pgm == null) {
            return new String[]{"Option", "Signature"};
        }
        String[] info = new String[]{"", ""};
        String version = "";
        if (pgm == this.programs[3]) {
            version = "Original";
        } else if (pgm == this.programs[1]) {
            version = "Latest";
        } else if (pgm == this.programs[2]) {
            version = "Checked Out";
        } else if (pgm == this.programs[0]) {
            version = "Result";
        }
        info[0] = prefix + version + suffix;
        if (f != null) {
            info[1] = f.getPrototypeString(true, false);
        }
        return info;
    }

    void setupConflictPanel(ListingMergePanel listingPanel, JPanel conflictPanel, Address entryPt, TaskMonitor monitor) {
        if (conflictPanel == null) {
            MergeManager.showBlockingError("Error Displaying Conflict Panel", "The conflict panel could not be created.");
            return;
        }
        this.currentMonitor = monitor;
        this.currentConflictPanel = (ConflictPanel)conflictPanel;
        try {
            SwingUtilities.invokeAndWait(() -> listingPanel.setBottomComponent(conflictPanel));
            SwingUtilities.invokeLater(() -> {
                listingPanel.clearAllBackgrounds();
                listingPanel.paintAllBackgrounds((AddressSetView)new AddressSet(entryPt, entryPt));
            });
        }
        catch (InterruptedException e) {
            this.showConflictPanelException(entryPt, e);
            return;
        }
        catch (InvocationTargetException e) {
            this.showConflictPanelException(entryPt, e);
            return;
        }
        if (this.mergeManager != null) {
            this.mergeManager.setApplyEnabled(false);
            this.mergeManager.showListingMergePanel(entryPt);
        }
    }

    private void showConflictPanelException(Address entryPt, Exception e) {
        String message = "Couldn't display conflict for function at " + entryPt.toString(true) + ".\n " + e.getMessage();
        MergeManager.showBlockingError("Function Merge Error", message, e);
    }

    String[] getVariableInfo(Variable var, String option) {
        if (option == null) {
            return new String[]{"Option", "Storage", "Name", "DataType", "Comment"};
        }
        String[] info = new String[]{"", "", "", "", ""};
        info[0] = option;
        if (var != null) {
            info[1] = var.getVariableStorage().toString();
            info[2] = var.getName();
            info[3] = var.getDataType().getDisplayName();
            info[4] = var.getComment();
        }
        return info;
    }

    int getOptionForChoice(int choice) {
        int associatedConflictOption = 0;
        switch (choice) {
            case 1: {
                associatedConflictOption = 2;
                break;
            }
            case 2: {
                associatedConflictOption = 4;
                break;
            }
            case 4: {
                associatedConflictOption = 1;
            }
        }
        return associatedConflictOption;
    }

    protected void clearConflictPanel() {
        try {
            SwingUtilities.invokeAndWait(() -> {
                if (this.currentConflictPanel != null) {
                    this.currentConflictPanel.clear();
                }
            });
        }
        catch (InterruptedException e) {
            Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
        }
    }

    protected void runSwing(Runnable r) {
        try {
            SwingUtilities.invokeAndWait(r);
        }
        catch (InterruptedException e) {
            Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
        }
    }

    void clearResolveErrors() {
        if (this.errorBuf.length() > 0) {
            this.errorBuf = new StringBuffer();
        }
    }

    void showResolveErrors(String title) {
        if (this.errorBuf.length() > 0) {
            try {
                SwingUtilities.invokeAndWait(() -> {
                    String msg = this.errorBuf.toString();
                    this.clearResolveErrors();
                    ReadTextDialog dialog = new ReadTextDialog(title, msg);
                    PluginTool mergeTool = this.mergeManager.getMergeTool();
                    this.mergeManager.getMergeTool().showDialog((DialogComponentProvider)dialog, (Component)mergeTool.getActiveWindow());
                });
            }
            catch (InterruptedException e) {
                throw new AssertException((Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new AssertException((Throwable)e);
            }
        }
    }

    void clearResolveInfo() {
        if (this.infoBuf.length() > 0) {
            this.infoBuf = new StringBuffer();
        }
    }

    void showResolveInfo(String title) {
        if (this.infoBuf.length() > 0) {
            try {
                SwingUtilities.invokeAndWait(() -> {
                    String msg = this.infoBuf.toString();
                    ReadTextDialog dialog = new ReadTextDialog(title, msg);
                    PluginTool mergeTool = this.mergeManager.getMergeTool();
                    this.mergeManager.getMergeTool().showDialog((DialogComponentProvider)dialog, (Component)mergeTool.getActiveWindow());
                });
            }
            catch (InterruptedException e) {
                throw new AssertException((Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new AssertException((Throwable)e);
            }
        }
    }

    protected VariousChoicesPanel createLocalVariableConflictPanel(LocalVariableConflict lvc, TaskMonitor monitor) {
        Address entryPt = lvc.entry;
        Variable[] vars = lvc.vars;
        Variable origLocal = vars[0];
        Variable latestLocal = vars[1];
        Variable myLocal = vars[2];
        int conflicts = lvc.varConflicts;
        VariousChoicesPanel panel = this.getEmptyVariousPanel();
        this.runSwing(() -> {
            String my;
            String latest;
            panel.setTitle("Function Local Variable");
            Variable var = latestLocal != null ? latestLocal : (myLocal != null ? myLocal : origLocal);
            String varInfo = "Local Variable" + ConflictUtility.spaces(4) + "Storage: " + ConflictUtility.getEmphasizeString(var.getVariableStorage().toString()) + ConflictUtility.spaces(4) + "First Use Offset: " + ConflictUtility.getOffsetString(var.getFirstUseOffset());
            String text = "Function: " + ConflictUtility.getEmphasizeString(this.functionManagers[0].getFunctionAt(entryPt).getName()) + ConflictUtility.spaces(4) + "EntryPoint: " + ConflictUtility.getAddressString(entryPt) + ConflictUtility.spaces(4) + varInfo;
            panel.setHeader(text);
            panel.addInfoRow("Conflict", new String[]{"Latest", "Checked Out"}, true);
            if ((conflicts & 2) != 0) {
                latest = latestLocal.getName();
                my = myLocal.getName();
                panel.addSingleChoice("Local Variable Name", new String[]{latest, my}, new LocalVarChangeListener(2, entryPt, vars, panel, monitor));
            }
            if ((conflicts & 4) != 0) {
                latest = latestLocal.getDataType().getName();
                my = myLocal.getDataType().getName();
                panel.addSingleChoice("Local Variable Data Type", new String[]{latest, my}, new LocalVarChangeListener(4, entryPt, vars, panel, monitor));
            }
            if ((conflicts & 0x10) != 0) {
                latest = latestLocal.getComment();
                my = myLocal.getComment();
                panel.addSingleChoice("Local Variable Comment", new String[]{latest, my}, new LocalVarChangeListener(16, entryPt, vars, panel, monitor));
            }
        });
        return panel;
    }

    protected VerticalChoicesPanel createRemoveConflictPanel(Function[] functions, TaskMonitor monitor) {
        Address addr = functions[3].getEntryPoint();
        String latest = this.getFunctionPrompt(addr, functions[1], "Latest");
        String my = this.getFunctionPrompt(addr, functions[2], "Checked Out");
        VerticalChoicesPanel panel = this.getEmptyVerticalPanel();
        this.runSwing(() -> {
            panel.setTitle("Function Remove");
            StringBuffer buf = new StringBuffer();
            buf.append("One function was removed and the other changed @ ");
            ConflictUtility.addAddress(buf, addr);
            buf.append(".");
            panel.setHeader(buf.toString());
            FunctionConflictChangeListener changeListener = new FunctionConflictChangeListener(4, addr, panel, monitor);
            panel.addRadioButtonRow(new String[]{latest}, "LatestVersionRB", 2, changeListener);
            panel.addRadioButtonRow(new String[]{my}, "CheckedOutVersionRB", 4, changeListener);
        });
        return panel;
    }

    private void mergeFunction(Address entryPt, int chosenConflictOption, TaskMonitor monitor) throws CancelledException {
        this.updateProgressMessage("Merging function @ " + entryPt.toString(true));
        ProgramMerge pgmMerge = this.getProgramListingMerge(chosenConflictOption);
        if (pgmMerge == null) {
            return;
        }
        Program origPgm = pgmMerge.getOriginProgram();
        if (origPgm == null) {
            return;
        }
        Function f = pgmMerge.mergeFunction(entryPt, monitor);
        if (f != null) {
            try {
                Function origF = origPgm.getFunctionManager().getFunctionAt(entryPt);
                if (origF != null) {
                    Namespace ns = this.listingMergeManager.resolveNamespace(origPgm, origF.getParentNamespace());
                    f.setParentNamespace(ns);
                }
            }
            catch (DuplicateNameException e) {
                MergeManager.showBlockingError("Error Setting Function Namespace", e.getMessage());
            }
            catch (InvalidInputException e) {
                MergeManager.showBlockingError("Error Setting Function Namespace", e.getMessage());
            }
            catch (CircularDependencyException e) {
                MergeManager.showBlockingError("Error Setting Function Namespace", e.getMessage());
            }
        }
    }

    protected ScrollingListChoicesPanel createStorageConflictPanel(final Address entryPt, final Pair<List<Variable>, List<Variable>> pair, final TaskMonitor monitor) {
        this.getEmptyScrollingListChoicesPanel();
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int choice = AbstractFunctionMerger.this.scrollingListConflictPanel.getUseForAllChoice();
                if (choice == 0) {
                    if (AbstractFunctionMerger.this.mergeManager != null) {
                        AbstractFunctionMerger.this.mergeManager.setApplyEnabled(false);
                    }
                    return;
                }
                if (AbstractFunctionMerger.this.mergeManager != null) {
                    AbstractFunctionMerger.this.mergeManager.clearStatusText();
                }
                try {
                    AbstractFunctionMerger.this.mergeVariableStorage(entryPt, (Pair<List<Variable>, List<Variable>>)pair, AbstractFunctionMerger.this.getOptionForChoice(choice), monitor);
                    if (AbstractFunctionMerger.this.mergeManager != null) {
                        AbstractFunctionMerger.this.mergeManager.setApplyEnabled(true);
                    }
                }
                catch (Exception e1) {
                    Msg.error((Object)this, (Object)("Unexpected Exception: " + e1.getMessage()), (Throwable)e1);
                }
            }
        };
        this.runSwing(() -> {
            this.scrollingListConflictPanel.setTitle("Parameter/Variable Storage");
            String text = "The function @ " + ConflictUtility.getAddressString(entryPt) + " has conflicting parameter/variable storage resulting from changes.<br>Choose the desired set of parameters/variables to keep.<br>";
            this.scrollingListConflictPanel.setHeader(text);
            this.scrollingListConflictPanel.setChoiceNames("Latest", "LatestListRB", "Checked Out", "CheckedOutListRB");
            this.scrollingListConflictPanel.setListChoice(changeListener, STORAGE_CONFLICT_CHOICES, STORAGE_CONFLICT_HEADINGS, this.getVariableDetails((List)pair.first), this.getVariableDetails((List)pair.second));
        });
        return this.scrollingListConflictPanel;
    }

    protected void mergeVariableStorage(Address entryPt, Pair<List<Variable>, List<Variable>> pair, int currentConflictOption, TaskMonitor monitor) throws CancelledException {
        ProgramMerge pgmMerge = this.getProgramListingMerge(currentConflictOption);
        List list = currentConflictOption == 2 ? (List)pair.first : (List)pair.second;
        pgmMerge.replaceVariables(entryPt, list, monitor);
    }

    protected List<String[]> getVariableDetails(List<Variable> list) {
        ArrayList<String[]> tableData = new ArrayList<String[]>();
        for (Variable var : list) {
            String[] data = new String[]{var instanceof Parameter ? "Param: " + ((Parameter)var).getOrdinal() : var.getFunction().getEntryPoint().addWrap((long)var.getFirstUseOffset()).toString(), var.getName(), var.getVariableStorage().toString(), var.getDataType().getName()};
            tableData.add(data);
        }
        return tableData;
    }

    protected VerticalChoicesPanel createParameterSigConflictPanel(final Function[] functions, final TaskMonitor monitor) {
        this.getEmptyVerticalPanel();
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int chosenConflictOption = AbstractFunctionMerger.this.verticalConflictPanel.getSelectedOptions();
                if (chosenConflictOption == 0) {
                    if (AbstractFunctionMerger.this.mergeManager != null) {
                        AbstractFunctionMerger.this.mergeManager.setApplyEnabled(false);
                    }
                    return;
                }
                if (AbstractFunctionMerger.this.mergeManager != null) {
                    AbstractFunctionMerger.this.mergeManager.clearStatusText();
                }
                try {
                    AbstractFunctionMerger.this.mergeParameters(functions, chosenConflictOption, monitor);
                    if (AbstractFunctionMerger.this.mergeManager != null) {
                        AbstractFunctionMerger.this.mergeManager.setApplyEnabled(true);
                    }
                }
                catch (Exception e1) {
                    Msg.error((Object)this, (Object)("Unexpected Exception: " + e1.getMessage()), (Throwable)e1);
                }
            }
        };
        this.runSwing(() -> {
            this.verticalConflictPanel.setTitle("Function Parameters");
            String text = this.getConflictPrefixString(functions) + " has conflicting signature storage changes.<br>Choose the desired function signature.<br>Note: If the signatures below look the same, then check for return/parameter storage differences in the Listings above.";
            this.verticalConflictPanel.setHeader(text);
            this.verticalConflictPanel.setRowHeader(this.getSignatureInfo(null, null, null, null));
            this.verticalConflictPanel.addRadioButtonRow(this.getSignatureInfo(this.programs[1], functions[1], "Use ", " version"), "LatestVersionRB", 2, changeListener);
            this.verticalConflictPanel.addRadioButtonRow(this.getSignatureInfo(this.programs[2], functions[2], "Use ", " version"), "CheckedOutVersionRB", 4, changeListener);
            this.verticalConflictPanel.addInfoRow(this.getSignatureInfo(this.programs[3], functions[3], "", " version"));
        });
        return this.verticalConflictPanel;
    }

    private String getConflictPrefixString(Function[] functions) {
        if (functions[2].isExternal()) {
            return "The Checked Out external function '" + ConflictUtility.getEmphasizeString(functions[2].getSymbol().getName(true)) + "'";
        }
        return "The Result function '" + ConflictUtility.getEmphasizeString(functions[0].getName()) + "' @ " + ConflictUtility.getAddressString(functions[0].getEntryPoint());
    }

    protected VariousChoicesPanel createFunctionConflictPanel(Function[] functions, TaskMonitor monitor) {
        if (functions[0] == null) {
            MergeManager.showBlockingError("Error Creating Function Conflict Panel", "RESULT function is null.");
            return null;
        }
        Address myEntryPoint = functions[2].getEntryPoint();
        StackFrame latestStack = functions[1].getStackFrame();
        StackFrame myStack = functions[2].getStackFrame();
        VariousChoicesPanel panel = this.getEmptyVariousPanel();
        int conflictCount = 0;
        try {
            conflictCount = this.funcConflicts.get((Object)myEntryPoint);
        }
        catch (NoValueException e) {
            MergeManager.showBlockingError("Error Creating Function Conflict Panel", "Couldn't get conflict information for MY function at " + myEntryPoint.toString(true) + ".");
            return null;
        }
        int conflicts = conflictCount;
        this.runSwing(() -> {
            String my;
            String latest;
            panel.setTitle("Function");
            String text = this.getConflictPrefixString(functions) + " has conflicting changes.<br>Choose the desired result for each conflict.<br>";
            panel.setHeader(text);
            panel.addInfoRow("Conflict", new String[]{"Latest", "Checked Out"}, true);
            if ((conflicts & 0x20) != 0) {
                latest = functions[1].getName();
                my = functions[2].getName();
                panel.addSingleChoice("Name", new String[]{latest, my}, new FunctionDetailChangeListener(32, functions, panel, monitor));
            }
            if ((conflicts & 2) != 0) {
                latest = NumericUtilities.toSignedHexString((long)latestStack.getReturnAddressOffset());
                my = NumericUtilities.toSignedHexString((long)myStack.getReturnAddressOffset());
                panel.addSingleChoice("Return Address Offset", new String[]{latest, my}, new FunctionDetailChangeListener(2, functions, panel, monitor));
            }
            if ((conflicts & 0x10) != 0) {
                latest = NumericUtilities.toSignedHexString((long)functions[1].getStackPurgeSize());
                my = NumericUtilities.toSignedHexString((long)functions[2].getStackPurgeSize());
                panel.addSingleChoice("Stack Purge Size", new String[]{latest, my}, new FunctionDetailChangeListener(16, functions, panel, monitor));
            }
            if ((conflicts & 0x40) != 0) {
                latest = Boolean.toString(functions[1].isInline());
                my = Boolean.toString(functions[2].isInline());
                panel.addSingleChoice("Is Inline?", new String[]{latest, my}, new FunctionDetailChangeListener(64, functions, panel, monitor));
            }
            if ((conflicts & 0x80) != 0) {
                latest = Boolean.toString(functions[1].hasNoReturn());
                my = Boolean.toString(functions[2].hasNoReturn());
                panel.addSingleChoice("Has No Return?", new String[]{latest, my}, new FunctionDetailChangeListener(128, functions, panel, monitor));
            }
            if ((conflicts & 0x100) != 0) {
                latest = functions[1].getCallingConventionName();
                my = functions[2].getCallingConventionName();
                panel.addSingleChoice("Calling Convention", new String[]{latest, my}, new FunctionDetailChangeListener(256, functions, panel, monitor));
            }
            if ((conflicts & 0x8000) != 0) {
                latest = functions[1].getSignatureSource();
                my = functions[2].getSignatureSource();
                panel.addSingleChoice("Signature Source", new String[]{latest.toString(), my.toString()}, new FunctionDetailChangeListener(32768, functions, panel, monitor));
            }
        });
        return panel;
    }

    protected VerticalChoicesPanel createFunctionReturnConflictPanel(final Function[] functions, final TaskMonitor monitor) {
        this.getEmptyVerticalPanel();
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int chosenConflictOption = AbstractFunctionMerger.this.verticalConflictPanel.getSelectedOptions();
                if (chosenConflictOption == 0) {
                    if (AbstractFunctionMerger.this.mergeManager != null) {
                        AbstractFunctionMerger.this.mergeManager.setApplyEnabled(false);
                    }
                    return;
                }
                if (AbstractFunctionMerger.this.mergeManager != null) {
                    AbstractFunctionMerger.this.mergeManager.clearStatusText();
                }
                try {
                    AbstractFunctionMerger.this.mergeFunctionReturn(functions, chosenConflictOption, monitor);
                    if (AbstractFunctionMerger.this.mergeManager != null) {
                        AbstractFunctionMerger.this.mergeManager.setApplyEnabled(true);
                    }
                }
                catch (Exception e1) {
                    Msg.error((Object)this, (Object)("Unexpected Exception: " + e1.getMessage()), (Throwable)e1);
                }
            }
        };
        this.runSwing(() -> {
            this.verticalConflictPanel.setTitle("Function Return");
            String text = this.getConflictPrefixString(functions) + " has conflicting Return changes.<br>Choose the desired Return.<br>";
            this.verticalConflictPanel.setHeader(text);
            this.verticalConflictPanel.setRowHeader(this.getReturnInfo(null, null, null, null));
            boolean hasCustomerStorage = functions[0].hasCustomVariableStorage();
            this.verticalConflictPanel.addRadioButtonRow(this.getReturnInfo(this.programs[1], this.getReturnString(functions[1], hasCustomerStorage), "Use ", " version"), "LatestVersionRB", 2, changeListener);
            this.verticalConflictPanel.addRadioButtonRow(this.getReturnInfo(this.programs[2], this.getReturnString(functions[2], hasCustomerStorage), "Use ", " version"), "CheckedOutVersionRB", 4, changeListener);
            this.verticalConflictPanel.addInfoRow(this.getReturnInfo(this.programs[3], this.getReturnString(functions[3], hasCustomerStorage), "", " version"));
        });
        return this.verticalConflictPanel;
    }

    protected VerticalChoicesPanel createRemovedVarConflictPanel(final LocalVariableConflict lvc, final TaskMonitor monitor) {
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AbstractFunctionMerger.this.clearResolveInfo();
                int chosenConflictOption = AbstractFunctionMerger.this.verticalConflictPanel.getSelectedOptions();
                if (chosenConflictOption == 0) {
                    if (AbstractFunctionMerger.this.mergeManager != null) {
                        AbstractFunctionMerger.this.mergeManager.setApplyEnabled(false);
                    }
                    return;
                }
                if (AbstractFunctionMerger.this.mergeManager != null) {
                    AbstractFunctionMerger.this.mergeManager.clearStatusText();
                }
                try {
                    AbstractFunctionMerger.this.mergeLocalVariable(512, lvc.entry, lvc.vars, chosenConflictOption, monitor);
                    if (AbstractFunctionMerger.this.mergeManager != null) {
                        AbstractFunctionMerger.this.mergeManager.setApplyEnabled(true);
                    }
                }
                catch (Exception e1) {
                    String msg = "Failed to resolve variable '" + (lvc.vars[0] != null ? lvc.vars[0].getName() : "") + "'.";
                    MergeManager.showBlockingError("Resolve Variable Error", msg, e1);
                }
                AbstractFunctionMerger.this.showResolveInfo(AbstractFunctionMerger.this.getInfoTitle());
            }
        };
        VerticalChoicesPanel panel = this.getEmptyVerticalPanel();
        this.runSwing(() -> {
            panel.setTitle("Function Variable Remove");
            StringBuffer buf = new StringBuffer();
            buf.append("Function variable was removed in one version and changed in the other @ ");
            ConflictUtility.addAddress(buf, lvc.entry);
            buf.append(".");
            panel.setHeader(buf.toString());
            String origPrefix = "'";
            String latestPrefix = lvc.vars[1] == null ? "Remove as in '" : "Change as in '";
            String myPrefix = lvc.vars[2] == null ? "Remove as in '" : "Change as in '";
            String suffix = "' version";
            panel.setRowHeader(this.getVariableInfo(null, null));
            panel.addRadioButtonRow(this.getVariableInfo(lvc.vars[1], latestPrefix + "Latest" + suffix), "LatestVersionRB", 2, changeListener);
            panel.addRadioButtonRow(this.getVariableInfo(lvc.vars[2], myPrefix + "Checked Out" + suffix), "CheckedOutVersionRB", 4, changeListener);
            panel.addInfoRow(this.getVariableInfo(lvc.vars[0], origPrefix + "Original" + suffix));
        });
        return panel;
    }

    protected String getFunctionPrompt(Address addr, Function function, String version) {
        if (function == null) {
            return "Delete function as in '" + version + "' version.";
        }
        return "Keep function '" + function.getName() + "' as in '" + version + "' version.";
    }

    protected void updateProgressMessage(String message) {
        this.mergeManager.updateProgress(message);
    }

    public void dispose() {
        this.errorBuf = null;
        this.infoBuf = null;
        this.mergeManager = null;
        this.programs = new Program[4];
        this.functionManagers = new FunctionManager[4];
        this.listingMergeManager = null;
        this.resultAddressFactory = null;
        this.latestResolvedDts = null;
        this.myResolvedDts = null;
        this.origResolvedDts = null;
        this.listingMergePanel = null;
        this.verticalConflictPanel = null;
        this.variousConflictPanel = null;
        this.scrollingListConflictPanel = null;
        this.currentConflictPanel = null;
        this.currentMonitor = null;
        this.removeSet = null;
        this.funcConflicts = null;
        this.funcSet = null;
    }

    class ParamInfoConflict {
        Address entry;
        int ordinal;
        int paramConflicts;

        ParamInfoConflict(AbstractFunctionMerger this$0, Address entry, int ordinal, int paramConflicts) {
            this.entry = entry;
            this.ordinal = ordinal;
            this.paramConflicts = paramConflicts;
        }
    }

    class LocalVariableConflict {
        Address entry;
        Variable[] vars;
        int varConflicts;

        LocalVariableConflict(AbstractFunctionMerger this$0, Address entry, Variable[] vars, int varConflicts) {
            this.entry = entry;
            this.vars = vars;
            this.varConflicts = varConflicts;
        }
    }

    protected class FunctionDetailChangeListener
    implements ChangeListener {
        int type;
        Function[] functions;
        TaskMonitor monitor;
        VariousChoicesPanel vPanel;

        FunctionDetailChangeListener(int type, Function[] functions, VariousChoicesPanel vPanel, TaskMonitor monitor) {
            this.type = type;
            this.functions = functions;
            this.monitor = monitor;
            this.vPanel = vPanel;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ResolveConflictChangeEvent re = (ResolveConflictChangeEvent)e;
            int choice = re.getChoice();
            AbstractFunctionMerger.this.mergeFunctionDetail(this.type, this.functions, AbstractFunctionMerger.this.getOptionForChoice(choice), this.monitor);
            this.adjustUseForAll();
            this.adjustApply();
        }

        void adjustUseForAll() {
            if (AbstractFunctionMerger.this.mergeManager != null) {
                this.vPanel.adjustUseForAllEnablement();
            }
        }

        void adjustApply() {
            if (AbstractFunctionMerger.this.mergeManager != null) {
                AbstractFunctionMerger.this.mergeManager.setApplyEnabled(this.vPanel.allChoicesAreResolved());
            }
        }
    }

    class FunctionConflictChangeListener
    implements ChangeListener {
        int type;
        Address entryPt;
        TaskMonitor monitor;
        ConflictPanel vPanel;

        FunctionConflictChangeListener(int type, Address entryPt, ConflictPanel vPanel, TaskMonitor monitor) {
            this.type = type;
            this.entryPt = entryPt;
            this.monitor = monitor;
            this.vPanel = vPanel;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ResolveConflictChangeEvent re = (ResolveConflictChangeEvent)e;
            int choice = re.getChoice();
            try {
                switch (this.type) {
                    case 2: 
                    case 4: 
                    case 8: {
                        AbstractFunctionMerger.this.mergeFunction(this.entryPt, choice, AbstractFunctionMerger.this.currentMonitor);
                    }
                }
            }
            catch (CancelledException e1) {
                Msg.error((Object)this, (Object)("Unexpected Exception: " + e1.getMessage()), (Throwable)e1);
            }
            this.adjustApply();
        }

        void adjustApply() {
            if (AbstractFunctionMerger.this.mergeManager != null) {
                AbstractFunctionMerger.this.mergeManager.setApplyEnabled(this.vPanel.allChoicesAreResolved());
            }
        }
    }

    class LocalVarChangeListener
    implements ChangeListener {
        int type;
        Address entryPt;
        Variable[] vars;
        VariousChoicesPanel vPanel;
        TaskMonitor monitor;

        LocalVarChangeListener(int type, Address entryPt, Variable[] vars, VariousChoicesPanel vPanel, TaskMonitor monitor) {
            this.type = type;
            this.entryPt = entryPt;
            this.vars = vars;
            this.vPanel = vPanel;
            this.monitor = monitor;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ResolveConflictChangeEvent re = (ResolveConflictChangeEvent)e;
            int choice = re.getChoice();
            AbstractFunctionMerger.this.mergeLocalVariable(this.type, this.entryPt, this.vars, AbstractFunctionMerger.this.getOptionForChoice(choice), this.monitor);
            this.adjustUseForAll();
            this.adjustApply();
        }

        void adjustUseForAll() {
            if (AbstractFunctionMerger.this.mergeManager != null) {
                this.vPanel.adjustUseForAllEnablement();
            }
        }

        void adjustApply() {
            if (AbstractFunctionMerger.this.mergeManager != null) {
                AbstractFunctionMerger.this.mergeManager.setApplyEnabled(this.vPanel.allChoicesAreResolved());
            }
        }
    }

    class FunctionAddressIterator
    implements AddressIterator {
        FunctionIterator functionIterator;

        FunctionAddressIterator(AbstractFunctionMerger this$0, FunctionIterator funcIter) {
            this.functionIterator = funcIter;
        }

        public Address next() {
            return ((Function)this.functionIterator.next()).getEntryPoint();
        }

        public boolean hasNext() {
            return this.functionIterator.hasNext();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public Iterator<Address> iterator() {
            return this;
        }
    }
}

