/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.Tool;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.action.builder.AbstractActionBuilder;
import docking.action.builder.ActionBuilder;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.NavigatableActionContext;
import ghidra.app.events.ProgramClosedPluginEvent;
import ghidra.app.events.ProgramSelectionPluginEvent;
import ghidra.app.plugin.core.analysis.FindReferencesTableModel;
import ghidra.app.plugin.core.analysis.ReferenceAddressPair;
import ghidra.app.plugin.core.analysis.UpdateAlignmentAction;
import ghidra.app.plugin.core.table.TableComponentProvider;
import ghidra.app.services.GoToService;
import ghidra.app.util.query.TableService;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlockType;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import java.util.ArrayList;
import java.util.List;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Code Viewer", shortDescription="Search for Direct References", description="Plugin to find all possible direct references to the address at the current cursor location.  A direct reference is some set of bytes that whentreated as an address, match the address of the current cursor location.", servicesRequired={GoToService.class, TableService.class}, eventsConsumed={ProgramClosedPluginEvent.class})
public class FindPossibleReferencesPlugin
extends Plugin {
    static final String RESTORE_SELECTION_ACTION_NAME = "Restore Direct Refs Search Selection";
    static final String SEARCH_DIRECT_REFS_ACTION_NAME = "Search for Direct References";
    static final String SEARCH_DIRECT_REFS_ACTION_HELP = "Direct_Refs_Search_Alignment";
    private List<TableComponentProvider<ReferenceAddressPair>> providerList;

    public FindPossibleReferencesPlugin(PluginTool tool) {
        super(tool);
        this.createActions();
        this.providerList = new ArrayList<TableComponentProvider<ReferenceAddressPair>>();
    }

    public void processEvent(PluginEvent event) {
        if (event instanceof ProgramClosedPluginEvent) {
            Program program = ((ProgramClosedPluginEvent)event).getProgram();
            this.programClosed(program);
            return;
        }
    }

    private void programClosed(Program program) {
        ArrayList<TableComponentProvider<ReferenceAddressPair>> list = new ArrayList<TableComponentProvider<ReferenceAddressPair>>(this.providerList);
        for (int i = 0; i < list.size(); ++i) {
            TableComponentProvider p = (TableComponentProvider)list.get(i);
            FindReferencesTableModel model = (FindReferencesTableModel)p.getModel();
            if (program != model.getProgram()) continue;
            this.providerList.remove(p);
        }
    }

    private void createActions() {
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(SEARCH_DIRECT_REFS_ACTION_NAME, this.getName()).menuPath(new String[]{"&\u641c\u7d22", "For Direct References"})).menuGroup("search for", "DirectReferences")).helpLocation(new HelpLocation("Search", SEARCH_DIRECT_REFS_ACTION_NAME))).description(this.getPluginDescription().getDescription())).withContext(ListingActionContext.class, true).inWindow(AbstractActionBuilder.When.CONTEXT_MATCHES).onAction(this::findReferences).enabledWhen(this::hasCorrectAddressSize).buildAndInstall((Tool)this.tool);
    }

    private boolean hasCorrectAddressSize(NavigatableActionContext context) {
        int size = context.getProgram().getAddressFactory().getDefaultAddressSpace().getSize();
        return size == 64 || size == 32 || size == 24 || size == 16 || size == 20 || size == 21;
    }

    private void createLocalActions(NavigatableActionContext context, ComponentProvider p, FindReferencesTableModel model) {
        this.addLocalAlignment(p, model, 1);
        this.addLocalAlignment(p, model, 2);
        this.addLocalAlignment(p, model, 3);
        this.addLocalAlignment(p, model, 4);
        this.addLocalAlignment(p, model, 8);
        final ProgramSelection selection = context.getSelection();
        final Program pgm = context.getProgram();
        DockingAction localAction = new DockingAction(RESTORE_SELECTION_ACTION_NAME, this.getName()){

            public void actionPerformed(ActionContext actionContext) {
                FindPossibleReferencesPlugin.this.restoreSearchSelection(selection, pgm);
            }
        };
        localAction.setEnabled(false);
        localAction.setHelpLocation(new HelpLocation("Search", RESTORE_SELECTION_ACTION_NAME));
        String group = "selection";
        localAction.setMenuBarData(new MenuData(new String[]{"Restore Search Selection"}, group));
        localAction.setPopupMenuData(new MenuData(new String[]{"Restore Search Selection"}, group));
        localAction.setDescription("Sets the program selection back to the selection this search was based upon.");
        if (selection != null && !selection.isEmpty()) {
            localAction.setEnabled(true);
            this.tool.addLocalAction(p, (DockingActionIf)localAction);
        }
    }

    private UpdateAlignmentAction addLocalAlignment(ComponentProvider p, FindReferencesTableModel model, int alignment) {
        UpdateAlignmentAction alignAction = new UpdateAlignmentAction(this, model, alignment);
        alignAction.setEnabled(alignment >= model.getAlignment());
        alignAction.setHelpLocation(new HelpLocation("Search", SEARCH_DIRECT_REFS_ACTION_HELP));
        this.tool.addLocalAction(p, (DockingActionIf)alignAction);
        return alignAction;
    }

    protected void restoreSearchSelection(ProgramSelection selection, Program program) {
        ProgramSelectionPluginEvent event = new ProgramSelectionPluginEvent(this.getName(), selection, program);
        this.tool.firePluginEvent((PluginEvent)event);
    }

    private void findReferences(NavigatableActionContext context) {
        String title;
        ProgramSelection fromSet = context.getSelection();
        Address fromAddr = context.getAddress();
        Program currentProgram = context.getProgram();
        ProgramSelection currentSelection = context.getSelection();
        if (fromAddr == null) {
            return;
        }
        if (currentSelection == null || currentSelection.isEmpty()) {
            if (currentProgram.getMemory().getBlock(fromAddr) == null) {
                Msg.showWarn(((Object)((Object)this)).getClass(), null, (String)"Search For Direct References", (Object)("Could not find memory associated with " + String.valueOf(fromAddr)));
                return;
            }
            if (currentProgram.getMemory().getBlock(fromAddr).getType() == MemoryBlockType.BIT_MAPPED) {
                Msg.showWarn(((Object)((Object)this)).getClass(), null, (String)"Search For Direct References", (Object)"Cannot search for direct references on bit memory!");
                return;
            }
            fromSet = this.getAddressSetForCodeUnitAt(currentProgram, fromAddr);
            title = ": Direct Refs to " + String.valueOf(fromAddr);
        } else {
            title = ": Direct Refs to Selection @ " + String.valueOf(currentSelection.getMinAddress());
        }
        ArrayList<TableComponentProvider<ReferenceAddressPair>> list = new ArrayList<TableComponentProvider<ReferenceAddressPair>>(this.providerList);
        for (int i = 0; i < list.size(); ++i) {
            TableComponentProvider p = (TableComponentProvider)list.get(i);
            if (!this.tool.isVisible((ComponentProvider)p)) {
                this.providerList.remove(p);
                continue;
            }
            FindReferencesTableModel model = (FindReferencesTableModel)p.getModel();
            AddressSetView searchSet = model.getSearchAddressSet();
            Address searchAddr = model.getAddress();
            if ((fromSet == null || fromSet.isEmpty() || !fromSet.equals(searchSet)) && (fromSet != null && !fromSet.isEmpty() || !fromAddr.equals((Object)searchAddr))) continue;
            model.refresh();
            this.tool.showComponentProvider((ComponentProvider)p, true);
            return;
        }
        FindReferencesTableModel model = null;
        model = new FindReferencesTableModel(fromSet, this.tool, currentProgram);
        TableService service = (TableService)this.tool.getService(TableService.class);
        TableComponentProvider<ReferenceAddressPair> p = service.showTable("Find References to" + title, "Possible References", model, "References", context.getNavigatable());
        p.installRemoveItemsAction();
        p.setHelpLocation(new HelpLocation("Search", SEARCH_DIRECT_REFS_ACTION_NAME));
        this.createLocalActions(context, (ComponentProvider)p, model);
        this.providerList.add(p);
    }

    private AddressSet getAddressSetForCodeUnitAt(Program program, Address fromAddr) {
        AddressSet set = new AddressSet();
        CodeUnit codeUnit = program.getListing().getCodeUnitContaining(fromAddr);
        if (codeUnit == null) {
            set.addRange(fromAddr, fromAddr);
        } else {
            set.addRange(codeUnit.getMinAddress(), codeUnit.getMaxAddress());
        }
        return set;
    }
}

