/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis.rust.demangler;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public final class RustDemanglerV0 {
    public static final String RECURSION_LIMIT_MESSAGE = "{recursion limit reached}";
    public static final int MAX_DEPTH = 500;

    private RustDemanglerV0() {
    }

    public static String demangle(String symbol) {
        return RustDemanglerV0.demangleInternal(symbol, false);
    }

    public static String demangleAlternate(String symbol) {
        return RustDemanglerV0.demangleInternal(symbol, true);
    }

    private static String demangleInternal(String symbol, boolean alternate) {
        if (symbol == null || symbol.isEmpty()) {
            return null;
        }
        String inner = RustDemanglerV0.stripPrefix(symbol);
        if (inner == null || inner.isEmpty()) {
            return null;
        }
        if (!RustDemanglerV0.isAscii(inner)) {
            return null;
        }
        if (!RustDemanglerV0.startsWithUpperPath(inner)) {
            return null;
        }
        try {
            Parser parser = new Parser(inner);
            try {
                Parser afterFirst = Printer.dryRunParsePath(parser.copy(), false, alternate);
                if (RustDemanglerV0.startsWithUpperPath(afterFirst)) {
                    Printer.dryRunParsePath(afterFirst, false, alternate);
                }
            }
            catch (ParseException e) {
                if (e.isRecursedTooDeep()) {
                    return null;
                }
                return null;
            }
            Printer printer = new Printer(parser.copy(), new StringBuilder(), alternate);
            printer.printPath(true);
            String result = printer.finish();
            String suffix = printer.remaining();
            if (!suffix.isEmpty()) {
                boolean keepSuffix;
                boolean bl = keepSuffix = suffix.startsWith(".") && !suffix.startsWith(".llvm") && !suffix.startsWith("@@");
                if (!keepSuffix) {
                    suffix = "";
                }
            }
            return suffix.isEmpty() ? result : result + suffix;
        }
        catch (ParseException e) {
            if (e.isRecursedTooDeep()) {
                return e.message();
            }
            return null;
        }
    }

    private static String stripPrefix(String symbol) {
        if (symbol.length() > 2 && symbol.startsWith("_R")) {
            return symbol.substring(2);
        }
        if (symbol.length() > 1 && symbol.startsWith("R")) {
            return symbol.substring(1);
        }
        if (symbol.length() > 3 && symbol.startsWith("__R")) {
            return symbol.substring(3);
        }
        return null;
    }

    private static boolean isAscii(String text) {
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) < '\u0080') continue;
            return false;
        }
        return true;
    }

    private static boolean startsWithUpperPath(String text) {
        if (text == null || text.isEmpty()) {
            return false;
        }
        char c = text.charAt(0);
        return c >= 'A' && c <= 'Z';
    }

    private static boolean startsWithUpperPath(Parser parser) {
        int peek = parser.peek();
        return peek >= 65 && peek <= 90;
    }

    private static String basicType(char tag) {
        switch (tag) {
            case 'a': {
                return "i8";
            }
            case 'b': {
                return "bool";
            }
            case 'c': {
                return "char";
            }
            case 'd': {
                return "f64";
            }
            case 'e': {
                return "str";
            }
            case 'f': {
                return "f32";
            }
            case 'h': {
                return "u8";
            }
            case 'i': {
                return "isize";
            }
            case 'j': {
                return "usize";
            }
            case 'l': {
                return "i32";
            }
            case 'm': {
                return "u32";
            }
            case 'n': {
                return "i128";
            }
            case 'o': {
                return "u128";
            }
            case 'p': {
                return "_";
            }
            case 's': {
                return "i16";
            }
            case 't': {
                return "u16";
            }
            case 'u': {
                return "()";
            }
            case 'v': {
                return "...";
            }
            case 'x': {
                return "i64";
            }
            case 'y': {
                return "u64";
            }
            case 'z': {
                return "!";
            }
        }
        return null;
    }

    private static int clamp(int value, int min, int max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    private static int hexValue(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return 10 + (c - 97);
        }
        if (c >= 'A' && c <= 'F') {
            return 10 + (c - 65);
        }
        throw new IllegalArgumentException("invalid hex digit: " + c);
    }

    private static String stripLeadingZeros(String value) {
        int i;
        for (i = 0; i < value.length() && value.charAt(i) == '0'; ++i) {
        }
        return value.substring(i);
    }

    private static boolean isHexDigit(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    private static long multiplyExact(long a, long b) throws ParseException {
        if (a == 0L || b == 0L) {
            return 0L;
        }
        long result = a * b;
        if (Long.divideUnsigned(result, a) != b) {
            throw new ParseException(ParseErrorKind.INVALID);
        }
        return result;
    }

    private static long multiplyAddBase62(long value, int digit) throws ParseException {
        long mult = RustDemanglerV0.multiplyExact(value, 62L);
        return RustDemanglerV0.addExact(mult, (long)digit);
    }

    private static int multiplyExact(int a, int b) throws ParseException {
        try {
            return Math.multiplyExact(a, b);
        }
        catch (ArithmeticException e) {
            throw new ParseException(ParseErrorKind.INVALID);
        }
    }

    private static long addExact(long a, long b) throws ParseException {
        long result = a + b;
        if (Long.compareUnsigned(result, a) < 0) {
            throw new ParseException(ParseErrorKind.INVALID);
        }
        return result;
    }

    private static int addExact(int a, int b) throws ParseException {
        try {
            return Math.addExact(a, b);
        }
        catch (ArithmeticException e) {
            throw new ParseException(ParseErrorKind.INVALID);
        }
    }

    private static final class Parser {
        private final String sym;
        private int next;
        private int depth;

        Parser(String sym) {
            this(sym, 0, 0);
        }

        Parser(String sym, int next, int depth) {
            this.sym = sym;
            this.next = next;
            this.depth = depth;
        }

        Parser copy() {
            return new Parser(this.sym, this.next, this.depth);
        }

        String remaining() {
            return this.sym.substring(this.next);
        }

        int peek() {
            if (this.next >= this.sym.length()) {
                return -1;
            }
            return this.sym.charAt(this.next);
        }

        boolean eat(char expected) {
            if (this.peek() == expected) {
                ++this.next;
                return true;
            }
            return false;
        }

        char next() throws ParseException {
            if (this.next >= this.sym.length()) {
                throw new ParseException(ParseErrorKind.INVALID);
            }
            return this.sym.charAt(this.next++);
        }

        void pushDepth() throws ParseException {
            ++this.depth;
            if (this.depth > 500) {
                throw new ParseException(ParseErrorKind.RECURSED_TOO_DEEP);
            }
        }

        void popDepth() {
            --this.depth;
        }

        HexNibbles hexNibbles() throws ParseException {
            char c;
            int start = this.next;
            while (RustDemanglerV0.isHexDigit(c = this.next())) {
            }
            if (c != '_') {
                throw new ParseException(ParseErrorKind.INVALID);
            }
            return new HexNibbles(this.sym.substring(start, this.next - 1));
        }

        int digit10() throws ParseException {
            int p = this.peek();
            if (p >= 48 && p <= 57) {
                ++this.next;
                return p - 48;
            }
            throw new ParseException(ParseErrorKind.INVALID);
        }

        int digit62() throws ParseException {
            int p = this.peek();
            if (p >= 48 && p <= 57) {
                ++this.next;
                return p - 48;
            }
            if (p >= 97 && p <= 122) {
                ++this.next;
                return 10 + (p - 97);
            }
            if (p >= 65 && p <= 90) {
                ++this.next;
                return 36 + (p - 65);
            }
            throw new ParseException(ParseErrorKind.INVALID);
        }

        long integer62() throws ParseException {
            if (this.eat('_')) {
                return 0L;
            }
            long value = 0L;
            while (!this.eat('_')) {
                int digit = this.digit62();
                value = RustDemanglerV0.multiplyAddBase62(value, digit);
            }
            return RustDemanglerV0.addExact(value, 1L);
        }

        long optInteger62(char tag) throws ParseException {
            if (!this.eat(tag)) {
                return 0L;
            }
            return RustDemanglerV0.addExact(this.integer62(), 1L);
        }

        long disambiguator() throws ParseException {
            return this.optInteger62('s');
        }

        Character namespace() throws ParseException {
            char c = this.next();
            if (c >= 'A' && c <= 'Z') {
                return Character.valueOf(c);
            }
            if (c >= 'a' && c <= 'z') {
                return null;
            }
            throw new ParseException(ParseErrorKind.INVALID);
        }

        Parser backref() throws ParseException {
            int start = this.next - 1;
            long offset = this.integer62();
            if (offset >= (long)start) {
                throw new ParseException(ParseErrorKind.INVALID);
            }
            Parser p = new Parser(this.sym, (int)offset, this.depth);
            p.pushDepth();
            return p;
        }

        Ident ident() throws ParseException {
            boolean isPunycode = this.eat('u');
            int len = this.digit10();
            if (len != 0) {
                int peek;
                while ((peek = this.peek()) >= 48 && peek <= 57) {
                    ++this.next;
                    len = RustDemanglerV0.multiplyExact(len, 10);
                    len = RustDemanglerV0.addExact(len, peek - 48);
                }
            }
            this.eat('_');
            if (len < 0 || this.next + len > this.sym.length()) {
                throw new ParseException(ParseErrorKind.INVALID);
            }
            String raw = this.sym.substring(this.next, this.next + len);
            this.next += len;
            if (isPunycode) {
                String punycode;
                String ascii;
                int sep = raw.lastIndexOf(95);
                if (sep >= 0) {
                    ascii = raw.substring(0, sep);
                    punycode = raw.substring(sep + 1);
                } else {
                    ascii = "";
                    punycode = raw;
                }
                if (punycode.isEmpty()) {
                    throw new ParseException(ParseErrorKind.INVALID);
                }
                return new Ident(ascii, punycode);
            }
            return new Ident(raw, "");
        }
    }

    private static final class Printer {
        private Parser parser;
        private StringBuilder out;
        private int boundLifetimeDepth;
        private final boolean alternate;

        Printer(Parser parser, StringBuilder out, boolean alternate) {
            this.parser = parser;
            this.out = out;
            this.boundLifetimeDepth = 0;
            this.alternate = alternate;
        }

        static Parser dryRunParsePath(Parser parser, boolean inValue, boolean alternate) throws ParseException {
            Printer printer = new Printer(parser, null, alternate);
            printer.printPath(inValue);
            return printer.parser.copy();
        }

        String finish() {
            return this.out == null ? "" : this.out.toString();
        }

        String remaining() {
            return this.parser.remaining();
        }

        void printPath(boolean inValue) throws ParseException {
            this.parser.pushDepth();
            char tag = this.parser.next();
            switch (tag) {
                case 'C': {
                    long dis = this.parser.disambiguator();
                    Ident name = this.parser.ident();
                    this.print(name.render());
                    if (dis == 0L || this.alternate) break;
                    this.print('[');
                    this.printLowerHex(dis);
                    this.print(']');
                    break;
                }
                case 'N': {
                    Character ns = this.parser.namespace();
                    this.printPath(inValue);
                    long dis = this.parser.disambiguator();
                    Ident name = this.parser.ident();
                    if (ns != null) {
                        this.print("::{");
                        switch (ns.charValue()) {
                            case 'C': {
                                this.print("closure");
                                break;
                            }
                            case 'S': {
                                this.print("shim");
                                break;
                            }
                            default: {
                                this.print(ns.charValue());
                            }
                        }
                        if (!name.isEmpty()) {
                            this.print(':');
                            this.print(name.render());
                        }
                        this.print('#');
                        this.print(dis);
                        this.print('}');
                        break;
                    }
                    if (name.isEmpty()) break;
                    this.print("::");
                    this.print(name.render());
                    break;
                }
                case 'M': 
                case 'X': 
                case 'Y': {
                    if (tag != 'Y') {
                        this.parser.disambiguator();
                        this.skippingPrinting(pr -> pr.printPath(false));
                    }
                    this.print('<');
                    this.printType();
                    if (tag != 'M') {
                        this.print(" as ");
                        this.printPath(false);
                    }
                    this.print('>');
                    break;
                }
                case 'I': {
                    this.printPath(inValue);
                    if (inValue) {
                        this.print("::");
                    }
                    this.print('<');
                    this.printSepList(pr -> pr.printGenericArg(), ", ");
                    this.print('>');
                    break;
                }
                case 'B': {
                    this.printBackref(pr -> pr.printPath(inValue));
                    break;
                }
                default: {
                    throw new ParseException(ParseErrorKind.INVALID);
                }
            }
            this.parser.popDepth();
        }

        private void printGenericArg() throws ParseException {
            if (this.parser.eat('L')) {
                long lt = this.parser.integer62();
                this.printLifetimeFromIndex(lt);
            } else if (this.parser.eat('K')) {
                this.printConst(false);
            } else {
                this.printType();
            }
        }

        private void printType() throws ParseException {
            char tag = this.parser.next();
            String basic = RustDemanglerV0.basicType(tag);
            if (basic != null) {
                this.print(basic);
                return;
            }
            this.parser.pushDepth();
            switch (tag) {
                case 'Q': 
                case 'R': {
                    long lt;
                    this.print('&');
                    if (this.parser.eat('L') && (lt = this.parser.integer62()) != 0L) {
                        this.printLifetimeFromIndex(lt);
                        this.print(' ');
                    }
                    if (tag != 'R') {
                        this.print("mut ");
                    }
                    this.printType();
                    break;
                }
                case 'O': 
                case 'P': {
                    this.print('*');
                    if (tag == 'P') {
                        this.print("const ");
                    } else {
                        this.print("mut ");
                    }
                    this.printType();
                    break;
                }
                case 'A': 
                case 'S': {
                    this.print('[');
                    this.printType();
                    if (tag == 'A') {
                        this.print("; ");
                        this.printConst(true);
                    }
                    this.print(']');
                    break;
                }
                case 'T': {
                    this.print('(');
                    int count = this.printSepList(Printer::printType, ", ");
                    if (count == 1) {
                        this.print(',');
                    }
                    this.print(')');
                    break;
                }
                case 'F': {
                    this.inBinder(pr -> {
                        boolean isUnsafe = pr.parser.eat('U');
                        String abi = null;
                        if (pr.parser.eat('K')) {
                            if (pr.parser.eat('C')) {
                                abi = "C";
                            } else {
                                Ident ident = pr.parser.ident();
                                if (!ident.punycode.isEmpty() || ident.ascii.isEmpty()) {
                                    throw new ParseException(ParseErrorKind.INVALID);
                                }
                                abi = ident.ascii;
                            }
                        }
                        if (isUnsafe) {
                            pr.print("unsafe ");
                        }
                        if (abi != null) {
                            pr.print("extern \"");
                            String[] parts = abi.split("_");
                            for (int i = 0; i < parts.length; ++i) {
                                if (i != 0) {
                                    pr.print('-');
                                }
                                pr.print(parts[i]);
                            }
                            pr.print("\" ");
                        }
                        pr.print("fn(");
                        pr.printSepList(Printer::printType, ", ");
                        pr.print(')');
                        if (!pr.parser.eat('u')) {
                            pr.print(" -> ");
                            pr.printType();
                        }
                    });
                    break;
                }
                case 'D': {
                    this.print("dyn ");
                    this.inBinder(pr -> pr.printSepList(Printer::printDynTrait, " + "));
                    if (!this.parser.eat('L')) {
                        throw new ParseException(ParseErrorKind.INVALID);
                    }
                    long lt = this.parser.integer62();
                    if (lt == 0L) break;
                    this.print(" + ");
                    this.printLifetimeFromIndex(lt);
                    break;
                }
                case 'B': {
                    this.printBackref(Printer::printType);
                    break;
                }
                case 'W': {
                    this.printType();
                    this.print(" is ");
                    this.printPat();
                    break;
                }
                default: {
                    --this.parser.next;
                    this.printPath(false);
                }
            }
            this.parser.popDepth();
        }

        private boolean printPathMaybeOpenGenerics() throws ParseException {
            if (this.parser.eat('B')) {
                boolean[] open = new boolean[]{false};
                this.printBackref(pr -> {
                    open[0] = pr.printPathMaybeOpenGenerics();
                });
                return open[0];
            }
            if (this.parser.eat('I')) {
                this.printPath(false);
                this.print('<');
                this.printSepList(Printer::printGenericArg, ", ");
                return true;
            }
            this.printPath(false);
            return false;
        }

        private void printDynTrait() throws ParseException {
            boolean open = this.printPathMaybeOpenGenerics();
            while (this.parser.eat('p')) {
                if (!open) {
                    this.print('<');
                    open = true;
                } else {
                    this.print(", ");
                }
                Ident name = this.parser.ident();
                this.print(name.render());
                this.print(" = ");
                this.printType();
            }
            if (open) {
                this.print('>');
            }
        }

        private void printPat() throws ParseException {
            char tag = this.parser.next();
            switch (tag) {
                case 'R': {
                    this.printConst(false);
                    this.print("..=");
                    this.printConst(false);
                    break;
                }
                case 'O': {
                    this.parser.pushDepth();
                    this.printPat();
                    while (!this.parser.eat('E')) {
                        this.print(" | ");
                        this.printPat();
                    }
                    this.parser.popDepth();
                    break;
                }
                case 'N': {
                    this.print("!null");
                    break;
                }
                default: {
                    throw new ParseException(ParseErrorKind.INVALID);
                }
            }
        }

        private void printConst(boolean inValue) throws ParseException {
            char tag = this.parser.next();
            this.parser.pushDepth();
            boolean openedBrace = false;
            boolean requireWrap = !inValue;
            block0 : switch (tag) {
                case 'p': {
                    this.print('_');
                    break;
                }
                case 'h': 
                case 'j': 
                case 'm': 
                case 'o': 
                case 't': 
                case 'y': {
                    this.printConstUint(tag);
                    break;
                }
                case 'a': 
                case 'i': 
                case 'l': 
                case 'n': 
                case 's': 
                case 'x': {
                    if (this.parser.eat('n')) {
                        this.print('-');
                    }
                    this.printConstUint(tag);
                    break;
                }
                case 'b': {
                    Long v = this.parser.hexNibbles().tryParseUInt();
                    if (v == null) {
                        throw new ParseException(ParseErrorKind.INVALID);
                    }
                    if (v == 0L) {
                        this.print("false");
                        break;
                    }
                    if (v == 1L) {
                        this.print("true");
                        break;
                    }
                    throw new ParseException(ParseErrorKind.INVALID);
                }
                case 'c': {
                    Long value = this.parser.hexNibbles().tryParseUInt();
                    if (value == null || value < 0L || value > 0x10FFFFL) {
                        throw new ParseException(ParseErrorKind.INVALID);
                    }
                    String data = new String(Character.toChars(value.intValue()));
                    this.printQuotedEscapedChars('\'', data);
                    break;
                }
                case 'e': {
                    if (requireWrap) {
                        openedBrace = true;
                        this.print('{');
                    }
                    this.print('*');
                    this.printConstStrLiteral();
                    break;
                }
                case 'Q': 
                case 'R': {
                    if (tag == 'R' && this.parser.eat('e')) {
                        this.printConstStrLiteral(true);
                        break;
                    }
                    if (requireWrap) {
                        openedBrace = true;
                        this.print('{');
                    }
                    this.print('&');
                    if (tag != 'R') {
                        this.print("mut ");
                    }
                    this.printConst(true);
                    break;
                }
                case 'A': {
                    if (requireWrap) {
                        openedBrace = true;
                        this.print('{');
                    }
                    this.print('[');
                    this.printSepList(pr -> pr.printConst(true), ", ");
                    this.print(']');
                    break;
                }
                case 'T': {
                    if (requireWrap) {
                        openedBrace = true;
                        this.print('{');
                    }
                    this.print('(');
                    int count = this.printSepList(pr -> pr.printConst(true), ", ");
                    if (count == 1) {
                        this.print(',');
                    }
                    this.print(')');
                    break;
                }
                case 'V': {
                    if (requireWrap) {
                        openedBrace = true;
                        this.print('{');
                    }
                    this.printPath(true);
                    char variant = this.parser.next();
                    switch (variant) {
                        case 'U': {
                            break block0;
                        }
                        case 'T': {
                            this.print('(');
                            this.printSepList(pr -> pr.printConst(true), ", ");
                            this.print(')');
                            break block0;
                        }
                        case 'S': {
                            this.print(" { ");
                            this.printSepList(pr -> {
                                pr.parser.disambiguator();
                                Ident name = pr.parser.ident();
                                pr.print(name.render());
                                pr.print(": ");
                                pr.printConst(true);
                            }, ", ");
                            this.print(" }");
                            break block0;
                        }
                    }
                    throw new ParseException(ParseErrorKind.INVALID);
                }
                case 'B': {
                    this.printBackref(pr -> pr.printConst(inValue));
                    break;
                }
                default: {
                    throw new ParseException(ParseErrorKind.INVALID);
                }
            }
            if (openedBrace) {
                this.print('}');
            }
            this.parser.popDepth();
        }

        private void printConstStrLiteral() throws ParseException {
            this.printConstStrLiteral(false);
        }

        private void printConstStrLiteral(boolean bare) throws ParseException {
            String decoded = this.parser.hexNibbles().tryParseStr();
            if (decoded == null) {
                throw new ParseException(ParseErrorKind.INVALID);
            }
            if (bare) {
                this.printQuotedEscapedChars('\"', decoded);
            } else {
                this.printQuotedEscapedChars('\"', decoded);
            }
        }

        private void printConstUint(char tyTag) throws ParseException {
            HexNibbles hex = this.parser.hexNibbles();
            Long value = hex.tryParseUInt();
            if (value != null) {
                this.print(value);
            } else {
                this.print("0x");
                this.print(hex.nibbles);
            }
            String ty = RustDemanglerV0.basicType(tyTag);
            if (ty != null && !this.alternate) {
                this.print(ty);
            }
        }

        private void printBackref(PrinterConsumer consumer) throws ParseException {
            Parser backref = this.parser.backref();
            if (this.out == null) {
                return;
            }
            Parser saved = this.parser;
            this.parser = backref;
            consumer.accept(this);
            this.parser = saved;
        }

        private void inBinder(PrinterConsumer consumer) throws ParseException {
            long count = this.parser.optInteger62('G');
            if (this.out == null) {
                consumer.accept(this);
                return;
            }
            if (count > 0L) {
                this.print("for<");
                int i = 0;
                while ((long)i < count) {
                    if (i != 0) {
                        this.print(", ");
                    }
                    ++this.boundLifetimeDepth;
                    this.printLifetimeFromIndex(1L);
                    ++i;
                }
                this.print("> ");
            }
            consumer.accept(this);
            this.boundLifetimeDepth -= (int)count;
        }

        private int printSepList(PrinterConsumer consumer, String sep) throws ParseException {
            int count = 0;
            while (!this.parser.eat('E')) {
                if (count != 0) {
                    this.print(sep);
                }
                consumer.accept(this);
                ++count;
            }
            return count;
        }

        private void printLifetimeFromIndex(long lt) throws ParseException {
            if (this.out == null) {
                return;
            }
            this.print('\'');
            if (lt == 0L) {
                this.print('_');
                return;
            }
            long depth = (long)this.boundLifetimeDepth - lt;
            if (depth < 0L) {
                throw new ParseException(ParseErrorKind.INVALID);
            }
            if (depth < 26L) {
                this.print((char)(97L + depth));
            } else {
                this.print('_');
                this.print(depth);
            }
        }

        private void skippingPrinting(PrinterConsumer consumer) throws ParseException {
            StringBuilder original = this.out;
            this.out = null;
            consumer.accept(this);
            this.out = original;
        }

        private void print(String text) {
            if (this.out != null) {
                this.out.append(text);
            }
        }

        private void print(char c) {
            if (this.out != null) {
                this.out.append(c);
            }
        }

        private void print(long value) {
            if (this.out != null) {
                this.out.append(value);
            }
        }

        private void printLowerHex(long value) {
            if (this.out != null) {
                this.out.append(Long.toHexString(value));
            }
        }

        private void printQuotedEscapedChars(char quote, String data) {
            if (this.out == null) {
                return;
            }
            this.out.append(quote);
            data.codePoints().forEach(cp -> {
                if (quote == '\'' && cp == 34 || quote == '\"' && cp == 39) {
                    this.out.appendCodePoint(cp);
                    return;
                }
                switch (cp) {
                    case 92: {
                        this.out.append("\\\\");
                        break;
                    }
                    case 10: {
                        this.out.append("\\n");
                        break;
                    }
                    case 13: {
                        this.out.append("\\r");
                        break;
                    }
                    case 9: {
                        this.out.append("\\t");
                        break;
                    }
                    case 0: {
                        this.out.append("\\0");
                        break;
                    }
                    case 34: {
                        if (quote == '\"') {
                            this.out.append("\\\"");
                            break;
                        }
                        this.out.append('\"');
                        break;
                    }
                    case 39: {
                        if (quote == '\'') {
                            this.out.append("\\'");
                            break;
                        }
                        this.out.append('\'');
                        break;
                    }
                    default: {
                        if (cp < 32 || cp == 127) {
                            this.out.append(String.format("\\x%02x", cp));
                            break;
                        }
                        this.out.appendCodePoint(cp);
                    }
                }
            });
            this.out.append(quote);
        }
    }

    private static final class ParseException
    extends Exception {
        private static final long serialVersionUID = 1L;
        final ParseErrorKind kind;

        ParseException(ParseErrorKind kind) {
            this.kind = kind;
        }

        boolean isRecursedTooDeep() {
            return this.kind == ParseErrorKind.RECURSED_TOO_DEEP;
        }

        String message() {
            return switch (this.kind.ordinal()) {
                default -> throw new MatchException(null, null);
                case 1 -> RustDemanglerV0.RECURSION_LIMIT_MESSAGE;
                case 0 -> "{invalid syntax}";
            };
        }
    }

    private static enum ParseErrorKind {
        INVALID,
        RECURSED_TOO_DEEP;

    }

    private static final class HexNibbles {
        private final String nibbles;

        HexNibbles(String nibbles) {
            this.nibbles = nibbles;
        }

        Long tryParseUInt() {
            String trimmed = RustDemanglerV0.stripLeadingZeros(this.nibbles);
            if (trimmed.length() > 16) {
                return null;
            }
            long value = 0L;
            for (int i = 0; i < trimmed.length(); ++i) {
                int digit = RustDemanglerV0.hexValue(trimmed.charAt(i));
                value = value << 4 | (long)digit;
            }
            return value;
        }

        String tryParseStr() {
            if ((this.nibbles.length() & 1) != 0) {
                return null;
            }
            byte[] bytes = new byte[this.nibbles.length() / 2];
            for (int i = 0; i < bytes.length; ++i) {
                int hi = RustDemanglerV0.hexValue(this.nibbles.charAt(2 * i));
                int lo = RustDemanglerV0.hexValue(this.nibbles.charAt(2 * i + 1));
                bytes[i] = (byte)(hi << 4 | lo);
            }
            try {
                return StandardCharsets.UTF_8.newDecoder().decode(ByteBuffer.wrap(bytes)).toString();
            }
            catch (CharacterCodingException e) {
                return null;
            }
        }
    }

    private static final class Ident {
        private final String ascii;
        private final String punycode;

        Ident(String ascii, String punycode) {
            this.ascii = ascii;
            this.punycode = punycode;
        }

        boolean isEmpty() {
            return this.ascii.isEmpty() && this.punycode.isEmpty();
        }

        String render() {
            if (this.punycode.isEmpty()) {
                return this.ascii;
            }
            List<Integer> decoded = this.decodePunycode();
            if (decoded == null) {
                StringBuilder builder = new StringBuilder("punycode{");
                if (!this.ascii.isEmpty()) {
                    builder.append(this.ascii).append('-');
                }
                builder.append(this.punycode).append('}');
                return builder.toString();
            }
            StringBuilder out = new StringBuilder();
            for (int cp : decoded) {
                out.appendCodePoint(cp);
            }
            return out.toString();
        }

        private List<Integer> decodePunycode() {
            if (this.punycode.isEmpty()) {
                return null;
            }
            ArrayList<Integer> output = new ArrayList<Integer>();
            this.ascii.codePoints().forEach(cp -> output.add(cp));
            int base = 36;
            int tMin = 1;
            int tMax = 26;
            int skew = 38;
            int damp = 700;
            int bias = 72;
            long i = 0L;
            long n = 128L;
            int index = 0;
            while (index < this.punycode.length()) {
                long delta = 0L;
                long w = 1L;
                int k = base;
                while (true) {
                    int digit;
                    char c;
                    if (index >= this.punycode.length()) {
                        return null;
                    }
                    if ((c = this.punycode.charAt(index++)) >= 'a' && c <= 'z') {
                        digit = c - 97;
                    } else if (c >= '0' && c <= '9') {
                        digit = 26 + (c - 48);
                    } else {
                        return null;
                    }
                    try {
                        delta = RustDemanglerV0.addExact(delta, RustDemanglerV0.multiplyExact(w, (long)digit));
                    }
                    catch (ParseException e) {
                        return null;
                    }
                    int t = RustDemanglerV0.clamp(k - bias, tMin, tMax);
                    if (digit < t) break;
                    try {
                        w = RustDemanglerV0.multiplyExact(w, (long)(base - t));
                    }
                    catch (ParseException e) {
                        return null;
                    }
                    k += base;
                }
                int outLen = output.size() + 1;
                try {
                    i = RustDemanglerV0.addExact(i, delta);
                    n = RustDemanglerV0.addExact(n, i / (long)outLen);
                }
                catch (ParseException e) {
                    return null;
                }
                if (!Character.isValidCodePoint((int)n) || (i %= (long)outLen) > Integer.MAX_VALUE) {
                    return null;
                }
                output.add((int)i, (int)n);
                ++i;
                delta /= (long)damp;
                damp = 2;
                delta += delta / (long)outLen;
                int kAdjust = 0;
                while (delta > (long)(base - tMin) * (long)tMax / 2L) {
                    delta /= (long)(base - tMin);
                    kAdjust += base;
                }
                bias = kAdjust + (int)(((long)(base - tMin) + 1L) * delta / (delta + (long)skew));
            }
            return output;
        }
    }

    @FunctionalInterface
    private static interface PrinterConsumer {
        public void accept(Printer var1) throws ParseException;
    }
}

