/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.archive;

import docking.DialogComponentProvider;
import docking.ReusableDialogComponentProvider;
import docking.widgets.button.BrowseButton;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.filechooser.GhidraFileChooserMode;
import docking.widgets.label.GDLabel;
import docking.widgets.textfield.ElidingFilePathTextField;
import generic.theme.Gui;
import ghidra.app.plugin.core.archive.ArchivePlugin;
import ghidra.framework.GenericRunInfo;
import ghidra.framework.model.ProjectLocator;
import ghidra.framework.preferences.Preferences;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.NamingUtilities;
import ghidra.util.filechooser.ExtensionFileFilter;
import ghidra.util.filechooser.GhidraFileFilter;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class RestoreDialog
extends ReusableDialogComponentProvider {
    private static final int NUM_TEXT_COLUMNS = 40;
    private ArchivePlugin plugin;
    private boolean actionComplete;
    private JLabel archiveLabel;
    private JTextField archiveField;
    private JButton archiveBrowse;
    private JLabel restoreLabel;
    private JTextField restoreField;
    private JButton restoreBrowse;
    private JLabel projectNameLabel;
    private JTextField projectNameField;
    private String archivePathName;
    private ProjectLocator restoreURL;

    public RestoreDialog(ArchivePlugin plugin) {
        super("Restore Project Archive");
        this.plugin = plugin;
        this.initialize();
        this.setHelpLocation(new HelpLocation("FrontEndPlugin", "Restore_Project"));
    }

    protected void initialize() {
        this.addWorkPanel(this.buildMainPanel());
        this.addOKButton();
        this.addCancelButton();
    }

    protected JPanel buildMainPanel() {
        this.archiveLabel = new GDLabel(" Archive File ");
        this.archiveLabel.getAccessibleContext().setAccessibleName("Archive File");
        this.archiveField = new ElidingFilePathTextField();
        this.archiveField.setColumns(40);
        this.archiveField.setName("archiveField");
        this.archiveField.getAccessibleContext().setAccessibleName("Archive");
        this.archiveBrowse = new BrowseButton();
        this.archiveBrowse.setName("archiveButton");
        this.archiveBrowse.getAccessibleContext().setAccessibleName("Archive");
        this.archiveBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object archivePath = RestoreDialog.this.chooseArchiveFile("Choose archive file", "Selects the project archive file to restore.");
                if (archivePath != null && !((String)archivePath).equals("")) {
                    if (!((String)archivePath).endsWith(".gar")) {
                        archivePath = (String)archivePath + ".gar";
                    }
                    RestoreDialog.this.archiveField.setText((String)archivePath);
                    String projectName = ArchivePlugin.getProjectName((String)archivePath);
                    RestoreDialog.this.projectNameField.setText(projectName);
                    String dir = RestoreDialog.this.restoreField.getText().trim();
                    if (dir.equals("")) {
                        dir = ((String)archivePath).substring(0, ((String)archivePath).lastIndexOf(File.separator));
                        RestoreDialog.this.restoreField.setText(dir);
                    }
                    if (projectName == null || projectName.equals("")) {
                        Msg.showError((Object)this, (Component)RestoreDialog.this.getComponent(), (String)"Error Restoring Project", (Object)"Archive File is not a valid project archive.");
                    }
                }
            }
        });
        Gui.registerFont((JComponent)this.archiveBrowse, (int)1);
        this.restoreLabel = new GDLabel(" Restore Directory ");
        this.restoreLabel.getAccessibleContext().setAccessibleName("Restore Directory");
        this.restoreField = new ElidingFilePathTextField();
        this.restoreField.setName("restoreField");
        this.restoreField.getAccessibleContext().setAccessibleName("Restore");
        this.restoreField.setColumns(40);
        this.restoreBrowse = new BrowseButton();
        this.restoreBrowse.setName("restoreButton");
        this.restoreBrowse.getAccessibleContext().setAccessibleName("Restore Browse");
        this.restoreBrowse.addActionListener(e -> {
            String dirPath = this.chooseDirectory("Choose restore directory", "Select the directory for restoring the project.");
            if (dirPath != null) {
                this.restoreField.setText(dirPath);
            }
        });
        Gui.registerFont((JComponent)this.restoreBrowse, (int)1);
        this.projectNameLabel = new GDLabel(" Project Name ");
        this.projectNameLabel.getAccessibleContext().setAccessibleName("Project Name");
        this.projectNameField = new JTextField();
        this.projectNameField.setName("projectNameField");
        this.projectNameField.getAccessibleContext().setAccessibleName("Project Name");
        this.projectNameField.setColumns(40);
        this.projectNameField.addActionListener(e -> {
            if (this.archiveField.getText().length() > 0 && this.restoreField.getText().length() > 0 && this.projectNameField.getText().length() > 0) {
                this.okCallback();
            }
        });
        GridBagLayout gbl = new GridBagLayout();
        JPanel outerPanel = new JPanel(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets.top = 5;
        gbc.insets.left = 5;
        gbc.insets.right = 5;
        gbc.anchor = 13;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbl.setConstraints(this.archiveLabel, gbc);
        outerPanel.add(this.archiveLabel);
        gbc.gridy = 1;
        gbl.setConstraints(this.restoreLabel, gbc);
        outerPanel.add(this.restoreLabel);
        gbc.gridy = 2;
        gbl.setConstraints(this.projectNameLabel, gbc);
        outerPanel.add(this.projectNameLabel);
        gbc.anchor = 10;
        gbc.insets.left = 0;
        gbc.insets.right = 0;
        gbc.weightx = 1.0;
        gbc.gridwidth = 1;
        gbc.fill = 2;
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbl.setConstraints(this.archiveField, gbc);
        outerPanel.add(this.archiveField);
        gbc.gridy = 1;
        gbl.setConstraints(this.restoreField, gbc);
        outerPanel.add(this.restoreField);
        gbc.gridy = 2;
        gbl.setConstraints(this.projectNameField, gbc);
        outerPanel.add(this.projectNameField);
        gbc.weightx = 0.0;
        gbc.anchor = 17;
        gbc.gridwidth = 1;
        gbc.insets.left = 5;
        gbc.insets.right = 5;
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbl.setConstraints(this.archiveBrowse, gbc);
        outerPanel.add(this.archiveBrowse);
        gbc.gridy = 1;
        gbl.setConstraints(this.restoreBrowse, gbc);
        outerPanel.add(this.restoreBrowse);
        outerPanel.getAccessibleContext().setAccessibleName("Restore");
        return outerPanel;
    }

    protected void okCallback() {
        if (this.checkInput()) {
            this.actionComplete = true;
            this.close();
        } else {
            this.getComponent().getToolkit().beep();
        }
    }

    protected void cancelCallback() {
        this.setStatusText("");
        this.close();
    }

    public boolean showDialog(String pathName, ProjectLocator projectLocator) {
        this.archivePathName = pathName;
        this.restoreURL = projectLocator;
        String projectName = this.projectNameField.getText();
        if (projectName == null || projectName.equals("")) {
            projectName = ArchivePlugin.getProjectName(pathName);
        }
        this.archiveField.setText(pathName);
        this.restoreField.setText(projectLocator != null ? projectLocator.getLocation() : null);
        this.projectNameField.setText(projectName);
        this.actionComplete = false;
        this.plugin.getTool().showDialog((DialogComponentProvider)this);
        return this.actionComplete;
    }

    public String getArchivePathName() {
        String archive = this.archiveField.getText().trim();
        if (archive.length() == 0) {
            return null;
        }
        File file = new File(archive);
        Object pathName = file.getAbsolutePath();
        if (pathName == null || ((String)pathName).length() == 0) {
            return null;
        }
        if (!((String)pathName).endsWith(".gar")) {
            pathName = (String)pathName + ".gar";
        }
        return pathName;
    }

    ProjectLocator getRestoreURL() {
        return this.restoreURL;
    }

    private boolean checkInput() {
        String archiveName = this.getArchivePathName();
        if (archiveName == null || archiveName.equals("")) {
            this.setStatusText("Specify a valid archive file.");
            return false;
        }
        String restoreDir = this.restoreField.getText().trim();
        if (restoreDir == null || restoreDir.equals("") || !new File(restoreDir).isDirectory()) {
            this.setStatusText("Specify a valid project directory.");
            return false;
        }
        String restoreProjectName = this.projectNameField.getText().trim();
        if (restoreProjectName == null || restoreProjectName.equals("") || !NamingUtilities.isValidName((String)restoreProjectName)) {
            this.setStatusText("Specify a valid project name.");
            return false;
        }
        this.archivePathName = archiveName;
        this.restoreURL = new ProjectLocator(restoreDir, restoreProjectName);
        File projFile = this.restoreURL.getMarkerFile();
        File projDir = this.restoreURL.getProjectDir();
        this.setStatusText("");
        if (projFile.exists() || projDir.exists()) {
            Msg.showInfo(((Object)((Object)this)).getClass(), (Component)this.getComponent(), (String)"Project Exists", (Object)("Cannot restore project because project named " + restoreProjectName + " already exists."));
            return false;
        }
        return true;
    }

    private GhidraFileChooser createFileChooser(String extension, String desc, String filePathName) {
        String exampleExtension = extension;
        long lastIndex = extension.lastIndexOf(".");
        if (lastIndex >= 0L) {
            exampleExtension = extension.substring((int)(lastIndex + 1L));
        }
        GhidraFileChooser fileChooser = new GhidraFileChooser(null);
        File file = null;
        if (filePathName != null && filePathName.length() > 0) {
            file = new File(filePathName);
            if (file.isDirectory()) {
                fileChooser.setCurrentDirectory(file);
            } else {
                fileChooser.setSelectedFile(file);
            }
        }
        if (file == null) {
            file = new File(GenericRunInfo.getProjectsDirPath());
            fileChooser.setCurrentDirectory(file);
        }
        fileChooser.setFileSelectionMode(0);
        fileChooser.setFileFilter((GhidraFileFilter)new ExtensionFileFilter(exampleExtension, desc));
        return fileChooser;
    }

    private GhidraFileChooser createDirectoryChooser() {
        GhidraFileChooser fileChooser = new GhidraFileChooser(null);
        File projectDirectory = new File(GenericRunInfo.getProjectsDirPath());
        fileChooser.setFileSelectionMode(GhidraFileChooserMode.DIRECTORIES_ONLY);
        fileChooser.setCurrentDirectory(projectDirectory);
        fileChooser.setSelectedFile(projectDirectory);
        return fileChooser;
    }

    String chooseArchiveFile(String approveButtonText, String approveToolTip) {
        File dir;
        GhidraFileChooser jarFileChooser = this.createFileChooser(".gar", "Ghidra Archives", this.archivePathName);
        jarFileChooser.setTitle("Restore a Ghidra Project - Archive");
        String lastDirSelected = Preferences.getProperty((String)"last.project.archive.dir");
        if (lastDirSelected != null && (dir = new File(lastDirSelected)).isDirectory()) {
            jarFileChooser.setCurrentDirectory(dir);
        }
        File jarFile = null;
        if (this.archivePathName != null && this.archivePathName.length() != 0) {
            jarFile = new File(this.archivePathName);
        }
        jarFileChooser.setSelectedFile(jarFile);
        jarFileChooser.setApproveButtonText(approveButtonText);
        jarFileChooser.setApproveButtonToolTipText(approveToolTip);
        String pathname = null;
        while (pathname == null) {
            File selectedFile = jarFileChooser.getSelectedFile();
            if (selectedFile == null) {
                return null;
            }
            File file = selectedFile;
            String chosenName = file.getName();
            if (!NamingUtilities.isValidProjectName((String)chosenName)) {
                Msg.showError(((Object)((Object)this)).getClass(), null, (String)"Invalid Archive Name", (Object)(chosenName + " is not a valid archive name"));
                continue;
            }
            Preferences.setProperty((String)"last.project.archive.dir", (String)file.getParent());
            pathname = file.getAbsolutePath();
        }
        jarFileChooser.dispose();
        return pathname;
    }

    String chooseDirectory(String approveButtonText, String approveToolTip) {
        GhidraFileChooser dirChooser = this.createDirectoryChooser();
        dirChooser.setTitle("Restore a Ghidra Project - Directory");
        if (this.restoreURL != null) {
            dirChooser.setSelectedFile(new File(this.restoreURL.getLocation()));
        }
        dirChooser.setApproveButtonText(approveButtonText);
        dirChooser.setApproveButtonToolTipText(approveToolTip);
        File selectedFile = dirChooser.getSelectedFile(true);
        dirChooser.dispose();
        if (selectedFile != null) {
            return selectedFile.getAbsolutePath();
        }
        return null;
    }
}

