/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.codebrowser;

import docking.ComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.widgets.fieldpanel.FieldPanel;
import docking.widgets.fieldpanel.Layout;
import docking.widgets.fieldpanel.LayoutModel;
import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.support.FieldLocation;
import docking.widgets.fieldpanel.support.FieldSelection;
import generic.theme.GColor;
import ghidra.GhidraOptions;
import ghidra.app.events.ProgramHighlightPluginEvent;
import ghidra.app.events.ProgramSelectionPluginEvent;
import ghidra.app.nav.Navigatable;
import ghidra.app.plugin.core.codebrowser.CodeBrowserPluginInterface;
import ghidra.app.plugin.core.codebrowser.CodeViewerProvider;
import ghidra.app.plugin.core.codebrowser.hover.ListingHoverService;
import ghidra.app.services.ButtonPressedListener;
import ghidra.app.services.ClipboardService;
import ghidra.app.services.CodeFormatService;
import ghidra.app.services.CodeViewerService;
import ghidra.app.services.CoordinatedListingPanelListener;
import ghidra.app.services.ListingMarginProviderService;
import ghidra.app.services.ListingOverviewProviderService;
import ghidra.app.services.MarkerService;
import ghidra.app.services.ViewManagerService;
import ghidra.app.util.ListingHighlightProvider;
import ghidra.app.util.ProgramDropProvider;
import ghidra.app.util.viewer.field.ListingColors;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.field.ListingTextField;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.format.FormatManager;
import ghidra.app.util.viewer.format.FormatModelListener;
import ghidra.app.util.viewer.listingpanel.AddressSetDisplayListener;
import ghidra.app.util.viewer.listingpanel.ListingMarginProvider;
import ghidra.app.util.viewer.listingpanel.ListingModel;
import ghidra.app.util.viewer.listingpanel.ListingOverviewProvider;
import ghidra.app.util.viewer.listingpanel.ListingPanel;
import ghidra.app.util.viewer.options.ListingDisplayOptionsEditor;
import ghidra.app.util.viewer.util.AddressIndexMap;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.model.EventType;
import ghidra.framework.options.OptionType;
import ghidra.framework.options.Options;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.ImmutableAddressSet;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;
import ghidra.util.ManualViewerCommandEditor;
import ghidra.util.ManualViewerCommandWrappedOption;
import ghidra.util.Swing;
import ghidra.util.SystemUtilities;
import java.awt.Color;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JComponent;

public abstract class AbstractCodeBrowserPlugin<P extends CodeViewerProvider>
extends Plugin
implements CodeViewerService,
CodeFormatService,
OptionsChangeListener,
FormatModelListener,
DomainObjectListener,
CodeBrowserPluginInterface {
    private static final String CURSOR_COLOR_OPTIONS_NAME = "Cursor.Cursor Color - Focused";
    private static final String UNFOCUSED_CURSOR_COLOR_OPTIONS_NAME = "Cursor.Cursor Color - Unfocused";
    private static final String MOUSE_WHEEL_HORIZONTAL_SCROLLING_OPTIONS_NAME = "Mouse.Horizontal Scrolling";
    private static final GColor FOCUSED_CURSOR_COLOR = new GColor("color.cursor.focused.listing");
    private static final GColor UNFOCUSED_CURSOR_COLOR = new GColor("color.cursor.unfocused.listing");
    private static final GColor CURRENT_LINE_HIGHLIGHT_COLOR = new GColor("color.bg.currentline.listing");
    protected final P connectedProvider;
    protected List<P> disconnectedProviders = new ArrayList<P>();
    protected FormatManager formatMgr;
    protected ViewManagerService viewManager;
    protected AddressSetView currentView = ImmutableAddressSet.EMPTY_SET;
    protected Program currentProgram;
    private boolean selectionChanging;
    private ProgramDropProvider dndProvider;

    public AbstractCodeBrowserPlugin(PluginTool tool) {
        super(tool);
        ToolOptions displayOptions = tool.getOptions("Listing Display");
        ToolOptions fieldOptions = tool.getOptions("Listing Fields");
        displayOptions.registerOptionsEditor(() -> new ListingDisplayOptionsEditor((Options)displayOptions));
        displayOptions.setOptionsHelpLocation(new HelpLocation(this.getName(), "Listing Display"));
        fieldOptions.setOptionsHelpLocation(new HelpLocation(this.getName(), "Listing Display"));
        this.formatMgr = new FormatManager(displayOptions, fieldOptions);
        this.formatMgr.addFormatModelListener(this);
        this.formatMgr.setServiceProvider((ServiceProvider)tool);
        this.connectedProvider = this.createProvider(this.formatMgr, true);
        tool.showComponentProvider(this.connectedProvider, true);
        this.initOptions((Options)fieldOptions);
        ((CodeViewerProvider)this.connectedProvider).getListingPanel().setTextBackgroundColor((Color)ListingColors.BACKGROUND);
        this.initMiscellaneousOptions();
        displayOptions.addOptionsChangeListener((OptionsChangeListener)this);
        fieldOptions.addOptionsChangeListener((OptionsChangeListener)this);
    }

    protected abstract P createProvider(FormatManager var1, boolean var2);

    protected void setView(AddressSetView newView) {
        if (this.currentView.hasSameAddresses(newView)) {
            return;
        }
        ProgramLocation location = this.getCurrentLocation();
        this.currentView = ImmutableAddressSet.asImmutable((AddressSetView)newView);
        ((CodeViewerProvider)this.connectedProvider).setView(this.currentView);
        if (location != null && this.currentView.contains(location.getAddress())) {
            this.goTo(location, true);
        }
        this.viewUpdated();
    }

    private void viewUpdated() {
        this.updateBackgroundColorModel();
        ((CodeViewerProvider)this.connectedProvider).setHighlight(((CodeViewerProvider)this.connectedProvider).getHighlight());
        this.setConnectedProviderSelection(((CodeViewerProvider)this.connectedProvider).getSelection());
    }

    protected void init() {
        ListingOverviewProviderService[] overviewServices;
        ClipboardService clipboardService;
        MarkerService markerService = (MarkerService)this.tool.getService(MarkerService.class);
        this.setMarkerService(markerService);
        this.updateBackgroundColorModel();
        if (this.viewManager == null) {
            this.viewManager = (ViewManagerService)this.tool.getService(ViewManagerService.class);
        }
        if ((clipboardService = (ClipboardService)this.tool.getService(ClipboardService.class)) != null) {
            ((CodeViewerProvider)this.connectedProvider).setClipboardService(clipboardService);
            for (Object provider : this.disconnectedProviders) {
                ((CodeViewerProvider)provider).setClipboardService(clipboardService);
            }
        }
        ListingMarginProviderService[] marginServices = (ListingMarginProviderService[])this.tool.getServices(ListingMarginProviderService.class);
        for (ListingMarginProviderService marginService : marginServices) {
            ((CodeViewerProvider)this.connectedProvider).addMarginService(marginService);
        }
        for (ListingOverviewProviderService service : overviewServices = (ListingOverviewProviderService[])this.tool.getServices(ListingOverviewProviderService.class)) {
            ((CodeViewerProvider)this.connectedProvider).addOverviewService(service);
        }
    }

    protected void updateBackgroundColorModel() {
        this.updateBackgroundColorModel((CodeViewerProvider)this.connectedProvider);
        for (CodeViewerProvider provider : this.disconnectedProviders) {
            this.updateBackgroundColorModel(provider);
        }
    }

    protected void updateBackgroundColorModel(CodeViewerProvider provider) {
        ListingPanel listingPanel = provider.getListingPanel();
        listingPanel.updateBackgroundColorModel();
    }

    public P createNewDisconnectedProvider() {
        ListingOverviewProviderService[] overviewServices;
        ListingMarginProviderService[] marginServices;
        ListingHoverService[] hoverServices;
        P newProvider = this.createProvider(this.formatMgr.createClone(), false);
        ((CodeViewerProvider)newProvider).setClipboardService((ClipboardService)this.tool.getService(ClipboardService.class));
        ListingPanel listingPanel = ((CodeViewerProvider)newProvider).getListingPanel();
        FieldPanel fieldPanel = listingPanel.getFieldPanel();
        List<ListingPanel> listingPanels = List.of(listingPanel);
        List<FieldPanel> fieldPanels = List.of(fieldPanel);
        this.initPanelOptions(listingPanels, fieldPanels);
        this.disconnectedProviders.add(newProvider);
        if (this.dndProvider != null) {
            ((CodeViewerProvider)newProvider).addProgramDropProvider(this.dndProvider);
        }
        for (ListingHoverService hoverService : hoverServices = (ListingHoverService[])this.tool.getServices(ListingHoverService.class)) {
            listingPanel.addHoverService(hoverService);
        }
        for (ListingMarginProviderService service : marginServices = (ListingMarginProviderService[])this.tool.getServices(ListingMarginProviderService.class)) {
            ((CodeViewerProvider)newProvider).addMarginService(service);
        }
        for (ListingOverviewProviderService service : overviewServices = (ListingOverviewProviderService[])this.tool.getServices(ListingOverviewProviderService.class)) {
            ((CodeViewerProvider)newProvider).addOverviewService(service);
        }
        MarkerService markerService = (MarkerService)this.tool.getService(MarkerService.class);
        listingPanel.setMarkerService(markerService);
        this.updateBackgroundColorModel((CodeViewerProvider)newProvider);
        this.tool.showComponentProvider(newProvider, true);
        return newProvider;
    }

    protected void setConnectedProviderHighlight(FieldSelection highlight) {
        if (highlight != null && !highlight.isEmpty()) {
            ListingPanel listingPanel = ((CodeViewerProvider)this.connectedProvider).getListingPanel();
            ProgramSelection programHighlight = listingPanel.getProgramSelection(highlight);
            ((CodeViewerProvider)this.connectedProvider).setHighlight(programHighlight);
            this.firePluginEvent(new ProgramHighlightPluginEvent(this.getName(), programHighlight, this.currentProgram));
        } else {
            ((CodeViewerProvider)this.connectedProvider).setHighlight(new ProgramSelection());
        }
    }

    protected void removeProvider(CodeViewerProvider provider) {
        this.tool.removeComponentProvider((ComponentProvider)provider);
        provider.dispose();
    }

    public void serviceAdded(Class<?> interfaceClass, Object service) {
        if (interfaceClass == ViewManagerService.class && this.viewManager == null) {
            this.viewManager = (ViewManagerService)service;
            this.setView(this.viewManager.getCurrentView());
        }
        if (interfaceClass == MarkerService.class) {
            MarkerService markerService = (MarkerService)this.tool.getService(MarkerService.class);
            this.setMarkerService(markerService);
            this.updateBackgroundColorModel();
            if (this.viewManager != null) {
                this.viewUpdated();
            }
        }
        if (interfaceClass == ListingHoverService.class) {
            ListingHoverService hoverService = (ListingHoverService)service;
            ((CodeViewerProvider)this.connectedProvider).getListingPanel().addHoverService(hoverService);
            for (CodeViewerProvider provider : this.disconnectedProviders) {
                provider.getListingPanel().addHoverService(hoverService);
            }
            ListingPanel otherPanel = ((CodeViewerProvider)this.connectedProvider).getOtherPanel();
            if (otherPanel != null) {
                otherPanel.addHoverService(hoverService);
            }
        }
        if (interfaceClass == ListingMarginProviderService.class) {
            ListingMarginProviderService marginService = (ListingMarginProviderService)service;
            ((CodeViewerProvider)this.connectedProvider).addMarginService(marginService);
            for (CodeViewerProvider provider : this.disconnectedProviders) {
                provider.addMarginService(marginService);
            }
        }
        if (interfaceClass == ListingOverviewProviderService.class) {
            ListingOverviewProviderService overviewService = (ListingOverviewProviderService)service;
            ((CodeViewerProvider)this.connectedProvider).addOverviewService(overviewService);
            for (CodeViewerProvider provider : this.disconnectedProviders) {
                provider.addOverviewService(overviewService);
            }
        }
    }

    private void setMarkerService(MarkerService markerService) {
        ListingPanel listingPanel = ((CodeViewerProvider)this.connectedProvider).getListingPanel();
        listingPanel.setMarkerService(markerService);
        for (CodeViewerProvider provider : this.disconnectedProviders) {
            listingPanel = provider.getListingPanel();
            listingPanel.setMarkerService(markerService);
        }
    }

    public void serviceRemoved(Class<?> interfaceClass, Object service) {
        if (service == this.viewManager && this.currentProgram != null) {
            this.viewManager = null;
            this.setView((AddressSetView)this.currentProgram.getMemory());
        }
        if (interfaceClass == MarkerService.class) {
            this.setMarkerService(null);
            ((CodeViewerProvider)this.connectedProvider).clearMarkers(this.currentProgram);
            this.updateBackgroundColorModel();
        }
        if (interfaceClass == ListingHoverService.class) {
            ListingHoverService hoverService = (ListingHoverService)service;
            ((CodeViewerProvider)this.connectedProvider).removeHoverService(hoverService);
            for (CodeViewerProvider provider : this.disconnectedProviders) {
                provider.removeHoverService(hoverService);
            }
        }
        if (interfaceClass == ListingMarginProviderService.class) {
            ListingMarginProviderService marginService = (ListingMarginProviderService)service;
            ((CodeViewerProvider)this.connectedProvider).removeMarginService(marginService);
            for (CodeViewerProvider provider : this.disconnectedProviders) {
                provider.removeMarginService(marginService);
            }
        }
        if (interfaceClass == ListingOverviewProviderService.class) {
            ListingOverviewProviderService overviewService = (ListingOverviewProviderService)service;
            ((CodeViewerProvider)this.connectedProvider).removeOverviewService(overviewService);
            for (CodeViewerProvider provider : this.disconnectedProviders) {
                provider.removeOverviewService(overviewService);
            }
        }
    }

    @Override
    public void addOverviewProvider(ListingOverviewProvider overviewProvider) {
        ((CodeViewerProvider)this.connectedProvider).addOverviewProvider(overviewProvider);
    }

    @Override
    public void addMarginProvider(ListingMarginProvider marginProvider) {
        ((CodeViewerProvider)this.connectedProvider).addMarginProvider(marginProvider);
    }

    @Override
    public void removeOverviewProvider(ListingOverviewProvider overviewProvider) {
        ((CodeViewerProvider)this.connectedProvider).removeOverviewProvider(overviewProvider);
    }

    @Override
    public void removeMarginProvider(ListingMarginProvider marginProvider) {
        ((CodeViewerProvider)this.connectedProvider).removeMarginProvider(marginProvider);
    }

    @Override
    public void addLocalAction(DockingAction action) {
        this.tool.addLocalAction(this.connectedProvider, (DockingActionIf)action);
    }

    @Override
    public void removeLocalAction(DockingAction action) {
        if (this.tool != null) {
            this.tool.removeLocalAction(this.connectedProvider, (DockingActionIf)action);
        }
    }

    @Override
    public void addProgramDropProvider(ProgramDropProvider dnd) {
        this.dndProvider = dnd;
        ((CodeViewerProvider)this.connectedProvider).addProgramDropProvider(dnd);
        for (CodeViewerProvider provider : this.disconnectedProviders) {
            provider.addProgramDropProvider(dnd);
        }
    }

    @Override
    public void addButtonPressedListener(ButtonPressedListener listener) {
        ((CodeViewerProvider)this.connectedProvider).getListingPanel().addButtonPressedListener(listener);
    }

    @Override
    public void removeButtonPressedListener(ButtonPressedListener listener) {
        ((CodeViewerProvider)this.connectedProvider).getListingPanel().removeButtonPressedListener(listener);
    }

    @Override
    public void removeHighlightProvider(ListingHighlightProvider highlightProvider, Program highlightProgram) {
        ((CodeViewerProvider)this.connectedProvider).removeHighlightProvider(highlightProvider, highlightProgram);
    }

    @Override
    public void setHighlightProvider(ListingHighlightProvider highlightProvider, Program highlightProgram) {
        ((CodeViewerProvider)this.connectedProvider).setHighlightProvider(highlightProvider, highlightProgram);
    }

    @Override
    public void setListingPanel(ListingPanel lp) {
        ((CodeViewerProvider)this.connectedProvider).setOtherPanel(lp);
        this.viewUpdated();
    }

    @Override
    public void setCoordinatedListingPanelListener(CoordinatedListingPanelListener listener) {
        ((CodeViewerProvider)this.connectedProvider).setCoordinatedListingPanelListener(listener);
    }

    @Override
    public void setNorthComponent(JComponent comp) {
        ((CodeViewerProvider)this.connectedProvider).setNorthComponent(comp);
    }

    @Override
    public void requestFocus() {
        this.connectedProvider.requestFocus();
    }

    @Override
    public void removeListingPanel(ListingPanel lp) {
        if (this.isDisposed()) {
            return;
        }
        if (((CodeViewerProvider)this.connectedProvider).getOtherPanel() == lp) {
            ((CodeViewerProvider)this.connectedProvider).clearPanel();
            this.viewUpdated();
        }
    }

    protected void dispose() {
        if (this.currentProgram != null) {
            this.currentProgram.removeListener((DomainObjectListener)this);
        }
        ((CodeViewerProvider)this.connectedProvider).clearMarkers(this.currentProgram);
        this.formatMgr.dispose();
        this.removeProvider((CodeViewerProvider)this.connectedProvider);
        for (CodeViewerProvider provider : this.disconnectedProviders) {
            this.removeProvider(provider);
        }
    }

    public void optionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue) {
        if (!options.getName().equals("Listing Fields")) {
            return;
        }
        List<ListingPanel> listingPanels = this.allListingPanels();
        List<FieldPanel> fieldPanels = this.allFieldPanels();
        if (optionName.equals("Selection Colors.Selection Color")) {
            Color color = (Color)newValue;
            this.onListingPanels(listingPanels, lp -> lp.setSelectionColor(color));
        } else if (optionName.equals("Selection Colors.Highlight Color")) {
            Color color = (Color)newValue;
            this.onListingPanels(listingPanels, lp -> lp.setHighlightColor(color));
        } else if (optionName.equals(CURSOR_COLOR_OPTIONS_NAME)) {
            Color color = (Color)newValue;
            this.onFieldPanels(fieldPanels, fp -> fp.setFocusedCursorColor(color));
        } else if (optionName.equals(UNFOCUSED_CURSOR_COLOR_OPTIONS_NAME)) {
            Color color = (Color)newValue;
            this.onFieldPanels(fieldPanels, fp -> fp.setNonFocusCursorColor(color));
        } else if (optionName.equals("Cursor.Highlight Cursor Line Color")) {
            Color color = (Color)newValue;
            this.onListingPanels(listingPanels, lp -> lp.setCursorHighlightColor(color));
        } else if (optionName.equals("Cursor.Highlight Cursor Line")) {
            Boolean doHighlight = (Boolean)newValue;
            this.onListingPanels(listingPanels, lp -> lp.setHighlightCursorLineEnabled(doHighlight));
        } else if (optionName.equals(MOUSE_WHEEL_HORIZONTAL_SCROLLING_OPTIONS_NAME)) {
            Boolean doScroll = (Boolean)newValue;
            this.onFieldPanels(fieldPanels, fp -> fp.setHorizontalScrollingEnabled(doScroll.booleanValue()));
        }
    }

    protected void onFieldPanels(List<FieldPanel> panels, Consumer<FieldPanel> c) {
        for (FieldPanel fp : panels) {
            c.accept(fp);
        }
    }

    protected void onListingPanels(List<ListingPanel> listingPanels, Consumer<ListingPanel> c) {
        for (ListingPanel lp : listingPanels) {
            c.accept(lp);
        }
    }

    private List<ListingPanel> allListingPanels() {
        ArrayList<ListingPanel> results = new ArrayList<ListingPanel>();
        results.add(((CodeViewerProvider)this.connectedProvider).getListingPanel());
        ListingPanel otherPanel = ((CodeViewerProvider)this.connectedProvider).getOtherPanel();
        if (otherPanel != null) {
            results.add(otherPanel);
        }
        for (CodeViewerProvider provider : this.disconnectedProviders) {
            results.add(provider.getListingPanel());
        }
        return results;
    }

    private List<FieldPanel> allFieldPanels() {
        ArrayList<FieldPanel> results = new ArrayList<FieldPanel>();
        FieldPanel fieldPanel = ((CodeViewerProvider)this.connectedProvider).getListingPanel().getFieldPanel();
        results.add(fieldPanel);
        ListingPanel otherPanel = ((CodeViewerProvider)this.connectedProvider).getOtherPanel();
        if (otherPanel != null) {
            FieldPanel otherFieldPanel = otherPanel.getFieldPanel();
            results.add(otherFieldPanel);
        }
        for (CodeViewerProvider provider : this.disconnectedProviders) {
            fieldPanel = provider.getListingPanel().getFieldPanel();
            results.add(fieldPanel);
        }
        return results;
    }

    @Override
    public void broadcastSelectionChanged(CodeViewerProvider provider, ProgramSelection selection) {
        if (provider == this.connectedProvider && !this.selectionChanging) {
            this.tool.firePluginEvent((PluginEvent)new ProgramSelectionPluginEvent(this.getName(), selection, ((CodeViewerProvider)this.connectedProvider).getProgram()));
        }
    }

    protected void setConnectedProviderSelection(ProgramSelection sel) {
        this.selectionChanging = true;
        ((CodeViewerProvider)this.connectedProvider).setSelection(sel);
        this.selectionChanging = false;
    }

    private void initMiscellaneousOptions() {
        HelpLocation helpLocation = new HelpLocation("ShowInstructionInfoPlugin", "Processor_Manual_Options");
        ToolOptions options = this.tool.getOptions("Processor Manuals");
        options.registerOption("Manual Viewer Options", OptionType.CUSTOM_TYPE, (Object)ManualViewerCommandWrappedOption.getDefaultBrowserLoaderOptions(), helpLocation, "Options for running manual viewer", () -> new ManualViewerCommandEditor());
    }

    private void initOptions(Options fieldOptions) {
        HelpLocation helpLocation = new HelpLocation(this.getName(), "Selection Colors");
        fieldOptions.getOptions("Selection Colors").setOptionsHelpLocation(helpLocation);
        fieldOptions.registerThemeColorBinding("Selection Colors.Selection Color", GhidraOptions.DEFAULT_SELECTION_COLOR.getId(), helpLocation, "The selection color in the browser.");
        fieldOptions.registerThemeColorBinding("Selection Colors.Highlight Color", GhidraOptions.DEFAULT_HIGHLIGHT_COLOR.getId(), helpLocation, "The highlight color in the browser.");
        fieldOptions.registerThemeColorBinding(CURSOR_COLOR_OPTIONS_NAME, FOCUSED_CURSOR_COLOR.getId(), helpLocation, "The color of the cursor in the browser.");
        fieldOptions.registerThemeColorBinding(UNFOCUSED_CURSOR_COLOR_OPTIONS_NAME, UNFOCUSED_CURSOR_COLOR.getId(), helpLocation, "The color of the cursor in the browser when the browser does not have focus.");
        fieldOptions.registerThemeColorBinding("Cursor.Highlight Cursor Line Color", CURRENT_LINE_HIGHLIGHT_COLOR.getId(), helpLocation, "The background color of the line where the cursor is located");
        fieldOptions.registerOption("Cursor.Highlight Cursor Line", (Object)true, helpLocation, "Toggles highlighting background color of line containing the cursor");
        helpLocation = new HelpLocation(this.getName(), "Keyboard_Controls_Shift");
        fieldOptions.registerOption(MOUSE_WHEEL_HORIZONTAL_SCROLLING_OPTIONS_NAME, (Object)true, helpLocation, "Enables horizontal scrolling by holding the Shift key while using the mouse scroll wheel");
        List<ListingPanel> listingPanels = this.allListingPanels();
        List<FieldPanel> fieldPanels = this.allFieldPanels();
        this.initPanelOptions(listingPanels, fieldPanels);
    }

    private void initPanelOptions(List<ListingPanel> listingPanels, List<FieldPanel> fieldPanels) {
        ToolOptions fieldOptions = this.tool.getOptions("Listing Fields");
        Color selectionColor = fieldOptions.getColor("Selection Colors.Selection Color", (Color)GhidraOptions.DEFAULT_SELECTION_COLOR);
        this.onListingPanels(listingPanels, lp -> lp.setSelectionColor(selectionColor));
        Color hlColor = fieldOptions.getColor("Selection Colors.Highlight Color", (Color)GhidraOptions.DEFAULT_HIGHLIGHT_COLOR);
        this.onListingPanels(listingPanels, lp -> lp.setHighlightColor(hlColor));
        Color focusedCursorColor = fieldOptions.getColor(CURSOR_COLOR_OPTIONS_NAME, (Color)FOCUSED_CURSOR_COLOR);
        this.onFieldPanels(fieldPanels, fp -> fp.setFocusedCursorColor(focusedCursorColor));
        Color unfocusedCursorColor = fieldOptions.getColor(UNFOCUSED_CURSOR_COLOR_OPTIONS_NAME, (Color)UNFOCUSED_CURSOR_COLOR);
        this.onFieldPanels(fieldPanels, fp -> fp.setNonFocusCursorColor(unfocusedCursorColor));
        boolean scrollingEnabled = fieldOptions.getBoolean(MOUSE_WHEEL_HORIZONTAL_SCROLLING_OPTIONS_NAME, true);
        this.onFieldPanels(fieldPanels, fp -> fp.setHorizontalScrollingEnabled(scrollingEnabled));
        Color cursorHighlightColor = fieldOptions.getColor("Cursor.Highlight Cursor Line Color", (Color)CURRENT_LINE_HIGHLIGHT_COLOR);
        this.onListingPanels(listingPanels, lp -> lp.setCursorHighlightColor(cursorHighlightColor));
        boolean isHighlightCursorLine = fieldOptions.getBoolean("Cursor.Highlight Cursor Line", true);
        this.onListingPanels(listingPanels, lp -> lp.setHighlightCursorLineEnabled(isHighlightCursorLine));
    }

    @Override
    public void updateDisplay() {
        ((CodeViewerProvider)this.connectedProvider).getListingPanel().updateDisplay(false);
    }

    @Override
    public FieldPanel getFieldPanel() {
        return ((CodeViewerProvider)this.connectedProvider).getListingPanel().getFieldPanel();
    }

    @Override
    public Navigatable getNavigatable() {
        return this.connectedProvider;
    }

    public void updateNow() {
        SystemUtilities.runSwingNow(() -> ((CodeViewerProvider)this.connectedProvider).getListingPanel().updateDisplay(true));
    }

    public boolean goToField(Address address, String fieldName, int row, int col) {
        return this.goToField(address, fieldName, 0, row, col, true);
    }

    public boolean goToField(Address addr, String fieldName, int occurrence, int row, int col) {
        return this.goToField(addr, fieldName, occurrence, row, col, true);
    }

    public boolean goToField(Address a, String fieldName, int occurrence, int row, int col, boolean scroll) {
        return (Boolean)Swing.runNow(() -> this.doGoToField(a, fieldName, occurrence, row, col, scroll));
    }

    private boolean doGoToField(Address a, String fieldName, int occurrence, int row, int col, boolean scroll) {
        FieldPanel fieldPanel;
        BigInteger index;
        int fieldNum;
        Swing.assertSwingThread((String)"'Go To' must be performed on the Swing thread");
        this.updateNow();
        ListingPanel panel = ((CodeViewerProvider)this.connectedProvider).getListingPanel();
        if (a == null) {
            a = this.getCurrentAddress();
        }
        if ((fieldNum = this.getFieldNumber(fieldName, occurrence, index = panel.getAddressIndexMap().getIndex(a), fieldPanel = panel.getFieldPanel())) < 0) {
            return false;
        }
        if (scroll) {
            fieldPanel.goTo(index, fieldNum, row, col, true);
        } else {
            fieldPanel.setCursorPosition(index, fieldNum, row, col);
        }
        return true;
    }

    private int getFieldNumber(String fieldName, int occurrence, BigInteger index, FieldPanel fieldPanel) {
        if (fieldName == null) {
            return -1;
        }
        int fieldNum = -1;
        LayoutModel model = fieldPanel.getLayoutModel();
        Layout layout = model.getLayout(index);
        if (layout == null) {
            return -1;
        }
        int instanceNum = 0;
        for (int i = 0; i < layout.getNumFields(); ++i) {
            ListingField bf;
            Field f = layout.getField(i);
            if (!(f instanceof ListingField) || !(bf = (ListingField)f).getFieldFactory().getFieldName().equals(fieldName) || instanceNum++ != occurrence) continue;
            fieldNum = i;
            break;
        }
        return fieldNum;
    }

    public Address getCurrentAddress() {
        ProgramLocation loc = this.getCurrentLocation();
        if (loc == null) {
            return null;
        }
        return this.getCurrentLocation().getAddress();
    }

    @Override
    public ProgramSelection getCurrentSelection() {
        return ((CodeViewerProvider)this.connectedProvider).getListingPanel().getProgramSelection();
    }

    Program getCurrentProgram() {
        return this.currentProgram;
    }

    public CodeViewerProvider getProvider() {
        return this.connectedProvider;
    }

    public boolean goTo(ProgramLocation location) {
        return this.goTo(location, true);
    }

    @Override
    public boolean goTo(ProgramLocation location, boolean centerOnScreen) {
        return (Boolean)Swing.runNow(() -> ((CodeViewerProvider)this.connectedProvider).getListingPanel().goTo(location, centerOnScreen));
    }

    @Override
    public ProgramLocation getCurrentLocation() {
        return ((CodeViewerProvider)this.connectedProvider).getListingPanel().getProgramLocation();
    }

    public FieldLocation getCurrentFieldLoction() {
        return this.getFieldPanel().getCursorLocation();
    }

    @Override
    public String getCurrentFieldTextSelection() {
        return ((CodeViewerProvider)this.connectedProvider).getStringSelection();
    }

    @Override
    public ListingField getCurrentField() {
        Field f = this.getFieldPanel().getCurrentField();
        if (f instanceof ListingField) {
            return (ListingField)f;
        }
        return null;
    }

    @Override
    public void addListingDisplayListener(AddressSetDisplayListener listener) {
        ((CodeViewerProvider)this.connectedProvider).addDisplayListener(listener);
    }

    @Override
    public void removeListingDisplayListener(AddressSetDisplayListener listener) {
        ((CodeViewerProvider)this.connectedProvider).removeDisplayListener(listener);
    }

    public String getCurrentFieldText() {
        ListingField lf = this.getCurrentField();
        if (lf instanceof ListingTextField) {
            return ((ListingTextField)lf).getText();
        }
        return "";
    }

    @Override
    public AddressSetView getView() {
        return this.currentView;
    }

    @Override
    public FormatManager getFormatManager() {
        return this.formatMgr;
    }

    public void toggleOpen(Data data) {
        ((CodeViewerProvider)this.connectedProvider).getListingPanel().getListingModel().toggleOpen(data);
    }

    @Override
    public AddressIndexMap getAddressIndexMap() {
        return this.getListingPanel().getAddressIndexMap();
    }

    @Override
    public ListingPanel getListingPanel() {
        return ((CodeViewerProvider)this.connectedProvider).getListingPanel();
    }

    Address getAddressTopOfScreen() {
        BigInteger index = this.getFieldPanel().getViewerPosition().getIndex();
        return this.getAddressIndexMap().getAddress(index);
    }

    @Override
    public void formatModelChanged(FieldFormatModel model) {
        this.tool.setConfigChanged(true);
    }

    @Override
    public ListingModel getListingModel() {
        return ((CodeViewerProvider)this.connectedProvider).getListingPanel().getListingModel().copy();
    }

    public void domainObjectChanged(DomainObjectChangedEvent ev) {
        if (ev.contains((EventType)DomainObjectEvent.FILE_CHANGED)) {
            ((CodeViewerProvider)this.connectedProvider).updateTitle();
        }
        if (ev.contains((EventType)DomainObjectEvent.RESTORED) && this.viewManager == null) {
            this.setView((AddressSetView)this.currentProgram.getMemory());
            this.viewUpdated();
        }
    }

    @Override
    public void providerClosed(CodeViewerProvider codeViewerProvider) {
        this.removeProvider(codeViewerProvider);
        if (!codeViewerProvider.isConnected()) {
            this.disconnectedProviders.remove(codeViewerProvider);
        }
    }
}

