/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DialogComponentProvider;
import docking.Tool;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.action.builder.ActionBuilder;
import docking.actions.PopupActionProvider;
import docking.widgets.tree.GTreeNode;
import generic.jar.ResourceFile;
import generic.util.Path;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.core.datamgr.DataTypePropertyManager;
import ghidra.app.plugin.core.datamgr.DataTypeSynchronizer;
import ghidra.app.plugin.core.datamgr.DataTypesActionContext;
import ghidra.app.plugin.core.datamgr.DataTypesProvider;
import ghidra.app.plugin.core.datamgr.OpenDomainFileTask;
import ghidra.app.plugin.core.datamgr.actions.RecentlyOpenedArchiveAction;
import ghidra.app.plugin.core.datamgr.actions.UpdateSourceArchiveNamesAction;
import ghidra.app.plugin.core.datamgr.actions.associate.CommitAction;
import ghidra.app.plugin.core.datamgr.actions.associate.DisassociateAction;
import ghidra.app.plugin.core.datamgr.actions.associate.RevertAction;
import ghidra.app.plugin.core.datamgr.actions.associate.SyncRefreshAction;
import ghidra.app.plugin.core.datamgr.actions.associate.UpdateAction;
import ghidra.app.plugin.core.datamgr.archive.Archive;
import ghidra.app.plugin.core.datamgr.archive.ArchiveManagerListener;
import ghidra.app.plugin.core.datamgr.archive.ArchiveUtils;
import ghidra.app.plugin.core.datamgr.archive.DataTypeManagerHandler;
import ghidra.app.plugin.core.datamgr.archive.DuplicateIdException;
import ghidra.app.plugin.core.datamgr.archive.FileArchive;
import ghidra.app.plugin.core.datamgr.archive.ProjectArchive;
import ghidra.app.plugin.core.datamgr.editor.DataTypeEditorManager;
import ghidra.app.plugin.core.datamgr.tree.ArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.DtFilterState;
import ghidra.app.plugin.core.datamgr.util.DataDropOnBrowserHandler;
import ghidra.app.plugin.core.datamgr.util.DataTypeChooserDialog;
import ghidra.app.services.CodeViewerService;
import ghidra.app.services.DataTypeArchiveService;
import ghidra.app.services.DataTypeManagerService;
import ghidra.app.services.DataTypeQueryService;
import ghidra.app.util.datatype.DataTypeSelectionDialog;
import ghidra.framework.Application;
import ghidra.framework.main.OpenVersionedFileDialog;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.model.EventType;
import ghidra.framework.model.Project;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.database.data.ProgramDataTypeManager;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.Category;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataTypeManagerChangeListener;
import ghidra.program.model.data.DataTypeManagerDomainObject;
import ghidra.program.model.data.DataTypePath;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.data.FactoryDataType;
import ghidra.program.model.data.SourceArchive;
import ghidra.program.model.listing.DataTypeArchive;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.data.DataTypeParser;
import ghidra.util.datastruct.LRUMap;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.awt.datatransfer.Clipboard;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import org.apache.commons.lang3.StringUtils;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Code Viewer", shortDescription="Window for managing datatypes", description="Provides the window for managing and categorizing dataTypes.  The datatype display shows all built-in datatypes, datatypes in the current program, and datatypes in all open archives.", servicesProvided={DataTypeManagerService.class, DataTypeQueryService.class, DataTypeArchiveService.class})
public class DataTypeManagerPlugin
extends ProgramPlugin
implements DomainObjectListener,
DataTypeManagerService,
PopupActionProvider {
    private static final String SEARCH_PROVIDER_NAME = "Search DataTypes Provider";
    private static final int RECENTLY_USED_CACHE_SIZE = 10;
    private static final String STANDARD_ARCHIVE_MENU = "Standard Archive";
    private static final String RECENTLY_OPENED_MENU = "Recently Opened Archive";
    private DataTypeManagerHandler dataTypeManagerHandler;
    private DataTypesProvider provider;
    private Map<String, DockingAction> recentlyOpenedArchiveMap;
    private Map<String, DockingAction> installArchiveMap;
    private Clipboard clipboard = new Clipboard(this.getName());
    private DataTypeEditorManager editorManager;
    private DataTypePropertyManager dataTypePropertyManager;

    public DataTypeManagerPlugin(PluginTool tool) {
        super(tool);
    }

    protected void init() {
        this.recentlyOpenedArchiveMap = new LRUMap<String, DockingAction>(10){

            protected void eldestEntryRemoved(Map.Entry<String, DockingAction> eldest) {
                DockingAction action = eldest.getValue();
                if (action == null) {
                    return;
                }
                DataTypeManagerPlugin.this.removeRecentAction(action);
            }
        };
        this.dataTypeManagerHandler = new DataTypeManagerHandler(this);
        this.dataTypePropertyManager = new DataTypePropertyManager();
        this.provider = new DataTypesProvider(this, "DataTypes Provider");
        this.createActions();
        this.dataTypeManagerHandler.addArchiveManagerListener(new ArchiveManagerListener(){

            @Override
            public void archiveClosed(Archive archive) {
                if (archive instanceof ProjectArchive) {
                    ProjectArchive projectArchive = (ProjectArchive)archive;
                    projectArchive.getDomainObject().removeListener((DomainObjectListener)DataTypeManagerPlugin.this);
                }
                DataTypeManagerPlugin.this.provider.archiveClosed(archive.getDataTypeManager());
            }

            @Override
            public void archiveOpened(Archive archive) {
                if (archive instanceof FileArchive) {
                    DataTypeManagerPlugin.this.addRecentlyOpenedArchiveFile(((FileArchive)archive).getFile());
                } else if (archive instanceof ProjectArchive) {
                    ProjectArchive projectArchive = (ProjectArchive)archive;
                    projectArchive.getDomainObject().addListener((DomainObjectListener)DataTypeManagerPlugin.this);
                    DataTypeManagerPlugin.this.addRecentlyOpenedProjectArchive((ProjectArchive)archive);
                }
            }

            @Override
            public void archiveDataTypeManagerChanged(Archive archive) {
                DataTypeManagerPlugin.this.provider.archiveChanged(archive);
            }

            @Override
            public void archiveStateChanged(Archive archive) {
                DataTypeManagerPlugin.this.provider.archiveChanged(archive);
            }
        });
        this.editorManager = new DataTypeEditorManager(this);
        this.tool.addPopupActionProvider((PopupActionProvider)this);
        this.tool.setMenuGroup(new String[]{"Refresh Sync Indicators For"}, "SYNC");
        this.tool.setMenuGroup(new String[]{"Update Data Types From"}, "SYNC");
        this.tool.setMenuGroup(new String[]{"Commit Data Types To"}, "SYNC");
        this.tool.setMenuGroup(new String[]{"Revert Data Types From"}, "SYNC");
        this.tool.setMenuGroup(new String[]{"Disassociate Data Types From"}, "SYNC");
        this.tool.setMenuGroup(new String[]{RECENTLY_OPENED_MENU}, "Recent");
        this.tool.setMenuGroup(new String[]{STANDARD_ARCHIVE_MENU}, "Recent");
    }

    public void serviceAdded(Class<?> interfaceClass, Object service) {
        if (interfaceClass == CodeViewerService.class) {
            CodeViewerService codeViewerService = (CodeViewerService)service;
            codeViewerService.addProgramDropProvider(new DataDropOnBrowserHandler(this));
        }
    }

    public void addRecentlyOpenedArchiveFile(ResourceFile file) {
        if (file == null) {
            return;
        }
        Path path = new Path(file);
        String absoluteFilePath = path.getPathAsString();
        if (!absoluteFilePath.endsWith(".gdt")) {
            return;
        }
        if (this.recentlyOpenedArchiveMap.get(absoluteFilePath) == null) {
            RecentlyOpenedArchiveAction action = new RecentlyOpenedArchiveAction(this, absoluteFilePath, RECENTLY_OPENED_MENU);
            action.setHelpLocation(new HelpLocation(this.getName(), "Recent_Archives"));
            this.recentlyOpenedArchiveMap.put(absoluteFilePath, action);
        }
        this.updateRecentlyOpenedArchivesMenu();
    }

    public void addRecentlyOpenedProjectArchive(String projectName, String pathname) {
        String projectPathname = DataTypeManagerHandler.getProjectPathname(projectName, pathname);
        if (this.recentlyOpenedArchiveMap.get(projectPathname) != null) {
            return;
        }
        RecentlyOpenedArchiveAction action = null;
        if (this.getProjectArchiveFile(projectName, pathname) != null) {
            action = new RecentlyOpenedArchiveAction(this, projectPathname, RECENTLY_OPENED_MENU);
            action.setHelpLocation(new HelpLocation(this.getName(), "Recent_Archives"));
        }
        this.recentlyOpenedArchiveMap.put(projectPathname, action);
        this.updateRecentlyOpenedArchivesMenu();
    }

    public void addRecentlyOpenedProjectArchive(ProjectArchive pa) {
        String projectPathname = this.dataTypeManagerHandler.getProjectPathname(pa, true);
        if (projectPathname != null) {
            DomainFile df = pa.getDomainFile();
            this.addRecentlyOpenedProjectArchive(df.getProjectLocator().getName(), df.getPathname());
        }
    }

    public DomainFile getProjectArchiveFile(String projectName, String pathname) {
        DomainFile df;
        Project project = this.tool.getProjectManager().getActiveProject();
        if (project != null && project.getName().equals(projectName) && (df = project.getProjectData().getFile(pathname)) != null && DataTypeArchive.class.isAssignableFrom(df.getDomainObjectClass())) {
            return df;
        }
        return null;
    }

    public Collection<String> getRecentlyOpenedArchives() {
        return Collections.unmodifiableSet(this.recentlyOpenedArchiveMap.keySet());
    }

    public void dispose() {
        this.tool.removePopupActionProvider((PopupActionProvider)this);
        this.dataTypeManagerHandler.closeAllArchives();
        this.dataTypeManagerHandler.dispose();
    }

    public void readConfigState(SaveState saveState) {
        this.dataTypeManagerHandler.restore(saveState);
        this.provider.restore(saveState);
    }

    public void writeConfigState(SaveState saveState) {
        this.dataTypeManagerHandler.save(saveState);
        this.provider.save(saveState);
    }

    public void domainObjectChanged(DomainObjectChangedEvent event) {
        if (event.contains((EventType)DomainObjectEvent.RESTORED)) {
            Object source = event.getSource();
            if (source instanceof DataTypeManagerDomainObject) {
                DataTypeManagerDomainObject domainObject = (DataTypeManagerDomainObject)source;
                this.provider.domainObjectRestored(domainObject);
                this.dataTypePropertyManager.domainObjectRestored(domainObject);
            }
        } else if (event.contains((EventType)DomainObjectEvent.RENAMED)) {
            this.provider.programRenamed();
        }
    }

    @Override
    protected void programDeactivated(Program program) {
        program.removeListener((DomainObjectListener)this);
        this.dataTypeManagerHandler.programClosed();
        this.dataTypePropertyManager.programClosed(program);
    }

    @Override
    protected void programActivated(Program program) {
        program.addListener((DomainObjectListener)this);
        this.dataTypeManagerHandler.programOpened(program);
        this.dataTypePropertyManager.programOpened(program);
    }

    @Override
    protected void programClosed(Program program) {
        this.provider.programClosed(program);
        this.editorManager.dismissEditors((DataTypeManager)program.getDataTypeManager());
    }

    protected boolean canCloseDomainObject(DomainObject dObj) {
        if (dObj instanceof DataTypeManagerDomainObject) {
            DataTypeManagerDomainObject dtmObject = (DataTypeManagerDomainObject)dObj;
            return this.editorManager.checkEditors(dtmObject.getDataTypeManager(), true);
        }
        return true;
    }

    protected boolean canClose() {
        if (!this.editorManager.checkEditors(null, true)) {
            return false;
        }
        this.editorManager.dismissEditors(null);
        this.dataTypeManagerHandler.updateKnownOpenArchives();
        return ArchiveUtils.canClose(this.dataTypeManagerHandler.getAllModifiedFileArchives(), (Component)this.provider.getComponent());
    }

    protected void close() {
        this.provider.dispose();
    }

    public DataTypeManagerHandler getDataTypeManagerHandler() {
        return this.dataTypeManagerHandler;
    }

    public DataTypeEditorManager getEditorManager() {
        return this.editorManager;
    }

    public DataTypesProvider getProvider() {
        return this.provider;
    }

    public Clipboard getClipboard() {
        return this.clipboard;
    }

    public DataTypesProvider createProvider() {
        DataTypesProvider newProvider = new DataTypesProvider(this, SEARCH_PROVIDER_NAME, true);
        newProvider.setIncludeDataTypeMembersInFilter(this.provider.isIncludeDataMembersInSearch());
        DtFilterState filterState = this.provider.getFilterState();
        newProvider.setFilterState(filterState.copy());
        return newProvider;
    }

    public Program getProgram() {
        return this.currentProgram;
    }

    public DataTypeConflictHandler getConflictHandler() {
        return this.provider.getConflictHandler();
    }

    void setStatus(String message) {
        this.tool.setStatusInfo(message);
    }

    public static boolean isValidTypeDefBaseType(Component parent, DataType dataType) {
        if (dataType instanceof FactoryDataType) {
            Msg.showError(DataTypeManagerPlugin.class, (Component)parent, (String)"TypeDef not allowed", (Object)("TypeDef not allowed on a Factory data-type: " + dataType.getName()));
            return false;
        }
        if (dataType instanceof Dynamic) {
            Msg.showError(DataTypeManagerPlugin.class, (Component)parent, (String)"TypeDef not allowed", (Object)("TypeDef not allowed on a Dynamic data-type: " + dataType.getName()));
            return false;
        }
        if (dataType.getLength() <= 0) {
            Msg.showError(DataTypeManagerPlugin.class, (Component)parent, (String)"TypeDef not allowed", (Object)("Data-type has unknown length: " + dataType.getName()));
            return false;
        }
        return true;
    }

    private void updateRecentlyOpenedArchivesMenu() {
        ArrayList<DockingAction> actionList = new ArrayList<DockingAction>(this.recentlyOpenedArchiveMap.values());
        for (DockingAction action : actionList) {
            if (action == null) continue;
            this.tool.removeLocalAction((ComponentProvider)this.provider, (DockingActionIf)action);
        }
        for (DockingAction action : actionList) {
            if (action == null) continue;
            this.tool.addLocalAction((ComponentProvider)this.provider, (DockingActionIf)action);
        }
    }

    private void createStandardArchivesMenu() {
        this.installArchiveMap = new TreeMap<String, DockingAction>();
        String gdt = ".gdt";
        List gdts = Application.findFilesByExtensionInApplication((String)gdt);
        for (ResourceFile archiveFile : gdts) {
            Path path = new Path(archiveFile);
            String absolutePath = path.getPathAsString();
            if (!absolutePath.contains("/data/typeinfo/")) continue;
            RecentlyOpenedArchiveAction action = new RecentlyOpenedArchiveAction(this, absolutePath, STANDARD_ARCHIVE_MENU);
            action.setHelpLocation(new HelpLocation(this.getName(), "Standard_Archives"));
            this.installArchiveMap.put(absolutePath, action);
        }
        for (DockingAction action : this.installArchiveMap.values()) {
            this.tool.addLocalAction((ComponentProvider)this.provider, (DockingActionIf)action);
        }
    }

    private void createActions() {
        this.createStandardArchivesMenu();
        ((ActionBuilder)((ActionBuilder)new ActionBuilder("Edit Data Type", this.getName()).keyBinding("Control Shift D")).onAction(this::edit)).buildAndInstall((Tool)this.tool);
    }

    private void removeRecentAction(DockingAction action) {
        this.tool.removeLocalAction((ComponentProvider)this.provider, (DockingActionIf)action);
    }

    private void edit(ActionContext c) {
        DataType dt = this.chooseType();
        if (dt != null) {
            this.edit(dt);
        }
    }

    private DataType chooseType() {
        int noSizeRestriction = -1;
        DataTypeSelectionDialog selectionDialog = new DataTypeSelectionDialog((ServiceProvider)this.tool, null, noSizeRestriction, DataTypeParser.AllowedDataTypes.ALL);
        this.tool.showDialog((DialogComponentProvider)selectionDialog);
        return selectionDialog.getUserChosenDataType();
    }

    @Override
    public HelpLocation getEditorHelpLocation(DataType dataType) {
        return this.editorManager.getEditorHelpLocation(dataType);
    }

    @Override
    public boolean isEditable(DataType dt) {
        return this.editorManager.isEditable(dt);
    }

    @Override
    public void edit(DataType dt) {
        this.editorManager.edit(dt);
    }

    @Override
    public void edit(Composite composite, String fieldName) {
        this.editorManager.edit(composite, fieldName);
    }

    @Override
    public DataTypeManager getBuiltInDataTypesManager() {
        return this.dataTypeManagerHandler.getBuiltInDataTypesManager();
    }

    public DataTypeManager getProgramDataTypeManager() {
        DataTypeManager[] managers;
        for (DataTypeManager manager : managers = this.getDataTypeManagers()) {
            if (!(manager instanceof ProgramDataTypeManager)) continue;
            return manager;
        }
        return null;
    }

    @Override
    public DataType getDataType(String filterText) {
        return this.promptForDataType(filterText);
    }

    @Override
    public List<DataType> findDataTypes(String dtName, TaskMonitor monitor) {
        ArrayList<DataType> results = new ArrayList<DataType>();
        DataTypeManager[] managers = this.getDataTypeManagers();
        DataTypeManager pdtm = this.getProgramDataTypeManager();
        pdtm.findDataTypes(dtName, results);
        for (DataTypeManager manager : managers) {
            if (manager instanceof ProgramDataTypeManager) continue;
            manager.findDataTypes(dtName, results);
        }
        return results;
    }

    @Override
    public List<DataType> getDataTypesByPath(DataTypePath path) {
        DataTypeManager[] managers;
        ArrayList<DataType> results = new ArrayList<DataType>();
        for (DataTypeManager manager : managers = this.getDataTypeManagers()) {
            DataType dt = manager.getDataType(path);
            if (dt == null) continue;
            if (manager instanceof ProgramDataTypeManager) {
                results.add(0, dt);
                continue;
            }
            results.add(dt);
        }
        return results;
    }

    @Override
    public DataType getProgramDataTypeByPath(DataTypePath path) {
        DataTypeManager pdtm = this.getProgramDataTypeManager();
        if (pdtm == null) {
            return null;
        }
        return pdtm.getDataType(path);
    }

    @Override
    public DataType promptForDataType(String filterText) {
        DataTypeChooserDialog dialog = new DataTypeChooserDialog(this);
        if (!StringUtils.isBlank((CharSequence)filterText)) {
            dialog.showPrepopulatedDialog((Tool)this.tool, filterText);
        } else {
            this.tool.showDialog((DialogComponentProvider)dialog);
        }
        return dialog.getSelectedDataType();
    }

    @Override
    public DataType getDataType(TreePath selectedPath) {
        DataTypeChooserDialog dialog = new DataTypeChooserDialog(this);
        if (selectedPath != null) {
            dialog.setSelectedPath(selectedPath);
        }
        this.tool.showDialog((DialogComponentProvider)dialog);
        return dialog.getSelectedDataType();
    }

    @Override
    public CategoryPath getCategoryPath(TreePath selectedPath) {
        DataTypeChooserDialog dialog = new DataTypeChooserDialog(this);
        dialog.setCategorySelectionMode(true);
        dialog.setShowProgramArchiveOnly(true);
        if (selectedPath != null) {
            dialog.setSelectedPath(selectedPath);
        }
        this.tool.showDialog((DialogComponentProvider)dialog);
        return dialog.getSelectedCategoryPath();
    }

    @Override
    public DataTypeManager[] getDataTypeManagers() {
        return this.dataTypeManagerHandler.getDataTypeManagers();
    }

    @Override
    public void closeArchive(DataTypeManager dtm) {
        this.dataTypeManagerHandler.closeArchive(dtm);
        this.provider.archiveClosed(dtm);
    }

    @Override
    public DataTypeManager openDataTypeArchive(String archiveName) throws IOException, DuplicateIdException {
        return this.dataTypeManagerHandler.openArchive(archiveName);
    }

    @Override
    public DataTypeManager openArchive(ResourceFile file, boolean acquireWriteLock) throws IOException, DuplicateIdException {
        Archive archive = this.openArchive(file.getFile(true), acquireWriteLock);
        return archive.getDataTypeManager();
    }

    @Override
    public DataTypeManager openArchive(DomainFile domainFile, TaskMonitor monitor) throws VersionException, CancelledException, IOException, DuplicateIdException {
        DataTypeArchive archive = this.openArchive(domainFile);
        return archive.getDataTypeManager();
    }

    public List<Archive> getAllArchives() {
        return this.dataTypeManagerHandler.getAllArchives();
    }

    public void openProjectDataTypeArchive() {
        OpenVersionedFileDialog<DataTypeArchive> dialog = new OpenVersionedFileDialog<DataTypeArchive>(this.tool, "Open Project Data Type Archive", DataTypeArchive.class);
        dialog.setHelpLocation(new HelpLocation("ProgramManagerPlugin", "Open_File_Dialog"));
        dialog.addOkActionListener(ev -> {
            DomainFile domainFile = dialog.getDomainFile();
            int version = dialog.getVersion();
            if (domainFile == null) {
                dialog.setStatusText("Please choose a Project Data Type Archive");
            } else {
                dialog.close();
                this.openArchive(domainFile, version);
            }
        });
        this.tool.showDialog(dialog);
    }

    @Override
    public List<DataType> getFavorites() {
        return this.dataTypeManagerHandler.getFavoriteDataTypes();
    }

    @Override
    public DataType getRecentlyUsed() {
        return this.dataTypeManagerHandler.getRecentlyDataType();
    }

    @Override
    public List<DataType> getSortedDataTypeList() {
        return this.dataTypeManagerHandler.getDataTypeIndexer().getSortedDataTypeList();
    }

    @Override
    public List<CategoryPath> getSortedCategoryPathList() {
        return this.dataTypeManagerHandler.getDataTypeIndexer().getSortedCategoryPathList();
    }

    @Override
    public void setDataTypeSelected(DataType dataType) {
        if (this.provider.isVisible()) {
            Swing.runIfSwingOrRunLater(() -> this.provider.setDataTypeSelected(dataType));
        }
    }

    @Override
    public void setCategorySelected(Category category) {
        if (this.provider.isVisible()) {
            Swing.runIfSwingOrRunLater(() -> this.provider.setCategorySelected(category));
        }
    }

    @Override
    public List<DataType> getSelectedDatatypes() {
        if (this.provider.isVisible()) {
            return this.provider.getSelectedDataTypes();
        }
        return Collections.emptyList();
    }

    @Override
    public void setRecentlyUsed(DataType dt) {
        this.dataTypeManagerHandler.setRecentlyUsedDataType(dt);
    }

    @Override
    public void addDataTypeManagerChangeListener(DataTypeManagerChangeListener listener) {
        this.dataTypeManagerHandler.addDataTypeManagerChangeListener(listener);
    }

    @Override
    public void removeDataTypeManagerChangeListener(DataTypeManagerChangeListener listener) {
        this.dataTypeManagerHandler.removeDataTypeManagerChangeListener(listener);
    }

    @Override
    public Set<String> getPossibleEquateNames(long value) {
        return this.dataTypeManagerHandler.getPossibleEquateNames(value);
    }

    public Class<?>[] getSupportedDataTypes() {
        return new Class[]{DataTypeArchive.class};
    }

    public boolean acceptData(DomainFile[] data) {
        if (data == null || data.length == 0) {
            return false;
        }
        boolean addedArchives = false;
        for (DomainFile element : data) {
            if (element == null || !DataTypeArchive.class.isAssignableFrom(element.getDomainObjectClass())) continue;
            this.openArchive(element);
            addedArchives = true;
        }
        if (addedArchives) {
            this.showProviderLater();
        }
        return addedArchives;
    }

    private void showProviderLater() {
        SwingUtilities.invokeLater(() -> this.tool.toFront((ComponentProvider)this.provider));
    }

    public DataTypeArchive openArchive(DomainFile df) {
        return this.openArchive(df, -1);
    }

    public DataTypeArchive openArchive(DomainFile df, int version) {
        OpenDomainFileTask task = new OpenDomainFileTask(df, version, this.tool, this);
        new TaskLauncher((Task)task, (Component)this.tool.getToolFrame(), 0);
        return task.getArchive();
    }

    public boolean commit(DataType dataType) {
        return DataTypeSynchronizer.commit(this.dataTypeManagerHandler, dataType);
    }

    public boolean update(DataType dataType) {
        return DataTypeSynchronizer.update(this.dataTypeManagerHandler, dataType);
    }

    public boolean revert(DataType dataType) {
        return DataTypeSynchronizer.update(this.dataTypeManagerHandler, dataType);
    }

    public void disassociate(DataType dataTypes) {
        DataTypeSynchronizer.disassociate(dataTypes);
    }

    @Override
    public Archive openArchive(DataTypeArchive dataTypeArchive) {
        return this.dataTypeManagerHandler.openArchive(dataTypeArchive);
    }

    @Override
    public Archive openArchive(File file, boolean acquireWriteLock) throws IOException, DuplicateIdException {
        return this.dataTypeManagerHandler.openArchive(file, acquireWriteLock, false);
    }

    public AddressSetView getCurrentSelection() {
        return this.currentSelection;
    }

    public List<DockingActionIf> getPopupActions(Tool dockingTool, ActionContext context) {
        if (!(context instanceof DataTypesActionContext)) {
            return null;
        }
        DataTypesActionContext dtContext = (DataTypesActionContext)context;
        GTreeNode selectedNode = dtContext.getClickedNode();
        if (!(selectedNode instanceof ArchiveNode)) {
            return null;
        }
        ArrayList<DockingActionIf> actions = new ArrayList<DockingActionIf>();
        ArchiveNode archiveNode = (ArchiveNode)selectedNode;
        Archive archive = archiveNode.getArchive();
        DataTypeManager dataTypeManager = archive.getDataTypeManager();
        if (dataTypeManager == null) {
            return null;
        }
        String group = "FGroup";
        List sourceArchives = dataTypeManager.getSourceArchives();
        for (SourceArchive sourceArchive : sourceArchives) {
            DataTypeManager sourceDTM = this.dataTypeManagerHandler.getDataTypeManager(sourceArchive);
            boolean canUpdate = this.canUpdate(sourceArchive, sourceDTM);
            boolean canCommit = this.canCommit(sourceArchive, sourceDTM);
            actions.add((DockingActionIf)new SyncRefreshAction(this, this.dataTypeManagerHandler, dataTypeManager, archiveNode, sourceArchive, true));
            actions.add((DockingActionIf)new CommitAction(this, this.dataTypeManagerHandler, dataTypeManager, archiveNode, sourceArchive, canCommit));
            actions.add((DockingActionIf)new UpdateAction(this, this.dataTypeManagerHandler, dataTypeManager, archiveNode, sourceArchive, canUpdate));
            actions.add((DockingActionIf)new RevertAction(this, this.dataTypeManagerHandler, dataTypeManager, archiveNode, sourceArchive, canCommit));
            actions.add((DockingActionIf)new DisassociateAction(this, this.dataTypeManagerHandler, dataTypeManager, archiveNode, sourceArchive));
        }
        for (DockingActionIf action : actions) {
            MenuData popupData = action.getPopupMenuData();
            String pullRightName = popupData.getMenuPath()[0];
            this.tool.setMenuGroup(new String[]{pullRightName}, group);
        }
        UpdateSourceArchiveNamesAction action = new UpdateSourceArchiveNamesAction(this, dataTypeManager);
        action.getPopupMenuData().setMenuGroup(group);
        actions.add((DockingActionIf)action);
        return actions;
    }

    private boolean canUpdate(SourceArchive sourceArchive, DataTypeManager sourceDTM) {
        long lastSyncTimeForSource;
        if (sourceDTM == null) {
            return false;
        }
        long lastChangeTimeForSource = sourceDTM.getLastChangeTimeForMyManager();
        return lastChangeTimeForSource != (lastSyncTimeForSource = sourceArchive.getLastSyncTime());
    }

    private boolean canCommit(SourceArchive sourceArchive, DataTypeManager sourceDTM) {
        if (sourceDTM == null) {
            return false;
        }
        return sourceArchive.isDirty();
    }

    public DomainFile[] getData() {
        ArrayList<DomainFile> domainFileList = new ArrayList<DomainFile>();
        List<Archive> allArchives = this.dataTypeManagerHandler.getAllArchives();
        for (Archive archive : allArchives) {
            if (!(archive instanceof ProjectArchive) || !archive.isModifiable()) continue;
            domainFileList.add(((ProjectArchive)archive).getDomainFile());
        }
        return domainFileList.toArray(new DomainFile[domainFileList.size()]);
    }

    protected boolean saveData() {
        return ArchiveUtils.canClose(this.dataTypeManagerHandler.getAllFileOrProjectArchives(), (Component)this.provider.getComponent());
    }
}

