/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.flowarrow;

import docking.widgets.fieldpanel.FieldPanel;
import ghidra.app.plugin.core.flowarrow.ConditionalFlowArrow;
import ghidra.app.plugin.core.flowarrow.DefaultFlowArrow;
import ghidra.app.plugin.core.flowarrow.FallthroughFlowArrow;
import ghidra.app.plugin.core.flowarrow.FlowArrow;
import ghidra.app.plugin.core.flowarrow.FlowArrowPanel;
import ghidra.app.plugin.core.flowarrow.FlowArrowPlugin;
import ghidra.app.util.viewer.field.ListingColors;
import ghidra.app.util.viewer.listingpanel.ListingMarginProvider;
import ghidra.app.util.viewer.listingpanel.ListingPanel;
import ghidra.app.util.viewer.listingpanel.VerticalPixelAddressMap;
import ghidra.app.util.viewer.util.AddressIndexMap;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.util.MarkerLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.UniversalID;
import java.awt.Color;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;

class FlowArrowMarginProvider
implements ListingMarginProvider {
    static final int LEFT_OFFSET = 3;
    private static final int MAX_DEPTH = 16;
    private static final int MAX_REFSTO_SHOW = 10;
    private Map<Address, Integer> startAddressToPixel = new HashMap<Address, Integer>();
    private Map<Address, Integer> endAddressToPixel = new HashMap<Address, Integer>();
    private FlowArrowPlugin plugin;
    private ListingPanel listingPanel;
    private Program program;
    private Address currentAddr;
    private FlowArrowPanel flowArrowPanel;
    private int maxColumn;
    private boolean isShowing = true;
    private boolean validState = false;
    private VerticalPixelAddressMap layoutToPixel;
    private Address screenTop;
    private Address screenBottom;
    private List<FlowArrow> flowArrows = new ArrayList<FlowArrow>();
    private Set<FlowArrow> selectedArrows = new HashSet<FlowArrow>();
    private Set<FlowArrow> activeArrows = new HashSet<FlowArrow>();

    FlowArrowMarginProvider(FlowArrowPlugin plugin) {
        this.plugin = plugin;
        this.flowArrowPanel = new FlowArrowPanel(this);
        this.flowArrowPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                boolean previousState = FlowArrowMarginProvider.this.isShowing;
                boolean bl = FlowArrowMarginProvider.this.isShowing = FlowArrowMarginProvider.this.flowArrowPanel.getWidth() > 3;
                if (FlowArrowMarginProvider.this.isShowing && !previousState) {
                    FlowArrowMarginProvider.this.updateAndRepaint();
                }
            }

            @Override
            public void componentShown(ComponentEvent e) {
                boolean previousState = FlowArrowMarginProvider.this.isShowing;
                boolean bl = FlowArrowMarginProvider.this.isShowing = FlowArrowMarginProvider.this.flowArrowPanel.getWidth() > 3;
                if (FlowArrowMarginProvider.this.isShowing && !previousState) {
                    FlowArrowMarginProvider.this.updateAndRepaint();
                }
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                FlowArrowMarginProvider.this.isShowing = false;
            }
        });
        this.flowArrowPanel.setBackground((Color)ListingColors.BACKGROUND);
        this.flowArrowPanel.setForeground((Color)ListingColors.FlowArrowColors.INACTIVE);
        this.flowArrowPanel.setHighlightColor((Color)ListingColors.FlowArrowColors.ACTIVE);
        this.flowArrowPanel.setSelectedColor((Color)ListingColors.FlowArrowColors.SELECTED);
    }

    @Override
    public void setOwnerId(UniversalID ownerId) {
    }

    @Override
    public JComponent getComponent() {
        return this.flowArrowPanel;
    }

    @Override
    public MarkerLocation getMarkerLocation(int x, int y) {
        return null;
    }

    @Override
    public boolean isResizeable() {
        return true;
    }

    @Override
    public void setLocation(ProgramLocation location) {
        this.currentAddr = location.getAddress();
        this.clearActiveArrows();
        this.assignActiveArrows();
        this.flowArrowPanel.repaint();
    }

    @Override
    public void screenDataChanged(ListingPanel listing, AddressIndexMap addrMap, VerticalPixelAddressMap pixMap) {
        this.listingPanel = listing;
        Program currentProgram = listing.getProgram();
        if (this.program != currentProgram) {
            this.clearAllArrows();
        }
        this.program = currentProgram;
        this.layoutToPixel = pixMap;
        this.validateState();
        this.updateAndRepaint();
    }

    Address getCurrentAddress() {
        return this.currentAddr;
    }

    Address getScreenBottomAddr() {
        return this.screenBottom;
    }

    int getMaxColumn() {
        return this.maxColumn;
    }

    boolean isOnScreen(Address address) {
        if (this.screenBottom == null || this.screenTop == null) {
            return true;
        }
        if (address.compareTo((Object)this.screenTop) < 0) {
            return false;
        }
        return address.compareTo((Object)this.screenBottom) <= 0;
    }

    boolean isOffscreen(FlowArrow arrow) {
        if (this.screenBottom == null || this.screenTop == null) {
            return true;
        }
        if (arrow.start.compareTo((Object)this.screenTop) < 0 && arrow.end.compareTo((Object)this.screenTop) < 0) {
            return true;
        }
        return arrow.start.compareTo((Object)this.screenBottom) > 0 && arrow.end.compareTo((Object)this.screenBottom) > 0;
    }

    boolean isBelowScreen(Address address) {
        if (this.screenBottom == null || this.screenTop == null) {
            return true;
        }
        return address.compareTo((Object)this.screenBottom) > 0;
    }

    Integer getStartPos(Address addr) {
        return this.startAddressToPixel.get(addr);
    }

    Integer getEndPos(Address addr) {
        return this.endAddressToPixel.get(addr);
    }

    void setArrowSelected(FlowArrow arrow, boolean selected) {
        if (selected) {
            this.selectedArrows.add(arrow);
        } else {
            this.selectedArrows.remove(arrow);
        }
    }

    Iterator<FlowArrow> getSelectedFlowArrows() {
        return this.selectedArrows.iterator();
    }

    Iterator<FlowArrow> getFlowArrowIterator() {
        return this.flowArrows.iterator();
    }

    Iterator<FlowArrow> getActiveArrows() {
        return this.activeArrows.iterator();
    }

    private void resetSelectedArrows() {
        for (FlowArrow arrow : this.selectedArrows) {
            arrow.resetShape();
        }
    }

    private void clearAllArrows() {
        this.flowArrows.clear();
        this.activeArrows.clear();
        this.selectedArrows.clear();
    }

    private void clearActiveArrows() {
        for (FlowArrow f : this.activeArrows) {
            f.active = false;
        }
        this.activeArrows.clear();
    }

    private void resetActiveArrows() {
        for (FlowArrow arrow : this.activeArrows) {
            arrow.resetShape();
        }
    }

    private void assignActiveArrows() {
        if (!this.activeArrows.isEmpty()) {
            this.resetActiveArrows();
            return;
        }
        if (this.currentAddr == null) {
            return;
        }
        for (FlowArrow arrow : this.flowArrows) {
            if (!this.currentAddr.equals((Object)arrow.start)) continue;
            arrow.active = true;
            this.activeArrows.add(arrow);
        }
    }

    private void mapArrowsByEndpoints(Map<Address, List<FlowArrow>> arrowsByStart, Map<Address, List<FlowArrow>> arrowsByEnd) {
        for (FlowArrow arrow : this.flowArrows) {
            arrowsByStart.computeIfAbsent(arrow.start, f -> new ArrayList()).add(arrow);
            arrowsByEnd.computeIfAbsent(arrow.end, f -> new ArrayList()).add(arrow);
        }
    }

    private List<ArrowGroup> groupArrowsBySharedEndpoints() {
        HashMap<Address, List<FlowArrow>> arrowsByStart = new HashMap<Address, List<FlowArrow>>();
        HashMap<Address, List<FlowArrow>> arrowsByEnd = new HashMap<Address, List<FlowArrow>>();
        this.mapArrowsByEndpoints(arrowsByStart, arrowsByEnd);
        ArrayList<ArrowGroup> groups = new ArrayList<ArrowGroup>();
        HashSet<FlowArrow> unprocessed = new HashSet<FlowArrow>(this.flowArrows);
        for (FlowArrow arrow : this.flowArrows) {
            if (!unprocessed.contains(arrow)) continue;
            ArrowGroup group = new ArrowGroup(this);
            List starts = (List)arrowsByStart.get(arrow.start);
            for (FlowArrow f : starts) {
                group.add(f);
                unprocessed.remove(arrow);
            }
            List ends = (List)arrowsByEnd.get(arrow.end);
            for (FlowArrow f : ends) {
                group.add(f);
                unprocessed.remove(arrow);
            }
            group.add(arrow);
            unprocessed.remove(arrow);
            groups.add(group);
        }
        groups.sort((g1, g2) -> g1.getSortAddress().compareTo((Object)g2.getSortAddress()));
        return groups;
    }

    private void assignArrowColumns() {
        List<ArrowGroup> groups = this.groupArrowsBySharedEndpoints();
        HashMap<Integer, ArrowGroup> groupsByColumn = new HashMap<Integer, ArrowGroup>();
        block0: for (ArrowGroup group : groups) {
            for (int nextCol = 0; nextCol < groups.size(); ++nextCol) {
                ArrowGroup existingGroup = (ArrowGroup)groupsByColumn.get(nextCol);
                if (existingGroup != null && existingGroup.overlaps(group)) continue;
                int column = Math.min(16, nextCol);
                group.setColumn(column);
                groupsByColumn.put(column, group);
                this.maxColumn = Math.max(this.maxColumn, column);
                continue block0;
            }
        }
    }

    private List<FlowArrow> getFlowArrowsForScreenInstructions(AddressSetView screenAddresses) {
        OffscreenArrowsFlow offscreenArrows = new OffscreenArrowsFlow();
        HashSet<FlowArrow> results = new HashSet<FlowArrow>();
        Listing listing = this.program.getListing();
        InstructionIterator it = listing.getInstructions(screenAddresses, true);
        for (Instruction inst : it) {
            ReferenceManager refManager = this.program.getReferenceManager();
            int refCount = refManager.getReferenceCountTo(inst.getMinAddress());
            if (refCount < 10) {
                for (Reference ref : inst.getReferenceIteratorTo()) {
                    this.createFlowArrow(results, offscreenArrows, ref);
                }
            }
            offscreenArrows.clear();
            for (Reference ref : inst.getReferencesFrom()) {
                this.createFlowArrow(results, offscreenArrows, ref);
            }
        }
        ArrayList<FlowArrow> newArrows = new ArrayList<FlowArrow>(results);
        Collections.sort(newArrows, (a1, a2) -> a1.end.compareTo((Object)a2.end));
        return newArrows;
    }

    private void createFlowArrow(Set<FlowArrow> results, OffscreenArrowsFlow offscreenArrows, Reference ref) {
        RefType type = ref.getReferenceType();
        if (!type.isJump() && !type.isFallthrough()) {
            return;
        }
        FlowArrow arrow = this.doCreateFlowArrow(ref);
        if (arrow == null) {
            return;
        }
        if (results.contains(arrow)) {
            return;
        }
        if (offscreenArrows.exists(arrow)) {
            return;
        }
        results.add(arrow);
        this.updateArrowSets(arrow);
    }

    private void updateArrowSets(FlowArrow arrow) {
        if (this.selectedArrows.remove(arrow)) {
            arrow.selected = true;
            this.selectedArrows.add(arrow);
        }
        if (this.activeArrows.remove(arrow)) {
            arrow.active = true;
            this.activeArrows.add(arrow);
        }
    }

    private FlowArrow doCreateFlowArrow(Reference ref) {
        Address start = this.toLayoutAddress(ref.getFromAddress());
        Address end = this.toLayoutAddress(ref.getToAddress());
        if (start == null || end == null) {
            return null;
        }
        if (!start.hasSameAddressSpace(end)) {
            return null;
        }
        Memory memory = this.program.getMemory();
        if (!memory.contains(end)) {
            return null;
        }
        RefType refType = ref.getReferenceType();
        if (refType.isFallthrough()) {
            return new FallthroughFlowArrow(this, this.flowArrowPanel, start, end, refType);
        }
        if (refType.isConditional()) {
            return new ConditionalFlowArrow(this, this.flowArrowPanel, start, end, refType);
        }
        return new DefaultFlowArrow(this, this.flowArrowPanel, start, end, refType);
    }

    private void validateState() {
        this.validState = true;
        if (this.program == null || this.layoutToPixel == null) {
            this.validState = false;
            return;
        }
        int n = this.layoutToPixel.getNumLayouts();
        this.validState = n != 0;
    }

    void updateAndRepaint() {
        this.update();
        this.flowArrowPanel.repaint();
    }

    private void update() {
        if (!this.isShowing || !this.validState) {
            return;
        }
        if (this.layoutToPixel == null) {
            return;
        }
        int n = this.layoutToPixel.getNumLayouts();
        if (n == 0) {
            return;
        }
        Address startAddress = this.layoutToPixel.getLayoutAddress(0);
        Address endAddress = this.layoutToPixel.getLayoutAddress(n - 1);
        this.screenTop = startAddress;
        this.screenBottom = endAddress;
        this.flowArrows.clear();
        this.startAddressToPixel.clear();
        this.endAddressToPixel.clear();
        this.maxColumn = 0;
        this.resetSelectedArrows();
        if (this.screenTop == null || this.screenBottom == null || n > 500) {
            return;
        }
        for (int layout = 0; layout < n; ++layout) {
            Address addr = this.layoutToPixel.getLayoutAddress(layout);
            if (addr == null) continue;
            this.startAddressToPixel.put(addr, this.layoutToPixel.getBeginPosition(layout));
            this.endAddressToPixel.put(addr, this.layoutToPixel.getEndPosition(layout));
        }
        AddressSetView flowSet = this.layoutToPixel.getAddressSet();
        this.flowArrows = this.getFlowArrowsForScreenInstructions(flowSet);
        this.assignArrowColumns();
        this.assignActiveArrows();
    }

    private Address toLayoutAddress(Address addr) {
        Integer pixel = this.startAddressToPixel.get(addr);
        if (pixel != null || addr.compareTo((Object)this.screenTop) < 0 || addr.compareTo((Object)this.screenBottom) > 0) {
            return addr;
        }
        int n = this.layoutToPixel.getNumLayouts();
        for (int i = 0; i < n; ++i) {
            Address layoutAddr = this.layoutToPixel.getLayoutAddress(i);
            Address endLayoutAddr = this.layoutToPixel.getLayoutEndAddress(i);
            if (layoutAddr == null || endLayoutAddr == null) continue;
            if (layoutAddr.compareTo((Object)addr) >= 0) {
                return null;
            }
            if (addr.compareTo((Object)endLayoutAddr) > 0) continue;
            return layoutAddr;
        }
        return addr;
    }

    void setBackground(Color c) {
        this.flowArrowPanel.setBackground(c);
    }

    void setForeground(Color c) {
        this.flowArrowPanel.setForeground(c);
    }

    void setHighlightColor(Color c) {
        this.flowArrowPanel.setHighlightColor(c);
    }

    @Override
    public void dispose() {
        this.plugin.remove(this);
        this.program = null;
        this.layoutToPixel = null;
        this.startAddressToPixel.clear();
        this.endAddressToPixel.clear();
        this.clearAllArrows();
        this.flowArrowPanel.dispose();
    }

    void goTo(Address address) {
        ProgramLocation location = new ProgramLocation(this.program, address);
        this.listingPanel.goTo(location);
    }

    void scrollTo(Address address) {
        ProgramLocation location = new ProgramLocation(this.program, address);
        this.listingPanel.scrollTo(location);
    }

    Address getLastAddressOnScreen(Address end, boolean up) {
        if (up) {
            return this.screenTop;
        }
        return this.screenBottom;
    }

    public void forwardMouseEventToListing(MouseWheelEvent e) {
        FieldPanel fieldPanel = this.listingPanel.getFieldPanel();
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        kfm.redispatchEvent((Component)fieldPanel, e);
    }

    private class ArrowGroup {
        private Set<FlowArrow> arrows = new HashSet<FlowArrow>();
        private AddressSet addrs = new AddressSet();
        private Address lowestEndAddress;
        private int column;

        private ArrowGroup(FlowArrowMarginProvider flowArrowMarginProvider) {
        }

        Address getSortAddress() {
            return this.lowestEndAddress;
        }

        void setColumn(int column) {
            this.column = column;
            for (FlowArrow f : this.arrows) {
                f.column = column;
            }
        }

        void add(FlowArrow f) {
            if (this.lowestEndAddress == null) {
                this.lowestEndAddress = f.end;
            } else if (this.lowestEndAddress.compareTo((Object)f.end) >= 0) {
                this.lowestEndAddress = f.end;
            }
            this.arrows.add(f);
            this.addrs.add((AddressSetView)f.addresses);
        }

        boolean overlaps(ArrowGroup other) {
            return this.addrs.intersects((AddressSetView)other.addrs);
        }
    }

    private class OffscreenArrowsFlow {
        private Map<Address, OffScreenFlow> flowsAbove = new HashMap<Address, OffScreenFlow>();
        private Map<Address, OffScreenFlow> flowsBelow = new HashMap<Address, OffScreenFlow>();

        private OffscreenArrowsFlow() {
        }

        boolean exists(FlowArrow arrow) {
            OffScreenFlow flow;
            boolean isBelow;
            boolean isAbove = arrow.end.compareTo((Object)FlowArrowMarginProvider.this.screenTop) < 0;
            boolean bl = isBelow = arrow.end.compareTo((Object)FlowArrowMarginProvider.this.screenBottom) > 0;
            if (!isAbove && !isBelow) {
                return false;
            }
            if (isAbove) {
                flow = this.flowsAbove.get(arrow.start);
                if (flow == null) {
                    flow = new OffScreenFlow(this);
                    this.flowsAbove.put(arrow.start, flow);
                }
            } else {
                flow = this.flowsBelow.get(arrow.start);
                if (flow == null) {
                    flow = new OffScreenFlow(this);
                    this.flowsBelow.put(arrow.start, flow);
                }
            }
            boolean alreadyHasArrow = flow.setFlow(arrow.refType);
            return alreadyHasArrow;
        }

        void clear() {
            this.flowsAbove.clear();
            this.flowsBelow.clear();
        }

        private class OffScreenFlow {
            private boolean conditional;
            private boolean fallthrough;
            private boolean other;

            private OffScreenFlow(OffscreenArrowsFlow offscreenArrowsFlow) {
            }

            boolean setFlow(RefType type) {
                boolean wasSet = false;
                if (type.isConditional()) {
                    wasSet = this.conditional;
                    this.conditional = true;
                } else if (type.isFallthrough()) {
                    wasSet = this.fallthrough;
                    this.fallthrough = true;
                } else {
                    wasSet = this.other;
                    this.other = true;
                }
                return wasSet;
            }
        }
    }
}

