/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.flowarrow;

import ghidra.app.events.ProgramActivatedPluginEvent;
import ghidra.app.events.ProgramClosedPluginEvent;
import ghidra.app.events.ProgramLocationPluginEvent;
import ghidra.app.plugin.core.flowarrow.FlowArrowMarginProvider;
import ghidra.app.services.ListingMarginProviderService;
import ghidra.app.util.viewer.listingpanel.ListingMarginProvider;
import ghidra.app.util.viewer.options.OptionsGui;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Code Viewer", shortDescription="Show arrows for execution flow", description="This plugin shows arrows to graphically illustrate the flow of execution within a function. The arrows indicate source and destination for jumps; solid lines indicate unconditional jumps; dashed lines indicate conditional jumps.", servicesProvided={ListingMarginProviderService.class}, eventsConsumed={ProgramActivatedPluginEvent.class, ProgramClosedPluginEvent.class, ProgramLocationPluginEvent.class})
public class FlowArrowPlugin
extends Plugin
implements ListingMarginProviderService {
    private List<FlowArrowMarginProvider> providers = new ArrayList<FlowArrowMarginProvider>();

    public FlowArrowPlugin(PluginTool tool) {
        super(tool);
        this.getOptions();
    }

    @Override
    public ListingMarginProvider createMarginProvider() {
        FlowArrowMarginProvider provider = new FlowArrowMarginProvider(this);
        this.providers.add(provider);
        return provider;
    }

    @Override
    public boolean isOwner(ListingMarginProvider provider) {
        return this.providers.contains(provider);
    }

    void remove(FlowArrowMarginProvider provider) {
        this.providers.remove(provider);
    }

    List<FlowArrowMarginProvider> getProviders() {
        return Collections.unmodifiableList(this.providers);
    }

    protected void dispose() {
        for (FlowArrowMarginProvider provider : new ArrayList<FlowArrowMarginProvider>(this.providers)) {
            provider.dispose();
        }
    }

    private void getOptions() {
        ToolOptions opt = this.tool.getOptions("Listing Display");
        opt.registerThemeColorBinding(OptionsGui.FLOW_ARROW_NON_ACTIVE.getColorOptionName(), OptionsGui.FLOW_ARROW_NON_ACTIVE.getThemeColorId(), null, "The color for an arrow with no endpoint at the current address");
        opt.registerThemeColorBinding(OptionsGui.FLOW_ARROW_ACTIVE.getColorOptionName(), OptionsGui.FLOW_ARROW_ACTIVE.getThemeColorId(), null, "The color for an arrow with an endpoint at the current address");
        opt.registerThemeColorBinding(OptionsGui.FLOW_ARROW_SELECTED.getColorOptionName(), OptionsGui.FLOW_ARROW_SELECTED.getThemeColorId(), null, "The color for an arrow that has been selected by the user");
    }
}

