/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.marker;

import ghidra.app.plugin.core.marker.MarkerManager;
import ghidra.app.services.GoToService;
import ghidra.app.services.ListingMarginProviderService;
import ghidra.app.services.ListingOverviewProviderService;
import ghidra.app.services.MarkerService;
import ghidra.app.util.viewer.listingpanel.ListingMarginProvider;
import ghidra.app.util.viewer.listingpanel.ListingOverviewProvider;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.util.HelpLocation;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Common", shortDescription="Provides the marker display", description="This plugin extends the code browser to include left and right markercomponents.  The left margin shows marks related to the address being shown at that location.  The right margin shows marks at a position that is relative to an addresses within the overall program (Overview).  This plugin also provides a service that other plugins can use to display markers.  Two types of markers are supported; point markers and area markers.  Area markers are used to indicate a range value such as selection.  Point markers are used to represent individual addresses such as bookmarks.", servicesRequired={GoToService.class}, servicesProvided={MarkerService.class, ListingMarginProviderService.class, ListingOverviewProviderService.class}, eventsConsumed={})
public class MarkerManagerPlugin
extends Plugin
implements ListingMarginProviderService,
ListingOverviewProviderService {
    private MarkerManager markerManager = new MarkerManager(this);

    public MarkerManagerPlugin(PluginTool tool) {
        super(tool);
        ToolOptions options = tool.getOptions("Navigation Markers");
        options.setOptionsHelpLocation(new HelpLocation("CodeBrowserPlugin", "Navigation Markers"));
        this.registerServiceProvided(MarkerService.class, this.markerManager);
    }

    protected void dispose() {
        this.markerManager.dispose();
    }

    @Override
    public ListingMarginProvider createMarginProvider() {
        return this.markerManager.createMarginProvider();
    }

    @Override
    public boolean isOwner(ListingMarginProvider provider) {
        return this.markerManager.contains(provider);
    }

    @Override
    public ListingOverviewProvider createOverviewProvider() {
        return this.markerManager.createOverviewProvider();
    }

    @Override
    public boolean isOwner(ListingOverviewProvider provider) {
        return this.markerManager.contains(provider);
    }
}

