/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.scalartable;

import docking.Tool;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.widgets.table.actions.DeleteTableRowAction;
import ghidra.app.context.NavigatableActionContext;
import ghidra.app.context.NavigatableContextAction;
import ghidra.app.events.ViewChangedPluginEvent;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.core.scalartable.ScalarSearchDialog;
import ghidra.app.plugin.core.scalartable.ScalarSearchProvider;
import ghidra.app.services.GoToService;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.model.EventType;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramEvent;
import ghidra.util.HelpLocation;
import ghidra.util.task.SwingUpdateManager;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Code Viewer", shortDescription="Displays scalars", description="This plugin allows users to search for scalar values in a program.", servicesRequired={GoToService.class}, eventsConsumed={ViewChangedPluginEvent.class})
public class ScalarSearchPlugin
extends ProgramPlugin
implements DomainObjectListener {
    static final String SEARCH_ACTION_NAME = "Search for Scalars";
    private SwingUpdateManager reloadUpdateMgr;
    private DockingAction searchAction;
    private Set<ScalarSearchProvider> providers = new HashSet<ScalarSearchProvider>();

    public ScalarSearchPlugin(PluginTool tool) {
        super(tool);
        this.reloadUpdateMgr = new SwingUpdateManager(1000, 60000, () -> this.providers.forEach(p -> p.reload()));
    }

    public void init() {
        super.init();
        this.createActions();
    }

    public void dispose() {
        this.reloadUpdateMgr.dispose();
        if (this.currentProgram != null) {
            this.currentProgram.removeListener((DomainObjectListener)this);
        }
        Iterator<ScalarSearchProvider> iter = this.providers.iterator();
        while (iter.hasNext()) {
            ScalarSearchProvider provider = iter.next();
            provider.dispose();
            iter.remove();
        }
        super.dispose();
    }

    public void domainObjectChanged(DomainObjectChangedEvent ev) {
        if (ev.contains(new EventType[]{DomainObjectEvent.RESTORED, ProgramEvent.CODE_ADDED, ProgramEvent.CODE_REMOVED})) {
            this.reloadUpdateMgr.update();
        }
    }

    @Override
    protected void programActivated(Program program) {
        program.addListener((DomainObjectListener)this);
    }

    @Override
    protected void programClosed(Program program) {
        program.removeListener((DomainObjectListener)this);
        Iterator<ScalarSearchProvider> iter = this.providers.iterator();
        while (iter.hasNext()) {
            ScalarSearchProvider provider = iter.next();
            if (provider.getProgram() != program) continue;
            provider.programClosed(program);
            iter.remove();
        }
    }

    private void openSearchDialog() {
        ScalarSearchDialog dialog = new ScalarSearchDialog(this);
        dialog.show();
        ScalarSearchProvider provider = dialog.getProvider();
        if (provider != null) {
            this.providers.add(provider);
        }
    }

    private void createActions() {
        this.searchAction = new NavigatableContextAction(SEARCH_ACTION_NAME, this.getName(), false){

            @Override
            public void actionPerformed(NavigatableActionContext context) {
                ScalarSearchPlugin.this.openSearchDialog();
            }
        };
        this.searchAction.setHelpLocation(new HelpLocation(this.getName(), "Scalar_Search"));
        this.searchAction.setMenuBarData(new MenuData(new String[]{"&\u641c\u7d22", "For Scalars..."}, null, "search for", -1, "Scalars"));
        this.searchAction.setDescription("Search program for scalars");
        this.searchAction.addToWindowWhen(NavigatableActionContext.class);
        this.tool.addAction((DockingActionIf)this.searchAction);
        DeleteTableRowAction.registerDummy((Tool)this.tool, (String)this.getName());
    }
}

