/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symboltree;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.action.DockingActionIf;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeFilterProvider;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.GTreeRestoreTreeStateTask;
import docking.widgets.tree.GTreeState;
import docking.widgets.tree.GTreeTask;
import docking.widgets.tree.support.GTreeNodeTransferable;
import docking.widgets.tree.support.GTreeSelectionEvent;
import docking.widgets.tree.tasks.GTreeBulkTask;
import generic.theme.GIcon;
import ghidra.app.plugin.core.symboltree.DisconnectedSymbolTreeProvider;
import ghidra.app.plugin.core.symboltree.SymbolGTree;
import ghidra.app.plugin.core.symboltree.SymbolTreeActionContext;
import ghidra.app.plugin.core.symboltree.SymbolTreePlugin;
import ghidra.app.plugin.core.symboltree.actions.CloneSymbolTreeAction;
import ghidra.app.plugin.core.symboltree.actions.ConvertToClassAction;
import ghidra.app.plugin.core.symboltree.actions.CreateClassAction;
import ghidra.app.plugin.core.symboltree.actions.CreateExternalLocationAction;
import ghidra.app.plugin.core.symboltree.actions.CreateLibraryAction;
import ghidra.app.plugin.core.symboltree.actions.CreateNamespaceAction;
import ghidra.app.plugin.core.symboltree.actions.CreateSymbolTableAction;
import ghidra.app.plugin.core.symboltree.actions.CutAction;
import ghidra.app.plugin.core.symboltree.actions.DeleteAction;
import ghidra.app.plugin.core.symboltree.actions.EditExternalLocationAction;
import ghidra.app.plugin.core.symboltree.actions.GoToExternalLocationAction;
import ghidra.app.plugin.core.symboltree.actions.NavigateOnIncomingAction;
import ghidra.app.plugin.core.symboltree.actions.NavigateOnOutgoingActon;
import ghidra.app.plugin.core.symboltree.actions.PasteAction;
import ghidra.app.plugin.core.symboltree.actions.RenameAction;
import ghidra.app.plugin.core.symboltree.actions.SelectionAction;
import ghidra.app.plugin.core.symboltree.actions.SetExternalProgramAction;
import ghidra.app.plugin.core.symboltree.actions.ShowSymbolReferencesAction;
import ghidra.app.plugin.core.symboltree.nodes.SymbolCategoryNode;
import ghidra.app.plugin.core.symboltree.nodes.SymbolNode;
import ghidra.app.plugin.core.symboltree.nodes.SymbolTreeRootNode;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectEvent;
import ghidra.framework.model.DomainObjectException;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.model.DomainObjectListenerBuilder;
import ghidra.framework.model.EventType;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CircularDependencyException;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.util.FunctionChangeRecord;
import ghidra.program.util.FunctionReturnTypeFieldLocation;
import ghidra.program.util.FunctionSignatureFieldLocation;
import ghidra.program.util.LabelFieldLocation;
import ghidra.program.util.OperandFieldLocation;
import ghidra.program.util.ProgramChangeRecord;
import ghidra.program.util.ProgramEvent;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.VariableLocation;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.ClosedException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.SwingUpdateManager;
import ghidra.util.task.TaskMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.TreePath;

public class SymbolTreeProvider
extends ComponentProviderAdapter {
    private static final Icon ICON = new GIcon("icon.plugin.symboltree.provider");
    private static final String NAME = "Symbol Tree";
    private ClipboardOwner clipboardOwner;
    private Clipboard localClipboard;
    protected DomainObjectListener domainObjectListener;
    protected Program program;
    protected SymbolTreePlugin plugin;
    protected SymbolGTree tree;
    protected JComponent component;
    protected NavigateOnIncomingAction navigateIncomingAction;
    protected NavigateOnOutgoingActon navigateOutgoingAction;
    private List<AbstractSymbolUpdateTask> bufferedTasks = new ArrayList<AbstractSymbolUpdateTask>();
    private Map<Program, GTreeState> treeStateMap = new HashMap<Program, GTreeState>();
    private SwingUpdateManager domainChangeUpdateManager = new SwingUpdateManager(1000, 30000, "Symbol Tree Provider - Bulk Update", () -> {
        if (this.bufferedTasks.isEmpty()) {
            return;
        }
        ArrayList<AbstractSymbolUpdateTask> copiedTasks = new ArrayList<AbstractSymbolUpdateTask>(this.bufferedTasks);
        this.bufferedTasks.clear();
        this.tree.runTask((GTreeTask)new BulkWorkTask(this.tree, copiedTasks));
    });
    private GTreeState preRestoreTreeState;
    private SwingUpdateManager restoredUpdateManager = new SwingUpdateManager(750, 30000, "Symbol Tree Provider - Restore", () -> {
        this.tree.refilterLater();
        if (this.preRestoreTreeState == null) {
            return;
        }
        this.tree.restoreTreeState(this.preRestoreTreeState);
        this.preRestoreTreeState = null;
    });

    public SymbolTreeProvider(PluginTool tool, SymbolTreePlugin plugin) {
        super(tool, NAME, plugin.getName());
        this.plugin = plugin;
        this.setWindowMenuGroup(NAME);
        this.setIcon(ICON);
        this.addToToolbar();
        this.domainObjectListener = this.createDomainObjectListener();
        this.localClipboard = new Clipboard(NAME);
        this.component = this.buildProvider();
        plugin.getTool().addComponentProvider((ComponentProvider)this, false);
        this.createActions();
        this.setHelpLocation(new HelpLocation("SymbolTreePlugin", "Symbol_Tree"));
    }

    protected JPanel createMainPanel(JComponent contentComponent) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)contentComponent, "Center");
        return panel;
    }

    protected SymbolTreeRootNode createRootNode() {
        return new SymbolTreeRootNode(this.program, this.getNodeGroupThreshold());
    }

    private JComponent buildProvider() {
        this.tree = this.createTree(this.createRootNode());
        this.tree.setRootVisible(false);
        return this.createMainPanel((JComponent)((Object)this.tree));
    }

    private SymbolGTree createTree(SymbolTreeRootNode rootNode) {
        if (this.tree != null) {
            this.tree.setRootNode(rootNode);
            return this.tree;
        }
        final SymbolGTree newTree = new SymbolGTree(rootNode, this.plugin);
        newTree.addGTreeSelectionListener(e -> {
            if (!this.navigateOutgoingAction.isSelected()) {
                return;
            }
            GTreeSelectionEvent.EventOrigin origin = e.getEventOrigin();
            if (origin != GTreeSelectionEvent.EventOrigin.USER_GENERATED) {
                this.contextChanged();
                return;
            }
            SymbolNode symbolNode = this.getSelectedSymbolNode();
            this.maybeGoToSymbol(symbolNode);
            this.contextChanged();
        });
        newTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!SymbolTreeProvider.this.navigateOutgoingAction.isSelected()) {
                    return;
                }
                Point p = e.getPoint();
                GTreeNode clickedNode = newTree.getNodeForLocation(p.x, p.y);
                if (clickedNode == null) {
                    return;
                }
                SymbolNode symbolNode = SymbolTreeProvider.this.getSelectedSymbolNode();
                if (!clickedNode.equals((Object)symbolNode)) {
                    return;
                }
                SymbolTreeProvider.this.maybeGoToSymbol(symbolNode);
            }
        });
        newTree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                SymbolTreeProvider.this.treeNodeCollapsed(event.getPath());
            }
        });
        newTree.setEditable(true);
        return newTree;
    }

    protected void treeNodeCollapsed(TreePath path) {
        Object lastPathComponent = path.getLastPathComponent();
        if (lastPathComponent instanceof SymbolCategoryNode && !this.tree.hasFilterText()) {
            this.tree.runTask(m -> ((SymbolCategoryNode)((Object)((Object)lastPathComponent))).unloadChildren());
        }
    }

    private SymbolNode getSelectedSymbolNode() {
        TreePath[] paths = this.tree.getSelectionPaths();
        if (paths == null || paths.length != 1) {
            return null;
        }
        Object object = paths[0].getLastPathComponent();
        if (object instanceof SymbolNode) {
            SymbolNode symbolNode = (SymbolNode)((Object)object);
            return symbolNode;
        }
        return null;
    }

    private void maybeGoToSymbol(SymbolNode node) {
        if (node == null) {
            return;
        }
        Symbol symbol = node.getSymbol();
        SymbolType type = symbol.getSymbolType();
        if (!type.isNamespace() || type == SymbolType.FUNCTION) {
            this.plugin.goTo(symbol);
        }
    }

    private void createActions() {
        CreateLibraryAction createImportAction = new CreateLibraryAction(this.plugin);
        SetExternalProgramAction setExternalProgramAction = new SetExternalProgramAction(this.plugin, this);
        CreateExternalLocationAction createExternalLocationAction = new CreateExternalLocationAction(this.plugin);
        EditExternalLocationAction editExternalLocationAction = new EditExternalLocationAction(this.plugin);
        String createGroup = "0Create";
        int createGroupIndex = 0;
        CreateNamespaceAction createNamespaceAction = new CreateNamespaceAction(this.plugin, createGroup, Integer.toString(createGroupIndex++));
        CreateClassAction createClassAction = new CreateClassAction(this.plugin, createGroup, Integer.toString(createGroupIndex++));
        ConvertToClassAction convertToClassAction = new ConvertToClassAction(this.plugin, createGroup, Integer.toString(createGroupIndex++));
        RenameAction renameAction = new RenameAction(this.plugin);
        CutAction cutAction = new CutAction(this.plugin, this);
        PasteAction pasteAction = new PasteAction(this.plugin, this);
        DeleteAction deleteAction = new DeleteAction(this.plugin);
        deleteAction.setEnabled(false);
        ShowSymbolReferencesAction referencesAction = new ShowSymbolReferencesAction(this.plugin.getTool(), this.plugin.getName());
        SelectionAction selectionAction = new SelectionAction(this.plugin);
        selectionAction.setEnabled(false);
        this.navigateIncomingAction = new NavigateOnIncomingAction(this.plugin);
        this.navigateOutgoingAction = new NavigateOnOutgoingActon(this.plugin);
        GoToExternalLocationAction goToExternalAction = new GoToExternalLocationAction(this.plugin);
        goToExternalAction.setEnabled(false);
        CloneSymbolTreeAction cloneAction = new CloneSymbolTreeAction(this.plugin, this);
        CreateSymbolTableAction tableAction = new CreateSymbolTableAction(this.plugin);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)createImportAction);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)setExternalProgramAction);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)createExternalLocationAction);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)editExternalLocationAction);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)createClassAction);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)createNamespaceAction);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)convertToClassAction);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)renameAction);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)cutAction);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)pasteAction);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)deleteAction);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)referencesAction);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)this.navigateIncomingAction);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)this.navigateOutgoingAction);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)selectionAction);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)goToExternalAction);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)cloneAction);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)tableAction);
    }

    public JComponent getComponent() {
        return this.component;
    }

    public ActionContext getActionContext(MouseEvent event) {
        if (this.program == null) {
            return null;
        }
        return new SymbolTreeActionContext(this, this.program, this.tree, this.tree.getSelectionPaths());
    }

    public void componentShown() {
        this.setProgram(this.program);
    }

    protected int getNodeGroupThreshold() {
        return this.plugin.getNodeGroupThreshold();
    }

    GTree getTree() {
        return this.tree;
    }

    public void cloneWindow() {
        DisconnectedSymbolTreeProvider newProvider = this.plugin.createNewDisconnectedProvider(this.program);
        Swing.runLater(() -> {
            newProvider.setProgram(this.program);
            this.transferSettings(newProvider);
        });
    }

    protected void transferSettings(DisconnectedSymbolTreeProvider newProvider) {
        GTreeState treeState = this.tree.getTreeState();
        newProvider.tree.setFilterRestoreState(treeState);
        GTreeFilterProvider filterProvider = this.tree.getFilterProvider();
        GTreeFilterProvider newFilterProvider = filterProvider.copy((GTree)newProvider.tree);
        newProvider.tree.setFilterProvider(newFilterProvider);
    }

    public Program getProgram() {
        return this.program;
    }

    void setProgram(Program program) {
        this.program = program;
        if (!this.isVisible()) {
            return;
        }
        if (program == null) {
            return;
        }
        program.addListener(this.domainObjectListener);
        this.rebuildTree();
        GTreeState treeState = this.treeStateMap.get(program);
        if (treeState != null) {
            this.tree.restoreTreeState(treeState);
        }
    }

    void programDeactivated(Program deactivatedProgram) {
        this.tree.cancelWork();
        deactivatedProgram.removeListener(this.domainObjectListener);
        GTreeState treeState = this.tree.getTreeState();
        this.treeStateMap.put(this.program, treeState);
        this.rebuildTree();
        this.program = null;
    }

    protected void rebuildTree() {
        this.component.remove((Component)((Object)this.tree));
        this.tree = this.createTree(this.createRootNode());
        this.component.add((Component)((Object)this.tree), "Center");
        this.component.repaint();
    }

    void programClosed(Program closedProgram) {
        this.tree.cancelWork();
        this.treeStateMap.remove(closedProgram);
    }

    public void setClipboardContents(GTreeNodeTransferable symbolTreeNodeTransferable) {
        this.localClipboard.setContents((Transferable)symbolTreeNodeTransferable, this.clipboardOwner);
    }

    public Clipboard getClipboard() {
        return this.localClipboard;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int reparentSymbols(Namespace namespace, List<Symbol> symbolList) {
        int count = 0;
        StringBuffer sb = new StringBuffer();
        int transactionID = this.program.startTransaction("Change Parent Namespaces");
        try {
            for (Symbol symbol : symbolList) {
                if (!this.canReparentSymbol(symbol) || !this.canMoveSymbol(namespace, symbol)) continue;
                try {
                    symbol.setNamespace(namespace);
                    ++count;
                }
                catch (DuplicateNameException e) {
                    sb.append("Parent namespace " + namespace.getName() + " contains namespace named " + symbol.getName() + "\n");
                }
                catch (CircularDependencyException | InvalidInputException e) {
                    sb.append("Could not change parent namespace for " + symbol.getName() + ": " + e.getMessage() + "\n");
                }
            }
        }
        finally {
            this.program.endTransaction(transactionID, true);
        }
        if (sb.length() > 0) {
            Msg.showInfo(((Object)((Object)this)).getClass(), null, (String)"Change Parent Namespace Failed", (Object)sb.toString());
        }
        return count;
    }

    private boolean canMoveSymbol(Namespace destinationNamespace, Symbol symbol) {
        SymbolTable symbolTable = this.program.getSymbolTable();
        if (symbol.isDescendant(destinationNamespace)) {
            return false;
        }
        if (!symbol.isValidParent(destinationNamespace)) {
            return false;
        }
        SymbolType symbolType = symbol.getSymbolType();
        if (symbolType.allowsDuplicates()) {
            return true;
        }
        List symbols = symbolTable.getSymbols(symbol.getName(), destinationNamespace);
        for (Symbol s : symbols) {
            if (s.getSymbolType().allowsDuplicates()) continue;
            return false;
        }
        return true;
    }

    private boolean canReparentSymbol(Symbol symbol) {
        SymbolType symbolType = symbol.getSymbolType();
        return symbolType == SymbolType.LABEL || symbolType == SymbolType.FUNCTION || symbolType == SymbolType.NAMESPACE || symbolType == SymbolType.CLASS;
    }

    private void reloadTree() {
        this.tree.cancelEditing();
        if (this.preRestoreTreeState == null) {
            this.preRestoreTreeState = this.tree.getTreeState();
        }
        this.restoredUpdateManager.updateLater();
        SymbolTreeRootNode node = (SymbolTreeRootNode)this.tree.getModelRoot();
        node.setChildren(null);
    }

    private void symbolChanged(Symbol symbol) {
        this.symbolChanged(symbol, symbol.getName());
    }

    private void symbolChanged(Symbol symbol, String oldName) {
        this.addTask(new SymbolChangedTask(this, this.tree, symbol, oldName));
    }

    private void symbolAdded(Symbol symbol) {
        this.addTask(new SymbolAddedTask(this, this.tree, symbol));
    }

    private void symbolRemoved(Symbol symbol) {
        this.addTask(new SymbolRemovedTask(this, this.tree, symbol));
    }

    private void addTask(AbstractSymbolUpdateTask task) {
        Swing.assertSwingThread((String)"Adding tasks must be done on the Swing thread,since they are put into a list that is processed on the Swing thread. ");
        this.bufferedTasks.add(task);
        this.domainChangeUpdateManager.update();
    }

    public void locationChanged(ProgramLocation loc) {
        if (!this.navigateIncomingAction.isSelected()) {
            return;
        }
        if (this.program != loc.getProgram()) {
            return;
        }
        if (!this.isVisible()) {
            return;
        }
        Symbol symbol = null;
        Address addr = loc.getAddress();
        if (loc instanceof VariableLocation) {
            Variable var = ((VariableLocation)loc).getVariable();
            if (var == null) {
                return;
            }
            symbol = var.getSymbol();
        } else if (loc instanceof FunctionSignatureFieldLocation || loc instanceof FunctionReturnTypeFieldLocation) {
            Function function = this.program.getFunctionManager().getFunctionContaining(addr);
            if (function == null) {
                return;
            }
            symbol = function.getSymbol();
        } else if (loc instanceof OperandFieldLocation) {
            Reference[] refs;
            int opIndex = ((OperandFieldLocation)loc).getOperandIndex();
            CodeUnit cu = this.program.getListing().getCodeUnitContaining(addr);
            for (Reference element : refs = cu.getOperandReferences(opIndex)) {
                symbol = this.program.getSymbolTable().getSymbol(element);
                if (symbol == null) {
                    continue;
                }
                break;
            }
        } else if (loc instanceof LabelFieldLocation) {
            LabelFieldLocation lfLoc = (LabelFieldLocation)loc;
            symbol = lfLoc.getSymbol();
        } else {
            symbol = this.program.getSymbolTable().getPrimarySymbol(loc.getAddress());
        }
        if (symbol == null || symbol.isDynamic()) {
            return;
        }
        this.selectSymbol(symbol);
    }

    public void selectSymbol(Symbol symbol) {
        SymbolTreeRootNode rootNode = (SymbolTreeRootNode)this.tree.getViewRoot();
        this.tree.runTask(new SearchTask(this.tree, rootNode, symbol));
    }

    void readConfigState(SaveState saveState) {
        this.navigateIncomingAction.setSelected(saveState.getBoolean("NAVIGATE_INCOMING", false));
        this.navigateOutgoingAction.setSelected(saveState.getBoolean("NAVIGATE_OUTGOING", true));
    }

    void writeConfigState(SaveState saveState) {
        saveState.putBoolean("NAVIGATE_INCOMING", this.navigateIncomingAction.isSelected());
        saveState.putBoolean("NAVIGATE_OUTGOING", this.navigateOutgoingAction.isSelected());
    }

    void dispose() {
        this.domainChangeUpdateManager.dispose();
        this.bufferedTasks.clear();
        this.tree.dispose();
        this.treeStateMap.clear();
        this.tree = null;
        this.component.removeAll();
        if (this.program != null) {
            this.program.removeListener(this.domainObjectListener);
            this.program = null;
        }
    }

    private DomainObjectListener createDomainObjectListener() {
        return ((DomainObjectListenerBuilder)((DomainObjectListenerBuilder)new DomainObjectListenerBuilder((Object)this).ignoreWhen(this::ignoreEvents)).any(new EventType[]{DomainObjectEvent.RESTORED}).terminate(this::reloadTree)).with(ProgramChangeRecord.class).each(new EventType[]{ProgramEvent.SYMBOL_RENAMED}).call(this::processSymbolRenamed).each(new EventType[]{ProgramEvent.SYMBOL_DATA_CHANGED, ProgramEvent.SYMBOL_SCOPE_CHANGED}).call(this::processSymbolChanged).each(new EventType[]{ProgramEvent.SYMBOL_ADDED}).call(this::processSymbolAdded).each(new EventType[]{ProgramEvent.SYMBOL_REMOVED}).call(this::processSymbolRemoved).each(new EventType[]{ProgramEvent.EXTERNAL_ENTRY_ADDED, ProgramEvent.EXTERNAL_ENTRY_REMOVED}).call(this::processExternalEntryChanged).any(new EventType[]{ProgramEvent.EXTERNAL_PATH_CHANGED, ProgramEvent.EXTERNAL_NAME_ADDED, ProgramEvent.EXTERNAL_NAME_REMOVED, ProgramEvent.EXTERNAL_NAME_CHANGED}).call(this::reloadTree).any(new EventType[]{ProgramEvent.FUNCTION_CHANGED}).call(this::processAllFunction).build();
    }

    private void processSymbolAdded(ProgramChangeRecord pcr) {
        this.symbolAdded((Symbol)pcr.getNewValue());
    }

    private void processSymbolRemoved(ProgramChangeRecord pcr) {
        this.symbolRemoved((Symbol)pcr.getObject());
    }

    private void processAllFunction(DomainObjectChangedEvent e) {
        HashSet<Symbol> symbols = new HashSet<Symbol>();
        int n = e.numRecords();
        for (int i = 0; i < n; ++i) {
            DomainObjectChangeRecord r = e.getChangeRecord(i);
            if (!(r instanceof FunctionChangeRecord)) continue;
            FunctionChangeRecord fcr = (FunctionChangeRecord)r;
            Function f = fcr.getFunction();
            Symbol s = f.getSymbol();
            symbols.add(s);
        }
        for (Symbol s : symbols) {
            this.symbolChanged(s);
        }
    }

    private void processSymbolChanged(ProgramChangeRecord pcr) {
        Symbol symbol = (Symbol)pcr.getObject();
        Object oldValue = pcr.getOldValue();
        if (oldValue instanceof Namespace) {
            Namespace oldNs = (Namespace)oldValue;
            this.addTask(new SymbolScopeChangedTask(this, this.tree, symbol, oldNs));
            return;
        }
        this.symbolChanged(symbol);
    }

    private void processSymbolRenamed(ProgramChangeRecord pcr) {
        Symbol symbol = (Symbol)pcr.getObject();
        String oldName = (String)pcr.getOldValue();
        this.symbolChanged(symbol, oldName);
    }

    private void processExternalEntryChanged(ProgramChangeRecord pcr) {
        Symbol[] symbols;
        Address address = pcr.getStart();
        SymbolTable symbolTable = this.program.getSymbolTable();
        for (Symbol symbol : symbols = symbolTable.getSymbols(address)) {
            this.symbolChanged(symbol, symbol.getName());
        }
    }

    private boolean ignoreEvents() {
        if (!this.isVisible()) {
            return true;
        }
        return this.treeIsCollapsed();
    }

    private boolean treeIsCollapsed() {
        GTreeNode root = this.tree.getViewRoot();
        if (!root.isExpanded()) {
            return true;
        }
        List children = root.getChildren();
        for (GTreeNode node : children) {
            if (!node.isExpanded()) continue;
            return false;
        }
        return true;
    }

    private class SymbolChangedTask
    extends AbstractSymbolUpdateTask {
        private String oldName;

        SymbolChangedTask(SymbolTreeProvider symbolTreeProvider, GTree tree, Symbol symbol, String oldName) {
            super(symbolTreeProvider, tree, symbol);
            this.oldName = oldName;
        }

        @Override
        void doRun(TaskMonitor monitor) throws CancelledException {
            SymbolTreeRootNode root = (SymbolTreeRootNode)this.tree.getModelRoot();
            root.symbolRemoved(this.symbol, this.oldName, monitor);
            if (!this.symbol.isDeleted()) {
                SymbolNode newNode = root.symbolAdded(this.symbol, monitor);
                this.tree.refilterLater((GTreeNode)newNode);
            }
        }
    }

    private abstract class AbstractSymbolUpdateTask
    extends GTreeTask {
        protected final Symbol symbol;

        AbstractSymbolUpdateTask(SymbolTreeProvider symbolTreeProvider, GTree tree, Symbol symbol) {
            super(tree);
            this.symbol = symbol;
        }

        abstract void doRun(TaskMonitor var1) throws CancelledException;

        public void run(TaskMonitor monitor) throws CancelledException {
            this.doRun(monitor);
        }

        public String toString() {
            return ((Object)((Object)this)).getClass().getSimpleName() + " " + String.valueOf(this.symbol);
        }
    }

    private class SymbolAddedTask
    extends AbstractSymbolUpdateTask {
        SymbolAddedTask(SymbolTreeProvider symbolTreeProvider, GTree tree, Symbol symbol) {
            super(symbolTreeProvider, tree, symbol);
        }

        @Override
        void doRun(TaskMonitor monitor) throws CancelledException {
            SymbolTreeRootNode rootNode = (SymbolTreeRootNode)this.tree.getModelRoot();
            if (!this.symbol.isDeleted()) {
                SymbolNode newNode = rootNode.symbolAdded(this.symbol, monitor);
                this.tree.refilterLater((GTreeNode)newNode);
            }
        }
    }

    private class SymbolRemovedTask
    extends AbstractSymbolUpdateTask {
        SymbolRemovedTask(SymbolTreeProvider symbolTreeProvider, GTree tree, Symbol symbol) {
            super(symbolTreeProvider, tree, symbol);
        }

        @Override
        void doRun(TaskMonitor monitor) throws CancelledException {
            SymbolTreeRootNode root = (SymbolTreeRootNode)this.tree.getModelRoot();
            root.symbolRemoved(this.symbol, this.symbol.getName(), monitor);
        }
    }

    private class SearchTask
    extends GTreeTask {
        private SymbolTreeRootNode rootNode;
        private Symbol searchSymbol;

        private SearchTask(GTree tree, SymbolTreeRootNode rootNode, Symbol searchSymbol) {
            super(tree);
            this.rootNode = rootNode;
            this.searchSymbol = searchSymbol;
        }

        public void run(TaskMonitor monitor) throws CancelledException {
            block3: {
                try {
                    monitor.setMessage("Searching for " + this.searchSymbol.getName());
                    SymbolNode key = SymbolNode.createNode(this.searchSymbol, SymbolTreeProvider.this.program);
                    GTreeNode node = this.rootNode.findSymbolTreeNode(key, true, monitor);
                    if (node != null) {
                        this.tree.setSelectedNode(node);
                    }
                }
                catch (DomainObjectException doe) {
                    Throwable cause = doe.getCause();
                    if (cause instanceof ClosedException) break block3;
                    throw doe;
                }
            }
        }
    }

    private class SymbolScopeChangedTask
    extends AbstractSymbolUpdateTask {
        private Namespace oldNamespace;

        SymbolScopeChangedTask(SymbolTreeProvider symbolTreeProvider, GTree tree, Symbol symbol, Namespace oldNamespace) {
            super(symbolTreeProvider, tree, symbol);
            this.oldNamespace = oldNamespace;
        }

        @Override
        void doRun(TaskMonitor monitor) throws CancelledException {
            SymbolTreeRootNode root = (SymbolTreeRootNode)this.tree.getModelRoot();
            root.symbolRemoved(this.symbol, this.oldNamespace, monitor);
            if (!this.symbol.isDeleted()) {
                SymbolNode newNode = root.symbolAdded(this.symbol, monitor);
                this.tree.refilterLater((GTreeNode)newNode);
            }
        }
    }

    private class BulkWorkTask
    extends GTreeBulkTask {
        private static final int MAX_TASK_COUNT = 1000;
        private List<AbstractSymbolUpdateTask> tasks;

        BulkWorkTask(GTree gTree, List<AbstractSymbolUpdateTask> tasks) {
            super(gTree);
            this.tasks = tasks;
        }

        public void runBulk(TaskMonitor monitor) throws CancelledException {
            if (this.tasks.size() > 1000) {
                Swing.runLater(() -> SymbolTreeProvider.this.reloadTree());
                return;
            }
            GTreeState state = this.tree.getTreeState();
            for (AbstractSymbolUpdateTask task : this.tasks) {
                monitor.checkCancelled();
                task.run(monitor);
            }
            GTreeRestoreTreeStateTask task = new GTreeRestoreTreeStateTask(this.tree, state);
            task.run(monitor);
        }
    }
}

