/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.terminal;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DialogComponentProvider;
import docking.DockingUtils;
import docking.DockingWindowManager;
import docking.WindowPosition;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.builder.ActionBuilder;
import docking.widgets.EventTrigger;
import docking.widgets.OkDialog;
import docking.widgets.fieldpanel.support.FieldLocation;
import docking.widgets.fieldpanel.support.FieldRange;
import docking.widgets.fieldpanel.support.FieldSelection;
import generic.theme.GColor;
import generic.theme.GIcon;
import ghidra.app.plugin.core.terminal.TerminalLayout;
import ghidra.app.plugin.core.terminal.TerminalListener;
import ghidra.app.plugin.core.terminal.TerminalPanel;
import ghidra.app.plugin.core.terminal.TerminalPlugin;
import ghidra.app.plugin.core.terminal.vt.VtOutput;
import ghidra.app.services.ClipboardService;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.Plugin;
import ghidra.util.HelpLocation;
import ghidra.util.Swing;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.collections4.IteratorUtils;

public class TerminalProvider
extends ComponentProviderAdapter {
    private static final Color COLOR_TERMINATED = new GColor("color.border.provider.disconnected");
    protected final TerminalPlugin plugin;
    protected final Plugin helpPlugin;
    protected final TerminalPanel panel;
    protected final FindDialog findDialog = new FindDialog();
    protected DockingAction actionFind;
    protected DockingAction actionFindNext;
    protected DockingAction actionFindPrevious;
    protected DockingAction actionSelectAll;
    protected DockingAction actionTerminate;
    protected DockingAction actionIncreaseSize;
    protected DockingAction actionDecreaseSize;
    protected DockingAction actionResetSize;
    private boolean terminated = false;

    public TerminalProvider(TerminalPlugin plugin, Charset charset, Plugin helpPlugin) {
        super(plugin.getTool(), "Terminal", plugin.getName());
        this.plugin = plugin;
        this.helpPlugin = helpPlugin;
        this.panel = new TerminalPanel(charset, this);
        this.panel.addTerminalListener(new TerminalListener(){

            @Override
            public void retitled(String title) {
                TerminalProvider.this.setSubTitle(title);
            }
        });
        this.createActions();
        this.setWindowMenuGroup("Terminals");
        this.setDefaultWindowPosition(WindowPosition.BOTTOM);
        this.setHelpLocation(new HelpLocation(helpPlugin.getName(), "plugin"));
        this.panel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
    }

    public JComponent getComponent() {
        return this.panel;
    }

    public void processInput(ByteBuffer buffer) {
        this.panel.processInput(buffer);
    }

    public TerminalPanel getTerminalPanel() {
        return this.panel;
    }

    public void removeFromTool() {
        this.panel.dispose();
        this.plugin.providers.remove((Object)this);
        super.removeFromTool();
    }

    public void setOutputCallback(VtOutput outputCb) {
        this.panel.setOutputCallback(outputCb);
    }

    public void addTerminalListener(TerminalListener listener) {
        this.panel.addTerminalListener(listener);
    }

    public void removeTerminalListener(TerminalListener listener) {
        this.panel.removeTerminalListener(listener);
    }

    public void setClipboardService(ClipboardService clipboardService) {
        this.panel.setClipboardService(clipboardService);
    }

    protected void createActions() {
        this.actionFind = (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Find", this.plugin.getName()).menuIcon((Icon)new GIcon("icon.search"))).menuPath(new String[]{"Find"})).menuGroup("Find")).keyBinding(KeyStroke.getKeyStroke(70, DockingUtils.CONTROL_KEY_MODIFIER_MASK | 0x40))).helpLocation(new HelpLocation(this.helpPlugin.getName(), "find"))).onAction(this::activatedFind)).buildAndInstallLocal((ComponentProvider)this);
        this.actionFindNext = (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Find Next", this.plugin.getName()).menuPath(new String[]{"Find Next"})).menuGroup("Find")).keyBinding(KeyStroke.getKeyStroke(72, DockingUtils.CONTROL_KEY_MODIFIER_MASK | 0x40))).helpLocation(new HelpLocation(this.helpPlugin.getName(), "find_next"))).enabledWhen(this::isEnabledFindStep)).onAction(this::activatedFindNext)).buildAndInstallLocal((ComponentProvider)this);
        this.actionFindPrevious = (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Find Previous", this.plugin.getName()).menuPath(new String[]{"Find Previous"})).menuGroup("Find")).keyBinding(KeyStroke.getKeyStroke(71, DockingUtils.CONTROL_KEY_MODIFIER_MASK | 0x40))).helpLocation(new HelpLocation(this.helpPlugin.getName(), "find_previous"))).enabledWhen(this::isEnabledFindStep)).onAction(this::activatedFindPrevious)).buildAndInstallLocal((ComponentProvider)this);
        this.actionSelectAll = (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Select All", this.plugin.getName()).menuPath(new String[]{"Select All"})).menuGroup("Select")).keyBinding(KeyStroke.getKeyStroke(65, DockingUtils.CONTROL_KEY_MODIFIER_MASK | 0x40))).helpLocation(new HelpLocation(this.helpPlugin.getName(), "select_all"))).onAction(this::activatedSelectAll)).buildAndInstallLocal((ComponentProvider)this);
        this.actionIncreaseSize = (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Increase Font Size", this.plugin.getName()).menuPath(new String[]{"Increase Font Size"})).menuGroup("View")).keyBinding(KeyStroke.getKeyStroke(61, DockingUtils.CONTROL_KEY_MODIFIER_MASK | 0x40))).helpLocation(new HelpLocation(this.helpPlugin.getName(), "increase_font_size"))).onAction(this::activatedIncreaseFontSize)).buildAndInstallLocal((ComponentProvider)this);
        this.actionDecreaseSize = (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Decrease Font Size", this.plugin.getName()).menuPath(new String[]{"Decrease Font Size"})).menuGroup("View")).keyBinding(KeyStroke.getKeyStroke(45, DockingUtils.CONTROL_KEY_MODIFIER_MASK))).helpLocation(new HelpLocation(this.helpPlugin.getName(), "decrease_font_size"))).onAction(this::activatedDecreaseFontSize)).buildAndInstallLocal((ComponentProvider)this);
        this.actionResetSize = (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Reset Font Size", this.plugin.getName()).menuPath(new String[]{"Reset Font Size"})).menuGroup("View")).keyBinding(KeyStroke.getKeyStroke(48, DockingUtils.CONTROL_KEY_MODIFIER_MASK))).helpLocation(new HelpLocation(this.helpPlugin.getName(), "decrease_font_size"))).onAction(this::activatedResetFontSize)).buildAndInstallLocal((ComponentProvider)this);
    }

    protected void activatedFind(ActionContext ctx) {
        this.tool.showDialog((DialogComponentProvider)this.findDialog);
    }

    protected void doFind(boolean forward) {
        FieldLocation start;
        FieldSelection sel = this.panel.getFieldPanel().getSelection();
        if (sel == null || sel.getNumRanges() == 0) {
            start = null;
        } else {
            FieldLocation s = sel.getFieldRange(0).getStart();
            start = forward ? new FieldLocation(s.getIndex(), 0, 0, s.getCol() + 1) : new FieldLocation(s.getIndex(), 0, 0, s.getCol() - 1);
        }
        FieldRange found = this.panel.find(this.findDialog.txtFind.getText(), this.findDialog.getOptions(), start, forward);
        if (found == null) {
            OkDialog.showInfo((String)"Find", (String)"String not found");
            return;
        }
        FieldSelection newSel = new FieldSelection();
        newSel.addRange(found);
        this.panel.fieldPanel.setSelection(newSel);
        this.panel.fieldPanel.scrollTo(found.getStart());
    }

    protected boolean isEnabledFindStep(ActionContext ctx) {
        return !this.findDialog.txtFind.getText().isEmpty();
    }

    protected void activatedFindNext(ActionContext ctx) {
        this.doFind(true);
    }

    protected void activatedFindPrevious(ActionContext ctx) {
        this.doFind(false);
    }

    protected void activatedSelectAll(ActionContext ctx) {
        FieldSelection sel = new FieldSelection();
        BigInteger numIndexes = this.panel.model.getNumIndexes();
        if (numIndexes.equals(BigInteger.ZERO)) {
            return;
        }
        BigInteger lastIndex = numIndexes.subtract(BigInteger.ONE);
        TerminalLayout layout = this.panel.model.getLayout(lastIndex);
        int lastCol = layout.line.length();
        sel.addRange(new FieldLocation(BigInteger.ZERO, 0, 0, 0), new FieldLocation(lastIndex, 0, 0, lastCol));
        if (this.panel.getFieldPanel().getSelection().equals((Object)sel)) {
            sel.clear();
        }
        this.panel.getFieldPanel().setSelection(sel, EventTrigger.GUI_ACTION);
    }

    protected void activatedIncreaseFontSize(ActionContext ctx) {
        this.panel.increaseFontSize();
    }

    protected void activatedDecreaseFontSize(ActionContext ctx) {
        this.panel.decreaseFontSize();
    }

    protected void activatedResetFontSize(ActionContext ctx) {
        this.panel.resetFontSize();
    }

    protected boolean isLocalActionKeyBinding(KeyEvent e) {
        KeyStroke stroke = KeyStroke.getKeyStrokeForEvent(e);
        DockingWindowManager wm = DockingWindowManager.getActiveInstance();
        for (DockingActionIf action : IteratorUtils.asIterable((Iterator)wm.getComponentActions((ComponentProvider)this))) {
            if (!Objects.equals(stroke, action.getKeyBinding())) continue;
            return true;
        }
        return false;
    }

    public void setFixedSize(short cols, short rows) {
        this.panel.setFixedTerminalSize(cols, rows);
    }

    public void setDyanmicSize() {
        this.panel.setDynamicTerminalSize();
    }

    public int getColumns() {
        return this.panel.getColumns();
    }

    public int getRows() {
        return this.panel.getRows();
    }

    public void setMaxScrollBackRows(int rows) {
        this.panel.model.setMaxScrollBackSize(rows);
    }

    public int getScrollBackRows() {
        return this.panel.model.getScrollBackSize();
    }

    public String getRangeText(int startCol, int startLine, int endCol, int endLine) {
        int scrollBack = this.getScrollBackRows();
        return this.panel.getSelectedText(new FieldRange(new FieldLocation(startLine + scrollBack, 0, 0, startCol), new FieldLocation(endLine + scrollBack, 0, 0, endCol)));
    }

    public int getCursorColumn() {
        return this.panel.getCursorColumn();
    }

    public int getCursorRow() {
        return this.panel.getCursorRow();
    }

    public void terminated(int exitcode) {
        Swing.runIfSwingOrRunLater(() -> {
            this.terminated = true;
            ((TerminalListener)this.panel.terminalListeners.invoke()).terminated(exitcode);
            this.removeLocalAction(this.actionTerminate);
            this.panel.terminalListeners.clear();
            this.panel.setOutputCallback(buf -> {});
            this.panel.getFieldPanel().setCursorOn(false);
            this.setTitle("[Terminal]");
            this.setSubTitle("Terminated");
            if (!this.isVisible()) {
                this.removeFromTool();
            } else {
                this.panel.setBorder(BorderFactory.createLineBorder(COLOR_TERMINATED, 2));
            }
        });
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public void setTerminateAction(Runnable action) {
        if (this.actionTerminate != null) {
            this.removeLocalAction(this.actionTerminate);
        }
        if (action != null) {
            this.actionTerminate = (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Terminate", this.plugin.getName()).menuIcon((Icon)new GIcon("icon.plugin.terminal.terminate"))).menuPath(new String[]{"Terminate"})).menuGroup("Terminate")).helpLocation(new HelpLocation(this.helpPlugin.getName(), "terminate"))).enabledWhen(ctx -> true)).onAction(ctx -> action.run())).buildAndInstallLocal((ComponentProvider)this);
        }
    }

    public void closeComponent() {
        super.closeComponent();
        if (this.terminated) {
            this.removeFromTool();
        }
    }

    protected class FindDialog
    extends DialogComponentProvider {
        protected final JTextField txtFind;
        protected final JCheckBox cbCaseSensitive;
        protected final JCheckBox cbWrapSearch;
        protected final JCheckBox cbWholeWord;
        protected final JCheckBox cbRegex;
        protected final JButton btnFindNext;
        protected final JButton btnFindPrevious;

        protected FindDialog() {
            super("Find", false, false, true, false);
            this.txtFind = new JTextField(20);
            this.cbCaseSensitive = new JCheckBox("Case sensitive");
            this.cbWrapSearch = new JCheckBox("Wrap search");
            this.cbWholeWord = new JCheckBox("Whole word");
            this.cbRegex = new JCheckBox("Regular expression");
            this.btnFindNext = new JButton("Next");
            this.btnFindPrevious = new JButton("Previous");
            this.populateComponents();
        }

        protected GridBagConstraints cell(int row, int col, int width, boolean hFill) {
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.gridx = col;
            constraints.gridy = row;
            constraints.gridwidth = width;
            constraints.fill = 2;
            constraints.insets = new Insets(row == 0 ? 0 : 5, col == 0 ? 0 : 3, 0, 0);
            constraints.weightx = hFill ? 1.0 : 0.0;
            return constraints;
        }

        protected JLabel label(String text) {
            JLabel label = new JLabel(text);
            label.setHorizontalAlignment(4);
            return label;
        }

        protected void populateComponents() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            panel.add((Component)this.label("Find"), this.cell(0, 0, 1, false));
            panel.add((Component)this.txtFind, this.cell(0, 1, 1, true));
            panel.add((Component)this.cbCaseSensitive, this.cell(2, 0, 2, true));
            panel.add((Component)this.cbWrapSearch, this.cell(3, 0, 2, true));
            panel.add((Component)this.cbWholeWord, this.cell(4, 0, 2, true));
            panel.add((Component)this.cbRegex, this.cell(5, 0, 2, true));
            this.addWorkPanel(panel);
            this.addButton(this.btnFindNext);
            this.addButton(this.btnFindPrevious);
            this.addDismissButton();
            this.setDefaultButton(this.btnFindNext);
            this.txtFind.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    TerminalProvider.this.contextChanged();
                    FindDialog.this.btnFindNext.setEnabled(TerminalProvider.this.isEnabledFindStep(null));
                    FindDialog.this.btnFindPrevious.setEnabled(TerminalProvider.this.isEnabledFindStep(null));
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    TerminalProvider.this.contextChanged();
                    FindDialog.this.btnFindNext.setEnabled(TerminalProvider.this.isEnabledFindStep(null));
                    FindDialog.this.btnFindPrevious.setEnabled(TerminalProvider.this.isEnabledFindStep(null));
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    TerminalProvider.this.contextChanged();
                    FindDialog.this.btnFindNext.setEnabled(TerminalProvider.this.isEnabledFindStep(null));
                    FindDialog.this.btnFindPrevious.setEnabled(TerminalProvider.this.isEnabledFindStep(null));
                }
            });
            this.btnFindNext.addActionListener(evt -> TerminalProvider.this.activatedFindNext(null));
            this.btnFindPrevious.addActionListener(evt -> TerminalProvider.this.activatedFindPrevious(null));
        }

        public Set<TerminalPanel.FindOptions> getOptions() {
            EnumSet<TerminalPanel.FindOptions> opts = EnumSet.noneOf(TerminalPanel.FindOptions.class);
            if (this.cbCaseSensitive.isSelected()) {
                opts.add(TerminalPanel.FindOptions.CASE_SENSITIVE);
            }
            if (this.cbWrapSearch.isSelected()) {
                opts.add(TerminalPanel.FindOptions.WRAP);
            }
            if (this.cbWholeWord.isSelected()) {
                opts.add(TerminalPanel.FindOptions.WHOLE_WORD);
            }
            if (this.cbRegex.isSelected()) {
                opts.add(TerminalPanel.FindOptions.REGEX);
            }
            return opts;
        }
    }
}

