/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.totd;

import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.ReusableDialogComponentProvider;
import docking.widgets.checkbox.GCheckBox;
import docking.widgets.label.GLabel;
import generic.theme.GIcon;
import generic.theme.GThemeDefaults;
import generic.theme.Gui;
import ghidra.app.plugin.core.totd.TipOfTheDayPlugin;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.CompoundBorder;

class TipOfTheDayDialog
extends ReusableDialogComponentProvider {
    private static final String FONT_ID = "font.plugin.tips";
    private static final String FONT_LABEL_ID = "font.plugin.tips.label";
    private static final int _24_HOURS = 86400000;
    private TipOfTheDayPlugin plugin;
    private JCheckBox showTipsCheckbox;
    private JButton nextTipButton;
    private JButton closeButton;
    private JTextArea tipArea;
    private int tipIndex = 0;
    private List<String> tips;
    private static long lastTipTime = 0L;

    TipOfTheDayDialog(TipOfTheDayPlugin plugin, List<String> tips) {
        super("\u6bcf\u65e5\u63d0\u793a", false, false, true, false);
        this.plugin = plugin;
        this.tips = tips;
        if (tips.isEmpty()) {
            tips.add("\u672a\u627e\u5230\u63d0\u793a\uff01");
        }
        GIcon tipIcon = new GIcon("icon.plugin.totd.provider");
        this.tipArea = new JTextArea(4, 30);
        this.tipArea.setFont(Gui.getFont((String)FONT_ID));
        this.tipArea.setWrapStyleWord(true);
        this.tipArea.setLineWrap(true);
        this.tipArea.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.tipArea.setBackground((Color)GThemeDefaults.Colors.BACKGROUND);
        JScrollPane tipScroll = new JScrollPane(this.tipArea);
        tipScroll.setHorizontalScrollBarPolicy(31);
        tipScroll.setVerticalScrollBarPolicy(20);
        tipScroll.setBorder(BorderFactory.createEmptyBorder());
        tipScroll.setPreferredSize(this.tipArea.getPreferredSize());
        this.showTipsCheckbox = new GCheckBox("\u542f\u52a8\u65f6\u663e\u793a");
        this.showTipsCheckbox.setSelected(true);
        this.showTipsCheckbox.addItemListener(e -> this.showTipsChanged());
        this.nextTipButton = new JButton("\u4e0b\u4e00\u6761");
        this.nextTipButton.addActionListener(e -> {
            this.incrementTipIndex();
            this.loadNextTip();
        });
        this.addButton(this.nextTipButton);
        this.closeButton = new JButton("\u5173\u95ed");
        this.closeButton.addActionListener(e -> this.close());
        this.addButton(this.closeButton);
        JPanel panel = new JPanel(new BorderLayout());
        CompoundBorder panelBorder = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10), BorderFactory.createLineBorder((Color)GThemeDefaults.Colors.BORDER));
        panel.setBorder(panelBorder);
        GLabel label = new GLabel("\u60a8\u77e5\u9053\u5417...", (Icon)tipIcon, 2);
        label.setBackground((Color)GThemeDefaults.Colors.BACKGROUND);
        label.setOpaque(true);
        Gui.registerFont((Component)label, (String)FONT_LABEL_ID);
        panel.add((Component)label, "North");
        panel.add((Component)tipScroll, "Center");
        JPanel panel2 = new JPanel(new BorderLayout(5, 5));
        panel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel2.add((Component)panel, "Center");
        panel2.add((Component)this.showTipsCheckbox, "South");
        this.addWorkPanel(panel2);
    }

    private void showTipsChanged() {
        this.plugin.writePreferences();
    }

    void show(Component parent) {
        long now = System.currentTimeMillis();
        if (now - lastTipTime > 86400000L) {
            this.doShow(parent);
        }
        lastTipTime = now;
    }

    void doShow(Component parent) {
        this.loadNextTip();
        DockingWindowManager.showDialog((Component)parent, (DialogComponentProvider)this);
    }

    private void incrementTipIndex() {
        ++this.tipIndex;
        this.tipIndex %= this.tips.size();
        this.plugin.writePreferences();
    }

    private void loadNextTip() {
        if (this.tips.isEmpty()) {
            return;
        }
        if (this.tipIndex < 0 || this.tipIndex > this.tips.size() - 1) {
            return;
        }
        String tip = this.tips.get(this.tipIndex);
        this.tipArea.setText(tip);
        this.tipArea.getAccessibleContext().setAccessibleName("Ghidra Tip of The Day");
        this.tipArea.getAccessibleContext().setAccessibleDescription(tip);
    }

    int getTipIndex() {
        return this.tipIndex;
    }

    int getNumberOfTips() {
        return this.tips.size();
    }

    boolean showTips() {
        return this.showTipsCheckbox.isSelected();
    }

    void setTipIndex(int tipIndex) {
        this.tipIndex = tipIndex;
        this.loadNextTip();
    }

    void setShowTips(boolean showTips) {
        this.showTipsCheckbox.setSelected(showTips);
    }
}

