/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.totd;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import ghidra.app.plugin.core.totd.TipOfTheDayDialog;
import ghidra.framework.main.ApplicationLevelOnlyPlugin;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.framework.preferences.Preferences;
import ghidra.util.HelpLocation;
import ghidra.util.SystemUtilities;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import utilities.util.FileUtilities;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Common", shortDescription="\u6bcf\u65e5\u63d0\u793a", description="\u663e\u793a\u4e00\u4e2a\u5305\u542b\u201c\u6bcf\u65e5\u63d0\u793a\u201d\u7684\u5bf9\u8bdd\u6846\u3002")
public class TipOfTheDayPlugin
extends Plugin
implements ApplicationLevelOnlyPlugin {
    private static final String TIP_INDEX = "TIP_INDEX";
    private static final String SHOW_TIPS = "SHOW_TIPS";
    private TipOfTheDayDialog dialog;
    private DockingAction action;

    public TipOfTheDayPlugin(PluginTool tool) {
        super(tool);
    }

    protected void init() {
        this.action = new DockingAction("\u6bcf\u65e5\u63d0\u793a", this.getName()){

            public void actionPerformed(ActionContext context) {
                TipOfTheDayPlugin.this.dialog.doShow(TipOfTheDayPlugin.this.tool.getToolFrame());
            }
        };
        this.action.setMenuBarData(new MenuData(new String[]{"\u5e2e\u52a9", "\u6bcf\u65e5\u63d0\u793a"}, "AAAHelpContents"));
        this.action.setEnabled(true);
        this.action.setHelpLocation(new HelpLocation("Tool", "Tip_of_the_day"));
        this.tool.addAction((DockingActionIf)this.action);
        List<String> tips = null;
        try {
            tips = this.loadTips();
        }
        catch (IOException e) {
            tips = new ArrayList<String>();
        }
        this.dialog = new TipOfTheDayDialog(this, tips);
        this.readPreferences();
    }

    private List<String> loadTips() throws IOException {
        try (InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("tips.txt");){
            List tips = in == null ? Collections.emptyList() : FileUtilities.getLines((InputStream)in);
            List<String> list = tips.stream().filter(s -> s.length() > 0).collect(Collectors.toList());
            return list;
        }
    }

    protected void dispose() {
        this.writePreferences();
        this.action.dispose();
        this.dialog.close();
    }

    private void readPreferences() {
        String tipIndexStr = Preferences.getProperty((String)TIP_INDEX, (String)"0", (boolean)true);
        String showTipsStr = Preferences.getProperty((String)SHOW_TIPS, (String)"true", (boolean)true);
        int tipIndex = Integer.parseInt(tipIndexStr);
        boolean showTips = Boolean.parseBoolean(showTipsStr);
        if (showTips) {
            ++tipIndex;
            this.writePreferences(tipIndex %= this.dialog.getNumberOfTips(), showTips);
        }
        this.dialog.setTipIndex(tipIndex);
        this.dialog.setShowTips(showTips);
        SystemUtilities.runSwingLater(() -> {
            if (showTips && !SystemUtilities.isInTestingMode()) {
                this.dialog.show(this.tool.getToolFrame());
            } else {
                this.dialog.close();
            }
        });
    }

    void writePreferences() {
        if (this.dialog != null) {
            this.writePreferences(this.dialog.getTipIndex(), this.dialog.showTips());
        }
    }

    private void writePreferences(int tipIndex, boolean showTips) {
        Preferences.setProperty((String)TIP_INDEX, (String)("" + tipIndex));
        Preferences.setProperty((String)SHOW_TIPS, (String)("" + showTips));
        Preferences.store();
    }
}

