/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.prototype.debug;

import docking.ActionContext;
import docking.DockableComponent;
import docking.DockingWindowManager;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.filechooser.FileNameExtensionFilter;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Developer", category="Diagnostic", shortDescription="Capture Screenshots", description="Capture screen images and export to Portable Network Graphic (.PNG) format.")
public class ScreenshotPlugin
extends ProgramPlugin {
    public static final String NAME = "ScreenshotPlugin";
    private PluginTool tool;
    private DockingAction captureActiveWindowAction;
    private DockingAction captureToolFrameAction;
    private JFileChooser fileChooser;

    public ScreenshotPlugin(PluginTool tool) {
        super(tool);
        this.tool = tool;
        this.setupActions();
    }

    public void init() {
        super.init();
    }

    public void dispose() {
        super.dispose();
    }

    private void setupActions() {
        this.captureActiveWindowAction = new DockingAction("Capture Active Component", this.getName()){

            public void actionPerformed(ActionContext context) {
                JFrame frame = ScreenshotPlugin.this.tool.getToolFrame();
                DockingWindowManager winMgr = DockingWindowManager.getInstance((Component)frame);
                Component activeComponent = winMgr.getActiveComponent();
                if (activeComponent == null) {
                    ScreenshotPlugin.this.tool.setStatusInfo("Error: No active window");
                    return;
                }
                RenderedImage image = ScreenshotPlugin.this.generateImage(activeComponent);
                String componentName = ((DockableComponent)activeComponent).getComponentWindowingPlaceholder().getName();
                File file = ScreenshotPlugin.this.getFile(componentName + ".png");
                if (file != null) {
                    ScreenshotPlugin.this.writeFile(image, file);
                }
            }
        };
        this.captureActiveWindowAction.setAddToAllWindows(true);
        this.captureActiveWindowAction.setDescription("Takes a screenshot of the active component provider and exports it to PNG format.");
        this.captureActiveWindowAction.setKeyBindingData(new KeyBindingData(122, 512));
        String group = "ScreenCapture";
        this.captureActiveWindowAction.setMenuBarData(new MenuData(new String[]{"&\u5de5\u5177", this.captureActiveWindowAction.getName()}, group));
        this.tool.addAction((DockingActionIf)this.captureActiveWindowAction);
        this.captureToolFrameAction = new DockingAction("Capture Current Tool Frame", this.getName()){

            public void actionPerformed(ActionContext context) {
                DockingWindowManager manager = DockingWindowManager.getActiveInstance();
                Window window = manager.getActiveWindow();
                RenderedImage image = ScreenshotPlugin.this.generateImage(window);
                String title = ScreenshotPlugin.this.getTitleForWindow(window);
                File file = ScreenshotPlugin.this.getFile(title + ".png");
                if (file != null) {
                    ScreenshotPlugin.this.writeFile(image, file);
                }
            }
        };
        this.captureToolFrameAction.setAddToAllWindows(true);
        this.captureToolFrameAction.setDescription("Takes a screenshot of the active tool and exports it to PNG format.");
        this.captureToolFrameAction.setKeyBindingData(new KeyBindingData(123, 512));
        this.captureToolFrameAction.setMenuBarData(new MenuData(new String[]{"&\u5de5\u5177", this.captureToolFrameAction.getName()}, group));
        this.tool.addAction((DockingActionIf)this.captureToolFrameAction);
    }

    private String getTitleForWindow(Window window) {
        if (window instanceof JFrame) {
            return ((JFrame)window).getTitle();
        }
        if (window instanceof JDialog) {
            return ((JDialog)window).getTitle();
        }
        return "Ghidra Window";
    }

    private File getFile(String fileName) {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            this.fileChooser.setDialogType(1);
            this.fileChooser.setDialogTitle("Save Image");
            this.fileChooser.setFileFilter(new FileNameExtensionFilter("Portable Network Graphics", "png"));
        }
        File selectedFile = new File(fileName);
        this.fileChooser.setSelectedFile(selectedFile);
        if (this.fileChooser.showSaveDialog(this.tool.getToolFrame()) == 0) {
            File file = this.fileChooser.getSelectedFile();
            if (file != null && !file.getName().endsWith(".png")) {
                return new File(file.getParentFile(), file.getName() + ".png");
            }
            return file;
        }
        return null;
    }

    private RenderedImage generateImage(Component component) {
        Rectangle r = component.getBounds();
        Image image = component.createImage(r.width, r.height);
        Graphics g = image.getGraphics();
        component.paint(g);
        return (RenderedImage)((Object)image);
    }

    private void writeFile(RenderedImage image, File selectedFile) {
        try {
            ImageIO.write(image, "png", selectedFile);
            this.tool.setStatusInfo("Captured tool to " + selectedFile.getCanonicalPath());
        }
        catch (Exception e) {
            this.tool.setStatusInfo("Error saving image: " + String.valueOf(e));
        }
    }
}

