/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.runtimeinfo;

import docking.widgets.label.GDLabel;
import docking.widgets.label.GLabel;
import ghidra.util.Disposable;
import ghidra.util.layout.PairLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;

class MemoryUsagePanel
extends JPanel
implements Disposable {
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat();
    private Timer timer;

    MemoryUsagePanel() {
        this.setLayout(new BorderLayout());
        JPanel centerPanel = new JPanel((LayoutManager)new PairLayout());
        centerPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GDLabel maxMem = new GDLabel("00000000000", 4);
        GDLabel totalMem = new GDLabel("00000000000", 4);
        GDLabel freeMem = new GDLabel("00000000000", 4);
        GDLabel usedMem = new GDLabel("00000000000", 4);
        centerPanel.add((Component)new GLabel("\u6700\u5927\uff1a"));
        centerPanel.add((Component)maxMem);
        centerPanel.add((Component)new GLabel("\u603b\u8ba1\uff1a"));
        centerPanel.add((Component)totalMem);
        centerPanel.add((Component)new GLabel("\u7a7a\u95f2\uff1a"));
        centerPanel.add((Component)freeMem);
        centerPanel.add((Component)new GLabel("\u5df2\u4f7f\u7528\uff1a"));
        centerPanel.add((Component)usedMem);
        this.add((Component)centerPanel, "Center");
        JPanel bottomPanel = new JPanel();
        JButton gcButton = new JButton("\u6536\u96c6\u5783\u573e");
        gcButton.addActionListener(e -> Runtime.getRuntime().gc());
        bottomPanel.add(gcButton);
        this.add((Component)bottomPanel, "South");
        this.timer = new Timer(2000, arg_0 -> this.lambda$new$1((JLabel)maxMem, (JLabel)totalMem, (JLabel)freeMem, (JLabel)usedMem, arg_0));
    }

    public void dispose() {
        this.timer.stop();
    }

    void shown() {
        this.timer.start();
    }

    void hidden() {
        this.timer.stop();
    }

    private String formatMemoryValue(long value) {
        return DECIMAL_FORMAT.format(value >>> 20) + "MB";
    }

    private /* synthetic */ void lambda$new$1(JLabel maxMem, JLabel totalMem, JLabel freeMem, JLabel usedMem, ActionEvent e) {
        Runtime runtime = Runtime.getRuntime();
        maxMem.setText(this.formatMemoryValue(runtime.maxMemory()));
        totalMem.setText(this.formatMemoryValue(runtime.totalMemory()));
        freeMem.setText(this.formatMemoryValue(runtime.freeMemory()));
        usedMem.setText(this.formatMemoryValue(runtime.totalMemory() - runtime.freeMemory()));
    }
}

