/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.runtimeinfo;

import docking.DialogComponentProvider;
import docking.Tool;
import docking.action.builder.ActionBuilder;
import ghidra.app.plugin.runtimeinfo.InstalledProcessorsProvider;
import ghidra.app.plugin.runtimeinfo.RuntimeInfoProvider;
import ghidra.framework.main.ApplicationLevelOnlyPlugin;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.util.HelpLocation;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Utility", category="Diagnostic", shortDescription="\u8fd0\u884c\u4fe1\u606f", description="\u8fd0\u884c\u4fe1\u606f\u663e\u793a\u63d2\u4ef6")
public class RuntimeInfoPlugin
extends Plugin
implements ApplicationLevelOnlyPlugin {
    private InstalledProcessorsProvider installedProcessorsProvider;
    private RuntimeInfoProvider runtimeInfoProvider;

    public RuntimeInfoPlugin(PluginTool tool) {
        super(tool);
        String supportedActionName = "\u5b89\u88c5\u5904\u7406\u5668";
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(supportedActionName, this.getName()).onAction(context -> this.showInstalledProcessors())).enabled(true)).menuPath(new String[]{"\u5e2e\u52a9", supportedActionName})).menuGroup("YYY")).helpLocation(this.getInstalledProcessorsHelpLocation())).buildAndInstall((Tool)tool);
        String runtimeInfoActionName = "\u8fd0\u884c\u4fe1\u606f";
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(runtimeInfoActionName, this.getName()).onAction(context -> this.showRuntimeInfo())).enabled(true)).menuPath(new String[]{"\u5e2e\u52a9", runtimeInfoActionName})).menuGroup("YYY")).helpLocation(this.getRuntimeInfoHelpLocation())).buildAndInstall((Tool)tool);
    }

    protected void dispose() {
        super.dispose();
        if (this.installedProcessorsProvider != null) {
            this.installedProcessorsProvider.dispose();
            this.installedProcessorsProvider = null;
        }
        if (this.runtimeInfoProvider != null) {
            this.runtimeInfoProvider.dispose();
            this.runtimeInfoProvider = null;
        }
    }

    protected HelpLocation getInstalledProcessorsHelpLocation() {
        return new HelpLocation("RuntimeInfoPlugin", "InstalledProcessors");
    }

    protected HelpLocation getRuntimeInfoHelpLocation() {
        return new HelpLocation("RuntimeInfoPlugin", "RuntimeInfo");
    }

    private void showInstalledProcessors() {
        if (this.installedProcessorsProvider == null) {
            this.installedProcessorsProvider = new InstalledProcessorsProvider(this);
        }
        this.tool.showDialog((DialogComponentProvider)this.installedProcessorsProvider);
    }

    private void showRuntimeInfo() {
        if (this.runtimeInfoProvider == null) {
            this.runtimeInfoProvider = new RuntimeInfoProvider(this);
        }
        this.tool.showDialog((DialogComponentProvider)this.runtimeInfoProvider);
    }
}

