/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.runtimeinfo;

import docking.ReusableDialogComponentProvider;
import generic.jar.ResourceFile;
import ghidra.GhidraClassLoader;
import ghidra.app.plugin.runtimeinfo.MapTablePanel;
import ghidra.app.plugin.runtimeinfo.MemoryUsagePanel;
import ghidra.app.plugin.runtimeinfo.RuntimeInfoPlugin;
import ghidra.app.plugin.runtimeinfo.VersionInfoPanel;
import ghidra.framework.Application;
import ghidra.framework.GModule;
import ghidra.util.Disposable;
import ghidra.util.classfinder.ClassFileInfo;
import ghidra.util.classfinder.ClassSearcher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

class RuntimeInfoProvider
extends ReusableDialogComponentProvider {
    private RuntimeInfoPlugin plugin;
    private JTabbedPane tabbedPane;
    private MemoryUsagePanel memoryUsagePanel;

    RuntimeInfoProvider(RuntimeInfoPlugin plugin) {
        super("\u8fd0\u884c\u4fe1\u606f", false, false, true, false);
        this.plugin = plugin;
        this.setHelpLocation(plugin.getRuntimeInfoHelpLocation());
        this.addWorkPanel(this.createWorkPanel());
    }

    public void dispose() {
        super.dispose();
        for (Component c : this.tabbedPane.getComponents()) {
            if (!(c instanceof Disposable)) continue;
            Disposable d = (Disposable)c;
            d.dispose();
        }
    }

    protected void dialogShown() {
        this.memoryUsagePanel.shown();
    }

    protected void dialogClosed() {
        this.memoryUsagePanel.hidden();
    }

    private JComponent createWorkPanel() {
        this.tabbedPane = new JTabbedPane();
        this.addVersionInfoPanel();
        this.addMemory();
        this.addApplicationLayout();
        this.addProperties();
        this.addEnvironment();
        this.addModules();
        this.addExtensionPoints();
        this.addClasspath();
        this.addExtensionsClasspath();
        JPanel mainPanel = new JPanel(new BorderLayout()){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(700, 400);
            }
        };
        mainPanel.add((Component)this.tabbedPane, "Center");
        mainPanel.getAccessibleContext().setAccessibleName("\u8fd0\u884c\u4fe1\u606f\u63d0\u4f9b\u8005");
        return mainPanel;
    }

    private void addVersionInfoPanel() {
        this.tabbedPane.add((Component)new VersionInfoPanel(), "\u7248\u672c");
    }

    private void addMemory() {
        this.memoryUsagePanel = new MemoryUsagePanel();
        this.memoryUsagePanel.getAccessibleContext().setAccessibleName("\u5185\u5b58\u7528\u91cf");
        this.tabbedPane.add((Component)this.memoryUsagePanel, "\u5185\u5b58");
    }

    private void addApplicationLayout() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PID", "" + ProcessHandle.current().pid());
        map.put("\u5b89\u88c5\u6587\u4ef6\u5939", Application.getInstallationDirectory().getAbsolutePath());
        map.put("\u8bbe\u7f6e\u6587\u4ef6\u5939", Application.getUserSettingsDirectory().getPath());
        map.put("\u7f13\u5b58\u6587\u4ef6\u5939", Application.getUserCacheDirectory().getPath());
        map.put("\u4e34\u65f6\u6587\u4ef6\u5939", Application.getUserTempDirectory().getPath());
        String name = "\u7a0b\u5e8f\u5e03\u5c40";
        this.tabbedPane.add(new MapTablePanel(name, map, "\u540d\u79f0", "\u8def\u5f84", 200, true, this.plugin), name);
    }

    private void addProperties() {
        Properties properties = System.getProperties();
        HashMap<String, String> map = new HashMap<String, String>();
        for (Object key : properties.keySet()) {
            map.put(key.toString(), properties.getOrDefault(key, "").toString());
        }
        String name = "\u5c5e\u6027";
        this.tabbedPane.add(new MapTablePanel(name, map, "\u540d\u79f0", "\u503c", 400, true, this.plugin), name);
    }

    private void addEnvironment() {
        Map<String, String> map = System.getenv();
        String name = "\u73af\u5883";
        this.tabbedPane.add(new MapTablePanel<String, String>(name, map, "\u540d\u79f0", "\u503c", 400, true, this.plugin), name);
    }

    private void addModules() {
        Map<String, ResourceFile> map = Application.getApplicationLayout().getModules().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((GModule)e.getValue()).getModuleRoot()));
        String name = "\u6a21\u5757";
        this.tabbedPane.add(new MapTablePanel<String, ResourceFile>(name, map, "\u540d\u79f0", "\u8def\u5f84", 400, true, this.plugin), name);
    }

    private void addExtensionPoints() {
        JTabbedPane epTabbedPane = new JTabbedPane();
        this.tabbedPane.add("\u6269\u5c55\u70b9", epTabbedPane);
        Map<String, String> map = ClassSearcher.getExtensionPointInfo().stream().collect(Collectors.toMap(ClassFileInfo::name, ClassFileInfo::path));
        String name = "\u6269\u5c55\u70b9\u4fe1\u606f (%d)".formatted(map.size());
        epTabbedPane.add(new MapTablePanel<String, String>(name, map, "\u540d\u79f0", "\u8def\u5f84", 400, true, this.plugin), name);
        map = ClassSearcher.getLoaded().stream().collect(Collectors.toMap(ClassFileInfo::name, ClassFileInfo::suffix));
        name = "\u5df2\u52a0\u8f7d (%d)".formatted(map.size());
        epTabbedPane.add(new MapTablePanel<String, String>(name, map, "\u540d\u79f0", "\u7c7b\u578b", 400, true, this.plugin), name);
        map = ClassSearcher.getFalsePositives().stream().collect(Collectors.toMap(ClassFileInfo::name, ClassFileInfo::suffix));
        name = "False Positives (%d)".formatted(map.size());
        epTabbedPane.add(new MapTablePanel<String, String>(name, map, "\u540d\u79f0", "\u7c7b\u578b", 400, true, this.plugin), name);
    }

    private void addClasspath() {
        Map<Integer, String> map = this.getClasspathMap("java.class.path");
        String name = "\u7c7b\u522b\u8def\u5f84";
        this.tabbedPane.add(new MapTablePanel<Integer, String>(name, map, "\u5e8f\u53f7", "\u8def\u5f84", 40, true, this.plugin), name);
    }

    private void addExtensionsClasspath() {
        Map<Integer, String> map = this.getClasspathMap("java.class.path.ext");
        String name = "\u6269\u5c55\u7c7b\u522b\u8def\u5f84";
        this.tabbedPane.add(new MapTablePanel<Integer, String>(name, map, "\u5e8f\u53f7", "\u8def\u5f84", 40, true, this.plugin), name);
    }

    private Map<Integer, String> getClasspathMap(String propertyName) {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        int i = 0;
        for (String entry : GhidraClassLoader.getClasspath((String)propertyName)) {
            map.put(i++, entry);
        }
        return map;
    }
}

