/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.runtimeinfo;

import docking.dnd.GClipboard;
import ghidra.framework.Application;
import ghidra.framework.ApplicationProperties;
import ghidra.framework.OperatingSystem;
import ghidra.util.SystemUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextArea;

class VersionInfoPanel
extends JPanel {
    VersionInfoPanel() {
        this.setLayout(new BorderLayout());
        JTextArea textArea = new JTextArea(this.gatherVersionInfo());
        this.add((Component)textArea, "Center");
        JPanel bottomPanel = new JPanel();
        JButton copyButton = new JButton("\u590d\u5236");
        copyButton.addActionListener(e -> {
            Clipboard clipboard = GClipboard.getSystemClipboard();
            clipboard.setContents(new StringSelection(textArea.getText()), null);
        });
        bottomPanel.add(copyButton);
        this.add((Component)bottomPanel, "South");
    }

    private String gatherVersionInfo() {
        String def = "???";
        ArrayList<String> lines = new ArrayList<String>();
        this.addApplicationInfo(lines, "???");
        this.addOperatingSystemInfo(lines, "???");
        this.addJavaInfo(lines, "???");
        return String.join((CharSequence)"\n", lines);
    }

    private void addApplicationInfo(List<String> lines, String def) {
        ApplicationProperties props = Application.getApplicationLayout().getApplicationProperties();
        lines.add("Ghidra \u7248\u672c\uff1a" + props.getApplicationVersion());
        lines.add("Ghidra \u53d1\u884c\uff1a" + props.getApplicationReleaseName());
        lines.add("Ghidra \u7f16\u8bd1\u65e5\u671f\uff1a" + props.getApplicationBuildDate());
        lines.add("Ghidra \u4fee\u8ba2\uff1a" + props.getProperty("application.revision.ghidra", def));
        lines.add("Ghidra \u5f00\u53d1\u8005\u6a21\u5f0f\uff1a" + SystemUtilities.isInDevelopmentMode());
    }

    private void addOperatingSystemInfo(List<String> lines, String def) {
        lines.add("\u7cfb\u7edf\u540d\u79f0\uff1a" + System.getProperty("os.name", def));
        lines.add("\u7cfb\u7edf\u67b6\u6784\uff1a" + System.getProperty("os.arch", def));
        lines.add("\u7cfb\u7edf\u7248\u672c\uff1a" + System.getProperty("os.version", def));
        if (OperatingSystem.CURRENT_OPERATING_SYSTEM.equals((Object)OperatingSystem.LINUX)) {
            String prettyName = def;
            File osReleaseFile = new File("/etc/os-release");
            if (!osReleaseFile.isFile()) {
                osReleaseFile = new File("/usr/lib/os-release");
            }
            try (BufferedReader reader = new BufferedReader(new FileReader(osReleaseFile));){
                Properties props = new Properties();
                props.load(reader);
                prettyName = props.getProperty("PRETTY_NAME", def);
                if (prettyName.startsWith("\"") && prettyName.endsWith("\"")) {
                    prettyName = prettyName.substring(1, prettyName.length() - 1);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            lines.add("\u64cd\u4f5c\u7cfb\u7edf\u7f8e\u540d\uff1a" + prettyName);
        }
    }

    private void addJavaInfo(List<String> lines, String def) {
        lines.add("Java \u4f9b\u5e94\u5546\uff1a" + System.getProperty("java.vendor", def));
        lines.add("Java \u7248\u672c: " + System.getProperty("java.version", def));
        lines.add("Java \u8def\u5f84: " + System.getProperty("java.home"));
    }
}

